/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.utils;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.ControlAp;

public class NameControlUtil {
    private static final Log LOGGER = LogFactory.getLog(NameControlUtil.class);
    private static final String NAME_UTIL_PATH = "kd.bos.name.util.NameUtil";
    private static final String GET_I18N_NAME_FORMAT = "getNameFormatStr";
    private static final String GET_DEFAULT_NAME_STYLE_ID = "getCountryDefaultNameStyleId";
    private static final String GET_NAME_STYLE_ID_BY_COUNTRY_ID = "getCountryNameTextStyles";
    private static final String GET_NAME_STYLE_CONFIG = "getNameStyleConfig";
    private static final String FORM_METADATA_UTIL = "kd.bos.designer.dao.FormMetadataUtil";
    private static final String CONTROL_AP_TO_MAP = "controlApToMap";

    public static String getNameFormatStr(Long configFormatId, Map<String, String> dataEntity) {
        String result = "";
        try {
            Class<?> clazz = Class.forName(NAME_UTIL_PATH);
            Method method = clazz.getDeclaredMethod(GET_I18N_NAME_FORMAT, Long.class, Map.class);
            result = (String)method.invoke(null, configFormatId, dataEntity);
        }
        catch (Exception e) {
            LOGGER.error(String.format(ResManager.loadKDString((String)"\u53cd\u5c04\u8c03\u7528\u65b9\u6cd5\u51fa\u9519,\u68c0\u67e5\u5982\u4e0b\u8def\u5f84\u662f\u5426\u5b58\u5728\uff1aclass:%1$s, method:%2$s", (String)"NameControlUtil_1", (String)"bos-ext-controls", (Object[])new Object[0]), NAME_UTIL_PATH, GET_I18N_NAME_FORMAT), (Object)e.getMessage());
        }
        return result;
    }

    public static Long getCountryDefaultNameStyleId(Long countryId) {
        Long result = null;
        try {
            Class<?> clazz = Class.forName(NAME_UTIL_PATH);
            Method method = clazz.getDeclaredMethod(GET_DEFAULT_NAME_STYLE_ID, Long.class);
            result = (Long)method.invoke(null, countryId);
        }
        catch (Exception e) {
            LOGGER.error(String.format(ResManager.loadKDString((String)"\u53cd\u5c04\u8c03\u7528\u65b9\u6cd5\u51fa\u9519,\u68c0\u67e5\u5982\u4e0b\u8def\u5f84\u662f\u5426\u5b58\u5728\uff1aclass:%1$s, method:%2$s", (String)"NameControlUtil_1", (String)"bos-ext-controls", (Object[])new Object[0]), NAME_UTIL_PATH, GET_DEFAULT_NAME_STYLE_ID), (Object)e.getMessage());
        }
        return result;
    }

    public static List<Map<String, Object>> getNameStyleConfig(Long nameStyleId) {
        List nameConfigStructList = null;
        try {
            Class<?> clazz = Class.forName(NAME_UTIL_PATH);
            Method method = clazz.getDeclaredMethod(GET_NAME_STYLE_CONFIG, Long.class, Map.class);
            nameConfigStructList = (List)method.invoke(null, nameStyleId, Collections.EMPTY_MAP);
        }
        catch (Exception e) {
            LOGGER.error(String.format(ResManager.loadKDString((String)"\u53cd\u5c04\u8c03\u7528\u65b9\u6cd5\u51fa\u9519,\u68c0\u67e5\u5982\u4e0b\u8def\u5f84\u662f\u5426\u5b58\u5728\uff1aclass:%1$s, method:%2$s", (String)"NameControlUtil_1", (String)"bos-ext-controls", (Object[])new Object[0]), NAME_UTIL_PATH, GET_NAME_STYLE_CONFIG), (Object)e.getMessage());
        }
        return nameConfigStructList;
    }

    public static Set<Long> getCountryNameTextStyles(Long countryId) {
        Set result = Collections.EMPTY_SET;
        try {
            Class<?> clazz = Class.forName(NAME_UTIL_PATH);
            Method method = clazz.getDeclaredMethod(GET_NAME_STYLE_ID_BY_COUNTRY_ID, Long.class);
            result = (Set)method.invoke(null, countryId);
        }
        catch (Exception e) {
            LOGGER.error(String.format(ResManager.loadKDString((String)"\u53cd\u5c04\u8c03\u7528\u65b9\u6cd5\u51fa\u9519,\u68c0\u67e5\u5982\u4e0b\u8def\u5f84\u662f\u5426\u5b58\u5728\uff1aclass:%1$s, method:%2$s", (String)"NameControlUtil_1", (String)"bos-ext-controls", (Object[])new Object[0]), NAME_UTIL_PATH, GET_NAME_STYLE_ID_BY_COUNTRY_ID), (Object)e.getMessage());
        }
        return result;
    }

    public static Map<String, Object> controlApToMap(String modelType, ControlAp<?> ctlAp) {
        Map result = null;
        try {
            Class<?> clazz = Class.forName(FORM_METADATA_UTIL);
            Method method = clazz.getDeclaredMethod(CONTROL_AP_TO_MAP, String.class, ControlAp.class);
            result = (Map)method.invoke(null, modelType, ctlAp);
        }
        catch (Exception e) {
            LOGGER.error(String.format(ResManager.loadKDString((String)"\u53cd\u5c04\u8c03\u7528\u65b9\u6cd5\u51fa\u9519,\u68c0\u67e5\u5982\u4e0b\u8def\u5f84\u662f\u5426\u5b58\u5728\uff1aclass:%1$s, method:%2$s", (String)"NameControlUtil_1", (String)"bos-ext-controls", (Object[])new Object[0]), FORM_METADATA_UTIL, CONTROL_AP_TO_MAP), (Object)e.getMessage());
        }
        return result;
    }
}

