/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sysint.servicehelper;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import sun.misc.BASE64Encoder;

public class HashHmacCrypto {
    private static final String CODE_UTF8 = "utf-8";

    public static String sign(String method, String url, TreeMap<String, String> params, TreeMap<String, String> headers, String key) throws UnsupportedEncodingException, InvalidKeyException, NoSuchAlgorithmException {
        StringBuilder source = new StringBuilder();
        source.append(method).append("\n");
        source.append(URLEncoder.encode(url, CODE_UTF8)).append("\n");
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            sb.append(URLEncoder.encode(entry.getKey(), CODE_UTF8)).append('=').append(URLEncoder.encode(entry.getValue(), CODE_UTF8)).append('&');
        }
        String paramsString = sb.toString();
        if (paramsString.length() > 0) {
            paramsString = paramsString.substring(0, paramsString.length() - 1);
            source.append(paramsString).append("\n");
        }
        sb = new StringBuilder();
        for (Map.Entry<String, String> header : headers.entrySet()) {
            sb.append(header.getKey().toLowerCase()).append(":").append(header.getValue().trim()).append("\n");
        }
        source.append((CharSequence)sb);
        return HashHmacCrypto.hmac(source.toString(), key);
    }

    private static String bytesToHex(byte[] hashInBytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < hashInBytes.length; ++i) {
            String hex = Integer.toHexString(hashInBytes[i] & 0xFF);
            if (hex.length() < 2) {
                hex = "0" + hex;
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    public static String hmac(String source, String key) throws NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException {
        byte[] keyBytes = key.getBytes(CODE_UTF8);
        SecretKeySpec signingKey = new SecretKeySpec(keyBytes, "HmacSHA256");
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(signingKey);
        byte[] rawHmac = mac.doFinal(source.getBytes(CODE_UTF8));
        return new BASE64Encoder().encode(HashHmacCrypto.bytesToHex(rawHmac).getBytes(CODE_UTF8));
    }
}

