/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sysint.servicehelper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.license.NextCloud;
import kd.bos.sysint.servicehelper.AccessTokenQO;
import kd.bos.sysint.servicehelper.HashHmacCrypto;
import kd.bos.util.HttpClientUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProductServiceImpl {
    private static final Logger logger = LoggerFactory.getLogger(ProductServiceImpl.class);
    private static final String CLOUD_API_URL = "http://api.kingdee.com/";
    private static final String TOKENADDRESS = "https://api.kingdee.com/linkceo/auth/product/token";
    private static final String RELATIVEPATH = "/linkceo/auth/product/token";
    public static final String CLOUD_URL = "http://api.kingdee.com/";
    public static final String CLIENT_ID = NextCloud.CLIENT_ID;
    public static final String CLIENT_SECRET = NextCloud.CLIENT_SECRET;
    private static final String CONTENT_TYPE = "Content-type";
    private static final String X_API_TIMESTAMP = "X-Api-TimeStamp";
    private static final String X_API_NONCE = "X-Api-Nonce";

    public String getCloudToken(AccessTokenQO accessTokenQO) throws IOException {
        String body = "";
        CloseableHttpClient client = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(this.getUrl(accessTokenQO));
        this.setHeader(httpPost, accessTokenQO);
        this.setBody(httpPost, accessTokenQO);
        CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            body = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
        }
        EntityUtils.consume((HttpEntity)entity);
        response.close();
        return body;
    }

    private void setHeader(HttpPost httpPost, AccessTokenQO accessTokenQO) {
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        String nonce = UUID.randomUUID().toString().replace("-", "");
        String signature = this.getSignature(accessTokenQO, nonce, timestamp);
        logger.info("========timestamp:" + timestamp);
        httpPost.setHeader(CONTENT_TYPE, "application/x-www-form-urlencoded;charset=utf-8");
        httpPost.setHeader("X-Api-ClientID", CLIENT_ID);
        httpPost.setHeader("X-Api-Auth-Version", "2.0");
        httpPost.setHeader(X_API_TIMESTAMP, timestamp);
        httpPost.setHeader(X_API_NONCE, nonce);
        httpPost.setHeader("X-Api-SignHeaders", "X-Api-TimeStamp,X-Api-Nonce");
        httpPost.setHeader("X-Api-Signature", signature);
        httpPost.setHeader("accept", "*/*");
        httpPost.setHeader("connection", "Keep-Alive");
    }

    private void setBody(HttpPost httpPost, AccessTokenQO accessTokenQO) throws UnsupportedEncodingException {
        String clientId = accessTokenQO.getClientId();
        String authCode = accessTokenQO.getAuthCode();
        String erpId = accessTokenQO.getErpId();
        String erpName = accessTokenQO.getErpName();
        String erpPhone = accessTokenQO.getErpPhone();
        String erpEmail = accessTokenQO.getErpEmail();
        String prodInstCode = accessTokenQO.getProdInstCode();
        String prodSN = accessTokenQO.getProdSN();
        String prodName = accessTokenQO.getProdName();
        String prodVersion = accessTokenQO.getProdVersion();
        String prodCategoryCode = accessTokenQO.getProdCategoryCode();
        String prodDeployWay = accessTokenQO.getProdDeployWay();
        String prodClientType = accessTokenQO.getProdClientType();
        String serviceEndDate = accessTokenQO.getServiceEndDate();
        String userSource = accessTokenQO.getUserSource();
        String customerLevel = accessTokenQO.getCustomerLevel();
        String userRole = accessTokenQO.getUserRole();
        String prodSoftcode = accessTokenQO.getProdSoftcode();
        String customerName = accessTokenQO.getCustomerName();
        String prodDomain = accessTokenQO.getProdDomain();
        String ip = accessTokenQO.getIp();
        String userAgent = accessTokenQO.getUserAgent();
        ArrayList<NameValuePair> nameValuePairList = new ArrayList<NameValuePair>();
        this.addNameValuePairList(clientId, authCode, erpId, erpName, erpPhone, erpEmail, prodInstCode, prodName, prodVersion, prodCategoryCode, prodDeployWay, prodClientType, serviceEndDate, userSource, customerLevel, userRole, prodSoftcode, customerName, prodDomain, ip, userAgent, nameValuePairList);
        UrlEncodedFormEntity httpEntity = new UrlEncodedFormEntity(nameValuePairList);
        httpPost.setEntity((HttpEntity)httpEntity);
    }

    private void addNameValuePairList(String clientId, String authCode, String erpId, String erpName, String erpPhone, String erpEmail, String prodInstCode, String prodName, String prodVersion, String prodCategoryCode, String prodDeployWay, String prodClientType, String serviceEndDate, String userSource, String customerLevel, String userRole, String prodSoftcode, String customerName, String prodDomain, String ip, String userAgent, List<NameValuePair> nameValuePairList) {
        this.judgeNotNullAndAdd("clientId", clientId, nameValuePairList);
        this.judgeNotNullAndAdd("authCode", authCode, nameValuePairList);
        this.judgeNotNullAndAdd("erpId", erpId, nameValuePairList);
        this.judgeNotNullAndAdd("erpName", erpName, nameValuePairList);
        this.judgeNotNullAndAdd("erpPhone", erpPhone, nameValuePairList);
        this.judgeNotNullAndAdd("erpEmail", erpEmail, nameValuePairList);
        this.judgeNotNullAndAdd("prodInstCode", prodInstCode, nameValuePairList);
        this.judgeNotNullAndAdd("prodName", prodName, nameValuePairList);
        this.judgeNotNullAndAdd("prodVersion", prodVersion, nameValuePairList);
        this.judgeNotNullAndAdd("prodCategoryCode", prodCategoryCode, nameValuePairList);
        this.judgeNotNullAndAdd("prodDeployWay", prodDeployWay, nameValuePairList);
        this.judgeNotNullAndAdd("prodClientType", prodClientType, nameValuePairList);
        this.judgeNotNullAndAdd("serviceEndDate", serviceEndDate, nameValuePairList);
        this.judgeNotNullAndAdd("userSource", userSource, nameValuePairList);
        this.judgeNotNullAndAdd("customerLevel", customerLevel, nameValuePairList);
        this.judgeNotNullAndAdd("userRole", userRole, nameValuePairList);
        this.judgeNotNullAndAdd("prodSoftcode", prodSoftcode, nameValuePairList);
        this.judgeNotNullAndAdd("customerName", customerName, nameValuePairList);
        this.judgeNotNullAndAdd("prodDomain", prodDomain, nameValuePairList);
        this.judgeNotNullAndAdd("ip", ip, nameValuePairList);
        this.judgeNotNullAndAdd("userAgent", userAgent, nameValuePairList);
    }

    private void judgeNotNullAndAdd(String key, String value, List<NameValuePair> nameValuePairList) {
        if (!StringUtils.isEmpty((CharSequence)value)) {
            BasicNameValuePair pair = new BasicNameValuePair(key, value);
            nameValuePairList.add((NameValuePair)pair);
        }
    }

    private String getUrl(AccessTokenQO accessTokenQO) {
        TreeMap paramMap = this.getParamMap(accessTokenQO);
        if (paramMap.isEmpty()) {
            return TOKENADDRESS;
        }
        StringBuilder param = new StringBuilder();
        for (Map.Entry entry : paramMap.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            param.append(key).append("=").append(value).append("&");
        }
        String paramString = param.toString();
        paramString = paramString.substring(0, paramString.length() - 1);
        return "https://api.kingdee.com/linkceo/auth/product/token?" + paramString;
    }

    private TreeMap getParamMap(AccessTokenQO accessTokenQO) {
        if (accessTokenQO == null) {
            return new TreeMap();
        }
        TreeMap<String, String> paramMap = new TreeMap<String, String>();
        String uid = accessTokenQO.getUid();
        if (!StringUtils.isEmpty((CharSequence)uid)) {
            paramMap.put("uid", uid);
        }
        return paramMap;
    }

    private String getSignature(AccessTokenQO accessTokenQO, String nonce, String timestamp) {
        TreeMap<String, String> headMap = new TreeMap<String, String>();
        headMap.put(X_API_NONCE, nonce);
        headMap.put(X_API_TIMESTAMP, timestamp);
        String sign = "";
        try {
            sign = HashHmacCrypto.sign("POST", RELATIVEPATH, this.getParamMap(accessTokenQO), headMap, CLIENT_SECRET);
            sign = sign.replaceAll(System.getProperty("line.separator"), "");
        }
        catch (Exception e) {
            logger.info(e.getMessage(), (Throwable)e);
        }
        return sign;
    }

    private void setJsonHeader(HttpPost httpPost, AccessTokenQO accessTokenQO) {
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        String nonce = UUID.randomUUID().toString().replace("-", "");
        String signature = this.getSignature(accessTokenQO, nonce, timestamp);
        httpPost.setHeader(CONTENT_TYPE, "application/json;charset=utf-8");
        httpPost.setHeader("X-Api-ClientID", CLIENT_ID);
        httpPost.setHeader("X-Api-Auth-Version", "2.0");
        httpPost.setHeader(X_API_TIMESTAMP, timestamp);
        httpPost.setHeader(X_API_NONCE, nonce);
        httpPost.setHeader("X-Api-SignHeaders", "X-Api-TimeStamp,X-Api-Nonce");
        httpPost.setHeader("X-Api-Signature", signature);
        httpPost.setHeader("accept", "*/*");
        httpPost.setHeader("connection", "Keep-Alive");
    }

    private void setJsonBody(HttpPost httpPost, AccessTokenQO accessTokenQO) throws UnsupportedEncodingException {
        String jsonStr = JSON.toJSONString((Object)accessTokenQO);
        StringEntity s = new StringEntity(jsonStr, "UTF-8");
        s.setContentEncoding((Header)new BasicHeader("Content-Type", "application/json"));
        httpPost.setEntity((HttpEntity)s);
    }

    public Map<String, String> getJsonCloudToken(AccessTokenQO accessTokenQO) throws IOException {
        HashMap<String, String> header = new HashMap<String, String>(8);
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        String nonce = UUID.randomUUID().toString().replace("-", "");
        String signature = this.getSignature(accessTokenQO, nonce, timestamp);
        header.put(CONTENT_TYPE, "application/json;charset=utf-8");
        header.put("X-Api-ClientID", CLIENT_ID);
        header.put("X-Api-Auth-Version", "2.0");
        header.put(X_API_TIMESTAMP, timestamp);
        header.put(X_API_NONCE, nonce);
        header.put("X-Api-SignHeaders", "X-Api-TimeStamp,X-Api-Nonce");
        header.put("X-Api-Signature", signature);
        header.put("accept", "*/*");
        String jsonStr = JSON.toJSONString((Object)accessTokenQO);
        String result = HttpClientUtils.postjson((String)this.getUrl(accessTokenQO), header, (String)jsonStr);
        HashMap<String, String> accessTokenMap = new HashMap<String, String>(8);
        if (kd.bos.util.StringUtils.isNotEmpty((String)result)) {
            JSONObject bodyJason = (JSONObject)JSON.parse((String)result);
            Integer errcode = bodyJason.getInteger("errcode");
            if (0 == errcode) {
                JSONObject data = bodyJason.getJSONObject("data");
                accessTokenMap.put("accessToken", data.getString("accessToken"));
                accessTokenMap.put("timestamp", data.getString("timestamp"));
                accessTokenMap.put("expiresIn", data.getString("expiresIn"));
                accessTokenMap.put("notifyStatus", data.getString("notifyStatus"));
                accessTokenMap.put("sleeping", data.getString("sleeping"));
                accessTokenMap.put("errcode", bodyJason.getString("errcode"));
            } else {
                accessTokenMap.put("description", bodyJason.getString("description"));
                accessTokenMap.put("description_cn", bodyJason.getString("description_cn"));
            }
            accessTokenMap.put("errorCode", bodyJason.getString("errcode"));
            return accessTokenMap;
        }
        accessTokenMap.put("errorCode", "530");
        return accessTokenMap;
    }

    public static String getAuthCode(String accesstoken, String targetId) {
        String response = null;
        String url = "http://api.kingdee.com/auth/user/auth_code";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("access_token", accesstoken);
        param.put("target_id", targetId);
        try {
            response = HttpClientUtils.post((String)url, ProductServiceImpl.getHttpRequestHeader(), param, (int)1800000, (int)1800000);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return response;
    }

    public static Map<String, String> getHttpRequestHeader() {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put(CONTENT_TYPE, "application/x-www-form-urlencoded;charset=UTF-8");
        return header;
    }
}

