/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sysint.servicehelper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.common.BaseAppParameterServiceHelper;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.license.NextCloud;
import kd.bos.license.api.ILicenseService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.user.DefaultParameterService;
import kd.bos.login.utils.BeanUtils;
import kd.bos.login.utils.DESUtilsEncrypter;
import kd.bos.login.utils.SHAUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.sysint.api.DataMappingService;
import kd.bos.sysint.api.IExtSysService;
import kd.bos.sysint.cache.AppFeaturesCache;
import kd.bos.sysint.cache.SysIntegCache;
import kd.bos.sysint.servicehelper.AccessTokenQO;
import kd.bos.sysint.servicehelper.HashHmacCrypto;
import kd.bos.sysint.servicehelper.ProductServiceImpl;
import kd.bos.sysint.servicehelper.SinatureUtil;
import kd.bos.sysint.servicehelper.cache.RobertCache;
import kd.bos.sysint.servicehelper.dto.SearchParams;
import kd.bos.util.HttpClientUtils;
import kd.bos.yzj.config.YzjConfigServiceHelper;
import kd.bos.yzj.model.YzjConfig;
import org.apache.commons.codec.binary.Base64;

@KSObject
public class SysIntegrationServiceHelper {
    private static Log logger = LogFactory.getLog(SysIntegrationServiceHelper.class);
    public static final String ENTITYID_EXTERNALSYS = "bas_externalsys";
    public static final String ENTITYID_BAS_DATATYPE = "bas_datatype";
    public static final String ENTITYID_BAS_DATAMAPPING = "bas_datamapping";
    public static final String ENTITYID_POSITIONMAPPING = "bas_positionmapping";
    private static final String KNOWLEDGE_API_URL = "https://knowledge.kingdee.com/";
    private static final String KINGDEE_API_URL = "http://api.cloudsz.kingdee.com/";
    private static final String RELATIVEPATH = "/linkceo/auth/product/token";
    public static final String CLOUD_URL = "http://api.kingdee.com/";
    public static final String CLIENT_ID = NextCloud.CLIENT_ID;
    public static final String CLIENT_SECRET = NextCloud.CLIENT_SECRET;
    private static final String KD_ONLINE_CODE_API_URL = "/opencloud/kdonline/acqcode";
    private static final String YZJ_GET_SECRET_API = "/gateway/open/linkspace/linkSpace/getSecret";
    private static final String YZJ_GET_ACCESSTOKEN_API = "/gateway/oauth2/token/getAccessToken";
    private static final String YZJ_DEFAULT_HOST = "https://www.yunzhijia.com";
    private static final String CLOUD_SERVICE_API_URL = "https://supportest.kingdee.com";
    private static final String PRE_SALES_CHAT_PC_API = "/osp2016/chat/pc/index.php";
    private static final String ONLINE_SERVICE_PC_API = "/productSelect.php";
    private static final int STANDARD_PRODUCT = 68;
    private static final int GALAXY_PRODUCT = 93;
    private static final int CONSTELLATION_PRODUCT = 3;
    private static final String APPFEATURE_URL = "https://vip.kingdee.com/knowledgeapi/";
    private static final String UPDATE_TIME = "updateTime";
    private static final String TITLE = "title";
    private static final String URL = "url";
    private static final String APPNUMBER = "appNumber";
    private static final String CONTENTS = "contents";
    private static final String EXTDATAID = "extdataid";
    private static final String NUMBER = "number";
    private static final String DOMAIN = "domain";
    private static final String MODULE = "module";
    private static final String BIZENTITY = "bizentity";
    private static final String LABEL = "label";
    private static final String RESTRICTIN = "restrictIn";
    private static final String AUTHCODE = "authcode";
    private static final String PAGESIZE = "pageSize";
    private static final String ALLOWHTML = "allowHtml";
    private static final String URL_DESC = "url: ";
    private static final String PARAM_DESC = "param: ";
    private static final String ERRCODE = "errcode";
    private static final String DESCRIPTION = "description";
    private static final String RESPONSE_DESC = "response: ";
    private static final String CLIENTID = "clientId";
    private static final String ERPID = "erpId";
    private static final String UNKNOWN = "unknown";
    private static final String PRODSN = "prodSN";
    private static final String SKYCLOUD = "SKYCLOUD";
    private static final String CLOUD = "Cloud";
    private static final String PRODUCT = "Product";
    private static final String TIMESTAMP = "timestamp";
    private static final String HOME_URL = "/home";
    private static final String ACCESSTOKEN = "accessToken";
    private static final String ERROR = "error";
    private static final String ROBERTHOMEURL_DESC = "robertHomeUrl: ";
    private static final String EXPIRESIN = "expiresIn";
    private static final String NOTIFYSTATUS = "notifyStatus";
    private static final String SLEEPING = "sleeping";
    private static final String DESCRIPTION_CN = "description_cn";
    private static final String SYSINTEGRATIONSERVICEHELPER_9 = "SysIntegrationServiceHelper_9";
    private static final String SUCCESS = "success";
    private static final String ERRORCODE = "errorCode";
    private static final String ENTITYURL = "entityUrl";
    private static final String CLASSIFIES = "classifies";
    private static final String KNOWLEDGEUPDATEDAT = "knowledgeUpdatedAt";
    private static final String KNOWLEDGE_URL_KEY = "knowledage.search.url";
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("SYSINTEG_DATA", new DistributeCacheHAPolicy());

    private static String getKnowledgeUrl() {
        String value = SystemPropertyUtils.getProptyByTenant((String)KNOWLEDGE_URL_KEY, (String)RequestContext.get().getTenantId());
        return value == null ? KNOWLEDGE_API_URL : value;
    }

    @KSMethod
    public static Map<String, String> getExternalData(Long externalSysID, String dataTypeNumber, String id, String number, String name) {
        SysIntegrationServiceHelper.setInfoLog(String.format(ResManager.loadKDString((String)"\u6839\u636e\u5185\u90e8\u6570\u636e\u4fe1\u606f\u67e5\u8be2\u5916\u90e8\u6570\u636e\u4fe1\u606f\u53c2\u6570\uff1aexternalSysID[%1$s], dataTypeNumber[%2$s], id[%3$s], number[%4$s], name[%5$s]", (String)"SysIntegrationServiceHelper_0", (String)"bos-sysinteg-servicehelper", (Object[])new Object[0]), externalSysID, dataTypeNumber, id, number, name));
        Map<String, String> externalData = new HashMap<String, String>();
        String key = externalSysID + id + number + name;
        String externalDataCache = SysIntegCache.getExternalData((String)dataTypeNumber, (String)key);
        if (!StringUtils.isEmpty((CharSequence)externalDataCache)) {
            if (!"DATA_LOADED".equals(externalDataCache)) {
                externalData = (Map)SerializationUtils.fromJsonString((String)externalDataCache, Map.class);
            }
            return externalData;
        }
        DynamicObject dataType = DataMappingService.getDataType((Long)externalSysID, (String)dataTypeNumber);
        if (dataType == null) {
            throw new KDException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5916\u90e8\u7cfb\u7edf\u6570\u636e\u7c7b\u578b\u4fe1\u606f\u5931\u8d25\uff1a\u5916\u90e8\u7cfb\u7edfID[%1$s], \u6570\u636e\u7c7b\u578b\u7f16\u7801[%2$s]", (String)"SysIntegrationServiceHelper_1", (String)"bos-sysinteg-servicehelper", (Object[])new Object[0]), externalSysID, dataTypeNumber));
        }
        externalData = DataMappingService.getDataMap((DynamicObject)dataType, (String)id, (String)number, (String)name);
        if (externalData != null && externalData.size() > 0) {
            externalDataCache = SerializationUtils.toJsonString(externalData);
            SysIntegCache.updateExternalDataCache((String)dataTypeNumber, (String)key, (String)externalDataCache);
            return externalData;
        }
        ORM orm = ORM.create();
        DynamicObject externalsys = orm.getById(ENTITYID_EXTERNALSYS, (Object)externalSysID);
        if (externalsys == null) {
            throw new KDException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5916\u90e8\u7cfb\u7edf\u4fe1\u606f\u5931\u8d25\uff0c\u5916\u90e8\u7cfb\u7edfID\uff1a%s\u3002", (String)"SysIntegrationServiceHelper_2", (String)"bos-sysinteg-servicehelper", (Object[])new Object[0]), externalSysID));
        }
        String impleclass = (String)externalsys.get("impleclass");
        IExtSysService extSysService = (IExtSysService)TypesContainer.createInstance((String)impleclass);
        externalData = DataMappingService.getExtData((DynamicObject)dataType, (String)number, (String)name, (IExtSysService)extSysService);
        if (externalData != null && externalData.size() > 0) {
            DataMappingService.saveDataMap((DynamicObject)dataType, (String)id, (String)number, (String)name, externalData);
        }
        SysIntegrationServiceHelper.updateExternalCache(dataTypeNumber, externalData, key);
        return externalData;
    }

    private static void updateExternalCache(String dataTypeNumber, Map<String, String> externalData, String key) {
        if (externalData == null || externalData.size() == 0) {
            SysIntegCache.updateExternalDataCache((String)dataTypeNumber, (String)key, (String)"DATA_LOADED");
        } else {
            String externalDataCache = SerializationUtils.toJsonString(externalData);
            SysIntegCache.updateExternalDataCache((String)dataTypeNumber, (String)key, (String)externalDataCache);
        }
    }

    @KSMethod
    public static Map<String, Map<String, String>> getInternalData(Long externalSysID, String dataTypeNumber, Set<String> ids, String number, String name) {
        QFilter idFilter;
        HashMap<String, Map<String, String>> internalDataMap = new HashMap<String, Map<String, String>>();
        DynamicObject dataType = null;
        dataType = DataMappingService.getDataType((Long)externalSysID, (String)dataTypeNumber);
        ORM orm = ORM.create();
        String selectFields = "*";
        String orderBys = "";
        QFilter datatypeFilter = new QFilter("datatype.id", "=", dataType.getPkValue());
        QFilter[] filters = new QFilter[]{datatypeFilter, idFilter = new QFilter(EXTDATAID, "in", ids)};
        DynamicObjectCollection datamappingList = orm.query(ENTITYID_BAS_DATAMAPPING, selectFields, filters, orderBys);
        if (datamappingList == null || datamappingList.size() == 0) {
            SysIntegrationServiceHelper.setInfoLog(String.format(ResManager.loadKDString((String)"\u5916\u90e8\u7cfb\u7edf\u201c%1$s\u201d\uff0c\u4e1a\u52a1\u5bf9\u8c61\u201c%2$s\u201d\u7684\u6570\u636eID\u201c%3$s\u201d\uff0c\u7f16\u7801\u201c%4$s\u201d\uff0c\u540d\u79f0\u201c%5$s\u201d\u672a\u5b9a\u4e49\u6570\u636e\u6620\u5c04\u3002", (String)"SysIntegrationServiceHelper_3", (String)"bos-sysinteg-servicehelper", (Object[])new Object[0]), externalSysID, dataTypeNumber, ids, number, name));
            return internalDataMap;
        }
        HashMap<String, String> internalData = null;
        for (DynamicObject datamapping : datamappingList) {
            internalData = new HashMap<String, String>();
            internalData.put("id", datamapping.getString("dataid"));
            internalData.put(NUMBER, datamapping.getString(NUMBER));
            internalData.put("name", datamapping.getString("name"));
            internalDataMap.put(datamapping.getString(EXTDATAID), internalData);
        }
        return internalDataMap;
    }

    @KSMethod
    public static Map<String, String> getInternalData(Long externalSysID, String dataTypeNumber, String id, String number, String name) {
        QFilter idFilter;
        HashMap<String, String> internalData = new HashMap<String, String>();
        DynamicObject dataType = null;
        dataType = DataMappingService.getDataType((Long)externalSysID, (String)dataTypeNumber);
        ORM orm = ORM.create();
        DynamicObject datamapping = null;
        String selectFields = "*";
        String orderBys = "";
        int top = 1;
        QFilter datatypeFilter = new QFilter("datatype.id", "=", dataType.getPkValue());
        QFilter[] filters = new QFilter[]{datatypeFilter, idFilter = new QFilter(EXTDATAID, "=", (Object)id)};
        DynamicObjectCollection datamappingList = orm.query(ENTITYID_BAS_DATAMAPPING, selectFields, filters, orderBys, top);
        if (datamappingList != null && datamappingList.size() > 0) {
            datamapping = (DynamicObject)datamappingList.get(0);
        }
        if (datamapping == null) {
            SysIntegrationServiceHelper.setInfoLog(String.format(ResManager.loadKDString((String)"\u5916\u90e8\u7cfb\u7edf\u201c%1$s\u201d\uff0c\u4e1a\u52a1\u5bf9\u8c61\u201c%2$s\u201d\u7684\u6570\u636eID\u201c%3$s\u201d\uff0c\u7f16\u7801\u201c%4$s\u201d\uff0c\u540d\u79f0\u201c%5$s\u201d\u672a\u5b9a\u4e49\u6570\u636e\u6620\u5c04\u3002", (String)"SysIntegrationServiceHelper_3", (String)"bos-sysinteg-servicehelper", (Object[])new Object[0]), externalSysID, dataTypeNumber, id, number, name));
            return internalData;
        }
        internalData.put("id", datamapping.getString("dataid"));
        internalData.put(NUMBER, datamapping.getString(NUMBER));
        internalData.put("name", datamapping.getString("name"));
        return internalData;
    }

    @KSMethod
    public static Map<String, String> getExternalPositionData(Long externalSysID, String dataTypeNumber, Long userID, Long orgID) {
        Map positionInfo = null;
        DynamicObject dataType = null;
        dataType = DataMappingService.getDataType((Long)externalSysID, (String)dataTypeNumber);
        positionInfo = DataMappingService.getPositionMap((DynamicObject)dataType, (Long)userID, (Long)orgID);
        if (positionInfo != null && positionInfo.size() > 0) {
            return positionInfo;
        }
        ORM orm = ORM.create();
        DynamicObject externalsys = (DynamicObject)dataType.get("externalsys");
        String impleclass = (String)(externalsys = orm.getById(ENTITYID_EXTERNALSYS, externalsys.getPkValue())).get("impleclass");
        IExtSysService extSysService = (IExtSysService)TypesContainer.createInstance((String)impleclass);
        positionInfo = DataMappingService.getExtPosition((Long)userID, (Long)orgID, (IExtSysService)extSysService);
        if (positionInfo != null && positionInfo.size() > 0) {
            DataMappingService.savePositionMap((DynamicObject)dataType, (Long)userID, (Long)orgID, (Map)positionInfo);
        }
        return positionInfo;
    }

    @Deprecated
    public static String knowledgeSearch(String type, String domain, String module, String bizentity, String label, String restrictIn, String content, String authcode, int page, int pageSize, Boolean allowHtml, String searchScope) {
        SearchParams searchParams = new SearchParams();
        searchParams.setType(type);
        searchParams.setDomain(domain);
        searchParams.setModule(module);
        searchParams.setBizentity(bizentity);
        searchParams.setLabel(label);
        searchParams.setRestrictIn(restrictIn);
        searchParams.setContent(content);
        searchParams.setAuthcode(authcode);
        searchParams.setPage(page);
        searchParams.setPageSize(pageSize);
        searchParams.setAllowHtml(allowHtml);
        searchParams.setSearchScope(searchScope);
        return SysIntegrationServiceHelper.knowledgeSearch(searchParams);
    }

    @Deprecated
    public static String knowledgeSearch(SearchParams searchParams) {
        Object isSearch = BaseAppParameterServiceHelper.getParameterFromCache((String)"knowledge_search");
        if (isSearch != null && !Boolean.parseBoolean(isSearch.toString())) {
            HashMap<String, String> errResponse = new HashMap<String, String>();
            errResponse.put(ERRCODE, "1");
            errResponse.put(DESCRIPTION, ResManager.loadKDString((String)"\u672a\u5f00\u542f\u201c\u641c\u7d22\u4e91\u793e\u533a\u77e5\u8bc6\u201d\uff0c\u5982\u6709\u9700\u6c42\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff0c\u7ba1\u7406\u5458\u53ef\u524d\u5f80\u7cfb\u7edf\u53c2\u6570\u5f00\u542f\u3002", (String)"SysIntegrationServiceHelper_4", (String)"bos-sysinteg-servicehelper", (Object[])new Object[0]));
            return JSON.toJSONString(errResponse);
        }
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        String url = SysIntegrationServiceHelper.getKnowledgeUrl() + "product/" + SysIntegrationServiceHelper.getProductId() + "/search";
        String response = null;
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("uid", userId);
        param.put("types", searchParams.getType());
        param.put(DOMAIN, searchParams.getDomain());
        param.put(MODULE, searchParams.getModule());
        param.put(BIZENTITY, searchParams.getBizentity());
        param.put(LABEL, searchParams.getLabel());
        param.put(RESTRICTIN, searchParams.getRestrictIn());
        param.put("text", searchParams.getContent());
        param.put(AUTHCODE, searchParams.getAuthcode());
        param.put("page", searchParams.getPage());
        param.put(PAGESIZE, searchParams.getPageSize());
        param.put("searchScope", searchParams.getSearchScope());
        String location = searchParams.getLocation();
        param.put("location", location == null ? "" : location);
        boolean allowHtml = searchParams.getAllowHtml();
        if (allowHtml) {
            param.put(ALLOWHTML, allowHtml);
        }
        SysIntegrationServiceHelper.setInfoLog("knowledgeSearch url:" + url);
        SysIntegrationServiceHelper.setInfoLog("knowledgeSearch params:" + ((Object)param).toString());
        try {
            response = HttpClientUtils.get((String)url, SysIntegrationServiceHelper.getHttpRequestHeader(), param);
        }
        catch (Exception e) {
            SysIntegrationServiceHelper.setInfoLog(e.getMessage());
            HashMap<String, String> errResponse = new HashMap<String, String>();
            errResponse.put(ERRCODE, "1");
            errResponse.put(DESCRIPTION, e.getMessage());
            return JSON.toJSONString(errResponse);
        }
        if (StringUtils.isEmpty((CharSequence)response)) {
            HashMap<String, String> errResponse = new HashMap<String, String>();
            errResponse.put(ERRCODE, "1");
            errResponse.put(DESCRIPTION, ResManager.loadKDString((String)"\u83b7\u53d6\u793e\u533a\u4e91\u4fe1\u606f\u5f02\u5e38", (String)"SysIntegrationServiceHelper_5", (String)"bos-sysinteg-servicehelper", (Object[])new Object[0]));
            return JSON.toJSONString(errResponse);
        }
        return response;
    }

    private static int getProductId() {
        ILicenseService licenseService = (ILicenseService)ServiceFactory.getService(ILicenseService.class);
        int modelType = licenseService.getModeType();
        int productId = modelType == 1 ? 68 : (modelType == 2 ? 93 : 3);
        return productId;
    }

    public static Map<String, String> getHttpRequestHeader() {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-type", "application/x-www-form-urlencoded;charset=UTF-8");
        return header;
    }

    public static String knowledgeHot(String type, String domain, String module, String bizentity, String label, String restrictIn, String content, String authcode, int page, int pageSize, Boolean allowHtml) {
        String response = null;
        String url = SysIntegrationServiceHelper.getKnowledgeUrl() + "product/3/hot";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("type", type);
        param.put(DOMAIN, domain);
        param.put(MODULE, module);
        param.put(BIZENTITY, bizentity);
        param.put(LABEL, label);
        param.put(RESTRICTIN, restrictIn);
        param.put("text", content);
        param.put(AUTHCODE, authcode);
        param.put("page", page);
        param.put(PAGESIZE, pageSize);
        param.put(ALLOWHTML, allowHtml);
        try {
            response = HttpClientUtils.get((String)url, SysIntegrationServiceHelper.getHttpRequestHeader(), param);
        }
        catch (Exception e) {
            SysIntegrationServiceHelper.setInfoLog(e.getMessage());
        }
        SysIntegrationServiceHelper.setInfoLog(RESPONSE_DESC + response);
        return response;
    }

    public static String knowledgeQuestions(String domain, String module, String bizentity, String label, String restrictIn, String authcode, int page, int pageSize, Boolean allowHtml) {
        String response = null;
        String url = SysIntegrationServiceHelper.getKnowledgeUrl() + "product/3/frequently-questions";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put(DOMAIN, domain);
        param.put(MODULE, module);
        param.put(BIZENTITY, bizentity);
        param.put(LABEL, label);
        param.put(RESTRICTIN, restrictIn);
        param.put(AUTHCODE, authcode);
        param.put("page", page);
        param.put(PAGESIZE, pageSize);
        param.put(ALLOWHTML, allowHtml);
        try {
            response = HttpClientUtils.get((String)url, SysIntegrationServiceHelper.getHttpRequestHeader(), param);
        }
        catch (Exception e) {
            SysIntegrationServiceHelper.setInfoLog(e.getMessage());
        }
        return response;
    }

    public static String knowledgeArticles(String domain, String module, String bizentity, String authcode) {
        String response = null;
        String url = SysIntegrationServiceHelper.getKnowledgeUrl() + "product/3/frequently-articles";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put(DOMAIN, domain);
        param.put(MODULE, module);
        param.put(BIZENTITY, bizentity);
        param.put(AUTHCODE, authcode);
        try {
            response = HttpClientUtils.get((String)url, SysIntegrationServiceHelper.getHttpRequestHeader(), param);
            SysIntegrationServiceHelper.setInfoLog(response);
        }
        catch (Exception e) {
            SysIntegrationServiceHelper.setInfoLog(e.getMessage());
        }
        return response;
    }

    public static String knowledgeCourses(String domain, String module, String label, String bizentity, String authcode, String restrictIn) {
        String response = null;
        String url = SysIntegrationServiceHelper.getKnowledgeUrl() + "product/3/related-courses";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put(DOMAIN, domain);
        param.put(MODULE, module);
        param.put(BIZENTITY, bizentity);
        param.put(RESTRICTIN, restrictIn);
        param.put(AUTHCODE, authcode);
        param.put(LABEL, label);
        try {
            response = HttpClientUtils.get((String)url, SysIntegrationServiceHelper.getHttpRequestHeader(), param);
            SysIntegrationServiceHelper.setInfoLog(response);
        }
        catch (Exception e) {
            SysIntegrationServiceHelper.setInfoLog(e.getMessage());
            HashMap<String, String> errResponse = new HashMap<String, String>();
            errResponse.put(ERRCODE, "1");
            errResponse.put(DESCRIPTION, e.getMessage());
            return JSON.toJSONString(errResponse);
        }
        if (StringUtils.isEmpty((CharSequence)response)) {
            HashMap<String, String> errResponse = new HashMap<String, String>();
            errResponse.put(ERRCODE, "1");
            errResponse.put(DESCRIPTION, ResManager.loadKDString((String)"\u83b7\u53d6\u793e\u533a\u4e91\u4fe1\u606f\u5f02\u5e38", (String)"SysIntegrationServiceHelper_5", (String)"bos-sysinteg-servicehelper", (Object[])new Object[0]));
            return JSON.toJSONString(errResponse);
        }
        return response;
    }

    public static String knowledgeSolutions(String errcode, String authcode) {
        String response = null;
        String url = "https://knowledge.kingdee.com/product/3/error-solutions";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put(ERRCODE, errcode);
        param.put(AUTHCODE, authcode);
        try {
            response = HttpClientUtils.post((String)url, SysIntegrationServiceHelper.getHttpRequestHeader(), param);
        }
        catch (IOException e) {
            SysIntegrationServiceHelper.setInfoLog(e.getMessage());
        }
        return response;
    }

    public static String knowledgeCommon(String domain, String module, String bizentity, String label, String authcode, int page, int pageSize) {
        String response = null;
        String url = "https://knowledge.kingdee.com/product/3/common";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put(DOMAIN, domain);
        param.put(MODULE, module);
        param.put(BIZENTITY, bizentity);
        param.put(LABEL, label);
        param.put(AUTHCODE, authcode);
        param.put("page", page);
        param.put(PAGESIZE, pageSize);
        try {
            response = HttpClientUtils.get((String)url, SysIntegrationServiceHelper.getHttpRequestHeader(), param);
        }
        catch (Exception e) {
            SysIntegrationServiceHelper.setInfoLog(e.getMessage());
        }
        return response;
    }

    public static String getCloudErpAccessToken() {
        String response = null;
        String url = "http://api.kingdee.com/clouderp/linkceo/accesstoken";
        HashMap<String, String> param = new HashMap<String, String>(8);
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        String nonce = UUID.randomUUID().toString().replace("-", "");
        String signature = SysIntegrationServiceHelper.getSignature(nonce, timestamp);
        param.put("X-Api-ClientID", CLIENT_ID);
        param.put("X-Api-Auth-Version", "2.0");
        param.put("X-Api-TimeStamp", timestamp);
        param.put("X-Api-SignHeaders", "X-Api-TimeStamp,X-Api-Nonce");
        param.put("X-Api-Nonce", nonce);
        param.put("X-Api-Signature", signature);
        RequestContext requestContext = RequestContext.get();
        Map productInfo = LicenseServiceHelper.getProductInfo();
        param.put(CLIENTID, CLIENT_ID);
        param.put("uid", requestContext.getUid());
        param.put(ERPID, requestContext.getUserId());
        param.put("erpName", requestContext.getUserName());
        param.put("erpPhone", UNKNOWN);
        param.put("erpEmail", UNKNOWN);
        param.put("prodInstCode", (String)productInfo.get("prodInstCode"));
        param.put(PRODSN, (String)productInfo.get("productNo"));
        param.put("prodName", ResManager.loadKDString((String)"\u91d1\u8776\u4e91\u82cd\u7a79", (String)"SysIntegrationServiceHelper_6", (String)"bos-sysinteg-servicehelper", (Object[])new Object[0]));
        param.put("prodVersion", (String)productInfo.get("productversion"));
        param.put("prodCategoryCode", SKYCLOUD);
        param.put("prodDeployWay", CLOUD);
        param.put("prodClientType", "WEB");
        param.put("serviceEndDate", (String)productInfo.get("expdate"));
        param.put("userSource", PRODUCT);
        param.put("customerLevel", UNKNOWN);
        param.put("userRole", UNKNOWN);
        param.put("state", "");
        param.put(TIMESTAMP, timestamp);
        param.put("prodSoftcode", (String)productInfo.get("softwareCode"));
        param.put("customerName", "");
        param.put("prodDomain", "");
        param.put("ip", requestContext.getLoginIP());
        param.put("userAgent", requestContext.getUserAgent());
        try {
            response = HttpClientUtils.post((String)url, SysIntegrationServiceHelper.getHttpRequestHeader(), param);
        }
        catch (Exception e) {
            SysIntegrationServiceHelper.setInfoLog(e.getMessage());
        }
        SysIntegrationServiceHelper.setInfoLog(RESPONSE_DESC + response);
        return response;
    }

    private static String getSignature(String nonce, String timestamp) {
        TreeMap<String, String> headMap = new TreeMap<String, String>();
        headMap.put("X-Api-Nonce", nonce);
        headMap.put("X-Api-TimeStamp", timestamp);
        String sign = "";
        try {
            TreeMap<String, String> paramMap = new TreeMap<String, String>();
            String uid = RequestContext.get().getUid();
            if (!StringUtils.isEmpty((CharSequence)uid)) {
                paramMap.put("uid", uid);
            }
            sign = HashHmacCrypto.sign("POST", RELATIVEPATH, paramMap, headMap, CLIENT_SECRET);
        }
        catch (Exception e) {
            SysIntegrationServiceHelper.setInfoLog(e.getMessage());
        }
        return sign;
    }

    public static String getAuthUserAuthCode(String accessToken, String targetId) {
        String authCode = null;
        String response = null;
        String url = "http://api.cloudsz.kingdee.com/auth/user/auth_code";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("access_token", accessToken);
        if (!StringUtils.isEmpty((CharSequence)targetId)) {
            param.put("target_id", "");
        }
        try {
            response = HttpClientUtils.post((String)url, SysIntegrationServiceHelper.getHttpRequestHeader(), param);
        }
        catch (Exception e) {
            SysIntegrationServiceHelper.setInfoLog(e.getMessage());
        }
        SysIntegrationServiceHelper.setInfoLog(RESPONSE_DESC + response);
        JSONObject jason = (JSONObject)JSON.parse((String)response);
        Object errcode = jason.get((Object)ERRCODE);
        authCode = errcode != null && "0".equals(errcode.toString()) ? jason.getString("auth_code") : "";
        return authCode;
    }

    public static Map<String, String> getRobertHome(Boolean isRequireNew) {
        Map<String, String> robertHomeInfo = new HashMap<String, String>(16);
        String linkCeoApiUrl = DefaultParameterService.getDefaultValueByKey((String)"link_ceo_api_url");
        String url = linkCeoApiUrl + HOME_URL;
        robertHomeInfo.put("robertUrl", linkCeoApiUrl);
        robertHomeInfo.put("homeUrl", url);
        String timestamp = String.valueOf(System.currentTimeMillis());
        RequestContext requestContext = RequestContext.get();
        String accessToken = null;
        Map<String, String> accessTokenMap = null;
        try {
            if (!isRequireNew.booleanValue()) {
                accessTokenMap = RobertCache.getAccessToken(requestContext.getUid());
            }
            if (accessTokenMap == null || SysIntegrationServiceHelper.isAccessTokenExpired(accessTokenMap)) {
                accessTokenMap = SysIntegrationServiceHelper.getAccessTokenMap(requestContext);
                if (accessTokenMap != null && accessTokenMap.size() > 0 && "0".equals(accessTokenMap.get(ERRCODE)) && !StringUtils.isEmpty((CharSequence)accessTokenMap.get(ACCESSTOKEN))) {
                    RobertCache.updateAccessToken(requestContext.getUid(), accessTokenMap);
                } else if (accessTokenMap != null && "530".equals(accessTokenMap.get(ERRORCODE))) {
                    int times;
                    int n = times = kd.bos.util.StringUtils.isNotEmpty((String)((String)cache.get("robertHome", "totalTimes"))) ? Integer.parseInt((String)cache.get("robertHome", "totalTimes")) : 0;
                    if (times >= 20) {
                        robertHomeInfo.put(SUCCESS, "false");
                    } else {
                        ++times;
                    }
                    cache.put("robertHome", "totalTimes", String.valueOf(times), 3600);
                }
            }
            if (accessTokenMap != null) {
                accessToken = accessTokenMap.get(ACCESSTOKEN);
            }
        }
        catch (IOException e) {
            SysIntegrationServiceHelper.setInfoLog(e.getMessage());
            robertHomeInfo.put(ERROR, e.getMessage());
            robertHomeInfo.put(SUCCESS, "false");
            return robertHomeInfo;
        }
        catch (Exception e) {
            SysIntegrationServiceHelper.setInfoLog(e.getMessage());
            robertHomeInfo.put(ERROR, e.getMessage());
            return robertHomeInfo;
        }
        if (accessTokenMap != null) {
            robertHomeInfo = SysIntegrationServiceHelper.getRobertHomeInfo(robertHomeInfo, timestamp, requestContext, accessToken, accessTokenMap);
        }
        return robertHomeInfo;
    }

    private static Map<String, String> getAccessTokenMap(RequestContext requestContext) throws IOException {
        AccessTokenQO accessTokenQO = new AccessTokenQO();
        accessTokenQO.setAuthCode(UNKNOWN);
        accessTokenQO.setClientId(CLIENT_ID);
        accessTokenQO.setCustomerLevel(UNKNOWN);
        accessTokenQO.setCustomerName(UNKNOWN);
        accessTokenQO.setErpEmail(UNKNOWN);
        accessTokenQO.setErpId(requestContext.getUserId());
        accessTokenQO.setErpName(requestContext.getUserName());
        accessTokenQO.setErpPhone(UNKNOWN);
        accessTokenQO.setProdCategoryCode(SKYCLOUD);
        accessTokenQO.setProdClientType("WEB");
        accessTokenQO.setProdDeployWay(CLOUD);
        accessTokenQO.setProdDomain(UNKNOWN);
        accessTokenQO.setProdInstCode(UNKNOWN);
        accessTokenQO.setProdName(UNKNOWN);
        accessTokenQO.setProdSN(UNKNOWN);
        accessTokenQO.setProdSoftcode(UNKNOWN);
        accessTokenQO.setProdVersion("1.0");
        accessTokenQO.setServiceEndDate("2019-05-31");
        accessTokenQO.setUid(requestContext.getUid());
        accessTokenQO.setUserRole(UNKNOWN);
        accessTokenQO.setUserSource(PRODUCT);
        accessTokenQO.setExtParam("{}");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SKYCLOUD.").append(requestContext.getTenantId()).append(".").append(requestContext.getAccountId());
        accessTokenQO.setDataCenterCode(stringBuilder.toString());
        String json = JSON.toJSONString((Object)accessTokenQO);
        ProductServiceImpl ps = new ProductServiceImpl();
        Map<String, String> accessTokenMap = ps.getJsonCloudToken(accessTokenQO);
        return accessTokenMap;
    }

    private static Map<String, String> getRobertHomeInfo(Map<String, String> robertHomeInfo, String timestamp, RequestContext requestContext, String accessToken, Map<String, String> accessTokenMap) {
        TreeMap<Object, Object> sortedMap = new TreeMap<Object, Object>();
        sortedMap.put(TIMESTAMP, timestamp);
        sortedMap.put(CLIENTID, CLIENT_ID);
        sortedMap.put(PRODSN, UNKNOWN);
        sortedMap.put("uid", requestContext.getUid());
        sortedMap.put(ERPID, requestContext.getUserId());
        String encodeToken = SinatureUtil.aesSign(sortedMap, accessToken);
        robertHomeInfo.put("uid", requestContext.getUid());
        robertHomeInfo.put(ERPID, requestContext.getUserId());
        robertHomeInfo.put(PRODSN, UNKNOWN);
        robertHomeInfo.put(ACCESSTOKEN, encodeToken);
        robertHomeInfo.put(TIMESTAMP, timestamp);
        robertHomeInfo.put(EXPIRESIN, accessTokenMap.get(EXPIRESIN));
        robertHomeInfo.put(NOTIFYSTATUS, accessTokenMap.get(NOTIFYSTATUS));
        robertHomeInfo.put(SLEEPING, accessTokenMap.get(SLEEPING));
        robertHomeInfo.put(DESCRIPTION, accessTokenMap.get(DESCRIPTION));
        robertHomeInfo.put(DESCRIPTION_CN, accessTokenMap.get(DESCRIPTION_CN));
        return robertHomeInfo;
    }

    private static boolean isAccessTokenExpired(Map<String, String> accessTokenMap) {
        boolean isExpired = false;
        Long createTime = Long.parseLong(accessTokenMap.get(TIMESTAMP));
        Long expiresIn = Long.parseLong(accessTokenMap.get(EXPIRESIN)) * 1000L;
        Long currentTime = System.currentTimeMillis();
        if (createTime + expiresIn < currentTime - 86400000L) {
            isExpired = true;
        }
        return isExpired;
    }

    public static Map<String, String> getOnlineCode() {
        return SysIntegrationServiceHelper.getOnlineCode(null);
    }

    public static Map<String, String> getOnlineCode(Map<String, Object> params) {
        String readkey;
        HashMap<String, String> onlineCode = new HashMap<String, String>(8);
        RequestContext requestContext = RequestContext.get();
        YzjConfig yzjConfig = YzjConfigServiceHelper.getConfig();
        String eid = yzjConfig.getEid();
        if (StringUtils.isBlank((CharSequence)eid)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u4e91\u4e4b\u5bb6\u5de5\u4f5c\u5708\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u4e91\u4e4b\u5bb6\u7684\u7cfb\u7edf\u53c2\u6570\u662f\u5426\u6b63\u786e\u3002", (String)"SysIntegrationServiceHelper_7", (String)"bos-sysinteg-servicehelper", (Object[])new Object[0]));
        }
        String oid = requestContext.getUserOpenId();
        if (StringUtils.isBlank((CharSequence)oid)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u60a8\u7684\u4e91\u4e4b\u5bb6\u516c\u5f00\u7801\u5931\u8d25\uff0c\u8bf7\u5148\u4ece\u4e91\u4e4b\u5bb6\u540c\u6b65\u4e2a\u4eba\u4fe1\u606f", (String)"SysIntegrationServiceHelper_8", (String)"bos-sysinteg-servicehelper", (Object[])new Object[0]));
        }
        String yzjUrl = yzjConfig.getUrl();
        if (StringUtils.isBlank((Object)yzjUrl)) {
            yzjUrl = YZJ_DEFAULT_HOST;
        }
        if (StringUtils.isBlank((Object)(readkey = yzjConfig.getReadKey()))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u4e91\u4e4b\u5bb6\u53ea\u8bfb\u5bc6\u94a5\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u4e91\u4e4b\u5bb6\u7684\u7cfb\u7edf\u53c2\u6570\u662f\u5426\u6b63\u786e\u3002", (String)SYSINTEGRATIONSERVICEHELPER_9, (String)"bos-sysinteg-servicehelper", (Object[])new Object[0]));
        }
        String resGroupSecret = readkey.toString();
        String targetSecret = "";
        String userEid = SysIntegrationServiceHelper.getCurrentUserEid();
        String paramEid = eid;
        if (StringUtils.isBlank((CharSequence)userEid) || "0".equals(userEid) || userEid.equals(eid)) {
            targetSecret = resGroupSecret;
        } else {
            paramEid = userEid;
            Map<String, String> sourceTokenData = SysIntegrationServiceHelper.getAccessToken(yzjUrl.toString(), eid, resGroupSecret);
            if (sourceTokenData.containsKey(ERROR)) {
                return sourceTokenData;
            }
            Map<String, String> targetSecretData = SysIntegrationServiceHelper.getSecret(yzjUrl.toString(), userEid, sourceTokenData.get("data"));
            if (targetSecretData.containsKey(ERROR)) {
                return targetSecretData;
            }
            targetSecret = targetSecretData.get("data");
        }
        SysIntegrationServiceHelper.getCodeFromYZJ(onlineCode, eid, oid, yzjUrl, targetSecret, paramEid);
        return onlineCode;
    }

    private static void getCodeFromYZJ(Map<String, String> onlineCode, String eid, String oid, Object yzjUrl, String targetSecret, String paramEid) {
        try {
            HashMap<String, String> yzjParams = new HashMap<String, String>();
            yzjParams.put("eid", paramEid);
            String kingdeeonline = "kingdeeonline";
            String key = paramEid + "$" + kingdeeonline;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("eid", (Object)paramEid);
            jsonObject.put("oid", (Object)oid);
            jsonObject.put(TIMESTAMP, (Object)Calendar.getInstance().getTimeInMillis());
            jsonObject.put("resGroupSecret", (Object)targetSecret);
            String encryptBody = null;
            try {
                DESUtilsEncrypter des = (DESUtilsEncrypter)BeanUtils.getBean((String)"kd.bos.login.utils.DESUtilsEncrypterImpl");
                byte[] encryptBts = des.encrypt(jsonObject.toJSONString().getBytes("UTF-8"), key);
                encryptBody = Base64.encodeBase64String((byte[])encryptBts);
            }
            catch (Exception e) {
                SysIntegrationServiceHelper.setInfoLog(e.toString());
            }
            yzjParams.put("encryptBody", encryptBody);
            String response = HttpClientUtils.post((String)(yzjUrl + KD_ONLINE_CODE_API_URL), SysIntegrationServiceHelper.getHttpRequestHeader(), yzjParams);
            String code = null;
            Integer expireTime = 0;
            String error = null;
            SysIntegrationServiceHelper.setInfoLog(response);
            JSONObject bodyJason = (JSONObject)JSON.parse((String)response);
            Boolean success = bodyJason.getBoolean(SUCCESS);
            Integer errorCode = bodyJason.getInteger(ERRORCODE);
            if (success.booleanValue() && 100 == errorCode) {
                JSONObject data = bodyJason.getJSONObject("data");
                code = data.getString("code");
                expireTime = data.getInteger("expireTime");
                onlineCode.put("code", code);
                onlineCode.put("expireTime", "" + expireTime);
            } else {
                error = bodyJason.getString(ERROR);
                onlineCode.put(ERROR, error);
            }
        }
        catch (Exception e) {
            SysIntegrationServiceHelper.setInfoLog(e.getMessage());
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u4e91\u4e4b\u5bb6\u5728\u7ebfCode\u53d1\u751f\u5f02\u5e38\uff1a%s", (String)"SysIntegrationServiceHelper_17", (String)"bos-sysinteg-servicehelper", (Object[])new Object[0]), e.getMessage()));
        }
        onlineCode.put("eid", eid);
        onlineCode.put("userEid", paramEid);
        onlineCode.put("oid", oid);
    }

    private static String getCurrentUserEid() {
        DynamicObject userObj = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(RequestContext.get().getUserId()), (String)"bos_user", (String)"eid");
        if (userObj == null) {
            return "";
        }
        return userObj.getString("eid");
    }

    public static Map<String, String> getAccessToken(String secret) {
        RequestContext requestContext = RequestContext.get();
        Account account = AccountUtils.getAccountById((String)requestContext.getAccountId());
        String eid = account.getEid();
        return SysIntegrationServiceHelper.getAccessToken("", eid, secret);
    }

    public static Map<String, String> getAccessToken(String yzjHost, String eid, String secret) {
        if (StringUtils.isBlank((CharSequence)yzjHost)) {
            yzjHost = YZJ_DEFAULT_HOST;
        }
        if (StringUtils.isBlank((CharSequence)eid)) {
            return SysIntegrationServiceHelper.genErrorMsg(ResManager.loadKDString((String)"\u83b7\u53d6\u4e91\u4e4b\u5bb6\u5de5\u4f5c\u5708\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u4e91\u4e4b\u5bb6\u7684\u7cfb\u7edf\u53c2\u6570\u662f\u5426\u6b63\u786e\u3002", (String)"SysIntegrationServiceHelper_7", (String)"bos-sysinteg-servicehelper", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)secret)) {
            return SysIntegrationServiceHelper.genErrorMsg(ResManager.loadKDString((String)"\u4e91\u4e4b\u5bb6Secret\u4e0d\u80fd\u4e3a\u7a7a", (String)"SysIntegrationServiceHelper_11", (String)"bos-sysinteg-servicehelper", (Object[])new Object[0]));
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("eid", eid);
        params.put("secret", secret);
        params.put(TIMESTAMP, Calendar.getInstance().getTimeInMillis());
        params.put("scope", "resGroupSecret");
        try {
            String response = HttpClientUtils.post((String)(yzjHost + YZJ_GET_ACCESSTOKEN_API), SysIntegrationServiceHelper.getHttpRequestHeader(), params);
            if (StringUtils.isBlank((CharSequence)response)) {
                return SysIntegrationServiceHelper.genErrorMsg(String.format(ResManager.loadKDString((String)"%s\uff1a\u83b7\u53d6\u4e91\u4e4b\u5bb6accessToken\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a\u3002", (String)"SysIntegrationServiceHelper_12", (String)"bos-sysinteg-servicehelper", (Object[])new Object[0]), eid));
            }
            JSONObject resJson = (JSONObject)JSON.parse((String)response);
            Boolean success = resJson.getBoolean(SUCCESS);
            if (success.booleanValue()) {
                JSONObject dataJson = resJson.getJSONObject("data");
                HashMap<String, String> result = new HashMap<String, String>();
                result.put("data", dataJson.getString(ACCESSTOKEN));
                return result;
            }
            SysIntegrationServiceHelper.setInfoLog(String.format(ResManager.loadKDString((String)"\u751f\u6210token\u5931\u8d25,EID\u4e3a\uff1a%1$s,\u4e91\u4e4b\u5bb6\u9519\u8bef\u6d88\u606f%2$s,\u4e91\u4e4b\u5bb6\u9519\u8bef\u7801\u4e3a:%3$s", (String)"SysIntegrationServiceHelper_19", (String)"bos-sysinteg-servicehelper", (Object[])new Object[0]), eid, resJson.getString(ERROR), resJson.getString(ERRORCODE)));
            return SysIntegrationServiceHelper.genErrorMsg(ResManager.loadKDString((String)"\u751f\u6210\u4e91\u4e4b\u5bb6\u4ee4\u724c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u4e91\u4e4b\u5bb6\u914d\u7f6e\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SysIntegrationServiceHelper_13", (String)"bos-sysinteg-servicehelper", (Object[])new Object[0]));
        }
        catch (Exception e) {
            SysIntegrationServiceHelper.setInfoLog(e.getMessage());
            return SysIntegrationServiceHelper.genErrorMsg(ResManager.loadKDString((String)"\u751f\u6210\u4e91\u4e4b\u5bb6\u4ee4\u724c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u4e91\u4e4b\u5bb6\u914d\u7f6e\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SysIntegrationServiceHelper_13", (String)"bos-sysinteg-servicehelper", (Object[])new Object[0]));
        }
    }

    public static Map<String, String> getSecret(String accessToken) {
        RequestContext requestContext = RequestContext.get();
        Account account = AccountUtils.getAccountById((String)requestContext.getAccountId());
        String eid = account.getEid();
        return SysIntegrationServiceHelper.getSecret("", eid, accessToken);
    }

    public static Map<String, String> getSecret(String yzjHost, String eid, String accessToken) {
        if (StringUtils.isBlank((CharSequence)yzjHost)) {
            yzjHost = YZJ_DEFAULT_HOST;
        }
        if (StringUtils.isBlank((CharSequence)eid)) {
            return SysIntegrationServiceHelper.genErrorMsg(ResManager.loadKDString((String)"\u83b7\u53d6\u4e91\u4e4b\u5bb6\u5de5\u4f5c\u5708\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u4e91\u4e4b\u5bb6\u7684\u7cfb\u7edf\u53c2\u6570\u662f\u5426\u6b63\u786e\u3002", (String)"SysIntegrationServiceHelper_7", (String)"bos-sysinteg-servicehelper", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            return SysIntegrationServiceHelper.genErrorMsg(ResManager.loadKDString((String)"\u4e91\u4e4b\u5bb6accessToken\u4e0d\u80fd\u4e3a\u7a7a", (String)"SysIntegrationServiceHelper_14", (String)"bos-sysinteg-servicehelper", (Object[])new Object[0]));
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("eid", eid);
        params.put(ACCESSTOKEN, accessToken);
        try {
            String response = HttpClientUtils.post((String)(yzjHost + YZJ_GET_SECRET_API), SysIntegrationServiceHelper.getHttpRequestHeader(), params);
            if (StringUtils.isBlank((CharSequence)response)) {
                return SysIntegrationServiceHelper.genErrorMsg(String.format(ResManager.loadKDString((String)"%s\uff1a\u83b7\u53d6\u4e91\u4e4b\u5bb6secret\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a\u3002", (String)"SysIntegrationServiceHelper_15", (String)"bos-sysinteg-servicehelper", (Object[])new Object[0]), eid));
            }
            JSONObject resJson = (JSONObject)JSON.parse((String)response);
            Boolean success = resJson.getBoolean(SUCCESS);
            if (success.booleanValue()) {
                HashMap<String, String> result = new HashMap<String, String>();
                result.put("data", resJson.getString("data"));
                return result;
            }
            SysIntegrationServiceHelper.setInfoLog(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u4e91\u4e4b\u5bb6secret\u5931\u8d25,EID\u4e3a\uff1a%1$s,\u4e91\u4e4b\u5bb6\u9519\u8bef\u6d88\u606f%2$s,\u4e91\u4e4b\u5bb6\u9519\u8bef\u7801\u4e3a:%3$s", (String)"SysIntegrationServiceHelper_18", (String)"bos-sysinteg-servicehelper", (Object[])new Object[0]), eid, resJson.getString(ERROR), resJson.getString(ERRORCODE)));
            return SysIntegrationServiceHelper.genErrorMsg(ResManager.loadKDString((String)"\u751f\u6210\u4e91\u4e4b\u5bb6\u79d8\u94a5\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u4e91\u4e4b\u5bb6\u914d\u7f6e\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SysIntegrationServiceHelper_16", (String)"bos-sysinteg-servicehelper", (Object[])new Object[0]));
        }
        catch (Exception e) {
            SysIntegrationServiceHelper.setInfoLog(e.getMessage());
            throw new KDBizException(ResManager.loadKDString((String)"\u751f\u6210\u4e91\u4e4b\u5bb6\u79d8\u94a5\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u4e91\u4e4b\u5bb6\u914d\u7f6e\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SysIntegrationServiceHelper_16", (String)"bos-sysinteg-servicehelper", (Object[])new Object[0]));
        }
    }

    private static Map<String, String> genErrorMsg(String msg) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(ERROR, msg);
        SysIntegrationServiceHelper.setInfoLog(msg);
        return result;
    }

    @Deprecated
    public static void updateAllAppFeatures() {
        String allAppFeatures = SysIntegrationServiceHelper.getAllAppFeatures();
        HashMap<String, String> appFeatrueMap = new HashMap<String, String>();
        JSONArray allAppFeaturesArr = JSONArray.parseArray((String)allAppFeatures);
        for (Object appFeatureObj : allAppFeaturesArr) {
            JSONObject appFeature = (JSONObject)appFeatureObj;
            String appNumber = appFeature.getString(APPNUMBER);
            JSONArray contents = appFeature.getJSONArray(CONTENTS);
            if (contents.size() <= 0) continue;
            int index = SysIntegrationServiceHelper.getIndexOfMaxUpateTime(contents);
            JSONObject content = (JSONObject)contents.get(index);
            String title = content.getString(TITLE);
            String updateTime = content.getString(UPDATE_TIME);
            String url = content.getString(URL);
            appFeatrueMap.put(APPNUMBER, appNumber);
            appFeatrueMap.put(TITLE, title);
            appFeatrueMap.put(UPDATE_TIME, updateTime);
            appFeatrueMap.put(URL, url);
            SysIntegrationServiceHelper.addOrUpdateFeature(appFeatrueMap, appNumber, updateTime);
        }
    }

    private static void addOrUpdateFeature(Map<String, String> appFeatrueMap, String appNumber, String updateTime) {
        AppFeaturesCache appFeaturesCache = new AppFeaturesCache();
        Map oldFeature = appFeaturesCache.getAppFeatrue(appNumber);
        if (null != oldFeature) {
            long oldTime = Long.parseLong((String)oldFeature.get(UPDATE_TIME));
            if (Long.parseLong(updateTime) < oldTime) {
                appFeatrueMap = oldFeature;
            }
        }
        appFeaturesCache.updateAppFeature(appNumber, appFeatrueMap);
    }

    private static int getIndexOfMaxUpateTime(JSONArray contents) {
        int index = 0;
        String updateTimeStr = ((JSONObject)contents.get(0)).getString(UPDATE_TIME);
        long maxUpdateTime = Long.parseLong(updateTimeStr);
        for (int i = 0; i < contents.size(); ++i) {
            JSONObject content = (JSONObject)contents.get(i);
            long updateTime = Long.parseLong(content.getString(UPDATE_TIME));
            if (updateTime <= maxUpdateTime) continue;
            index = i;
        }
        return index;
    }

    public static String getAllAppFeatures() {
        ArrayList<Map<String, Object>> allAppFeatures = new ArrayList<Map<String, Object>>();
        Object map = null;
        Object content = null;
        int page = 1;
        int pageSize = 1000;
        Calendar now = Calendar.getInstance();
        now.add(5, -30);
        long createdAtEnd = System.currentTimeMillis();
        long createdAtStart = now.getTimeInMillis();
        String response = null;
        StringBuilder url = new StringBuilder();
        StringBuilder param = new StringBuilder();
        url.append("https://vip.kingdee.com/knowledgeapi/product/3/search?label=NewFeatures&restrictIn=label");
        param.append("&page=").append(page).append("&pageSize=").append(pageSize);
        param.append("&updatedAtStart=").append(createdAtStart);
        param.append("&updatedAtEnd=").append(createdAtEnd);
        url.append((CharSequence)param);
        try {
            response = HttpClientUtils.get((String)url.toString(), SysIntegrationServiceHelper.getHttpRequestHeader(), null);
        }
        catch (Exception e) {
            SysIntegrationServiceHelper.setInfoLog(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u793e\u533a\u4e91\u65b0\u7279\u6027\u4fe1\u606f\u5f02\u5e38:%s", (String)"SysIntegrationServiceHelper_23", (String)"bos-sysinteg-servicehelper", (Object[])new Object[0]), e.getMessage()));
            return JSON.toJSONString(allAppFeatures);
        }
        if (StringUtils.isEmpty((CharSequence)response)) {
            SysIntegrationServiceHelper.setInfoLog(ResManager.loadKDString((String)"\u83b7\u53d6\u793e\u533a\u4e91\u65b0\u7279\u6027\u4fe1\u606f\u4e3a\u7a7a", (String)"SysIntegrationServiceHelper_24", (String)"bos-sysinteg-servicehelper", (Object[])new Object[0]));
            return JSON.toJSONString(allAppFeatures);
        }
        JSONObject responseObj = (JSONObject)JSON.parse((String)response);
        int totalPages = Integer.parseInt(responseObj.get((Object)"totalPages").toString());
        String contentStr = responseObj.get((Object)"content").toString();
        JSONArray conents = (JSONArray)JSONArray.parse((String)contentStr);
        for (Object contentObj : conents) {
            JSONObject contentJsonObj = (JSONObject)JSON.parse((String)contentObj.toString());
            String title = contentJsonObj.get((Object)TITLE).toString();
            String entityUrl = contentJsonObj.get((Object)ENTITYURL).toString();
            String classifiesStr = null;
            String knowledgeUpdatedAt = null;
            if ("Question".equals(contentJsonObj.get((Object)"entity-type").toString())) {
                if (null == contentJsonObj.get((Object)TITLE) || null == contentJsonObj.get((Object)ENTITYURL) || null == contentJsonObj.get((Object)"answer")) {
                    SysIntegrationServiceHelper.setInfoLog(ResManager.loadKDString((String)"\u83b7\u53d6\u793e\u533a\u4e91\u65b0\u7279\u6027title/entityUrl/answer\u4e3a\u7a7a", (String)"SysIntegrationServiceHelper_22", (String)"bos-sysinteg-servicehelper", (Object[])new Object[0]));
                    continue;
                }
                JSONObject answer = (JSONObject)JSON.parse((String)contentJsonObj.get((Object)"answer").toString());
                if (null == answer.get((Object)CLASSIFIES) || null == answer.get((Object)KNOWLEDGEUPDATEDAT)) {
                    SysIntegrationServiceHelper.setInfoLog(ResManager.loadKDString((String)"\u83b7\u53d6\u793e\u533a\u4e91\u65b0\u7279\u6027answer/classifies/knowledgeUpdatedAt\u4e3a\u7a7a", (String)"SysIntegrationServiceHelper_21", (String)"bos-sysinteg-servicehelper", (Object[])new Object[0]));
                    continue;
                }
                knowledgeUpdatedAt = answer.get((Object)KNOWLEDGEUPDATEDAT).toString();
                classifiesStr = answer.get((Object)CLASSIFIES).toString();
            } else {
                if (null == contentJsonObj.get((Object)TITLE) || null == contentJsonObj.get((Object)ENTITYURL) || null == contentJsonObj.get((Object)KNOWLEDGEUPDATEDAT) || null == contentJsonObj.get((Object)CLASSIFIES)) {
                    SysIntegrationServiceHelper.setInfoLog(ResManager.loadKDString((String)"\u83b7\u53d6\u793e\u533a\u4e91\u65b0\u7279\u6027title/entityUrl/knowledgeUpdatedAt/classifies\u4e3a\u7a7a", (String)"SysIntegrationServiceHelper_20", (String)"bos-sysinteg-servicehelper", (Object[])new Object[0]));
                    continue;
                }
                knowledgeUpdatedAt = contentJsonObj.get((Object)KNOWLEDGEUPDATEDAT).toString();
                classifiesStr = contentJsonObj.get((Object)CLASSIFIES).toString();
            }
            SysIntegrationServiceHelper.putXmlDataIntoMap(allAppFeatures, title, entityUrl, classifiesStr, knowledgeUpdatedAt);
        }
        return JSON.toJSONString(allAppFeatures);
    }

    private static void putXmlDataIntoMap(List<Map<String, Object>> allAppFeatures, String title, String entityUrl, String classifiesStr, String knowledgeUpdatedAt) {
        JSONArray classifies = (JSONArray)JSONArray.parse((String)classifiesStr);
        for (Object classifyObj : classifies) {
            Object moduleObj;
            JSONObject product = (JSONObject)JSON.parse((String)classifyObj.toString());
            Object domainObj = product.get((Object)"child");
            if (null == domainObj || null == (moduleObj = ((JSONObject)domainObj).get((Object)"child"))) continue;
            String appnumber = ((JSONObject)moduleObj).get((Object)"code").toString();
            HashMap<String, Object> map = new HashMap<String, Object>();
            ArrayList contents = new ArrayList();
            HashMap<String, String> content = new HashMap<String, String>();
            map.put(APPNUMBER, appnumber);
            map.put(CONTENTS, contents);
            content.put(TITLE, title);
            content.put(UPDATE_TIME, knowledgeUpdatedAt + "");
            content.put(URL, entityUrl);
            contents.add(content);
            allAppFeatures.add(map);
        }
    }

    public static Map<String, String> getPreSalesChatURL(String authCode) {
        HashMap<String, String> preSalesChatURLInfo = new HashMap<String, String>(8);
        Object response = null;
        String url = "https://supportest.kingdee.com/osp2016/chat/pc/index.php";
        StringBuilder sb = new StringBuilder(url);
        String timestamp = String.valueOf(System.currentTimeMillis());
        RequestContext requestContext = RequestContext.get();
        try {
            HashMap<String, String> param = new HashMap<String, String>(8);
            ArrayList<Object> paramVal = new ArrayList<Object>(8);
            param.put("kduid", requestContext.getUid());
            param.put("vendorID", "8");
            param.put("type", "Sales");
            param.put("source", "Kdcloud");
            param.put("serviceType", "1");
            param.put(AUTHCODE, authCode);
            param.put("nonce", timestamp);
            param.put(TIMESTAMP, timestamp);
            sb.append("?vendorID=8");
            for (Map.Entry entry : param.entrySet()) {
                if (!((String)entry.getKey()).equals("vendorID")) {
                    sb.append("&").append((String)entry.getKey()).append("=").append((String)entry.getValue());
                }
                paramVal.add(entry.getValue());
            }
            paramVal.add("LTAIKzJqfjQ70Jiw");
            Collections.sort(paramVal);
            String paramValStr = StringUtils.join(paramVal, (String)"");
            String signature = SHAUtils.sha((String[])new String[]{paramValStr});
            preSalesChatURLInfo.put("preSalesChatURL", sb.toString());
            preSalesChatURLInfo.put("preSalesChatSignatureURL", sb + "&signature=" + signature);
        }
        catch (Exception e) {
            SysIntegrationServiceHelper.setInfoLog(e.getMessage());
            preSalesChatURLInfo.put(ERROR, e.getMessage());
            return preSalesChatURLInfo;
        }
        return preSalesChatURLInfo;
    }

    public static Map<String, String> getOnlineServiceURL() {
        HashMap<String, String> onlineServiceURLInfo = new HashMap<String, String>();
        StringBuilder robertHomeUrl = new StringBuilder();
        Object response = null;
        String url = "https://supportest.kingdee.com/productSelect.php";
        String linkCeoApiUrl = DefaultParameterService.getDefaultValueByKey((String)"link_ceo_api_url");
        onlineServiceURLInfo.put("robertUrl", linkCeoApiUrl);
        onlineServiceURLInfo.put("homeUrl", url);
        String timestamp = String.valueOf(System.currentTimeMillis());
        RequestContext requestContext = RequestContext.get();
        Map productInfo = LicenseServiceHelper.getProductInfo();
        String accessToken = null;
        Map<String, String> accessTokenMap = null;
        try {
            if (accessTokenMap == null) {
                AccessTokenQO accessTokenQO = new AccessTokenQO();
                accessTokenQO.setAuthCode(UNKNOWN);
                accessTokenQO.setClientId(CLIENT_ID);
                accessTokenQO.setCustomerLevel(UNKNOWN);
                accessTokenQO.setCustomerName(UNKNOWN);
                accessTokenQO.setErpEmail(UNKNOWN);
                accessTokenQO.setErpId(requestContext.getUserId());
                accessTokenQO.setErpName(requestContext.getUserName());
                accessTokenQO.setErpPhone(UNKNOWN);
                accessTokenQO.setProdCategoryCode(SKYCLOUD);
                accessTokenQO.setProdClientType("WEB");
                accessTokenQO.setProdDeployWay(CLOUD);
                accessTokenQO.setProdDomain(UNKNOWN);
                accessTokenQO.setProdInstCode(UNKNOWN);
                accessTokenQO.setProdName(UNKNOWN);
                accessTokenQO.setProdSN(UNKNOWN);
                accessTokenQO.setProdSoftcode(UNKNOWN);
                accessTokenQO.setProdVersion("1.0");
                accessTokenQO.setServiceEndDate("2019-05-31");
                accessTokenQO.setUid(requestContext.getUid());
                accessTokenQO.setUserRole(UNKNOWN);
                accessTokenQO.setUserSource(PRODUCT);
                accessTokenQO.setExtParam("{}");
                String json = JSON.toJSONString((Object)accessTokenQO);
                ProductServiceImpl ps = new ProductServiceImpl();
                accessTokenMap = ps.getJsonCloudToken(accessTokenQO);
            }
            accessToken = (String)accessTokenMap.get(ACCESSTOKEN);
        }
        catch (IOException e) {
            SysIntegrationServiceHelper.setInfoLog(e.getMessage());
            onlineServiceURLInfo.put(ERROR, e.getMessage());
            return onlineServiceURLInfo;
        }
        TreeMap<Object, Object> sortedMap = new TreeMap<Object, Object>();
        sortedMap.put(TIMESTAMP, timestamp);
        sortedMap.put(CLIENTID, CLIENT_ID);
        sortedMap.put(PRODSN, UNKNOWN);
        sortedMap.put("uid", requestContext.getUid());
        sortedMap.put(ERPID, requestContext.getUserId());
        String encodeToken = SinatureUtil.aesSign(sortedMap, accessToken);
        robertHomeUrl.append(linkCeoApiUrl);
        robertHomeUrl.append(HOME_URL);
        robertHomeUrl.append("?uid=").append(requestContext.getUid());
        robertHomeUrl.append("&erpId=").append(requestContext.getUserId());
        robertHomeUrl.append("&prodSN=").append(UNKNOWN);
        robertHomeUrl.append("&timestamp=").append(timestamp);
        robertHomeUrl.append("&accessToken=").append(encodeToken);
        onlineServiceURLInfo.put("uid", requestContext.getUid());
        onlineServiceURLInfo.put(ERPID, requestContext.getUserId());
        onlineServiceURLInfo.put(PRODSN, UNKNOWN);
        onlineServiceURLInfo.put(ACCESSTOKEN, encodeToken);
        onlineServiceURLInfo.put(TIMESTAMP, timestamp);
        onlineServiceURLInfo.put(EXPIRESIN, accessTokenMap.get(EXPIRESIN));
        onlineServiceURLInfo.put(NOTIFYSTATUS, accessTokenMap.get(NOTIFYSTATUS));
        onlineServiceURLInfo.put(SLEEPING, accessTokenMap.get(SLEEPING));
        onlineServiceURLInfo.put(DESCRIPTION, accessTokenMap.get(DESCRIPTION));
        onlineServiceURLInfo.put(DESCRIPTION_CN, accessTokenMap.get(DESCRIPTION_CN));
        return onlineServiceURLInfo;
    }

    private static void setInfoLog(String mes) {
        logger.info(mes);
    }
}

