/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sysint.api;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.sysint.api.IExtSysService;
import kd.bos.sysint.cache.SysIntegCacheMrg;
import kd.bos.util.StringUtils;

public class DataMappingService {
    private static Log log = LogFactory.getLog(DataMappingService.class);
    public static final String ENTITYID_EXTERNALSYS = "bas_externalsys";
    public static final String ENTITYID_EASCONFIG = "bas_easconfig";
    public static final String ENTITYID_BAS_DATATYPE = "bas_datatype";
    public static final String ENTITYID_BAS_DATAMAPPING = "bas_datamapping";
    public static final String ENTITYID_POSITIONMAPPING = "bas_positionmapping";
    public static final String ENTITYID_ORG_STRUCTURE = "bos_org_structure";
    private static final String NUMBER = "number";
    private static final String BOS_SYSINTEG_BUSINESS = "bos-sysinteg-business";
    private static final String BOS_USERPOSITION = "bos_userposition";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String BOS_ORG = "bos_org";
    private static final String BOS_COSTCENTER = "bos_costcenter";
    private static final String EXTDATAID = "extdataid";
    private static final String EXTNUMBER = "extnumber";
    private static final String EXTNAME = "extname";

    public void createMapping(Long dataTypeID) {
        ORM orm = ORM.create();
        DynamicObject dataType = orm.getById(ENTITYID_BAS_DATATYPE, (Object)dataTypeID);
        String dataTypeNumber = dataType.get(NUMBER).toString();
        DynamicObject externalsys = (DynamicObject)dataType.get("externalsys");
        if (null == externalsys) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5916\u90e8\u7cfb\u7edf\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u5f55\u5165", (String)"DataMappingService_5", (String)BOS_SYSINTEG_BUSINESS, (Object[])new Object[0]));
        }
        externalsys = orm.getById(ENTITYID_EXTERNALSYS, externalsys.getPkValue());
        DynamicObject bizObj = (DynamicObject)dataType.get("dataType");
        if (null == bizObj) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u5f55\u5165\u4e1a\u52a1\u5bf9\u8c61", (String)"DataMappingService_3", (String)BOS_SYSINTEG_BUSINESS, (Object[])new Object[0]));
        }
        String bizObjID = (String)bizObj.get(NUMBER);
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)bizObjID);
        String tableName = dt.getAlias();
        if (StringUtils.isEmpty((String)tableName)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u6570\u636e\u8868\u4e0d\u5b58\u5728", (String)"DataMappingService_4", (String)BOS_SYSINTEG_BUSINESS, (Object[])new Object[0]));
        }
        this.save(dataTypeID, dataType, dataTypeNumber, externalsys, bizObjID, tableName);
        SysIntegCacheMrg.clearCache(dataTypeNumber);
    }

    private void save(Long dataTypeID, DynamicObject dataType, String dataTypeNumber, DynamicObject externalsys, String bizObjID, String tableName) {
        String algoKey = DataMappingService.class.getName();
        StringBuilder sql = new StringBuilder(StringUtils.getEmpty());
        if (BOS_USERPOSITION.equals(bizObjID)) {
            sql.append(" select up.fid,up.fdptid from ");
            sql.append(tableName);
            sql.append(" up where not EXISTS (SELECT 1 from T_BAS_PositionMapping pm where up.fid = pm.FUserID and up.fdptid = pm.FOrgID) ");
        } else {
            sql.append(" select * from ");
            sql.append(tableName);
            sql.append(" inner JOIN ");
            sql.append(tableName);
            sql.append("_L on ");
            sql.append(tableName);
            sql.append(".fid = ");
            sql.append(tableName);
            sql.append("_l.FID ");
            sql.append(" where ");
            sql.append(tableName);
            sql.append(".fid not in(select FDataID from T_BAS_DataMapping where FDataTypeID = ");
            sql.append(dataTypeID);
            sql.append(") ");
            sql.append(" and ");
            sql.append(tableName);
            sql.append("_L.FLOCALEID = 'zh_CN' ");
        }
        Object[] params = null;
        try (DataSet ds = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.basedata, (String)sql.toString(), params);){
            Iterator rowIterator = ds.iterator();
            Row data = null;
            String impleclass = (String)externalsys.get("impleclass");
            IExtSysService extSysService = (IExtSysService)TypesContainer.createInstance((String)impleclass);
            extSysService.init((Long)externalsys.getPkValue());
            while (rowIterator != null && rowIterator.hasNext()) {
                data = (Row)rowIterator.next();
                Map<String, String> map = this.validateParm(dataTypeID, dataType, dataTypeNumber, externalsys, bizObjID, tableName, data);
                String id = map.get(ID);
                String number = map.get(NUMBER);
                String name = map.get(NAME);
                if (BOS_USERPOSITION.equals(bizObjID)) {
                    this.savePositionMapBeforeDo(dataType, data, extSysService);
                    continue;
                }
                this.saveDataMapBeforeDo(dataType, bizObjID, data, id, number, name, extSysService);
            }
        }
    }

    private Map<String, String> validateParm(Long dataTypeID, DynamicObject dataType, String dataTypeNumber, DynamicObject externalsys, String bizObjID, String tableName, Row data) {
        String id = null;
        String number = null;
        String name = null;
        HashMap<String, String> map = new HashMap<String, String>(3);
        if (!BOS_USERPOSITION.equals(bizObjID)) {
            if ("bos_person".equals(dataTypeNumber) || "bos_user".equals(dataTypeNumber)) {
                id = data.get("fid").toString();
                number = data.getString("FOpenID");
                name = data.getString("ftruename");
            } else if (BOS_ORG.equals(bizObjID) || BOS_COSTCENTER.equals(bizObjID)) {
                id = data.get("fid").toString();
                number = data.getString("fnumber");
                name = this.getOrgFullNameByID(id);
            } else {
                id = data.get("fid").toString();
                number = data.getString("fnumber");
                name = data.getString("fname");
            }
        }
        map.put(ID, id);
        map.put(NUMBER, number);
        map.put(NAME, name);
        return map;
    }

    private void savePositionMapBeforeDo(DynamicObject dataType, Row data, IExtSysService extSysService) {
        Long orgId;
        Map<String, String> externalData = null;
        Long userId = data.getLong("fid");
        externalData = DataMappingService.getExtPosition(userId, orgId = data.getLong("fdptid"), extSysService);
        if (externalData != null && externalData.size() > 0) {
            DataMappingService.savePositionMap(dataType, userId, orgId, externalData);
        }
    }

    private void saveDataMapBeforeDo(DynamicObject dataType, String bizObjID, Row data, String id, String number, String name, IExtSysService extSysService) {
        Map<String, String> externalData = DataMappingService.getExtData(dataType, number, name, extSysService);
        if (externalData != null && externalData.size() > 0) {
            if (BOS_ORG.equals(bizObjID) || BOS_COSTCENTER.equals(bizObjID)) {
                name = data.getString("fname");
            }
            DataMappingService.saveDataMap(dataType, id, number, name, externalData);
        }
    }

    private String getOrgFullNameByID(String orgId) {
        String fullName = "";
        String selectFields = "fullname";
        QFilter viewFilter = new QFilter("view", "=", (Object)1L);
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.valueOf(orgId));
        QFilter[] filters = new QFilter[]{viewFilter, orgFilter};
        DynamicObject orgInfo = QueryServiceHelper.queryOne((String)ENTITYID_ORG_STRUCTURE, (String)selectFields, (QFilter[])filters);
        if (orgInfo != null) {
            fullName = orgInfo.getString("fullname");
        }
        return fullName;
    }

    public static void saveDataMap(DynamicObject dataType, String id, String number, String name, Map externalData) {
        ORM orm = ORM.create();
        MainEntityType datamappingDT = EntityMetadataCache.getDataEntityType((String)ENTITYID_BAS_DATAMAPPING);
        DynamicObject datamappingInfo = null;
        datamappingInfo = new DynamicObject((DynamicObjectType)datamappingDT);
        datamappingInfo.set("datatype", (Object)dataType);
        datamappingInfo.set("dataid", (Object)id);
        datamappingInfo.set(NUMBER, (Object)number);
        datamappingInfo.set(NAME, (Object)name);
        datamappingInfo.set(EXTDATAID, externalData.get(ID));
        datamappingInfo.set(EXTNUMBER, externalData.get(NUMBER));
        datamappingInfo.set(EXTNAME, externalData.get(NAME));
        orm.insert(datamappingInfo);
    }

    public static Map<String, String> getExtData(DynamicObject dataType, String number, String name, IExtSysService extSysService) {
        Map externalData = null;
        try {
            String dataTypeNumber;
            switch (dataTypeNumber = dataType.get(NUMBER).toString()) {
                case "bos_org": {
                    externalData = extSysService.getExternalOrg(number, name);
                    break;
                }
                case "bos_costcenter": {
                    externalData = extSysService.getExternalCostCenter(number, name);
                    break;
                }
                case "bos_user": {
                    externalData = extSysService.getExternalUser(number, name);
                    break;
                }
                case "bos_person": {
                    externalData = extSysService.getExternalPerson(number, name);
                    break;
                }
                case "bd_settlementtype": {
                    externalData = extSysService.getExternalSettlementType(number, name);
                    break;
                }
                case "bd_city": {
                    externalData = extSysService.getExternalCity(number, name);
                    break;
                }
                case "bd_bebank": {
                    externalData = extSysService.getExternalBEBank(number, name);
                    break;
                }
                case "bd_currency": {
                    externalData = extSysService.getExternalCurrency(number, name);
                    break;
                }
                case "bos_userposition": {
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw e;
        }
        return externalData;
    }

    public static void savePositionMap(DynamicObject dataType, Long userID, Long orgID, Map<String, String> positionInfo) {
        ORM orm = ORM.create();
        MainEntityType datamappingDT = EntityMetadataCache.getDataEntityType((String)ENTITYID_POSITIONMAPPING);
        DynamicObject datamappingInfo = null;
        datamappingInfo = new DynamicObject((DynamicObjectType)datamappingDT);
        datamappingInfo.set("datatype", (Object)dataType);
        datamappingInfo.set("userid", (Object)userID);
        datamappingInfo.set("orgid", (Object)orgID);
        datamappingInfo.set("extpersonid", (Object)positionInfo.get("personId"));
        datamappingInfo.set("extpersonnumber", (Object)positionInfo.get("userNumber"));
        datamappingInfo.set("extpersonname", (Object)positionInfo.get("userName"));
        datamappingInfo.set("extorgid", (Object)positionInfo.get("orgId"));
        datamappingInfo.set("extorgnumber", (Object)positionInfo.get("orgNumber"));
        datamappingInfo.set("extorgname", (Object)positionInfo.get("orgName"));
        datamappingInfo.set("extpositionid", (Object)positionInfo.get("positionId"));
        datamappingInfo.set("extpositionnumber", (Object)positionInfo.get("positionNumber"));
        datamappingInfo.set("extpositionname", (Object)positionInfo.get("positionName"));
        orm.insert(datamappingInfo);
    }

    public static Map<String, String> getDataMap(DynamicObject dataType, String id, String number, String name) {
        QFilter idFilter;
        HashMap<String, String> externalData = null;
        ORM orm = ORM.create();
        DynamicObject datamapping = null;
        String selectFields = "*";
        String orderBys = "";
        int top = 1;
        QFilter datatypeFilter = new QFilter("datatype.id", "=", dataType.getPkValue());
        QFilter[] filters = new QFilter[]{datatypeFilter, idFilter = new QFilter("dataid", "=", (Object)id)};
        DynamicObjectCollection datamappingList = orm.query(ENTITYID_BAS_DATAMAPPING, selectFields, filters, orderBys, top);
        if (datamappingList != null && datamappingList.size() > 0) {
            datamapping = (DynamicObject)datamappingList.get(0);
            externalData = new HashMap<String, String>();
            externalData.put(ID, datamapping.getString(EXTDATAID));
            externalData.put(NUMBER, datamapping.getString(EXTNUMBER));
            externalData.put(NAME, datamapping.getString(EXTNAME));
            return externalData;
        }
        if (StringUtils.isEmpty((String)number) || StringUtils.isEmpty((String)name)) {
            log.error("\u4e0d\u5b58\u5728\u6570\u636e\u7c7b\u578b" + dataType + " ID " + id + " \u7f16\u7801 " + number + " \u540d\u79f0 " + name + " \u7684\u6620\u5c04\u5173\u7cfb\u3002");
            return externalData;
        }
        QFilter numberFilter = new QFilter(NUMBER, "=", (Object)number);
        QFilter nameFilter = new QFilter(NAME, "=", (Object)name);
        filters = new QFilter[]{datatypeFilter, numberFilter, nameFilter};
        datamappingList = orm.query(ENTITYID_BAS_DATAMAPPING, selectFields, filters, orderBys, top);
        if (datamappingList != null && datamappingList.size() > 0) {
            datamapping = (DynamicObject)datamappingList.get(0);
            externalData = new HashMap();
            externalData.put(ID, datamapping.getString(EXTDATAID));
            externalData.put(NUMBER, datamapping.getString(EXTNUMBER));
            externalData.put(NAME, datamapping.getString(EXTNAME));
            return externalData;
        }
        log.error("\u4e0d\u5b58\u5728\u6570\u636e\u7c7b\u578b" + dataType + " ID " + id + " \u7f16\u7801 " + number + " \u540d\u79f0 " + name + " \u7684\u6620\u5c04\u5173\u7cfb\u3002");
        return externalData;
    }

    public static Map<String, String> getExtPosition(Long userID, Long orgID, IExtSysService extSysService) {
        Map positionInfo = null;
        positionInfo = extSysService.getExternalPosition(userID, orgID);
        return positionInfo;
    }

    public static Map<String, String> getPositionMap(DynamicObject dataType, Long userID, Long orgID) {
        QFilter orgidFilter;
        QFilter useridFilter;
        HashMap<String, String> positionInfo = null;
        ORM orm = ORM.create();
        DynamicObject datamapping = null;
        String selectFields = "*";
        String orderBys = "";
        int top = 1;
        QFilter datatypeFilter = new QFilter("datatype.id", "=", dataType.getPkValue());
        QFilter[] filters = new QFilter[]{datatypeFilter, useridFilter = new QFilter("userid", "=", (Object)userID), orgidFilter = new QFilter("orgid", "=", (Object)orgID)};
        DynamicObjectCollection datamappingList = orm.query(ENTITYID_POSITIONMAPPING, selectFields, filters, orderBys, top);
        if (datamappingList != null && datamappingList.size() > 0) {
            datamapping = (DynamicObject)datamappingList.get(0);
            positionInfo = new HashMap<String, String>();
            positionInfo.put(ID, datamapping.getString("extpositionid"));
            positionInfo.put(NUMBER, datamapping.getString("extpositionnumber"));
            positionInfo.put(NAME, datamapping.getString("extpositionname"));
        }
        return positionInfo;
    }

    public static DynamicObject getDataType(Long externalSysID, String dataTypeNumber) {
        QFilter externalSysFilter = new QFilter("externalsys", "=", (Object)externalSysID);
        QFilter numberFilter = new QFilter(NUMBER, "=", (Object)dataTypeNumber);
        QFilter[] filters = new QFilter[]{externalSysFilter, numberFilter};
        DynamicObject dataType = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITYID_BAS_DATATYPE, (QFilter[])filters);
        if (dataType == null) {
            log.error("\u5916\u90e8\u7cfb\u7edf " + externalSysID + "\uff0c\u4e1a\u52a1\u5bf9\u8c61 " + dataTypeNumber + " \u672a\u5b9a\u4e49\u6570\u636e\u7c7b\u578b\uff01");
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5916\u90e8\u7cfb\u7edf %1$s\uff0c\u4e1a\u52a1\u5bf9\u8c61 %2$s \u672a\u5b9a\u4e49\u6570\u636e\u7c7b\u578b\uff01", (String)"DataMappingService_6", (String)BOS_SYSINTEG_BUSINESS, (Object[])new Object[0]), externalSysID, dataTypeNumber));
        }
        return dataType;
    }
}

