/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sysint.cache;

import com.alibaba.fastjson.JSON;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.sysint.cache.AppFeaturesCacheMrg;

public class AppFeaturesCache {
    private static final Log log = LogFactory.getLog(AppFeaturesCache.class);
    private static final String USER_ENTITY_NUMBER = "bos_user";
    private static final String UPDATE_TIME = "updateTime";
    private static final String FLAG = "flag";

    public Date getAppFeatureLastUpdateTime(String appNumber) {
        Date appFeatureLastUpdateTime = null;
        Map appFeatrue = null;
        try {
            String allAppFeaturesType = AppFeaturesCacheMrg.getType4AllAppFeatures();
            String appFeatrueJson = AppFeaturesCacheMrg.getCache(allAppFeaturesType, appNumber);
            if (StringUtils.isNotEmpty((CharSequence)appFeatrueJson)) {
                appFeatrue = (Map)JSON.parse((String)appFeatrueJson);
                appFeatureLastUpdateTime = new Date(Long.parseLong((String)appFeatrue.get(UPDATE_TIME)));
            }
        }
        catch (Exception e) {
            log.info("\u83b7\u53d6\u65b0\u7279\u6027\u66f4\u65b0\u65f6\u95f4\u5f02\u5e38:" + e.getMessage());
        }
        return appFeatureLastUpdateTime;
    }

    public Map<String, String> getAppFeatrue(String appNumber) {
        Map appFeatrue = null;
        String allAppFeaturesType = AppFeaturesCacheMrg.getType4AllAppFeatures();
        String appFeatrueJson = AppFeaturesCacheMrg.getCache(allAppFeaturesType, appNumber);
        appFeatrue = (Map)JSON.parse((String)appFeatrueJson);
        return appFeatrue;
    }

    public void updateAppFeature(String appNumber, Map<String, String> appFeatrue) {
        String allAppFeaturesType = AppFeaturesCacheMrg.getType4AllAppFeatures();
        AppFeaturesCacheMrg.putCache(allAppFeaturesType, appNumber, JSON.toJSONString(appFeatrue));
    }

    public Boolean getUserAppFeatureFlag(Long userID, String appNumber) {
        Boolean flag = Boolean.FALSE;
        try {
            String key = userID + appNumber;
            String userAppFeaturesType = AppFeaturesCacheMrg.getType4UserAppFeatures();
            String appFeatrueJson = AppFeaturesCacheMrg.getCache(userAppFeaturesType, key);
            Map<String, String> appFeatrue = this.getAppFeatrue(appNumber);
            if (null == appFeatrue) {
                return flag;
            }
            flag = this.saveAppFeature(flag, appFeatrueJson, appFeatrue);
        }
        catch (Exception e) {
            log.info("\u83b7\u53d6\u7528\u6237\u65b0\u7279\u6027\u5f02\u5e38:" + e.getMessage());
        }
        return flag;
    }

    private Boolean saveAppFeature(Boolean flag, String appFeatrueJson, Map<String, String> appFeatrue) {
        Date newTime = new Date(Long.parseLong(appFeatrue.get(UPDATE_TIME)));
        if (StringUtils.isNotEmpty((CharSequence)appFeatrueJson)) {
            Date oldTime;
            Map userAppFeatrue = (Map)JSON.parse((String)appFeatrueJson);
            String updateTimeStr = String.valueOf(userAppFeatrue.get(UPDATE_TIME));
            if (StringUtils.isNotEmpty((CharSequence)updateTimeStr) && newTime.after(oldTime = new Date(Long.parseLong(appFeatrue.get(UPDATE_TIME))))) {
                flag = Boolean.TRUE;
            }
        } else {
            flag = Boolean.TRUE;
        }
        return flag;
    }

    public void updateUserAppFeatureFlag(Long userID, String appNumber, Boolean flag, Date newTime) {
        String key = userID + appNumber;
        String userAppFeaturesType = AppFeaturesCacheMrg.getType4UserAppFeatures();
        HashMap<String, Comparable<Boolean>> map = new HashMap<String, Comparable<Boolean>>();
        map.put(FLAG, flag);
        map.put(UPDATE_TIME, Long.valueOf(newTime.getTime()));
        AppFeaturesCacheMrg.putCache(userAppFeaturesType, key, JSON.toJSONString(map));
    }

    public void batchUpdateUserAppFeatureFlag(String appNumber, Boolean flag) {
        String userAppFeaturesType = AppFeaturesCacheMrg.getType4UserAppFeatures();
        List<Long> userIds = this.getUserIds();
        HashMap<String, String> allUserAppFeatureMap = new HashMap<String, String>(userIds.size());
        HashMap<String, String> userAppFeatrue = new HashMap<String, String>(userIds.size());
        for (Long userID : userIds) {
            String key = userID + appNumber;
            userAppFeatrue.put(FLAG, String.valueOf(flag));
            allUserAppFeatureMap.put(key, JSON.toJSONString(userAppFeatrue));
        }
        AppFeaturesCacheMrg.putCache(userAppFeaturesType, allUserAppFeatureMap);
    }

    public void batchUpdateUserAppFeatureFlag(String appNumber) {
        String userAppFeaturesType = AppFeaturesCacheMrg.getType4UserAppFeatures();
        List<Long> userIds = this.getUserIds();
        HashMap<String, String> allUserAppFeatureMap = new HashMap<String, String>(userIds.size());
        HashMap<String, String> userAppFeatrue = new HashMap<String, String>(userIds.size());
        for (Long userID : userIds) {
            String key = userID + appNumber;
            userAppFeatrue.put(FLAG, String.valueOf(Boolean.TRUE));
            allUserAppFeatureMap.put(key, JSON.toJSONString(userAppFeatrue));
        }
        AppFeaturesCacheMrg.putCache(userAppFeaturesType, allUserAppFeatureMap);
    }

    private List<Long> getUserIds() {
        String dataTableName = ORM.create().getDataEntityType(USER_ENTITY_NUMBER).getAlias();
        String dbRouteKey = ORM.create().getDataEntityType(USER_ENTITY_NUMBER).getDBRouteKey();
        DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
        String sql = "SELECT fid FROM " + dataTableName;
        List result = (List)DB.query((DBRoute)dbRoute, (String)sql, null, (ResultSetHandler)new ResultSetHandler<List<Long>>(){

            public List<Long> handle(ResultSet rs) throws SQLException {
                ArrayList<Long> list = new ArrayList<Long>(10);
                while (rs.next()) {
                    list.add(rs.getLong(1));
                }
                return list;
            }
        });
        return result;
    }
}

