/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sysint.cache;

import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.exception.KDBizException;

public class SysIntegCacheMrg {
    private static final String SYS_INTEG = "SYS_INTEG";
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("SYS_INTEG", new DistributeCacheHAPolicy());
    public static final String DATA_LOADED = "DATA_LOADED";

    private SysIntegCacheMrg() {
    }

    private static String getAcctId() {
        String acctId = CacheKeyUtil.getAcctId();
        if (acctId == null || acctId.length() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u79df\u6237\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SysIntegCacheMrg_0", (String)"bos-sysinteg-business", (Object[])new Object[0]));
        }
        return acctId;
    }

    public static void clearAllCache() {
    }

    public static void clearCache(String type) {
        type = type + "_" + SysIntegCacheMrg.getAcctId();
        cache.removeType(type);
    }

    public static void clearCache(String type, String key) {
        type = type + "_" + SysIntegCacheMrg.getAcctId();
        cache.remove(type, key);
    }

    public static void clearCacheWithPrefix(String type, String keyPrefix) {
        List keyList = cache.getKeysWithPrefix(type, keyPrefix);
        if (keyList.size() > 0) {
            cache.remove(type, keyList.toArray(new String[0]));
        }
    }

    public static String getCache(String type, String key) {
        type = type + "_" + SysIntegCacheMrg.getAcctId();
        return (String)cache.get(type, key);
    }

    public static void putCache(String type, String key, String value) {
        type = type + "_" + SysIntegCacheMrg.getAcctId();
        cache.put(type, key, (Object)value);
    }

    public static void putCache(String type, Map<String, String> values) {
        type = type + "_" + SysIntegCacheMrg.getAcctId();
        cache.put(type, values);
    }

    public static Map<String, String> getCache(String type) {
        type = type + "_" + SysIntegCacheMrg.getAcctId();
        return cache.getAll(type);
    }

    public static void loaded(String type, String key) {
        type = type + "_" + SysIntegCacheMrg.getAcctId();
        cache.put(type, key, (Object)DATA_LOADED);
    }

    public static boolean isData(String value) {
        if (value == null || value.length() == 0) {
            return false;
        }
        return !value.equals(DATA_LOADED);
    }

    public static boolean isLoaded(String value) {
        return value != null && value.length() != 0;
    }
}

