/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.community.article.handler;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.encrypt.Encrypters;
import kd.bos.entity.param.AppParam;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import org.apache.http.client.methods.RequestBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudAPIHelper {
    private static final Logger LOG = LoggerFactory.getLogger(CloudAPIHelper.class);

    public RequestBuilder getRequestBuilder(String method, String root, String url, String queryString) {
        RequestBuilder requestBuilder = "get".equalsIgnoreCase(method) ? RequestBuilder.get((String)(root + url + "?" + queryString)) : RequestBuilder.post((String)(root + url + "?" + queryString));
        String header = "X-Api-TimeStamp,X-Api-Nonce";
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("X-Api-TimeStamp", String.valueOf(new Date().getTime()));
        headerMap.put("X-Api-Nonce", String.valueOf(new SecureRandom().nextInt(100) + 1));
        headerMap.forEach((k, v) -> requestBuilder.setHeader(k, v));
        requestBuilder.setHeader("X-Api-ClientID", CloudAPIHelper.getAppParam("clientid"));
        requestBuilder.setHeader("X-Api-Auth-Version", "2.0");
        requestBuilder.setHeader("X-Api-SignHeaders", header);
        String sigStr = null;
        try {
            sigStr = this.getSignStr(method, url, queryString, header, headerMap, CloudAPIHelper.getAppParam("signkey"));
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        requestBuilder.setHeader("X-Api-Signature", sigStr);
        return requestBuilder;
    }

    public Map<String, String> getGetRequestHeader(String seriesCode, int page, String domain, String url, String queryString) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("category_code", "developer01");
        header.put("series_code", seriesCode);
        header.put("page", String.valueOf(page + 1));
        header.put("pageSize", "50");
        header.put("domain", domain);
        HashMap<String, String> signMap = new HashMap<String, String>();
        signMap.put("X-Api-TimeStamp", String.valueOf(new Date().getTime()));
        signMap.put("X-Api-Nonce", String.valueOf(new SecureRandom().nextInt(100) + 1));
        header.putAll(signMap);
        header.put("X-Api-ClientID", CloudAPIHelper.getAppParam("clientid"));
        header.put("X-Api-Auth-Version", "2.0");
        header.put("X-Api-SignHeaders", "X-Api-TimeStamp,X-Api-Nonce");
        try {
            String sigStr = this.getSignStr("get", url, queryString, "X-Api-TimeStamp,X-Api-Nonce", signMap, CloudAPIHelper.getAppParam("signkey"));
            if (StringUtils.isNotBlank((CharSequence)sigStr)) {
                header.put("X-Api-Signature", sigStr);
            }
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        return header;
    }

    public String getSignStr(String method, String url, String queryString, String header, Map<String, String> headerMap, String secret) throws UnsupportedEncodingException, NoSuchAlgorithmException, InvalidKeyException {
        Object[] q = queryString.split("&");
        Arrays.sort(q);
        StringBuilder newQueryString = new StringBuilder();
        for (Object s : q) {
            String[] keyValue = ((String)s).split("=");
            if (keyValue.length == 0) continue;
            String key = URLEncoder.encode(keyValue[0], "UTF-8");
            String value = "";
            if (keyValue.length >= 2) {
                value = URLEncoder.encode(keyValue[1], "UTF-8");
            }
            newQueryString.append(key).append("=").append(value).append("&");
        }
        StringBuilder newHeader = new StringBuilder();
        Object[] h = header.split(",");
        Arrays.sort(h);
        for (Object s : h) {
            newHeader.append(((String)s).toLowerCase()).append(":").append(headerMap.get(s)).append("\n");
        }
        String c = method.toUpperCase() + "\n" + URLEncoder.encode(url, "UTF-8") + "\n" + newQueryString.substring(0, newQueryString.length() - 1) + "\n" + newHeader;
        Mac hmacSHA256 = Mac.getInstance("HmacSHA256");
        byte[] s = secret.getBytes();
        hmacSHA256.init(new SecretKeySpec(s, 0, s.length, "HmacSHA256"));
        byte[] results = hmacSHA256.doFinal(c.getBytes());
        return new String(Base64.getEncoder().encode(this.byteArrayToHexString(results).getBytes()));
    }

    private String byteArrayToHexString(byte[] c) {
        StringBuilder s = new StringBuilder();
        for (byte b : c) {
            String h = Integer.toHexString(b & 0xFF);
            if (h.length() == 1) {
                s.append("0");
            }
            s.append(h);
        }
        return s.toString();
    }

    private static Map<String, Object> getAppParam() {
        AppParam appParam = new AppParam();
        appParam.setAppId("3V/T0S8J3=5O");
        appParam.setOrgId(Long.valueOf(RequestContext.get().getOrgId()));
        appParam.setViewType("15");
        return SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
    }

    private static String getAppParam(String key) {
        Map<String, Object> appParam = CloudAPIHelper.getAppParam();
        Object paramValue = appParam.get(key);
        if (StringUtils.isBlank((Object)paramValue)) {
            return "";
        }
        if ("signkey".equals(key)) {
            return Encrypters.decode((String)((String)paramValue).substring(7));
        }
        return (String)paramValue;
    }
}

