/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.kmbase.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.gptas.api.km.split.SplitConfig;
import kd.bos.gptas.api.vector.EmbeddingModel;
import kd.bos.gptas.common.vectordb.VectorStoreFactory;
import kd.bos.gptas.common.vectordb.service.VectorStoreService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;

public class KMConfigReader {
    private static final Log logger = LogFactory.getLog(KMConfigReader.class);
    private static final String BOS_GPTAS_KM = "bos-gptas-km";

    public static SplitConfig getSplitConfig(String entityNumber) {
        DynamicObject row = KMConfigReader.getKmConfig(entityNumber);
        return KMConfigReader.buildSplitConfig(row);
    }

    public static List<SplitConfig> getBatchSplitConfig(List<String> entityNumbers) {
        Collection<DynamicObject> rows = KMConfigReader.getBatchKmConfig(entityNumbers);
        ArrayList<SplitConfig> configs = new ArrayList<SplitConfig>(entityNumbers.size());
        for (DynamicObject row : rows) {
            SplitConfig splitConfig = KMConfigReader.buildSplitConfig(row);
            configs.add(splitConfig);
        }
        return configs;
    }

    private static Collection<DynamicObject> getBatchKmConfig(List<String> entityNumbers) {
        QFilter qFilter = new QFilter("kmformid.number", "in", entityNumbers);
        QFilter[] qFilterList = new QFilter[]{qFilter};
        Map corpusLibs = BusinessDataReader.loadFromCache((String)"bos_knl_kmconfig", (QFilter[])qFilterList);
        String number = KMConfigReader.hasInitialize(entityNumbers, corpusLibs);
        if (StringUtils.isNotBlank((CharSequence)number)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u77e5\u8bc6\u5e93%s\u672a\u521d\u59cb\u5316\uff0c\u8bf7\u5728\u5217\u8868\u4e2d\u6267\u884c\u201c\u521d\u59cb\u5316\u6570\u636e\u5e93\u201d\u3002", (String)"KMConfigReader_1", (String)BOS_GPTAS_KM, (Object[])new Object[0]), number));
        }
        return corpusLibs.values();
    }

    private static String hasInitialize(List<String> entityNumbers, Map<Object, DynamicObject> corpusLibs) {
        String number = "";
        List collect = corpusLibs.values().stream().map(dynamicObject -> dynamicObject.getString("kmformid.number")).collect(Collectors.toList());
        for (String entityNumber : entityNumbers) {
            if (collect.contains(entityNumber)) continue;
            number = String.join((CharSequence)number, entityNumber);
        }
        return number;
    }

    private static SplitConfig buildSplitConfig(DynamicObject row) {
        SplitConfig splitConfig = new SplitConfig();
        splitConfig.setFormId(row.getString("kmformid.number"));
        splitConfig.setChunkover(row.getInt("chunkoverlap"));
        splitConfig.setChunkSize(row.getInt("chunksize"));
        splitConfig.setSeparators(row.getString("separators"));
        splitConfig.setKeepSeparator(row.getBoolean("keepseparator"));
        splitConfig.setEmbeddingModel(Enum.valueOf(EmbeddingModel.class, row.getString("indexmethod")));
        splitConfig.setEnablererank(row.getBoolean("enablererank"));
        splitConfig.setReranknumber(row.getString("reranknumber"));
        splitConfig.setRerankllmtype(row.getString("rerankllmtype"));
        splitConfig.setSplitByQ(row.getBoolean("q"));
        splitConfig.setSplitByQA(row.getBoolean("qa"));
        splitConfig.setMaxQ(row.getInt("maxq"));
        splitConfig.setEnableIndex(row.getBoolean("enableindex"));
        VectorStoreService vectorStoreService = VectorStoreFactory.create((EmbeddingModel)splitConfig.getEmbeddingModel());
        splitConfig.setEnableVector(vectorStoreService.supportVector() && row.getBoolean("vector"));
        splitConfig.setEnableFullText(vectorStoreService.supportFullText() && row.getBoolean("es"));
        if (!splitConfig.isEnableVector() && !splitConfig.isEnableFullText()) {
            splitConfig.setEnableVector(true);
        }
        splitConfig.setCleanEmailUrl(row.getBoolean("cleanemailurl"));
        splitConfig.setCleanSpecSym(row.getBoolean("cleanspecsym"));
        splitConfig.setEnableOCR(row.getBoolean("enableocr"));
        String fileTypes = row.getString("filetype");
        if (StringUtils.isNotBlank((CharSequence)fileTypes) && StringUtils.isNotBlank((CharSequence)fileTypes.replace(",", ""))) {
            List fileTypeList = Arrays.stream(fileTypes.split(",")).filter(StringUtils::isNotBlank).collect(Collectors.toList());
            splitConfig.setFileTypes(fileTypeList);
        }
        return splitConfig;
    }

    private static DynamicObject getKmConfig(String entityNumber) {
        QFilter qFilter = new QFilter("kmformid.number", "=", (Object)entityNumber);
        QFilter[] qFilterList = new QFilter[]{qFilter};
        Map corpusLibs = BusinessDataReader.loadFromCache((String)"bos_knl_kmconfig", (QFilter[])qFilterList);
        if (corpusLibs.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u77e5\u8bc6\u5e93\u672a\u521d\u59cb\u5316\uff0c\u8bf7\u5728\u5217\u8868\u4e2d\u6267\u884c\u201c\u521d\u59cb\u5316\u6570\u636e\u5e93\u201d\u3002", (String)"KMConfigReader_0", (String)BOS_GPTAS_KM, (Object[])new Object[0]));
        }
        return (DynamicObject)corpusLibs.values().iterator().next();
    }
}

