/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.kmbase.kmconfig;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.param.AppParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.gptas.api.vector.EmbeddingModel;
import kd.bos.gptas.entity.KMEntityType;
import kd.bos.gptas.kmbase.service.OCRService;
import kd.bos.gptas.servicehelper.AIServiceProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class KMConfigEditPlugin
extends AbstractFormPlugin {
    private static final String BOS_GPTAS_KM = "bos-gptas-km";
    private static final String ENTITY_KM_CONFIG = "bos_knl_kmconfig";
    private static final String APPID_GAI = "3ACHGCGWU9MJ";
    private static final String BTN_SAVE = "btnok";
    private static final String FIELD_ENABLE_OCR = "enableocr";
    private static final Log log = LogFactory.getLog(KMConfigEditPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit kmformid = (BasedataEdit)this.getControl("kmformid");
        kmformid.addBeforeF7SelectListener(evt -> {
            evt.getFormShowParameter().setCustomParam("modeltype", (Object)"KMModel");
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
            qFilters.add(new QFilter("bizappid.number", "!=", (Object)"tpl"));
            evt.setCustomQFilters(qFilters);
        });
        this.addClickListeners(new String[]{BTN_SAVE});
    }

    public void beforeBindData(EventObject e) {
        List<ComboItem> embedingList = this.getEmbedingList();
        if (embedingList != null) {
            ComboEdit findexmethod = (ComboEdit)this.getControl("indexmethod");
            findexmethod.setComboItems(embedingList);
        }
    }

    private List<Map<String, Object>> getRerankList() {
        IPageCache pageCache = this.getPageCache();
        String string = pageCache.get("rerank_list");
        if (StringUtils.isNotBlank((CharSequence)string)) {
            return (List)SerializationUtils.fromJsonString((String)string, List.class);
        }
        return Collections.emptyList();
    }

    private List<Map<String, Object>> getRerankListFromAI() {
        try {
            List rerankList = (List)AIServiceProxy.invokeAICCServiceMethod((String)"AiccService", (String)"getRerankList", (Object[])new Object[0]);
            return rerankList;
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
            return null;
        }
    }

    private List<ComboItem> getEmbedingList() {
        EmbeddingModel[] values = EmbeddingModel.values();
        List list = (List)AIServiceProxy.invokeAICCServiceMethod((String)"AiccService", (String)"queryInstance", (Object[])new Object[]{null, null, null});
        HashMap<String, String> mapService = new HashMap<String, String>(16);
        if (list != null && !list.isEmpty()) {
            for (Map map : list) {
                String serviceNumber = (String)map.get("service.number");
                mapService.put(serviceNumber, (String)map.get("service.name"));
            }
            ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(16);
            for (EmbeddingModel valueMapItem : values) {
                String s = (String)mapService.get(valueMapItem.name());
                if (s == null) continue;
                ComboItem comboItem = new ComboItem();
                comboItem.setValue(valueMapItem.name());
                comboItem.setCaption(new LocaleString(s));
                comboItemList.add(comboItem);
            }
            return comboItemList;
        }
        return null;
    }

    public void afterBindData(EventObject e) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Object entityNumber = fsp.getCustomParam("entityNumber");
        Boolean lockdesc = (Boolean)fsp.getCustomParam("lockdesc");
        if (Boolean.TRUE.equals(lockdesc)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"description"});
        }
        if (null == entityNumber || StringUtils.isBlank((CharSequence)entityNumber.toString())) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"kmformid"});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"kmformid"});
            this.getModel().setValue("kmformid", entityNumber);
            DynamicObject data = QueryServiceHelper.queryOne((String)entityNumber.toString(), (String)"id", (QFilter[])new QFilter[]{new QFilter("status", "=", (Object)"C")});
            if (data != null) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"indexmethod"});
            }
        }
        this.toggleMaxQEnable();
    }

    private void isEnableRerank(List<Map<String, Object>> rerankList) {
        boolean value = (Boolean)this.getModel().getValue("enablererank");
        this.getView().setEnable(Boolean.valueOf(value), new String[]{"reranknumber"});
        if (value) {
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(rerankList.size());
            for (Map<String, Object> re : rerankList) {
                ComboItem comboItem = new ComboItem();
                comboItem.setValue((String)re.get("number"));
                comboItem.setId((String)re.get("number"));
                comboItem.setCaption(new LocaleString((String)re.get("name")));
                comboItems.add(comboItem);
            }
            ComboEdit comboEdit = (ComboEdit)this.getView().getControl("reranknumber");
            comboEdit.setComboItems(comboItems);
        } else {
            this.getModel().setValue("reranknumber", (Object)"");
            this.getModel().setValue("rerankllmtype", (Object)"");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if ("kmformid".equals(e.getProperty().getName())) {
            if (this.getView().getFormShowParameter().getStatus() != OperationStatus.ADDNEW) {
                return;
            }
            DynamicObject kmformid = (DynamicObject)this.getModel().getValue("kmformid");
            if (kmformid != null) {
                this.getModel().setValue("number", (Object)kmformid.getString("number"));
                this.getModel().setValue("name", (Object)kmformid.getString("name"));
                this.getModel().setItemValueByNumber("type", "knowledge_qa");
                KMEntityType entityType = (KMEntityType)EntityMetadataCache.getDataEntityType((String)kmformid.getString("number"));
                this.getModel().setValue("chunksize", (Object)entityType.getChunkLength());
                this.getModel().setValue("chunkoverlap", (Object)entityType.getOverLap());
                this.getModel().setValue("separators", (Object)entityType.getSeparator());
            }
        } else if ("indexmethod".equals(e.getProperty().getName())) {
            EmbeddingModel embeddingModel;
            int dimension;
            Integer chunksize = (Integer)this.getModel().getValue("chunksize");
            String indexMethod = (String)this.getModel().getValue("indexmethod");
            if (StringUtils.isNotBlank((CharSequence)indexMethod) && (dimension = (embeddingModel = Enum.valueOf(EmbeddingModel.class, indexMethod)).getDimension()) < chunksize) {
                this.getModel().setValue("chunksize", (Object)dimension);
            }
        } else if (!"enablererank".equals(e.getProperty().getName())) {
            if ("reranknumber".equals(e.getProperty().getName())) {
                List<Map<String, Object>> rerankList = this.getRerankList();
                Object value = this.getModel().getValue("reranknumber");
                Optional<Map> optionalMap = rerankList.stream().filter(v -> value.equals(v.get("number"))).findFirst();
                if (optionalMap.isPresent()) {
                    Map objectMap = optionalMap.get();
                    this.getModel().setValue("rerankllmtype", objectMap.get("llmType"));
                }
            } else if (e.getProperty().getName().equals("enableindex")) {
                this.toggleMaxQEnable();
            } else if (e.getProperty().getName().equals("chunksize") && this.getModel().getValue("enableindex") == Boolean.TRUE) {
                Integer chunksize;
                Integer value = (Integer)KMConfigEditPlugin.getAppParamValue(APPID_GAI, "indexspan");
                if (value == null || value == 0) {
                    value = 100;
                }
                if ((chunksize = (Integer)this.getModel().getValue("chunksize")) == null) {
                    chunksize = 0;
                }
                this.getModel().setValue("maxq", (Object)Math.ceil((double)chunksize.intValue() / (double)value.intValue()));
            }
        }
    }

    private static Object getAppParamValue(String bizAppId, String key) {
        AppParam appParam = new AppParam();
        appParam.setAppId(bizAppId);
        appParam.setOrgId(Long.valueOf(RequestContext.get().getOrgId()));
        appParam.setViewType("15");
        Map m = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        Object paramValue = m.get(key);
        if (StringUtils.isBlank(paramValue)) {
            return "";
        }
        return paramValue;
    }

    private void toggleMaxQEnable() {
        Boolean enableindex = (Boolean)this.getModel().getValue("enableindex");
        this.getView().setEnable(enableindex, new String[]{"maxq"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operation = (FormOperate)args.getSource();
        if ("save".equals(operation.getOperateKey())) {
            DynamicObject row;
            EmbeddingModel embeddingModel;
            int dimension;
            DynamicObject data;
            Object id = null;
            if (((BillView)this.getView()).getStatus() != OperationStatus.ADDNEW) {
                id = ((BillShowParameter)this.getView().getFormShowParameter()).getPkId();
            }
            if (null == (data = (DynamicObject)this.getModel().getValue("kmformid"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u77e5\u8bc6\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"KMConfigEditPlugin_1", (String)BOS_GPTAS_KM, (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Boolean q = (Boolean)this.getModel().getValue("q");
            Boolean qa = (Boolean)this.getModel().getValue("qa");
            if (q.equals(Boolean.FALSE) && qa.equals(Boolean.FALSE)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"QA\u5411\u91cf\u8303\u56f4\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u3002", (String)"KMConfigEditPlugin_2", (String)BOS_GPTAS_KM, (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Integer chunksize = (Integer)this.getModel().getValue("chunksize");
            String indexMethod = (String)this.getModel().getValue("indexmethod");
            if (StringUtils.isNotBlank((CharSequence)indexMethod) && (dimension = (embeddingModel = Enum.valueOf(EmbeddingModel.class, indexMethod)).getMaxToken()) < chunksize) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5206\u5757\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7\u5411\u91cf\u6a21\u578b\u7684\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u3002\u7ef4\u5ea6:%s", (String)"KMConfigEditPlugin_3", (String)BOS_GPTAS_KM, (Object[])new Object[0]), dimension));
                args.setCancel(true);
                return;
            }
            Map map = BusinessDataReader.loadFromCache((String)ENTITY_KM_CONFIG, (QFilter[])new QFilter[]{new QFilter("kmformid", "=", (Object)data.getString("id"))});
            if (!map.isEmpty() && !(row = (DynamicObject)map.values().iterator().next()).get("id").equals(id)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u77e5\u8bc6\u5e93\u914d\u7f6e\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"KMConfigEditPlugin_0", (String)BOS_GPTAS_KM, (Object[])new Object[0]));
                args.setCancel(true);
            }
            if (this.getModel().getValue("enableindex") == Boolean.TRUE) {
                int maxQ = this.getMaxQ();
                BigDecimal currentQ = (BigDecimal)this.getModel().getValue("maxq");
                if (currentQ.intValue() > maxQ) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5173\u8054\u95ee\u9898\u4e0a\u9650\u4e0d\u80fd\u8d85\u8fc7%s\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"KMConfigEditPlugin_4", (String)BOS_GPTAS_KM, (Object[])new Object[0]), maxQ));
                    args.setCancel(true);
                    return;
                }
                if (currentQ.intValue() == 0) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5173\u8054\u95ee\u9898\u4e0a\u9650\u4e0d\u80fd\u4e3a0\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"KMConfigEditPlugin_6", (String)BOS_GPTAS_KM, (Object[])new Object[0]), maxQ));
                    args.setCancel(true);
                    return;
                }
            }
        }
    }

    private int getMaxQ() {
        Integer chunksize;
        Integer value = (Integer)KMConfigEditPlugin.getAppParamValue(APPID_GAI, "indexspan");
        if (value == null || value == 0) {
            value = 100;
        }
        if ((chunksize = (Integer)this.getModel().getValue("chunksize")) == null) {
            chunksize = 0;
        }
        return (int)Math.ceil((double)chunksize.intValue() / (double)value.intValue());
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        OperationResult result = args.getOperationResult();
        String operateKey = args.getOperateKey();
        if ("save".equals(operateKey) && result.isSuccess()) {
            DynamicObject kmEntity = this.getModel().getDataEntity().getDynamicObject("kmformid");
            String kmEntityNumber = kmEntity.getString("id");
            this.getView().returnDataToParent((Object)kmEntityNumber);
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        Button button;
        String key;
        Object source = evt.getSource();
        if (source instanceof Button && BTN_SAVE.equals(key = (button = (Button)source).getKey())) {
            this.checkOCRServiceAvailable(evt);
        }
    }

    private void checkOCRServiceAvailable(BeforeClickEvent evt) {
        Object enableOcr = this.getModel().getValue(FIELD_ENABLE_OCR);
        if (Boolean.FALSE.equals(enableOcr)) {
            return;
        }
        boolean ocrAvailable = OCRService.create().checkOCRAvailable();
        if (!ocrAvailable) {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u73af\u5883\u672a\u914d\u7f6e\u89c6\u89c9\u670d\u52a1\u6a21\u578b\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"KMConfigEditPlugin_7", (String)BOS_GPTAS_KM, (Object[])new Object[0]));
        }
    }
}

