/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.kmbase.knowledge;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.property.entryfilter.EntryFilterItemInfo;
import kd.bos.entity.property.entryfilter.EntryQueryParam;
import kd.bos.form.control.Button;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.gptas.api.KMConfigService;
import kd.bos.gptas.api.VectorService;
import kd.bos.gptas.api.km.split.SplitConfig;
import kd.bos.gptas.api.vector.Chunk;
import kd.bos.gptas.api.vector.EmbeddingModel;
import kd.bos.gptas.api.vector.VectorResult;
import kd.bos.gptas.servicehelper.AIServiceProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AIKMHitTestFormPlugin
extends AbstractFormPlugin {
    private static final Logger log = LoggerFactory.getLogger(AIKMHitTestFormPlugin.class);
    private static final String SYSTEM_TYPE = "ai-km";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"hittest", "btn_filter"});
    }

    public void afterCreateNewData(EventObject e) {
        Object souce;
        List<Map<String, Object>> rerankList = this.getRerankListFromAI();
        if (rerankList != null) {
            ComboEdit reranklist = (ComboEdit)this.getControl("rerankmodel");
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(rerankList.size());
            for (Map<String, Object> re : rerankList) {
                ComboItem comboItem = new ComboItem();
                comboItem.setValue((String)re.get("number"));
                comboItem.setId((String)re.get("number"));
                comboItem.setCaption(new LocaleString((String)re.get("name")));
                comboItems.add(comboItem);
            }
            reranklist.setComboItems(comboItems);
            if (!rerankList.isEmpty()) {
                this.getModel().setValue("rerankmodel", rerankList.get(0).get("number"));
            }
        }
        if ("km".equals(souce = this.getView().getFormShowParameter().getCustomParam("source"))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"entityids"});
            Object ids = this.getView().getFormShowParameter().getCustomParam("knowledgeids");
            if (ids instanceof List) {
                Map dynamicObjects = BusinessDataReader.loadFromCache((Object[])((List)ids).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"aikm_knl_manager"));
                this.getModel().setValue("knowledges", (Object)dynamicObjects);
            }
        } else if ("entity".equals(souce)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"knowledges"});
            this.getModel().setValue("rerank", (Object)false);
            Object entityId = this.getView().getFormShowParameter().getCustomParam("entityid");
            if (entityId instanceof String) {
                Map dynamicObjectMap = BusinessDataReader.loadFromCache((Object[])new Object[]{entityId}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_entityobject"));
                this.getModel().setValue("entityids", dynamicObjectMap.values().stream().findFirst().get());
            }
        }
    }

    public void afterBindData(EventObject e) {
        Object source = this.getView().getFormShowParameter().getCustomParam("source");
        if ("entity".equals(source)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"rerank", "rerankmodel", "retrievalstrategy"});
        }
    }

    public void click(EventObject evt) {
        Object source = evt.getSource();
        if (source instanceof Button) {
            String key;
            switch (key = ((Button)source).getKey()) {
                case "hittest": {
                    if (!this.validate()) {
                        return;
                    }
                    String retrieveQues = (String)this.getModel().getValue("retrievalques");
                    this.retrieve(retrieveQues);
                    break;
                }
                case "btn_filter": {
                    this.filter();
                    break;
                }
            }
        }
    }

    private List<Map<String, Object>> getRerankListFromAI() {
        try {
            List rerankList = (List)AIServiceProxy.invokeAICCServiceMethod((String)"AiccService", (String)"getRerankList", (Object[])new Object[0]);
            return rerankList;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private boolean validate() {
        String rerankMode;
        boolean enableRerank;
        DynamicObject dynamicObject;
        String retrieveQues = (String)this.getModel().getValue("retrievalques");
        if (StringUtils.isBlank((CharSequence)retrieveQues)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u68c0\u7d22\u95ee\u9898\u3002", (String)"AIKMHitTestFormPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        Object source = this.getView().getFormShowParameter().getCustomParam("source");
        if ("km".equals(source)) {
            DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)this.getModel().getValue("knowledges");
            if (dynamicObjects.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6d4b\u8bd5\u8303\u56f4\u3002", (String)"AIKMHitTestFormPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return false;
            }
        } else if ("entity".equals(source) && (dynamicObject = (DynamicObject)this.getModel().getValue("entityids")) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6d4b\u8bd5\u8303\u56f4\u3002", (String)"AIKMHitTestFormPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        if ((enableRerank = ((Boolean)this.getModel().getValue("rerank")).booleanValue()) && StringUtils.isBlank((CharSequence)(rerankMode = (String)this.getModel().getValue("rerankmodel")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91cd\u6392\u6a21\u578b\u3002", (String)"AIKMHitTestFormPlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void retrieve(String retrieveText) {
        List vectorResult;
        block5: {
            Object source = this.getView().getFormShowParameter().getCustomParam("source");
            int recallCount = ((BigDecimal)this.getModel().getValue("recallcount")).intValue();
            try {
                if ("km".equals(source)) {
                    MulBasedataDynamicObjectCollection dynamicObjectCollection = (MulBasedataDynamicObjectCollection)this.getModel().getValue("knowledges");
                    ArrayList<Long> knowledgeIds = new ArrayList<Long>();
                    for (DynamicObject dynamicObject : dynamicObjectCollection) {
                        Long id = (Long)((DynamicObject)dynamicObject.get("fbasedataid")).get("id");
                        knowledgeIds.add(id);
                    }
                    String retrievalStrategy = (String)this.getModel().getValue("retrievalstrategy");
                    float threshold = ((BigDecimal)this.getModel().getValue("threshold")).floatValue();
                    Boolean rerank = (Boolean)this.getModel().getValue("rerank");
                    Object rerankMode = this.getModel().getValue("rerankmodel");
                    vectorResult = (List)DispatchServiceHelper.invokeBizService((String)"ai", (String)"aikm", (String)"AIKMService", (String)"retrieval", (Object[])new Object[]{retrieveText, knowledgeIds, retrievalStrategy, recallCount, Float.valueOf(threshold), rerank, (String)rerankMode});
                    break block5;
                }
                if ("entity".equals(source)) {
                    DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue("entityids");
                    String entityNumber = dynamicObject.getString("number");
                    SplitConfig splitConfig = KMConfigService.create().getSplitConfig(entityNumber);
                    VectorService vectorService = VectorService.create((EmbeddingModel)splitConfig.getEmbeddingModel());
                    ArrayList<String> entityIds = new ArrayList<String>();
                    entityIds.add(entityNumber);
                    vectorResult = vectorService.search(entityIds, retrieveText, recallCount);
                    break block5;
                }
                return;
            }
            catch (Exception ex) {
                log.error("retrieve error", (Throwable)ex);
                this.getView().showMessage(ex.getMessage());
                this.getModel().deleteEntryData("entryentity");
                return;
            }
        }
        this.fillCardEntry(vectorResult);
    }

    public void fillCardEntry(List<VectorResult> result) {
        this.getModel().deleteEntryData("entryentity");
        int row = 0;
        Object source = this.getView().getFormShowParameter().getCustomParam("source");
        float threshold = ((BigDecimal)this.getModel().getValue("threshold")).floatValue();
        log.info("fillCardEntry result before filter and sort {}", (Object)SerializationUtils.toJsonString(result));
        if (threshold != 0.0f) {
            result = result.stream().filter(vectorResult -> {
                String similarityType = vectorResult.getSimilarityType();
                if ("L2".equals(similarityType)) {
                    return 1.0f - vectorResult.getScore() >= threshold;
                }
                if ("COSINE".equals(similarityType)) {
                    return vectorResult.getScore() >= threshold;
                }
                return true;
            }).sorted(Comparator.comparing(VectorResult::getScore).reversed()).collect(Collectors.toList());
        }
        if (result.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u68c0\u7d22\u7ed3\u679c\u4e3a\u7a7a\u3002", (String)"AIKMHitTestFormPlugin_4", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
        this.getModel().batchCreateNewEntryRow("entryentity", result.size());
        for (VectorResult vectorResult2 : result) {
            Chunk chunk = vectorResult2.getChunk();
            String similarityType = vectorResult2.getSimilarityType();
            this.getModel().setValue("knlname", (Object)chunk.getKnowledgeName(), row);
            this.getModel().setValue("segseq", (Object)chunk.getChunkSeq(), row);
            float actulScore = "L2".equals(similarityType) ? 1.0f - vectorResult2.getScore() : ("COSINE".equals(similarityType) ? vectorResult2.getScore() : 0.0f);
            this.getModel().setValue("matchscore", (Object)Float.valueOf(actulScore), row);
            String content = chunk.getExtendContent();
            this.getModel().setValue("content", (Object)(StringUtils.isNotBlank((CharSequence)content) ? content : chunk.getContent()), row);
            String entityNumber = chunk.getEntityId();
            Map dynamicObjMap = BusinessDataReader.loadFromCache((Object[])new Object[]{entityNumber}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_entityobject"));
            if (dynamicObjMap.size() == 1) {
                DynamicObject dynamicObj = (DynamicObject)dynamicObjMap.values().stream().findFirst().get();
                if ("km".equals(source)) {
                    String entityId = dynamicObj.getString("dentityid");
                    Map knowledgeMap = BusinessDataReader.loadFromCache((String)"aikm_knl_manager", (QFilter[])new QFilter[]{new QFilter("kmentityid", "=", (Object)entityId).or(new QFilter("kmqaentityid", "=", (Object)entityId))});
                    DynamicObject belongKnl = (DynamicObject)knowledgeMap.values().stream().findFirst().get();
                    if (belongKnl != null) {
                        this.getModel().setValue("belongknl", (Object)((ILocaleString)belongKnl.get("name")).getLocaleValue(), row);
                    }
                } else if ("entity".equals(source)) {
                    this.getModel().setValue("belongknl", (Object)((ILocaleString)dynamicObj.get("name")).getLocaleValue(), row);
                }
            }
            ++row;
        }
        this.getView().updateView("entryentity");
    }

    private void filter() {
        float minScore = ((Float)this.getModel().getValue("minscore")).floatValue();
        String searchContent = (String)this.getModel().getValue("serachcontent");
        EntryQueryParam entryQueryParam = new EntryQueryParam();
        ArrayList<EntryFilterItemInfo> filterItems = new ArrayList<EntryFilterItemInfo>(3);
        filterItems.add(new EntryFilterItemInfo("content", (Object)searchContent, CompareTypeEnum.LIKE.getId()));
        filterItems.add(new EntryFilterItemInfo("minscore", (Object)Float.valueOf(minScore), CompareTypeEnum.GREATEROREQUAL.getId()));
        entryQueryParam.setFilterItems(filterItems);
        this.getModel().filterEntry("cardentry", entryQueryParam);
        this.getView().updateView("cardentry");
    }
}

