/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.kmbase.knowledge;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.entryfilter.EntryFilterItemInfo;
import kd.bos.entity.property.entryfilter.EntryQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.Markdown;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Tab;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Button;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.events.BeforeAttachmentUploadEvent;
import kd.bos.form.control.events.BeforeAttachmentUploadListener;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.gptas.api.KMConfigService;
import kd.bos.gptas.api.km.DocParser;
import kd.bos.gptas.api.km.KMType;
import kd.bos.gptas.api.km.split.SplitConfig;
import kd.bos.gptas.kmbase.common.KMConfigReader;
import kd.bos.gptas.kmbase.newsplitter.CommonSplitBuilder;
import kd.bos.gptas.kmbase.parser.FileParseFactory;
import kd.bos.gptas.kmbase.progress.KnlProgressBuilder;
import kd.bos.gptas.kmbase.utils.KnowledgeUtils;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KMTemplateFormPlugin
extends AbstractBasePlugIn
implements UploadListener,
BeforeAttachmentUploadListener,
RowClickEventListener,
SearchEnterListener {
    private static final Logger log = LoggerFactory.getLogger(KMTemplateFormPlugin.class);
    private static final String SYSTEM_TYPE = "bos-gptas-km";
    private static final String USEORG = "useOrg";
    private static final String FIELD_CREATEORG = "org";
    private static final String FIELD_ENABLE_OCR = "enableocr";
    private static final String ATTACHMENT_PANEL = "attachmentpanelap";
    private static final String CALLBACK_CHANGE_SPLIT_TYPE = "changeSplitType";
    private static final String CALLBACK_CHANGE_ENABLE_OCR = "changeEnableOcr";
    private static final String CHUNK_SELF_BUILD = "2";
    private static final String CALLBACK_TASK_UPLOAD = "taskUploadFile";
    private static boolean isNeedSplit = false;
    private static final Map<String, List<String>> splitTypeExtMap = new HashMap<String, List<String>>(6);

    private Map<String, ComboItem> getComboItem() {
        HashMap<String, ComboItem> comboItemsMap = new HashMap<String, ComboItem>(6);
        comboItemsMap.put("auto", new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u81ea\u52a8\u5339\u914d", (String)"KMTemplateFormPlugin_10", (String)SYSTEM_TYPE, (Object[])new Object[0])), "auto"));
        comboItemsMap.put("common", new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u901a\u7528\u6587\u4ef6", (String)"KMTemplateFormPlugin_11", (String)SYSTEM_TYPE, (Object[])new Object[0])), KMType.common.getName()));
        comboItemsMap.put("excel", new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u8868\u683c\u6587\u4ef6", (String)"KMTemplateFormPlugin_12", (String)SYSTEM_TYPE, (Object[])new Object[0])), KMType.excel.getName()));
        comboItemsMap.put("qa", new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u95ee\u7b54\u5bf9", (String)"KMTemplateFormPlugin_13", (String)SYSTEM_TYPE, (Object[])new Object[0])), KMType.qa.getName()));
        comboItemsMap.put("java", new ComboItem(new LocaleString(ResManager.loadKDString((String)"JAVA\u4ee3\u7801", (String)"KMTemplateFormPlugin_14", (String)SYSTEM_TYPE, (Object[])new Object[0])), KMType.java.getName()));
        comboItemsMap.put("kingscript", new ComboItem(new LocaleString(ResManager.loadKDString((String)"KingScript\u4ee3\u7801", (String)"KMTemplateFormPlugin_15", (String)SYSTEM_TYPE, (Object[])new Object[0])), KMType.kingscript.getName()));
        return comboItemsMap;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"reset", "savebtn", "edit", "closerightsplitflex"});
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl(ATTACHMENT_PANEL);
        attachmentPanel.addUploadListener((UploadListener)this);
        attachmentPanel.addBeforeUploadListener((BeforeAttachmentUploadListener)this);
        CardEntry cardEntry = (CardEntry)this.getControl("segmententity");
        cardEntry.addRowClickListener((RowClickEventListener)this);
        Search search = (Search)this.getView().getControl("searchap");
        search.addClickListener((ClickListener)this);
        search.addEnterListener((SearchEnterListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String createOrgId;
        DataEntityPropertyCollection properties = this.getModel().getDataEntityType().getProperties();
        if (properties.containsKey((Object)FIELD_CREATEORG) && StringUtils.isNotBlank((CharSequence)(createOrgId = (String)this.getView().getFormShowParameter().getCustomParam(USEORG)))) {
            this.getModel().setValue(FIELD_CREATEORG, (Object)Long.valueOf(createOrgId));
        }
    }

    public void afterBindData(EventObject e) {
        this.updateAvailableSplitType(this.getAttachmentFileExt());
        this.updateMarkdown();
        Object splitType = this.getModel().getValue("type");
        this.updateAttachmentExt(splitType);
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl(ATTACHMENT_PANEL);
        List attachmentDatas = attachmentPanel.getAttachmentData();
        DynamicObjectCollection segmentEntry = this.getModel().getEntryEntity("segmententity");
        boolean dataChanged = this.getModel().getDataChanged();
        this.getModel().setValue("filterway", (Object)"0");
        if (!segmentEntry.isEmpty()) {
            for (DynamicObject segment : segmentEntry) {
                int seq = (Integer)segment.get("seq");
                this.getModel().setValue("segseq", (Object)seq, seq - 1);
            }
            Label segsCountLabel = (Label)this.getControl("segscount");
            segsCountLabel.setText(String.format(ResManager.loadKDString((String)"\u5171%d\u4e2a\u5206\u5757", (String)"KMTemplateFormPlugin_23", (String)SYSTEM_TYPE, (Object[])new Object[0]), segmentEntry.size()));
            if (CollectionUtils.isNotEmpty((Collection)attachmentDatas)) {
                Map attachmentData = (Map)attachmentDatas.get(0);
                attachmentData.put("visible", "1110");
                IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                clientViewProxy.setEntryProperty(ATTACHMENT_PANEL, "data", (Object)attachmentDatas);
            }
        }
        this.getModel().setDataChanged(dataChanged);
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        Tab tab = (Tab)this.getControl("tabap");
        if (0 == operationStatus.getValue()) {
            tab.activeTab("markdownpage");
        } else {
            tab.activeTab("segmentpartpage");
        }
        this.changeSplitContainerStatus(SplitDirection.right, true);
        this.setEnableOCRVisible();
        this.getModel().setDataChanged(false);
    }

    public void search(SearchEnterEvent evt) {
        String searchContent = evt.getText();
        EntryQueryParam entryQueryParam = new EntryQueryParam();
        ArrayList<EntryFilterItemInfo> filterItems = new ArrayList<EntryFilterItemInfo>(1);
        if (StringUtils.isBlank((CharSequence)searchContent)) {
            entryQueryParam.setFilterItems(filterItems);
            this.getModel().filterEntry("segmententity", entryQueryParam);
            this.getView().updateView("segmententity");
            return;
        }
        filterItems.add(new EntryFilterItemInfo("segment_tag", (Object)searchContent, CompareTypeEnum.LIKE.getId()));
        entryQueryParam.setFilterItems(filterItems);
        this.getModel().filterEntry("segmententity", entryQueryParam);
        this.getView().updateView("segmententity");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String property = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (property) {
            case "type": {
                this.propertyChangedSplitType(e);
                break;
            }
            case "inputcontent_tag": {
                isNeedSplit = true;
                break;
            }
            case "filterway": {
                EntryQueryParam entryQueryParam = new EntryQueryParam();
                ArrayList<EntryFilterItemInfo> filterItems = new ArrayList<EntryFilterItemInfo>(1);
                if ("0".equals(newValue)) {
                    entryQueryParam.setFilterItems(filterItems);
                    this.getModel().filterEntry("segmententity", entryQueryParam);
                    this.getView().updateView("segmententity");
                    return;
                }
                filterItems.add(new EntryFilterItemInfo("creatway", newValue, CompareTypeEnum.EQUAL.getId()));
                entryQueryParam.setFilterItems(filterItems);
                this.getModel().filterEntry("segmententity", entryQueryParam);
                this.getView().updateView("segmententity");
                break;
            }
            case "segcontent_tag": {
                this.getModel().beginInit();
                this.getModel().setValue("segcontent_tag", newValue);
                if (newValue instanceof String) {
                    Label charCount = (Label)this.getControl("charcount");
                    charCount.setText(((String)newValue).length() + ResManager.loadKDString((String)"\u5b57\u7b26", (String)"KMTemplateFormPlugin_20", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                }
                this.getModel().endInit();
                this.getView().updateView("segcontent");
                break;
            }
            case "enableocr": {
                String entityNumber = this.getModel().getDataEntityType().getName();
                SplitConfig splitConfig = KMConfigService.create().getSplitConfig(entityNumber);
                String fileType = this.getAttachmentFileExt();
                if (StringUtils.isBlank((CharSequence)fileType)) {
                    return;
                }
                List fileTypes = splitConfig.getFileTypes();
                if (fileTypes == null || !fileTypes.contains(fileType)) break;
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5c06\u6e05\u9664\u73b0\u6709\u5185\u5bb9\u548c\u5206\u5757\uff0c\u91cd\u65b0\u8bc6\u522b\u6587\u4ef6\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"", (String)SYSTEM_TYPE, (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CALLBACK_CHANGE_ENABLE_OCR));
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("bar_save".equals(itemKey) || "bar_submit".equals(itemKey)) {
            this.updateValBeforeSave();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setSkipNoField(true);
    }

    public void click(EventObject evt) {
        Object source = evt.getSource();
        if (source instanceof Button) {
            String key;
            Button button = (Button)source;
            switch (key = button.getKey()) {
                case "edit": {
                    this.changeSplitContainerStatus(SplitDirection.left, false);
                    break;
                }
                case "closerightsplitflex": {
                    this.changeSplitContainerStatus(SplitDirection.right, true);
                    break;
                }
                case "reset": {
                    int seq = (Integer)this.getModel().getValue("focusrow");
                    this.setRow2segDetail(seq - 1);
                    break;
                }
                case "savebtn": {
                    int seq = (Integer)this.getModel().getValue("focusrow");
                    String editSegmentContent = (String)this.getModel().getValue("segcontent_tag");
                    String formId = this.getView().getFormShowParameter().getFormId();
                    Map result = BusinessDataReader.loadFromCache((String)"bos_knl_kmconfig", (QFilter[])new QFilter[]{new QFilter("kmformid", "=", (Object)formId)});
                    Optional option = result.values().stream().findFirst();
                    int chunkSize = 0;
                    if (option.isPresent()) {
                        chunkSize = ((DynamicObject)option.get()).getInt("chunksize");
                    }
                    if (editSegmentContent.length() > chunkSize) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8f93\u5165\u5b57\u7b26\u6570\u4e3a%1$d\uff0c\u8d85\u8fc7\u4e86\u5206\u5757\u957f\u5ea6%2$d", (String)"KMTemplateformPlugin_22", (String)SYSTEM_TYPE, (Object[])new Object[0]), editSegmentContent.length(), chunkSize));
                        return;
                    }
                    this.getModel().setValue("segment_tag", (Object)editSegmentContent, seq - 1);
                    Object creat = this.getModel().getValue("creats");
                    if ("1".equals(creat) || "3".equals(creat)) {
                        this.getModel().setValue("creatway", (Object)"3", seq - 1);
                    } else {
                        this.getModel().setValue("creatway", (Object)CHUNK_SELF_BUILD, seq - 1);
                    }
                    this.getModel().setValue("segmenttype", (Object)"TEXT", seq - 1);
                    this.getView().updateView("segmententity");
                    boolean exsitCard = this.getView().existView(this.getView().getPageId() + "-segment_card");
                    if (exsitCard) {
                        IFormView cardView = this.getView().getView(this.getView().getPageId() + "-segment_card");
                        DynamicObjectCollection rows = cardView.getModel().getEntryEntity("segmententry");
                        for (DynamicObject row : rows) {
                            if (seq != row.getInt("segdetailseq")) continue;
                            cardView.getModel().setValue("segment_tag", (Object)editSegmentContent, row.getInt("seq") - 1);
                        }
                        cardView.updateView("segmententry");
                        this.getView().sendFormAction(cardView);
                    }
                    this.changeSplitContainerStatus(SplitDirection.right, true);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5206\u5757\u66f4\u65b0\u6210\u529f\u3002", (String)"KMTemplateFormPlugin_9", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    break;
                }
            }
        }
    }

    private void changeSplitContainerStatus(SplitDirection direction, boolean status) {
        SplitContainer splitContainer = (SplitContainer)this.getControl("splitcontainerap");
        splitContainer.changeFlexStatus(direction, status);
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("segmententity");
        for (DynamicObject dynamicObject : dynamicObjects) {
        }
        this.getView().updateView("segmententity");
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        RowDataEntity[] rowDataEntities = e.getRowDataEntities();
        String entryName = e.getEntryProp().getName();
        if ("segmententity".equals(entryName)) {
            for (RowDataEntity rowDataEntity : rowDataEntities) {
                rowDataEntity.getDataEntity().set("creatway", (Object)CHUNK_SELF_BUILD);
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        this.getModel().setValue("segcontent_tag", null);
        this.getModel().setValue("segcontent", null);
        int row = evt.getRow();
        this.setRow2segDetail(row);
    }

    private void setRow2segDetail(int row) {
        this.getModel().getDataEntity(true);
        DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)this.getModel().getValue("segmententity");
        if (row != -1 && !dynamicObjects.isEmpty()) {
            DynamicObject dyObj = (DynamicObject)dynamicObjects.get(row);
            this.getModel().beginInit();
            int seq = dyObj.getInt("seq");
            this.getModel().setValue("focusrow", (Object)seq);
            String segmentTag = dyObj.getString("segment_tag");
            this.getModel().setValue("segcontent_tag", (Object)(StringUtils.isBlank((CharSequence)segmentTag) ? null : segmentTag));
            this.getModel().setValue("creats", dyObj.get("creatway"));
            Label label = (Label)this.getControl("charcount");
            label.setText(dyObj.getString("segment_tag").length() + ResManager.loadKDString((String)"\u5b57\u7b26", (String)"KMTemplateFormPlugin_20", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            this.getModel().endInit();
        }
        this.getView().updateView("segcontent");
    }

    private void resetSegmentDetail(boolean clearFocusRow) {
        this.getModel().setValue("segcontent_tag", null);
        Label label = (Label)this.getControl("charcount");
        label.setText(0 + ResManager.loadKDString((String)"\u5b57\u7b26", (String)"KMTemplateFormPlugin_20", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        if (clearFocusRow) {
            this.getModel().beginInit();
            this.getModel().setValue("focusrow", (Object)-1);
            this.getModel().setValue("creats", null);
            this.getModel().endInit();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operationKey;
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        switch (operationKey = operate.getOperateKey()) {
            case "save": 
            case "submit": {
                String fileExt;
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("segmententity");
                if (isNeedSplit || entryEntity.isEmpty()) {
                    operate.getOption().setVariableValue("isNeedSplit", "true");
                }
                if (!StringUtils.isNotBlank((CharSequence)(fileExt = this.getAttachmentFileExt()))) break;
                operate.getOption().setVariableValue("fileExt", fileExt);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        this.updateMarkdown();
        if ("save".equals(operateKey) || "audit".equals(operateKey) || "unaudit".equals(operateKey)) {
            List errorInfos = args.getOperationResult().getAllErrorOrValidateInfo();
            if (CollectionUtils.isNotEmpty((Collection)errorInfos) || !args.getOperationResult().isSuccess()) {
                return;
            }
            isNeedSplit = false;
            if ("audit".equals(operateKey)) {
                new KnlProgressBuilder().showPage(this.getView());
            } else {
                this.getView().invokeOperation("refresh");
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvt) {
        String actionId = closedCallBackEvt.getActionId();
        Object returnData = closedCallBackEvt.getReturnData();
        if (CALLBACK_TASK_UPLOAD.equals(actionId) && returnData instanceof Map) {
            Map returnDataMap = (Map)returnData;
            if (!returnDataMap.containsKey("taskinfo")) {
                return;
            }
            String taskInfoStr = (String)returnDataMap.get("taskinfo");
            TaskInfo taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class);
            if (!taskInfo.isTaskEnd()) {
                return;
            }
            String data = taskInfo.getData();
            if (StringUtils.isBlank((CharSequence)data)) {
                return;
            }
            Map dataMap = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
            Object isSuccess = dataMap.get("success");
            Object content = dataMap.get("content");
            Object message = dataMap.get("message");
            if ("true".equals(isSuccess) && StringUtils.isNotBlank(content)) {
                this.getModel().setValue("inputcontent_tag", (Object)content.toString());
                this.updateMarkdown();
                this.updateSpliteType();
                this.updateAttachmentExt(KMType.common.getName());
                this.updateAvailableSplitType("pdf");
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u89e3\u6790\u5b8c\u6210", (String)"KMTemplateFormPlugin_21", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            } else if (StringUtils.isNotBlank(message)) {
                this.getView().showErrorNotification(message.toString());
                AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl(ATTACHMENT_PANEL);
                List attachmentData = attachmentPanel.getAttachmentData();
                if (CollectionUtils.isNotEmpty((Collection)attachmentData)) {
                    Map attachmentInfo = (Map)attachmentData.get(0);
                    Object name = attachmentInfo.get("name");
                    OrmLocaleValue knlName = (OrmLocaleValue)this.getModel().getValue("name");
                    if (StringUtils.isNotBlank((CharSequence)knlName.getLocaleValue()) && knlName.getLocaleValue().equals(name)) {
                        this.getModel().setValue("name", null);
                    }
                }
                this.updateAvailableSplitType("");
                this.updateSpliteType();
                this.getModel().beginInit();
                this.getModel().setValue(FIELD_ENABLE_OCR, (Object)false);
                this.getModel().endInit();
                this.getView().updateView(FIELD_ENABLE_OCR);
            }
        }
    }

    public void beforeAttachmentUpload(BeforeAttachmentUploadEvent evt) {
        Object source = evt.getSource();
        if (!(source instanceof AttachmentPanel)) {
            return;
        }
        String controlKey = ((AttachmentPanel)source).getKey();
        if (!ATTACHMENT_PANEL.equals(controlKey)) {
            return;
        }
        List attachInfos = evt.getSourceAttachments();
        if (null == attachInfos || attachInfos.isEmpty()) {
            return;
        }
        if (attachInfos.size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u77e5\u8bc6\u6587\u4ef6\u4e0d\u652f\u6301\u4e0a\u4f20\u591a\u4efd\u3002", (String)"KMTemplateFormPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
    }

    public void upload(UploadEvent evt) {
        Object[] attachmentInfos = evt.getUrls();
        if (null == attachmentInfos || attachmentInfos.length == 0) {
            evt.setCancel(true);
            return;
        }
        Map fileInfo = (Map)attachmentInfos[0];
        if (!fileInfo.containsKey("url") || !fileInfo.containsKey("name")) {
            evt.setCancel(true);
            evt.setCancelMsg(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u5b8c\u6574\u7684\u6587\u4ef6\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u4e0a\u4f20\u6587\u4ef6\u5e76\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"KMTemplateFormPlugin_4", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
        String fileName = (String)fileInfo.get("name");
        if (StringUtils.isBlank((CharSequence)fileName) || !fileName.contains(".")) {
            evt.setCancel(true);
            evt.setCancelMsg(ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u7c7b\u578b\u4e0d\u652f\u6301\u3002", (String)"KMTemplateFormPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
        String url = fileInfo.get("url").toString();
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        InputStream inputStream = tempFileCache.getInputStream(url);
        String fileHash = "";
        try {
            fileHash = DigestUtils.sha256Hex((InputStream)inputStream);
        }
        catch (IOException e) {
            log.error("calculate file hash failed: " + e.getMessage());
        }
        if (StringUtils.isNotBlank((CharSequence)fileHash) && !this.validateDuplicateFile(fileHash, fileName)) {
            evt.setCancel(true);
            evt.setCancelMsg(String.format(ResManager.loadKDString((String)"[%s]\u4e0e\u5185\u5bb9\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u4e0a\u4f20\u3002", (String)"KMTemplateFormPlugin_24", (String)SYSTEM_TYPE, (Object[])new Object[0]), fileName));
            return;
        }
        this.getModel().setValue("filehash", (Object)fileHash);
        String type = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase();
        String entityNumber = this.getView().getEntityId();
        DocParser parser = FileParseFactory.getParser(type, entityNumber);
        if (null == parser) {
            evt.setCancel(true);
            evt.setCancelMsg(ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u7c7b\u578b\u4e0d\u652f\u6301\u3002", (String)"KMTemplateFormPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
        List fileTypes = KMConfigService.create().getSplitConfig(entityNumber).getFileTypes();
        Object enableOcr = this.getModel().getValue(FIELD_ENABLE_OCR);
        if (Boolean.TRUE.equals(enableOcr) && KnowledgeUtils.getExtByFileType(fileTypes).contains(type)) {
            this.dispatchOcrParseTask(fileName, entityNumber, url);
            return;
        }
        this.getModel().getDataEntity().beginInit();
        this.getModel().setValue(FIELD_ENABLE_OCR, (Object)false);
        this.getModel().getDataEntity().endInit();
        this.getView().updateView(FIELD_ENABLE_OCR);
        parser.setEnableOCR(false);
        try {
            String content = "";
            Object splitType = this.getModel().getValue("type");
            if (null == splitType || "auto".equals(splitType)) {
                splitType = KnowledgeUtils.getSplitTypeByExtention(type, false);
            }
            parser.setSplitType(splitType.toString());
            content = parser.parse(tempFileCache.getInputStream(url), url, null);
            String warnMsg = parser.getWarnMsg();
            if (StringUtils.isNotBlank((CharSequence)warnMsg)) {
                this.getView().showTipNotification(warnMsg);
            }
            if (StringUtils.isBlank((CharSequence)content)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u5931\u8d25\uff0c\u77e5\u8bc6\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"KMTemplateFormPlugin_5", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
            this.getModel().setValue("inputcontent_tag", (Object)content);
        }
        catch (Exception exp) {
            evt.setCancel(true);
            evt.setCancelMsg(exp.getMessage());
            log.error(exp.getMessage(), (Throwable)exp);
        }
    }

    public void afterUpload(UploadEvent evt) {
        if (evt.isCancel() || null == evt.getUrls() || evt.getUrls().length == 0) {
            return;
        }
        String fileExt = this.getAttachmentFileExt();
        this.updateAvailableSplitType(fileExt);
        Object splitType = this.getModel().getValue("type");
        if (null == splitType || "auto".equals(splitType)) {
            this.updateSpliteType();
        }
        Map attachmentInfo = (Map)evt.getUrls()[0];
        OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("name");
        if (attachmentInfo.containsKey("name") && (name.isEmpty() || StringUtils.isBlank((CharSequence)name.getLocaleValue()))) {
            this.getModel().setValue("name", attachmentInfo.get("name"));
        }
        this.updateMarkdown();
    }

    public void afterRemove(UploadEvent evt) {
        this.updateAvailableSplitType("");
        this.getModel().beginInit();
        this.getModel().setValue("inputcontent_tag", (Object)"");
        this.getModel().deleteEntryData("segmententity");
        this.getModel().setValue("type", (Object)"auto");
        this.getModel().endInit();
        this.getView().updateView();
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId = evt.getCallBackId();
        if (CALLBACK_CHANGE_SPLIT_TYPE.equals(callBackId)) {
            MessageBoxResult result = evt.getResult();
            if (MessageBoxResult.Yes.equals((Object)result)) {
                this.updateAttachmentExt(this.getModel().getValue("type"));
                String newContent = this.reloadAttachmentContent();
                this.getModel().setValue("inputcontent_tag", (Object)newContent);
                this.splitContent();
                IFormView parentView = (IFormView)evt.getSource();
                parentView.updateView("segmententity");
                this.getView().updateView();
            } else {
                this.resetSplitType();
            }
        } else if (CALLBACK_CHANGE_ENABLE_OCR.equals(callBackId)) {
            MessageBoxResult result = evt.getResult();
            if (MessageBoxResult.Yes.equals((Object)result)) {
                this.getModel().deleteEntryData("segmententity");
                String entityNumber = this.getModel().getDataEntityType().getName();
                List fileTypes = KMConfigService.create().getSplitConfig(entityNumber).getFileTypes();
                AttachmentPanel attachmentPanelAp = (AttachmentPanel)this.getControl(ATTACHMENT_PANEL);
                Map attachmentData = (Map)attachmentPanelAp.getAttachmentData().get(0);
                String type = this.getAttachmentFileExt();
                Object enableOcr = this.getModel().getValue(FIELD_ENABLE_OCR);
                if (Boolean.TRUE.equals(enableOcr) && fileTypes.contains(type)) {
                    this.dispatchOcrParseTask(attachmentData.getOrDefault("name", "").toString(), entityNumber, attachmentData.getOrDefault("relativeUrl", attachmentData.getOrDefault("url", "")).toString());
                } else {
                    this.getModel().setValue("inputcontent_tag", (Object)this.reloadAttachmentContent());
                    this.getView().updateView();
                }
                Label segsCountLabel = (Label)this.getControl("segscount");
                segsCountLabel.setText(String.format(ResManager.loadKDString((String)"\u5171%d\u4e2a\u5206\u5757", (String)"KMTemplateFormPlugin_23", (String)SYSTEM_TYPE, (Object[])new Object[0]), 0));
            } else {
                this.getModel().beginInit();
                this.getModel().setValue(FIELD_ENABLE_OCR, (Object)((Boolean)this.getModel().getValue(FIELD_ENABLE_OCR) == false ? 1 : 0));
                this.getView().updateView(FIELD_ENABLE_OCR);
                this.getModel().endInit();
            }
        }
    }

    private void updateValBeforeSave() {
        this.getModel().getDataEntity(true);
        this.getModel().beginInit();
        Markdown md = (Markdown)this.getView().getControl("markdownap");
        String sampleText = md.getText();
        if (StringUtils.isBlank((CharSequence)sampleText)) {
            this.getModel().setValue("inputcontent_tag", (Object)"");
            return;
        }
        String ltrimSample = this.ltrim(sampleText);
        if (ltrimSample.startsWith("```\n")) {
            this.getModel().setValue("inputcontent_tag", (Object)ltrimSample.substring(4));
        } else if (ltrimSample.startsWith("```")) {
            this.getModel().setValue("inputcontent_tag", (Object)ltrimSample.substring(3));
        } else {
            this.getModel().setValue("inputcontent_tag", (Object)sampleText);
        }
        this.getModel().endInit();
        this.getView().updateView("inputcontent_tag");
    }

    private void updateMarkdown() {
        String sampleText = (String)this.getModel().getValue("inputcontent_tag");
        Markdown md = (Markdown)this.getView().getControl("markdownap");
        if (!sampleText.trim().startsWith("```")) {
            md.setText("```\n" + sampleText);
        } else {
            md.setText(sampleText);
        }
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.VIEW) {
            md.setModelType(Markdown.Preview);
        } else {
            String value = (String)this.getModel().getValue("status");
            if ("A".equals(value)) {
                md.setModelType(Markdown.Edit);
            } else {
                md.setModelType(Markdown.Preview);
            }
        }
        this.getView().updateView("markdownap");
    }

    public String ltrim(String value) {
        int st;
        int len = value.length();
        for (st = 0; st < len && value.charAt(st) <= ' '; ++st) {
        }
        return st > 0 ? value.substring(st, len) : value;
    }

    private String getExtendNameByType(String type) {
        if (StringUtils.isBlank((CharSequence)type) || !splitTypeExtMap.containsKey(type)) {
            return String.join((CharSequence)",", (Iterable<? extends CharSequence>)splitTypeExtMap.get("auto"));
        }
        return String.join((CharSequence)",", (Iterable<? extends CharSequence>)splitTypeExtMap.get(type));
    }

    private void splitContent() {
        String content = (String)this.getModel().getValue("inputcontent_tag");
        if (StringUtils.isBlank((CharSequence)content)) {
            return;
        }
        String entityNumber = this.getView().getFormShowParameter().getFormId();
        SplitConfig splitConfig = KMConfigReader.getSplitConfig(entityNumber);
        String splitType = (String)this.getModel().getValue("type");
        String fileExt = this.getAttachmentFileExt();
        if (StringUtils.isBlank((CharSequence)splitType) || "auto".equals(splitType)) {
            splitType = StringUtils.isNotBlank((CharSequence)fileExt) ? KnowledgeUtils.getSplitTypeByExtention(fileExt, false) : KMType.common.getName();
        }
        splitConfig.setType(splitType);
        List<DynamicObject> entryRows = CommonSplitBuilder.doSplit(splitConfig, content);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("segmententity");
        entryEntity.clear();
        entryEntity.addAll(entryRows);
        this.getModel().updateEntryCache(entryEntity);
    }

    private void propertyChangedSplitType(PropertyChangedArgs args) {
        Object newValue = args.getChangeSet()[0].getNewValue();
        Object oldValue = args.getChangeSet()[0].getOldValue();
        if (null == oldValue) {
            return;
        }
        Markdown md = (Markdown)this.getView().getControl("markdownap");
        String mdContent = md.getText();
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl(ATTACHMENT_PANEL);
        List attachmentData = attachmentPanel.getAttachmentData();
        if (attachmentData.isEmpty()) {
            this.updateAttachmentExt(newValue);
            if (!StringUtils.isBlank((CharSequence)mdContent)) {
                this.splitContent();
            }
        } else {
            this.getView().getPageCache().put("oldSplitType", null == oldValue ? "" : oldValue.toString());
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4fee\u6539\u7b97\u6cd5\u540e\uff0c\u5df2\u6709\u7684\u5206\u5757\u5c06\u88ab\u6e05\u7a7a\uff0c\u6587\u4ef6\u5c06\u91cd\u65b0\u5206\u5757\u3002", (String)"KMTemplateFormPlugin_8", (String)SYSTEM_TYPE, (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CALLBACK_CHANGE_SPLIT_TYPE));
        }
    }

    private String reloadAttachmentContent() {
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl(ATTACHMENT_PANEL);
        List attachmentData = attachmentPanel.getAttachmentData();
        if (attachmentData.isEmpty()) {
            return "";
        }
        Map attachmentInfo = (Map)attachmentData.get(0);
        Object url = attachmentInfo.get("url");
        Object relativeUrl = attachmentInfo.get("relativeUrl");
        Object fileName = attachmentInfo.get("name");
        if (null == fileName) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u9644\u4ef6\u6587\u6863\u5185\u5bb9\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u9644\u4ef6\u5e76\u91cd\u8bd5\u3002", (String)"KMTemplateFormPlugin_6", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return "";
        }
        String fileType = fileName.toString().substring(fileName.toString().lastIndexOf(".") + 1);
        try {
            InputStream in;
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            FileService fileService = FileServiceFactory.getAttachmentFileService();
            if (null != relativeUrl && fileService.exists(relativeUrl.toString())) {
                in = fileService.getInputStream(relativeUrl.toString());
            } else if (null != url && cache.exists(url.toString())) {
                in = cache.getInputStream(url.toString());
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u9644\u4ef6\u6587\u6863\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u670d\u52a1\u3002", (String)"KMTemplateFormPlugin_7", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return "";
            }
            DocParser parser = FileParseFactory.getParser(fileType, this.getModel().getDataEntityType().getName());
            Object splitType = this.getModel().getValue("type");
            if (null != splitType && !"auto".equals(splitType)) {
                parser.setSplitType(splitType.toString());
            }
            return parser.parse(in, url.toString(), null);
        }
        catch (Exception e) {
            log.error(e.toString());
            this.resetSplitType();
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u9644\u4ef6\u6587\u6863\u5185\u5bb9\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u9644\u4ef6\u5e76\u91cd\u8bd5\u3002", (String)"KMTemplateFormPlugin_6", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
    }

    private void resetSplitType() {
        String oldSplitType = this.getView().getPageCache().get("oldSplitType");
        this.getModel().beginInit();
        this.getModel().setValue("type", (Object)oldSplitType);
        this.getModel().endInit();
        this.getView().updateView("type");
    }

    private void updateSpliteType() {
        String newSplitType = "auto";
        String fileExt = this.getAttachmentFileExt();
        if (StringUtils.isNotBlank((CharSequence)fileExt)) {
            newSplitType = KnowledgeUtils.getSplitTypeByExtention(fileExt, false);
        }
        this.getModel().beginInit();
        this.getModel().setValue("type", (Object)newSplitType);
        this.getModel().endInit();
        this.getView().updateView("type");
        this.updateAttachmentExt(newSplitType);
    }

    private void updateAttachmentExt(Object splitType) {
        HashMap<String, String> attachmentMeta = new HashMap<String, String>(1);
        attachmentMeta.put("ext", String.join((CharSequence)",", (Iterable<? extends CharSequence>)splitTypeExtMap.get(null != splitType && splitTypeExtMap.containsKey(splitType) ? splitType : "auto")));
        this.getView().updateControlMetadata(ATTACHMENT_PANEL, attachmentMeta);
        this.getView().updateView(ATTACHMENT_PANEL);
    }

    private void updateAvailableSplitType(String fileExt) {
        List<Object> availableComboItems = new ArrayList<ComboItem>(6);
        switch (fileExt) {
            case "pdf": {
                availableComboItems = Collections.singletonList(this.getComboItem().get("common"));
                break;
            }
            case "docx": 
            case "txt": {
                availableComboItems.add(this.getComboItem().get("common"));
                availableComboItems.add(this.getComboItem().get("java"));
                availableComboItems.add(this.getComboItem().get("kingscript"));
                break;
            }
            case "xls": 
            case "xlsx": {
                availableComboItems.add(this.getComboItem().get("common"));
                availableComboItems.add(this.getComboItem().get("excel"));
                availableComboItems.add(this.getComboItem().get("qa"));
                break;
            }
            case "java": {
                availableComboItems = Collections.singletonList(this.getComboItem().get("java"));
                break;
            }
            case "ts": {
                availableComboItems = Collections.singletonList(this.getComboItem().get("kingscript"));
                break;
            }
            default: {
                availableComboItems = new ArrayList<ComboItem>(this.getComboItem().values());
            }
        }
        ComboProp type = (ComboProp)this.getModel().getDataEntityType().findProperty("type");
        Map<String, ValueMapItem> map = type.getComboItems().stream().collect(Collectors.toMap(ValueMapItem::getValue, v -> v));
        availableComboItems.forEach(item -> {
            ValueMapItem valueMapItem = (ValueMapItem)map.get(item.getValue());
            if (valueMapItem != null) {
                item.setItemVisible(valueMapItem.isItemVisible());
            }
        });
        ComboEdit comboEdit = (ComboEdit)this.getControl("type");
        comboEdit.setComboItems(availableComboItems);
        this.getView().updateView("type");
    }

    private String getAttachmentFileExt() {
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl(ATTACHMENT_PANEL);
        List attachmentDatas = attachmentPanel.getAttachmentData();
        if (attachmentDatas.isEmpty()) {
            return "";
        }
        Map attachmentInfo = (Map)attachmentDatas.get(0);
        String fileName = attachmentInfo.get("name").toString();
        return fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase();
    }

    private void dispatchOcrParseTask(String fileName, String entityNumber, String url) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId(this.getView().getFormShowParameter().getAppId());
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setJobType(JobType.REALTIME);
        LocaleString jobName = new LocaleString("OCR parse:" + fileName);
        jobInfo.setName(jobName.toString());
        jobInfo.setNumber(entityNumber + "_parseFileJob");
        jobInfo.setId(ID.genStringId());
        jobInfo.setCanStop(Boolean.valueOf(true));
        jobInfo.setTaskClassname("kd.bos.gptas.kmbase.knowledge.KMAttachmentUploadTask");
        jobInfo.setRunByLang(RequestContext.get().getLang());
        HashMap<String, String> params = new HashMap<String, String>(3);
        params.put("url", url);
        params.put("entityNumber", entityNumber);
        jobInfo.setParams(params);
        CloseCallBack closeCallBack = new CloseCallBack("kd.bos.gptas.kmbase.knowledge.KMTemplateFormPlugin", CALLBACK_TASK_UPLOAD);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCaption("\u4efb\u52a1\u6267\u884c\u8fdb\u5ea6");
        jobFormInfo.setCanBackground(false);
        jobFormInfo.setCanStop(true);
        jobFormInfo.setCloseCallBack(closeCallBack);
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView());
    }

    private boolean validateDuplicateFile(String fileHash, String fileName) {
        QFilter filter;
        String entityNumber = this.getView().getFormShowParameter().getFormId();
        DynamicObject knlData = QueryServiceHelper.queryOne((String)entityNumber, (String)"id", (QFilter[])new QFilter[]{filter = new QFilter("filehash", "=", (Object)fileHash)});
        if (null == knlData) {
            return true;
        }
        String knlId = knlData.getString("id");
        QFilter attachmentFilter = new QFilter("fbilltype", "=", (Object)entityNumber);
        attachmentFilter.and("finterid", "=", (Object)knlId);
        DynamicObject attachmentInfo = QueryServiceHelper.queryOne((String)"bos_attachment", (String)"fattachmentname", (QFilter[])new QFilter[]{attachmentFilter});
        if (null == attachmentInfo) {
            return true;
        }
        return !StringUtils.equalsIgnoreCase((CharSequence)fileName, (CharSequence)attachmentInfo.getString("fattachmentname"));
    }

    private void setEnableOCRVisible() {
        String entityNumber = this.getModel().getDataEntityType().getName();
        SplitConfig splitConfig = KMConfigService.create().getSplitConfig(entityNumber);
        boolean enableOCR = splitConfig.isEnableOCR();
        List fileTypes = splitConfig.getFileTypes();
        String fileExt = this.getAttachmentFileExt();
        if (enableOCR && fileTypes != null && !fileTypes.isEmpty() && (StringUtils.isBlank((CharSequence)fileExt) || fileTypes.contains(fileExt))) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{FIELD_ENABLE_OCR});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{FIELD_ENABLE_OCR});
            this.getModel().beginInit();
            this.getModel().setValue(FIELD_ENABLE_OCR, (Object)false);
            this.getModel().endInit();
        }
    }

    static {
        splitTypeExtMap.put("auto", Arrays.asList("txt", "pdf", "doc", "docx", "xls", "xlsx", "java", "ts"));
        splitTypeExtMap.put("common", Arrays.asList("txt", "pdf", "doc", "docx", "xls", "xlsx"));
        splitTypeExtMap.put("excel", Arrays.asList("xls", "xlsx"));
        splitTypeExtMap.put("qa", Arrays.asList("xls", "xlsx"));
        splitTypeExtMap.put("java", Collections.singletonList("java"));
        splitTypeExtMap.put("kingscript", Collections.singletonList("ts"));
    }
}

