/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.kmbase.knowledge;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.gptas.api.km.KMType;
import kd.bos.gptas.api.km.split.SplitConfig;
import kd.bos.gptas.kmbase.common.KMConfigReader;
import kd.bos.gptas.kmbase.newsplitter.CommonSplitBuilder;
import kd.bos.gptas.kmbase.utils.KnowledgeUtils;

public class KMTemplateOpPlugin
extends AbstractOperationServicePlugIn {
    private static final String CHUNK_SELF_BUILD = "2";
    protected static final String IS_NEED_SPLIT = "isNeedSplit";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("type");
        e.getFieldKeys().add("inputcontent_tag");
        e.getFieldKeys().add("segmententity");
        e.getFieldKeys().add("segmententity.segment");
        e.getFieldKeys().add("segmententity.segmenttype");
        e.getFieldKeys().add("segmententity.extendcontent");
        e.getFieldKeys().add("segmententity.seghits");
        e.getFieldKeys().add("segmententity.creatway");
    }

    public void splitContent(DynamicObject[] eDataEntities, String entityNumber) {
        SplitConfig splitConfig = KMConfigReader.getSplitConfig(entityNumber);
        for (DynamicObject entity : eDataEntities) {
            List changedProps = entity.getDataEntityState().GetDirtyProperties();
            Set changedPropNumbers = changedProps.stream().map(IMetadata::getName).collect(Collectors.toSet());
            DynamicObjectCollection segmentEntity = entity.getDynamicObjectCollection("segmententity");
            if (!changedPropNumbers.contains("inputcontent_tag") && !changedPropNumbers.contains("type") && !segmentEntity.isEmpty()) continue;
            String type = entity.getString("type");
            String fileExt = "";
            if (this.getOption().containsVariable("fileExt")) {
                fileExt = this.getOption().getVariableValue("fileExt");
            }
            if (StringUtils.isBlank((CharSequence)type) || "auto".equals(type)) {
                type = StringUtils.isNotBlank((CharSequence)fileExt) ? KnowledgeUtils.getSplitTypeByExtention(fileExt, false) : KMType.common.getName();
                entity.set("type", (Object)type);
            }
            String content = entity.getString("inputcontent_tag");
            splitConfig.setType(type);
            List<DynamicObject> entryRows = CommonSplitBuilder.doSplit(splitConfig, content);
            segmentEntity.removeIf(chunk -> !CHUNK_SELF_BUILD.equals(chunk.get("creatway")));
            segmentEntity.addAll(entryRows);
            for (int i = 0; i < segmentEntity.size(); ++i) {
                ((DynamicObject)segmentEntity.get(i)).set("seq", (Object)(i + 1));
            }
        }
    }
}

