/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.kmbase.newsplitter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.gptas.api.km.CustomSplitter;
import kd.bos.gptas.api.km.KMType;
import kd.bos.gptas.api.km.split.SplitConfig;
import kd.bos.gptas.api.km.split.SplitEvent;
import kd.bos.gptas.kmbase.common.KMEntityImportPluginService;
import kd.bos.gptas.kmbase.newsplitter.ISplitterService;
import kd.bos.gptas.kmbase.newsplitter.impl.ExcelSplitterServiceImpl;
import kd.bos.gptas.kmbase.newsplitter.impl.JavaCodeSplitterServiceImpl;
import kd.bos.gptas.kmbase.newsplitter.impl.KingScriptSplitterServiceImpl;
import kd.bos.gptas.kmbase.newsplitter.impl.QASplitterServiceImpl;
import kd.bos.gptas.kmbase.newsplitter.impl.TextSplitterServiceImpl;
import kd.bos.gptas.kmbase.newsplitter.result.SplitResult;
import kd.bos.gptas.kmbase.newsplitter.utils.RecursiveCharacterTextSplitter;
import org.apache.commons.lang3.StringUtils;

public class CommonSplitBuilder {
    private static final String BOS_GPTAS_KM = "bos-gptas-km";
    private static final int DEFAULT_CHUNCK_SIZE = 450;

    public static List<DynamicObject> doSplit(SplitConfig config, String content) {
        SplitEvent splitEvent = new SplitEvent(config, content, CommonSplitBuilder.buildEntityType(config.getFormId()));
        List<CustomSplitter> customSplits = KMEntityImportPluginService.newInstance(config.getFormId(), CustomSplitter.class);
        for (CustomSplitter iCommonSplitter : customSplits) {
            List splitResult = iCommonSplitter.split(splitEvent);
            if (splitResult == null || splitResult.isEmpty()) continue;
            if (!CommonSplitBuilder.checkResultType(splitResult, splitEvent)) {
                throw new RuntimeException(ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b\u4e0d\u6b63\u786e\u3002", (String)"CommonSplitBuilder_0", (String)BOS_GPTAS_KM, (Object[])new Object[0]));
            }
            return splitResult;
        }
        return CommonSplitBuilder.commonSplit(splitEvent);
    }

    private static DynamicObjectType buildEntityType(String formId) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)formId);
        DynamicCollectionProperty segmentEntity = (DynamicCollectionProperty)dataEntityType.getProperty("segmententity");
        return (DynamicObjectType)segmentEntity.getItemType();
    }

    private static boolean checkResultType(List<DynamicObject> splitResult, SplitEvent splitEvent) {
        return splitResult.stream().allMatch(res -> splitEvent.getSegmentEntityType().equals((Object)res.getDataEntityType()));
    }

    private static List<DynamicObject> commonSplit(SplitEvent splitEvent) {
        ISplitterService splitter = CommonSplitBuilder.buildSplitter(splitEvent.getSplitConfig());
        List<Object> splitRes = CommonSplitBuilder.getSplitData(splitEvent, splitter);
        ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(splitRes.size());
        for (int i = 0; i < splitRes.size(); ++i) {
            Object splitRe = splitRes.get(i);
            DynamicObject dynamicObject = splitEvent.createEntryDynamicObject();
            if (splitRe instanceof SplitResult) {
                SplitResult res = (SplitResult)splitRe;
                String segContent = res.getContent();
                dynamicObject.set("segment_tag", (Object)segContent);
                dynamicObject.set("extendcontent_tag", (Object)res.getExtendContent());
                dynamicObject.set("segmenttype", (Object)(StringUtils.isBlank((CharSequence)res.getSegmentType()) ? "TEXT" : res.getSegmentType()));
                dynamicObject.set("seq", (Object)i);
            } else {
                dynamicObject.set("segment_tag", splitRe);
                dynamicObject.set("segmenttype", (Object)"TEXT");
                dynamicObject.set("seq", (Object)i);
            }
            dynamicObject.set("creatway", (Object)"1");
            dynamicObjectList.add(dynamicObject);
        }
        return dynamicObjectList;
    }

    private static List<Object> getSplitData(SplitEvent splitEvent, ISplitterService splitter) {
        List<Object> splitRes = splitter.split(splitEvent.getContent(), splitEvent.getSplitConfig().getChunkSize());
        if (splitRes.isEmpty()) {
            splitRes = splitter.split(splitEvent.getContent(), splitEvent.getSplitConfig().getChunkSize(), splitEvent.getSplitConfig());
        }
        if (splitRes.isEmpty()) {
            splitRes = new TextSplitterServiceImpl(CommonSplitBuilder.buildText(splitEvent.getSplitConfig())).split(splitEvent.getContent(), splitEvent.getSplitConfig().getChunkSize());
        }
        return splitRes;
    }

    private static ISplitterService buildSplitter(SplitConfig config) {
        if (KMType.kingscript.getName().equals(config.getType())) {
            return new KingScriptSplitterServiceImpl();
        }
        if (KMType.java.getName().equals(config.getType())) {
            return new JavaCodeSplitterServiceImpl();
        }
        if (KMType.qa.getName().equals(config.getType())) {
            return new QASplitterServiceImpl();
        }
        if (KMType.excel.getName().equals(config.getType())) {
            return new ExcelSplitterServiceImpl();
        }
        return new TextSplitterServiceImpl(CommonSplitBuilder.buildText(config));
    }

    private static RecursiveCharacterTextSplitter buildText(SplitConfig config) {
        RecursiveCharacterTextSplitter recursiveCharacterTextSplitter = new RecursiveCharacterTextSplitter();
        recursiveCharacterTextSplitter.setChunkSize(config.getChunkSize() != 0 ? config.getChunkSize() : 450);
        recursiveCharacterTextSplitter.setChunkOverlap(config.getChunkover());
        if (StringUtils.isBlank((CharSequence)config.getSeparators())) {
            config.setSeparators("\n");
        }
        recursiveCharacterTextSplitter.setSeparators(Arrays.asList(config.getSeparators().split(",")));
        recursiveCharacterTextSplitter.setKeepSeparator(config.isKeepSeparator());
        return recursiveCharacterTextSplitter;
    }
}

