/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.kmbase.newsplitter.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.gptas.kmbase.newsplitter.utils.TextSplitter;

public class RecursiveCharacterTextSplitter
extends TextSplitter {
    protected List<String> separators = Arrays.asList("\n\n", "\n", " ", "");

    public List<String> getSeparators() {
        return this.separators;
    }

    public void setSeparators(List<String> separators) {
        this.separators = new ArrayList<String>(16);
        for (String separator : separators) {
            if (separator.equals(".")) {
                separator = "\\.";
            } else if (separator.equals("?")) {
                separator = "\\?";
            }
            if (separator.isEmpty()) continue;
            this.separators.add(separator);
        }
    }

    public List<String> innerSplitText(String text, List<String> separators) {
        String separator = separators.get(separators.size() - 1);
        List<String> newSeparators = new ArrayList<String>();
        boolean foundSeparator = false;
        for (int i = 0; i < separators.size() && !foundSeparator; ++i) {
            String temp = separators.get(i);
            if (temp.isEmpty()) {
                separator = temp;
                foundSeparator = true;
                continue;
            }
            if (!Pattern.compile(temp).matcher(text).find()) continue;
            separator = temp;
            newSeparators = separators.subList(i + 1, separators.size());
            foundSeparator = true;
        }
        return this.recursivelySplitLongerTexts(text, separator, newSeparators);
    }

    private List<String> recursivelySplitLongerTexts(String text, String separator, List<String> newSeparators) {
        ArrayList<String> finalChunks = new ArrayList<String>();
        List<String> splits = RecursiveCharacterTextSplitter.splitTextWithRegex(text, separator, this.keepSeparator);
        ArrayList<String> tempGoodSplits = new ArrayList<String>();
        String tempSeparator = this.keepSeparator ? "" : separator;
        for (String s : splits) {
            if (StringUtils.isBlank((CharSequence)s)) continue;
            if ((Integer)this.lengthFunction.apply(s) < this.chunkSize) {
                tempGoodSplits.add(s);
                continue;
            }
            if (!tempGoodSplits.isEmpty()) {
                List<String> mergedText = this.mergeSplits(tempGoodSplits, tempSeparator);
                finalChunks.addAll(mergedText);
                tempGoodSplits.clear();
            }
            if (newSeparators.isEmpty()) {
                finalChunks.addAll(RecursiveCharacterTextSplitter.truncateText(s, this.chunkSize));
                continue;
            }
            String chunkOverText = "";
            if (!finalChunks.isEmpty()) {
                chunkOverText = this.getChunkOverText((String)finalChunks.get(finalChunks.size() - 1), separator);
            }
            List<String> otherInfo = this.innerSplitText(chunkOverText + s, newSeparators);
            finalChunks.addAll(otherInfo);
        }
        if (!tempGoodSplits.isEmpty()) {
            List<String> mergedText = this.mergeSplits(tempGoodSplits, tempSeparator);
            finalChunks.addAll(mergedText);
        }
        return finalChunks;
    }

    @Override
    public List<String> splitText(String text) {
        return this.innerSplitText(text.replaceAll("\r\n", "\n"), this.separators);
    }
}

