/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.kmbase.newsplitter.utils;

import java.util.ArrayList;
import java.util.List;

public class VideoTextSplitter {
    private static final String TIME_PATTERN = "[0-9]{2}:[0-6][0-9]:[0-6][0-9]|[0-6][0-9]:[0-6][0-9]";

    public static List<Paragraph> splits(String text) {
        String[] lines = text.split("[\r\n]");
        ArrayList<Paragraph> paragraphs = new ArrayList<Paragraph>();
        Paragraph currentParagraph = null;
        for (String line : lines) {
            if (line == null || line.trim().isEmpty()) continue;
            String[] parts = line.split(" ");
            String time = parts[parts.length - 1];
            if (time.matches(TIME_PATTERN)) {
                int timeInSeconds = VideoTextSplitter.convertTimeToSeconds(time);
                currentParagraph = new Paragraph(timeInSeconds);
                paragraphs.add(currentParagraph);
                continue;
            }
            if (currentParagraph == null) continue;
            currentParagraph.addLine(line);
        }
        if (paragraphs.isEmpty()) {
            Paragraph paragraph = new Paragraph(0);
            paragraph.addLine(text);
            paragraphs.add(paragraph);
        }
        return paragraphs;
    }

    private static int convertTimeToSeconds(String time) {
        if (time == null || !time.matches(TIME_PATTERN)) {
            throw new IllegalArgumentException("Invalid time: " + time);
        }
        String[] parts = time.split(":");
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        if (parts.length == 3) {
            hours = Integer.parseInt(parts[0]);
            minutes = Integer.parseInt(parts[1]);
            seconds = Integer.parseInt(parts[2]);
        }
        if (parts.length == 2) {
            minutes = Integer.parseInt(parts[0]);
            seconds = Integer.parseInt(parts[1]);
        }
        if (parts.length == 1 || parts.length > 3) {
            throw new IllegalArgumentException("Invalid time format: " + time);
        }
        return hours * 3600 + minutes * 60 + seconds;
    }

    public static class Paragraph {
        private StringBuilder content;
        private int time;

        public Paragraph(int time) {
            this.time = time;
        }

        public void addLine(String line) {
            if (this.content == null) {
                this.content = new StringBuilder();
            } else {
                this.content.append("\n");
            }
            this.content.append(line);
        }

        public String getContent() {
            return this.content.toString();
        }

        public int getTime() {
            return this.time;
        }

        public void setTime(int time) {
            this.time = time;
        }
    }
}

