/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.kmbase.parser;

import java.util.ArrayList;
import java.util.regex.Pattern;
import kd.bos.dataentity.utils.StringUtils;

public class DocumentFormatUtils {
    private static final Pattern pageNumberPattern = Pattern.compile("\\d+/\\d+");
    private static final String pageTemplate = "\u2462\u79d8\u5bc6\u4fe1\u606f \u4e25\u7981\u6cc4\u9732";

    public static String documentClear(String doc) {
        int minLines = 5;
        ArrayList lines = new ArrayList(64);
        ArrayList<String> dir = new ArrayList<String>(12);
        int blankLineCount = 0;
        for (String line : doc.split("\n")) {
            if (StringUtils.isBlank((CharSequence)line)) {
                if (++blankLineCount >= 2) {
                    continue;
                }
            } else {
                blankLineCount = 0;
            }
            if (DocumentFormatUtils.isPageNumber(line) || DocumentFormatUtils.isPageTemplate(line, pageTemplate) || DocumentFormatUtils.isDirectoryEntry(line)) {
                dir.add(line);
                continue;
            }
            if (!dir.isEmpty() && dir.size() <= 5) {
                lines.addAll(dir);
                dir.clear();
            }
            if (DocumentFormatUtils.isPageTemplate(line, pageTemplate)) continue;
            lines.add(line);
            dir.clear();
        }
        if (!dir.isEmpty() && dir.size() <= 5) {
            lines.addAll(dir);
        }
        StringBuilder ret = new StringBuilder(doc.length());
        for (Object line : lines) {
            ret.append(line).append('\n');
        }
        return ret.toString();
    }

    private static boolean isPageNumber(String line) {
        return pageNumberPattern.matcher(DocumentFormatUtils.trimInline(line)).matches();
    }

    private static boolean isPageTemplate(String line, String ... pageTemplates) {
        line = line.trim();
        for (String t : pageTemplates) {
            if (!line.startsWith(t)) continue;
            return true;
        }
        return false;
    }

    private static boolean isDirectoryEntry(String line) {
        boolean ret;
        if (line.length() >= 18 || line.indexOf(65292) != -1 || line.indexOf(12290) != -1 || line.indexOf(65307) != -1 || line.indexOf(65311) != -1 || line.indexOf(12289) != -1) {
            return false;
        }
        boolean bl = ret = (line = line.replace('\u7b2c', ' ').replace('(', ' ').replace('\uff08', ' ').replace("\u3000", "").trim()).isEmpty() || line.equals("\r") || line.startsWith("\u4e00") || line.startsWith("\u4e8c") || line.startsWith("\u4e09") || line.startsWith("\u56db") || line.startsWith("\u4e94") || line.startsWith("\u516d") || line.startsWith("\u4e03") || line.startsWith("\u516b") || line.startsWith("\u4e5d") || line.startsWith("\u5341") || line.startsWith("\u76ee\u5f55") || line.startsWith("\u9644\u5f55") || line.startsWith("\u9644\u5219");
        if (!ret) {
            return (line = DocumentFormatUtils.trimInline(line)).startsWith("\u76ee\u5f55") || line.startsWith("\u9644\u5f55") || line.startsWith("\u9644\u5219");
        }
        return ret;
    }

    private static String trimInline(String line) {
        StringBuilder s = new StringBuilder(line.length());
        for (char ch : line.toCharArray()) {
            if (ch == ' ' || ch == '\u3000' || ch == '\r') continue;
            s.append(ch);
        }
        return s.toString();
    }
}

