/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.kmbase.parser;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.gptas.kmbase.parser.AbstractParser;
import kd.bos.util.CollectionUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelParser
extends AbstractParser {
    private final String type;
    private String splitType;
    private int emptyAnswerNumber = 0;

    public ExcelParser(String type) {
        this.type = type;
    }

    @Override
    public String parseText(InputStream in) throws IOException {
        HSSFWorkbook workBook;
        if ("xls".equals(this.type)) {
            workBook = new HSSFWorkbook(in);
        } else if ("xlsx".equals(this.type)) {
            workBook = new XSSFWorkbook(in);
        } else {
            return "";
        }
        DataFormatter formatter = new DataFormatter();
        if ("common".equals(this.splitType)) {
            return this.commonParse(formatter, (Workbook)workBook);
        }
        if ("excel".equals(this.splitType) || StringUtils.isBlank((CharSequence)this.splitType)) {
            return this.excelParse(formatter, (Workbook)workBook);
        }
        if ("qa".equals(this.splitType)) {
            return this.qaParse(formatter, (Workbook)workBook);
        }
        return "";
    }

    public void setSplitType(String splitType) {
        this.splitType = splitType;
    }

    private String commonParse(DataFormatter formatter, Workbook workbook) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
            int rowNumbers;
            Sheet sheet = workbook.getSheetAt(i);
            boolean isSheetHidden = workbook.isSheetHidden(i);
            if (isSheetHidden || (rowNumbers = sheet.getPhysicalNumberOfRows()) <= 0) continue;
            Map<String, String> mergeCellRelation = this.getMergeCellRelation(sheet, formatter);
            for (Row row : sheet) {
                if (row.getZeroHeight()) continue;
                StringBuilder rowBuilder = new StringBuilder();
                for (Cell cell : row) {
                    if (sheet.isColumnHidden(cell.getColumnIndex())) continue;
                    rowBuilder.append(this.getCellValue(cell, formatter, mergeCellRelation)).append(" ");
                }
                if (StringUtils.isBlank((CharSequence)rowBuilder.toString())) continue;
                builder.append((CharSequence)rowBuilder).append("\n");
            }
        }
        return builder.toString();
    }

    private String excelParse(DataFormatter formatter, Workbook workbook) {
        JSONArray contentArray = new JSONArray();
        for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
            int rowNumbers;
            Sheet sheet = workbook.getSheetAt(i);
            boolean isSheetHidden = workbook.isSheetHidden(i);
            if (isSheetHidden || (rowNumbers = sheet.getPhysicalNumberOfRows()) <= 0) continue;
            Map<String, String> mergeCellRelation = this.getMergeCellRelation(sheet, formatter);
            for (Row row : sheet) {
                if (row.getZeroHeight()) continue;
                JSONObject rowJson = new JSONObject(true);
                for (Cell cell : row) {
                    String cellValue;
                    if (sheet.isColumnHidden(cell.getColumnIndex()) || !StringUtils.isNotBlank((CharSequence)(cellValue = this.getCellValue(cell, formatter, mergeCellRelation)))) continue;
                    rowJson.put(String.valueOf(cell.getAddress().toString()), (Object)cellValue);
                }
                if (rowJson.isEmpty()) continue;
                contentArray.add((Object)rowJson);
            }
        }
        if (contentArray.isEmpty()) {
            return "";
        }
        return contentArray.toString(new SerializerFeature[]{SerializerFeature.PrettyFormat});
    }

    private String qaParse(DataFormatter formatter, Workbook workbook) {
        JSONArray qaArray = new JSONArray();
        for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
            Sheet sheet;
            int rowNumbers;
            boolean isSheetHidden = workbook.isSheetHidden(i);
            if (isSheetHidden || (rowNumbers = (sheet = workbook.getSheetAt(i)).getPhysicalNumberOfRows()) <= 1) continue;
            int questionColumnIndex = -1;
            int answerColumnIndex = -1;
            for (int j = 0; j < sheet.getRow(0).getLastCellNum(); ++j) {
                if (sheet.isColumnHidden(j)) continue;
                if (questionColumnIndex == -1) {
                    questionColumnIndex = j;
                    continue;
                }
                if (answerColumnIndex != -1) continue;
                answerColumnIndex = j;
            }
            Map<String, String> mergeCellRelation = this.getMergeCellRelation(sheet, formatter);
            int firstRowIndex = -1;
            for (Row row : sheet) {
                if (row.getZeroHeight()) continue;
                if (firstRowIndex == -1) {
                    firstRowIndex = row.getRowNum();
                    continue;
                }
                JSONObject qaJson = new JSONObject();
                String question = this.getCellValue(row.getCell(questionColumnIndex), formatter, mergeCellRelation);
                String answer = this.getCellValue(row.getCell(answerColumnIndex), formatter, mergeCellRelation);
                if (StringUtils.isBlank((CharSequence)question) && StringUtils.isBlank((CharSequence)answer)) continue;
                if (StringUtils.isBlank((CharSequence)answer)) {
                    ++this.emptyAnswerNumber;
                }
                qaJson.put("Q", (Object)question);
                qaJson.put("A", (Object)answer);
                qaArray.add((Object)qaJson);
            }
        }
        if (qaArray.isEmpty()) {
            return "";
        }
        return qaArray.toString(new SerializerFeature[]{SerializerFeature.PrettyFormat});
    }

    public String getWarnMsg() {
        if ("qa".equals(this.splitType) && this.emptyAnswerNumber > 0) {
            String msg = ResManager.loadKDString((String)"\u5f53\u524d\u6709\u3010%s\u3011\u4e2a\u95ee\u7b54\u5bf9\u7684\u7b54\u6848\u4e3a\u7a7a\uff0c\u8bf7\u786e\u4fdd\u63d0\u4f9b\u6709\u6548\u7684\u7b54\u6848\u5185\u5bb9\u3002", (String)"ExcelParser_0", (String)"bos-gptas-km", (Object[])new Object[0]);
            return String.format(msg, this.emptyAnswerNumber);
        }
        return "";
    }

    private Map<String, String> getMergeCellRelation(Sheet sheet, DataFormatter formatter) {
        List mergedRegions = sheet.getMergedRegions();
        if (CollectionUtils.isEmpty((Collection)mergedRegions)) {
            return new HashMap<String, String>(0);
        }
        HashMap<String, String> mergeCellRelation = new HashMap<String, String>(16);
        for (CellRangeAddress mergedRegion : mergedRegions) {
            int firstRow = mergedRegion.getFirstRow();
            int firstColumn = mergedRegion.getFirstColumn();
            String mergeRegionValue = formatter.formatCellValue(sheet.getRow(firstRow).getCell(firstColumn));
            int lastRow = mergedRegion.getLastRow();
            int lastColumn = mergedRegion.getLastColumn();
            for (int r = firstRow; r <= lastRow; ++r) {
                Row row = sheet.getRow(r);
                for (int c = firstColumn; c <= lastColumn; ++c) {
                    Cell cell = row.getCell(c);
                    mergeCellRelation.put(cell.getAddress().toString(), mergeRegionValue);
                }
            }
        }
        return mergeCellRelation;
    }

    private String getCellValue(Cell cell, DataFormatter formatter, Map<String, String> mergeCellRelation) {
        String cellValue = formatter.formatCellValue(cell);
        if (mergeCellRelation.isEmpty()) {
            return cellValue;
        }
        String address = cell.getAddress().toString();
        if (StringUtils.isBlank((CharSequence)cellValue) && mergeCellRelation.containsKey(address)) {
            return mergeCellRelation.get(address);
        }
        return cellValue;
    }
}

