/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.kmbase.parser;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.gptas.api.km.DocParser;
import kd.bos.gptas.kmbase.common.KMEntityImportPluginService;
import kd.bos.gptas.kmbase.parser.AbstractParser;
import kd.bos.gptas.kmbase.parser.ExcelParser;
import kd.bos.gptas.kmbase.parser.PDFParser;
import kd.bos.gptas.kmbase.parser.ParseProxy;
import kd.bos.gptas.kmbase.parser.TextParser;
import kd.bos.gptas.kmbase.parser.WordParser;

public class FileParseFactory {
    public static DocParser getParser(String fileType, String formId) {
        String type;
        AbstractParser parser = null;
        Map<String, DocParser> parserMap = FileParseFactory.getCustomParserMap(formId);
        if (parserMap.containsKey(type = fileType.toLowerCase())) {
            return parserMap.get(type);
        }
        switch (type) {
            case "pdf": {
                parser = new PDFParser();
                break;
            }
            case "java": 
            case "ts": 
            case "txt": {
                parser = new TextParser();
                break;
            }
            case "doc": 
            case "docx": {
                parser = new WordParser(type);
                break;
            }
            case "xls": 
            case "xlsx": {
                parser = new ExcelParser(type);
                break;
            }
        }
        return new ParseProxy(parser, formId);
    }

    private static Map<String, DocParser> getCustomParserMap(String formId) {
        List<DocParser> customParsers = KMEntityImportPluginService.newInstance(formId, DocParser.class);
        HashMap<String, DocParser> customParserMap = new HashMap<String, DocParser>(customParsers.size());
        for (DocParser customParser : customParsers) {
            String fileType = customParser.getFileType();
            if (StringUtils.isBlank((CharSequence)fileType)) continue;
            customParserMap.put(fileType.toLowerCase(), customParser);
        }
        return customParserMap;
    }
}

