/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.kmbase.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.gptas.kmbase.parser.DocumentSplitter;
import org.apache.pdfbox.multipdf.Splitter;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PDFDocumentSplitter
extends DocumentSplitter {
    private static final String SYSTEM_TYPE = "bos-gptas-km";
    private static final Logger log = LoggerFactory.getLogger(PDFDocumentSplitter.class);

    public PDFDocumentSplitter(String url, PushbackInputStream inputStream, int splitPages) {
        super(url, inputStream, splitPages);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected List<InputStream> doSplit(PushbackInputStream inputStream) {
        try (PDDocument doc = PDDocument.load((InputStream)inputStream);){
            if (doc.getNumberOfPages() <= this.getSplitPages()) {
                List<InputStream> list = Collections.emptyList();
                return list;
            }
            Splitter splitter = new Splitter();
            splitter.setSplitAtPage(this.getSplitPages());
            List split = splitter.split(doc);
            ArrayList<InputStream> list = new ArrayList<InputStream>(16);
            for (PDDocument pdDocument : split) {
                DocumentSplitter.MyByteArrayOutputStream out = new DocumentSplitter.MyByteArrayOutputStream();
                pdDocument.save((OutputStream)out);
                list.add(out.newInputStream());
                pdDocument.close();
                out.close();
            }
            ArrayList<InputStream> arrayList = list;
            return arrayList;
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    protected String getFileType() {
        return "pdf";
    }
}

