/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.kmbase.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.gptas.api.km.split.SplitConfig;
import kd.bos.gptas.api.vector.Chunk;
import kd.bos.gptas.common.GptasErrorCode;
import kd.bos.gptas.kmbase.service.EmbeddingTransactionHandler;
import kd.bos.gptas.kmbase.service.KnowledgeVectorServiceImpl;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

class KMChunkEmbeddingHandler
implements EmbeddingTransactionHandler {
    private Log logger = LogFactory.getLog(KMChunkEmbeddingHandler.class);

    KMChunkEmbeddingHandler() {
    }

    @Override
    public int getChunkCount(DynamicObject data) {
        DynamicObjectCollection segmentEntities = data.getDynamicObjectCollection("segmententity");
        return segmentEntities.size();
    }

    @Override
    public void save(String entityId, SplitConfig splitConfig, DynamicObject data, Consumer<Integer> chunkConsumer) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
        ArrayList<Chunk> chunks = new ArrayList<Chunk>(16);
        boolean isGroupKM = dataEntityType.getProperties().containsKey((Object)"group");
        Long groupId = 0L;
        if (isGroupKM) {
            try {
                groupId = data.getLong("group_id");
            }
            catch (NumberFormatException ignore) {
                this.logger.warn("group_id is not number");
            }
        }
        DynamicObjectCollection segmentEntities = data.getDynamicObjectCollection("segmententity");
        for (DynamicObject segmentRow : segmentEntities) {
            Chunk chunk = new Chunk();
            chunk.setId(Long.valueOf(segmentRow.getLong("id")));
            chunk.setEntityId(entityId);
            chunk.setKnowledgeId(Long.valueOf(data.getLong("id")));
            chunk.setContent(segmentRow.getString("segment_tag"));
            chunk.setChunkType(segmentRow.getString("segmenttype"));
            chunk.setGroupId(groupId);
            chunks.add(chunk);
        }
        KnowledgeVectorServiceImpl knowledgeVectorService = new KnowledgeVectorServiceImpl(splitConfig.getEmbeddingModel());
        knowledgeVectorService.addEmbeddingCompleteListener(chunkConsumer::accept);
        boolean result = knowledgeVectorService.batchSave(entityId, chunks);
        if (!result) {
            throw new KDBizException(GptasErrorCode.VECTOR_STORE_WRITE_ERROR.toErrorCode(), new Object[0]);
        }
    }

    @Override
    public void deleteAll(String entityId, SplitConfig splitConfig, DynamicObject data) {
        new KnowledgeVectorServiceImpl(splitConfig.getEmbeddingModel()).delete(entityId, Collections.singletonList(data.getLong("id")));
    }
}

