/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.kmbase.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.gptas.api.RerankService;
import kd.bos.gptas.api.vector.Chunk;
import kd.bos.gptas.api.vector.EmbeddingModel;
import kd.bos.gptas.api.vector.KMSearchOption;
import kd.bos.gptas.api.vector.VectorResult;
import kd.bos.gptas.api.vector.VectorTaskItem;
import kd.bos.gptas.common.KnowledgeVectorStorePlugin;
import kd.bos.gptas.common.VectorServiceImpl;
import kd.bos.gptas.kmbase.service.KnowledgeVectorService;
import kd.bos.gptas.kmbase.vectortask.KnowledgeVectorTaskManager;
import kd.bos.gptas.kmbase.vectortask.model.KnowledgeVectorModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.Pair;
import org.apache.commons.collections4.CollectionUtils;

public class KnowledgeVectorServiceImpl
extends VectorServiceImpl
implements KnowledgeVectorService {
    private static final Log log = LogFactory.getLog(KnowledgeVectorServiceImpl.class);
    private static final String ID_FIELD = "id";
    private static final String ENTITY_ID_FIELD = "segmententity.id";

    public KnowledgeVectorServiceImpl(EmbeddingModel embeddingModel) {
        super(embeddingModel);
        this.setVectorStorePlugin(Collections.singletonList(new KnowledgeVectorStorePlugin()));
    }

    @Override
    public String submitSaveTaskForKnl(List<Chunk> chunks, Consumer<List<KnowledgeVectorModel>> resultCallBack) {
        List entityIds = chunks.stream().map(Chunk::getEntityId).collect(Collectors.toList());
        KnowledgeVectorTaskManager vectorTaskManager = new KnowledgeVectorTaskManager(this.getEmbeddingService(entityIds), this.vectorStore, this.getVectorStorePluginList());
        return vectorTaskManager.submitForKnowledge(chunks, resultCallBack);
    }

    @Override
    public List<VectorTaskItem> getFailSaveTaskItems(String taskId) {
        return KnowledgeVectorTaskManager.getFailedVectorTaskChunks((String)taskId);
    }

    @Override
    public KnowledgeVectorModel getVectorKnowledge(String taskId, Long knowledgeId) {
        return KnowledgeVectorTaskManager.getVectorKnowledge(taskId, knowledgeId);
    }

    @Override
    public List<KnowledgeVectorModel> getVectorKnowledges(String taskId) {
        return KnowledgeVectorTaskManager.getVectorKnowledges(taskId);
    }

    public List<VectorResult> search(String entityId, QFilter[] filters, String content, int topK, KMSearchOption option) {
        if (option != null && option.isEnabledPermission()) {
            boolean checkPerm;
            PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
            long userId = RequestContext.get().getCurrUserId();
            String appId = option.getAppId();
            if (!option.hasValidAppId()) {
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityId);
                appId = entityType.getAppId();
            }
            if (!(checkPerm = permissionService.checkPermission(userId, appId, entityId, "47150e89000000ac"))) {
                return Collections.emptyList();
            }
            QFilter permissionFilter = permissionService.getViewPermFilter(Long.valueOf(userId), appId, entityId);
            if (filters == null || filters.length == 0) {
                filters = permissionFilter.toArray();
            } else {
                QFilter[] newFilters = Arrays.copyOf(filters, filters.length + 1);
                newFilters[filters.length] = permissionFilter;
                filters = newFilters;
            }
        }
        List<VectorResult> vectorResults = option != null && option.isEnabledRerank() ? this.searchAndRerank(entityId, filters, content, topK, option) : this.searchWithFilter(entityId, filters, content, topK);
        if (option != null && option.isEnabledChunkSeqRank()) {
            vectorResults = this.reorderBySequence(vectorResults, topK);
        }
        return vectorResults;
    }

    /*
     * WARNING - void declaration
     */
    public List<VectorResult> reorderBySequence(List<VectorResult> originalResults, int topK) {
        void var8_11;
        if (originalResults == null || originalResults.isEmpty() || topK <= 0) {
            return originalResults;
        }
        int minTopK = Math.min(topK, originalResults.size());
        ArrayList<VectorResult> topResults = new ArrayList<VectorResult>(minTopK);
        for (int i = 0; i < minTopK; ++i) {
            topResults.add(originalResults.get(i));
        }
        ArrayList<List<VectorResult>> knowledgeGroups = new ArrayList<List<VectorResult>>(topResults.stream().filter(result -> result.getChunk() != null && result.getChunk().getKnowledgeId() != null).collect(Collectors.groupingBy(r -> r.getChunk().getKnowledgeId())).values());
        LinkedList sequentialGroups = new LinkedList();
        for (List list : knowledgeGroups) {
            list.sort(Comparator.comparingInt(r -> r.getChunk().getChunkSeq()));
            ArrayList currentSequence = new ArrayList(list.size());
            currentSequence.add(list.get(0));
            for (int i = 1; i < list.size(); ++i) {
                VectorResult current = (VectorResult)list.get(i);
                VectorResult previous = (VectorResult)list.get(i - 1);
                if (current.getChunk().getChunkSeq() != previous.getChunk().getChunkSeq() + 1) {
                    sequentialGroups.add(new ArrayList(currentSequence));
                    currentSequence.clear();
                }
                currentSequence.add(current);
            }
            if (currentSequence.isEmpty()) continue;
            sequentialGroups.add(currentSequence);
        }
        if (!sequentialGroups.isEmpty()) {
            sequentialGroups.sort((g1, g2) -> {
                int minRank1 = g1.stream().mapToInt(VectorResult::getRank).min().orElse(Integer.MAX_VALUE);
                int minRank2 = g2.stream().mapToInt(VectorResult::getRank).min().orElse(Integer.MAX_VALUE);
                return Integer.compare(minRank1, minRank2);
            });
        }
        List<VectorResult> mergedResults = sequentialGroups.stream().flatMap(Collection::stream).collect(Collectors.toList());
        if (topK < originalResults.size()) {
            mergedResults.addAll(originalResults.subList(topK, originalResults.size()));
        }
        boolean bl = false;
        while (var8_11 < mergedResults.size()) {
            mergedResults.get((int)var8_11).setRank((int)(var8_11 + true));
            ++var8_11;
        }
        return mergedResults;
    }

    private List<VectorResult> searchAndRerank(String entityNumber, QFilter[] filters, String content, int topK, KMSearchOption option) {
        RerankService rerankService = RerankService.create((String)option.getRerankNumber());
        int extendTopK = 64;
        List<VectorResult> vectorResults = this.searchWithFilter(entityNumber, filters, content, extendTopK);
        if (CollectionUtils.isEmpty(vectorResults)) {
            return vectorResults;
        }
        return rerankService.rerankSearchResults(content, vectorResults, Math.min(topK, vectorResults.size()));
    }

    private List<VectorResult> searchWithFilter(String entityNumber, QFilter[] filters, String content, int topK) {
        if (filters == null || filters.length == 0) {
            return this.search(Collections.singletonList(entityNumber), content, topK);
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        boolean hasChunkConditions = this.hasChunkRelatedConditions(entityType, filters);
        if (hasChunkConditions) {
            Pair<Set<Long>, Set<Long>> searchIds = this.getKnowledgeAndChunkIds(entityType, filters);
            if (((Set)searchIds.getKey()).isEmpty() || ((Set)searchIds.getValue()).isEmpty()) {
                return Collections.emptyList();
            }
            return this.search(Collections.singletonList(entityNumber), new ArrayList((Collection)searchIds.getKey()), new ArrayList((Collection)searchIds.getValue()), content, topK);
        }
        List<Long> knowledgeIds = this.getKnowledgeIds(entityType, filters);
        if (knowledgeIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.search(Collections.singletonList(entityNumber), knowledgeIds, null, content, topK);
    }

    private boolean hasChunkRelatedConditions(MainEntityType entityType, QFilter[] filters) {
        String entityName = entityType.getName();
        return Arrays.stream(filters).filter(Objects::nonNull).map(QFilter::getProperty).anyMatch(prop -> prop.startsWith(entityName + "."));
    }

    private Pair<Set<Long>, Set<Long>> getKnowledgeAndChunkIds(MainEntityType entityType, QFilter[] filters) {
        HashSet knowledgeIds = new HashSet();
        HashSet chunkIds = new HashSet();
        String selectFields = String.format("%s, %s", ID_FIELD, ENTITY_ID_FIELD);
        DynamicObjectCollection results = QueryServiceHelper.query((String)entityType.getName(), (String)selectFields, (QFilter[])filters);
        results.forEach(obj -> {
            knowledgeIds.add(obj.getLong(ID_FIELD));
            chunkIds.add(obj.getLong(ENTITY_ID_FIELD));
        });
        return new Pair(knowledgeIds, chunkIds);
    }

    private List<Long> getKnowledgeIds(MainEntityType entityType, QFilter[] filters) {
        return QueryServiceHelper.queryPrimaryKeys((String)entityType.getName(), (QFilter[])filters, null, (int)-1).stream().map(key -> (Long)key).collect(Collectors.toList());
    }
}

