/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.kmbase.service;

import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.gptas.api.km.ParseListener;
import kd.bos.gptas.kmbase.parser.DocumentSplitter;
import kd.bos.gptas.kmbase.service.OCRService;
import kd.bos.gptas.kmbase.service.OCRServiceImpl;

public class OCRServiceSplitImpl
implements OCRService {
    private static final String SYSTEM_TYPE = "bos-gptas-km";
    private OCRService ocrService = new OCRServiceImpl();

    @Override
    public String ocrParse(String url, ParseListener listener) {
        try {
            String msg;
            List<String> listURls = Collections.singletonList(url);
            DocumentSplitter documentSplitter = DocumentSplitter.create(url, 200);
            if (documentSplitter != null) {
                listURls = documentSplitter.split();
            }
            if (listURls.size() > 1) {
                msg = String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u5df2\u62c6\u5206\uff0c\u5171%s\u4efd\u3002", (String)"OCRServiceSplitImpl_0", (String)SYSTEM_TYPE, (Object[])new Object[0]), listURls.size());
                listener.updateProgress(msg);
            } else {
                msg = "";
            }
            SplitListener splitter = new SplitListener(listener, msg);
            int i = 1;
            StringBuilder sb = new StringBuilder(16);
            for (String listURl : listURls) {
                if (listURls.size() > 1) {
                    splitter.setPrefix(String.format(ResManager.loadKDString((String)"\u6b63\u5728\u5904\u7406%1$s/%2$s\uff1a", (String)"OCRServiceSplitImpl_2", (String)SYSTEM_TYPE, (Object[])new Object[0]), i, listURls.size()));
                }
                String s = this.ocrService.ocrParse(listURl, splitter);
                sb.append(s);
                ++i;
            }
            if (documentSplitter != null) {
                documentSplitter.close();
            }
            return sb.toString();
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("1001", e.getMessage()), new Object[0]);
        }
    }

    @Override
    public boolean checkOCRAvailable() {
        return this.ocrService.checkOCRAvailable();
    }

    static class SplitListener
    implements ParseListener {
        private ParseListener parseListener;
        private String prefix = "";

        public SplitListener(ParseListener parseListener, String perfix) {
            this.parseListener = parseListener;
            this.prefix = perfix;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public boolean getStop() {
            return this.parseListener == null ? false : this.parseListener.getStop();
        }

        public void updateProgress(String progress) {
            if (this.parseListener == null) {
                return;
            }
            this.parseListener.updateProgress(this.prefix + progress);
        }
    }
}

