/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.kmbase.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.gptas.api.KMSearchService;
import kd.bos.gptas.api.RerankService;
import kd.bos.gptas.api.km.split.SplitConfig;
import kd.bos.gptas.api.rerank.RerankResult;
import kd.bos.gptas.api.vector.EmbeddingModel;
import kd.bos.gptas.api.vector.KMSearchOption;
import kd.bos.gptas.api.vector.VectorResult;
import kd.bos.gptas.kmbase.common.KMConfigReader;
import kd.bos.gptas.kmbase.service.RetrievalService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.StringUtils;

public class RetrievalServiceImpl
implements RetrievalService {
    private static final Log logger = LogFactory.getLog(RetrievalServiceImpl.class);
    private static final String RESULTS_KEY = "results";

    @Override
    public Map<String, Object> retrieval(String paramJson) {
        logger.info("Starting retrieval with params: {}", (Object)paramJson);
        RetrievalParam retrievalParam = this.parseParam(paramJson);
        logger.info("Searching with query: '{}', entities: {}, topK: {}, rerank: {}", new Object[]{retrievalParam.getQuery(), retrievalParam.getEntityIds().size(), retrievalParam.getTopK(), retrievalParam.isRerank()});
        List<VectorResult> vectorResults = this.doSearch(retrievalParam);
        List<VectorResult> filterVectorResults = vectorResults.stream().filter(vectorResult -> vectorResult.getChunk() != null && StringUtils.isNotBlank((CharSequence)vectorResult.getChunk().getContent())).collect(Collectors.toList());
        logger.info("Vector search completed. Total results: {}, after filtering: {}", (Object)vectorResults.size(), (Object)filterVectorResults.size());
        Map<String, Object> results = retrievalParam.isRerank() ? this.handleRerank(filterVectorResults, retrievalParam) : this.formatByVectorResults(filterVectorResults);
        int resultCount = ((List)results.get(RESULTS_KEY)).size();
        logger.info("Retrieval completed. Final results count: {}", (Object)resultCount);
        return results;
    }

    private RetrievalParam parseParam(String paramJson) {
        if (StringUtils.isBlank((CharSequence)paramJson)) {
            logger.error("Parameter JSON is null or empty");
            throw new IllegalArgumentException("paramJson cannot be null or empty");
        }
        try {
            JSONObject param = JSON.parseObject((String)paramJson);
            if (param.getString("query") == null || param.getJSONArray("entityIds") == null || param.getString("searchType") == null || param.getInteger("topK") == null) {
                logger.error("Missing required parameters in JSON: {}", (Object)paramJson);
                throw new IllegalArgumentException("Missing required parameters: query, entityIds, searchType, or topK");
            }
            RetrievalParam retrievalParam = new RetrievalParam();
            retrievalParam.setQuery(param.getString("query"));
            retrievalParam.setEntityIds(param.getJSONArray("entityIds").stream().map(Object::toString).collect(Collectors.toList()));
            retrievalParam.setSearchType(param.getString("searchType"));
            retrievalParam.setTopK(param.getIntValue("topK"));
            retrievalParam.setThreshold(param.getDoubleValue("threshold"));
            retrievalParam.setRerank(param.getBooleanValue("rerank"));
            logger.info("Parsed parameters - Query: '{}', EntityIds: {}, SearchType: {}, TopK: {}, Threshold: {}, Rerank: {}", new Object[]{retrievalParam.getQuery(), retrievalParam.getEntityIds(), retrievalParam.getSearchType(), retrievalParam.getTopK(), retrievalParam.getThreshold(), retrievalParam.isRerank()});
            return retrievalParam;
        }
        catch (Exception e) {
            logger.error("Failed to parse parameter JSON: " + paramJson, (Throwable)e);
            throw e;
        }
    }

    private List<VectorResult> doSearch(RetrievalParam retrievalParam) {
        List<SplitConfig> allSplitConfigs = KMConfigReader.getBatchSplitConfig(retrievalParam.getEntityIds());
        logger.info("Retrieved {} split configs for {} entities", (Object)allSplitConfigs.size(), (Object)retrievalParam.getEntityIds().size());
        Map<EmbeddingModel, List<SplitConfig>> splitConfigByEmbedded = allSplitConfigs.stream().collect(Collectors.groupingBy(SplitConfig::getEmbeddingModel));
        logger.info("Grouped into {} embedding models", (Object)splitConfigByEmbedded.size());
        ArrayList<VectorResult> results = new ArrayList<VectorResult>();
        for (Map.Entry<EmbeddingModel, List<SplitConfig>> entry : splitConfigByEmbedded.entrySet()) {
            results.addAll(this.searchByEmbeddingModel(entry.getKey(), entry.getValue(), retrievalParam));
        }
        results.sort(Comparator.comparingDouble(VectorResult::getScore));
        IntStream.range(0, results.size()).forEach(i -> ((VectorResult)results.get(i)).setRank(i + 1));
        logger.info("Search completed, total results: {}", (Object)results.size());
        return results;
    }

    private List<VectorResult> searchByEmbeddingModel(EmbeddingModel model, List<SplitConfig> configs, RetrievalParam param) {
        logger.info("Performing search with model: {}, query: '{}', topK: {}", new Object[]{model.getModelName(), param.getQuery(), param.getTopK()});
        KMSearchService searchService = KMSearchService.create((EmbeddingModel)model);
        return configs.stream().flatMap(config -> searchService.search(config.getFormId(), null, param.getQuery(), param.getTopK(), KMSearchOption.defaults()).stream()).collect(Collectors.toList());
    }

    private Map<String, Object> handleRerank(List<VectorResult> vectorResults, RetrievalParam param) {
        logger.info("Starting rerank for {} results", (Object)vectorResults.size());
        List<SplitConfig> configs = KMConfigReader.getBatchSplitConfig(param.getEntityIds());
        Optional<String> rerankNumber = configs.stream().filter(config -> StringUtils.isNotBlank((CharSequence)config.getReranknumber())).map(SplitConfig::getReranknumber).findFirst();
        if (!rerankNumber.isPresent()) {
            logger.info("No rerank number found, returning original results");
            return this.formatByVectorResults(vectorResults);
        }
        logger.info("Performing rerank with number: {}", (Object)rerankNumber.get());
        List chunks = vectorResults.stream().map(VectorResult::getChunk).collect(Collectors.toList());
        List rerankResults = RerankService.create((String)rerankNumber.get()).rerank(param.getQuery(), chunks, param.getTopK());
        return this.formatByRerankResults(rerankResults);
    }

    private Map<String, Object> formatByVectorResults(List<VectorResult> results) {
        logger.info("Formatting {} vector results", (Object)results.size());
        List resultList = results.stream().map(result -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("entityId", result.getChunk().getEntityId());
            map.put("chunkId", result.getChunk().getId());
            map.put("title", result.getChunk().getKnowledgeName());
            map.put("chunk", result.getChunk().getContent());
            map.put("score", Float.valueOf(result.getScore()));
            return map;
        }).collect(Collectors.toList());
        return Collections.singletonMap(RESULTS_KEY, resultList);
    }

    private Map<String, Object> formatByRerankResults(List<RerankResult> results) {
        logger.info("Formatting {} rerank results", (Object)results.size());
        List resultList = results.stream().map(result -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("entityId", result.getChunk().getEntityId());
            map.put("chunkId", result.getChunk().getId());
            map.put("title", result.getChunk().getKnowledgeName());
            map.put("chunk", result.getChunk().getContent());
            map.put("score", Float.valueOf(result.getRelevanceScore()));
            return map;
        }).collect(Collectors.toList());
        return Collections.singletonMap(RESULTS_KEY, resultList);
    }

    private static class RetrievalParam {
        private String query;
        private List<String> entityIds;
        private String searchType;
        private int topK;
        private double threshold;
        private boolean rerank;

        private RetrievalParam() {
        }

        public String getQuery() {
            return this.query;
        }

        public void setQuery(String query) {
            this.query = query;
        }

        public List<String> getEntityIds() {
            return this.entityIds;
        }

        public void setEntityIds(List<String> entityIds) {
            this.entityIds = entityIds;
        }

        public String getSearchType() {
            return this.searchType;
        }

        public void setSearchType(String searchType) {
            this.searchType = searchType;
        }

        public int getTopK() {
            return this.topK;
        }

        public void setTopK(int topK) {
            this.topK = topK;
        }

        public double getThreshold() {
            return this.threshold;
        }

        public void setThreshold(double threshold) {
            this.threshold = threshold;
        }

        public boolean isRerank() {
            return this.rerank;
        }

        public void setRerank(boolean rerank) {
            this.rerank = rerank;
        }
    }
}

