/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.kmbase.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.gptas.api.km.KMType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnowledgeUtils {
    private static final Logger log = LoggerFactory.getLogger(KnowledgeUtils.class);
    private static final String SYSTEM_TYPE = "bos-gptas-km";

    public static String getSplitTypeByExtention(String ext, boolean isQAKnl) {
        if (StringUtils.isBlank((CharSequence)ext)) {
            return KMType.common.getName();
        }
        switch (ext) {
            case "xls": 
            case "xlsx": {
                return isQAKnl ? KMType.qa.getName() : KMType.excel.getName();
            }
            case "java": {
                return KMType.java.getName();
            }
            case "ts": {
                return KMType.kingscript.getName();
            }
        }
        return KMType.common.getName();
    }

    public static String getFileSizeFormat(int size) {
        DecimalFormat df = new DecimalFormat("0.0");
        if (size < 1024) {
            return size + "B";
        }
        if (size < 0x100000) {
            return df.format((double)size / 1024.0) + "KB";
        }
        return df.format((double)size / 1048576.0) + "MB";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static InputStream copyInputStream(InputStream in) {
        byte[] buffer = new byte[1024];
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            int len;
            while ((len = in.read(buffer)) > -1) {
                baos.write(buffer, 0, len);
            }
            baos.flush();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(baos.toByteArray());
            return byteArrayInputStream;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<String> getExtByFileType(List<String> fileTypes) {
        if (fileTypes == null || fileTypes.isEmpty()) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> extList = new ArrayList<String>(10);
        for (String fileType : fileTypes) {
            if (StringUtils.equalsIgnoreCase((CharSequence)"word", (CharSequence)fileType)) {
                extList.add("doc");
                extList.add("docx");
                continue;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)"excel", (CharSequence)fileType)) {
                extList.add("xls");
                extList.add("xlsx");
                continue;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)"pdf", (CharSequence)fileType)) {
                extList.add("pdf");
                continue;
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)"text", (CharSequence)fileType)) continue;
            extList.add("txt");
        }
        return extList;
    }
}

