/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.kmbase.vectorcheck;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.gptas.api.KMConfigService;
import kd.bos.gptas.api.VectorService;
import kd.bos.gptas.api.km.split.SplitConfig;
import kd.bos.gptas.api.vector.EmbeddingModel;
import kd.bos.gptas.common.vectordb.VectorStoreFactory;
import kd.bos.gptas.common.vectordb.service.VectorStoreService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class VectorCheckFormPlugin
extends AbstractFormPlugin {
    private static final String MODEL_TYPE_KM = "KMModel";
    private static final String COLOR_LIGHT_GREEN = "lightgreen";
    private static final String COLOR_RED = "red";
    private static final String DB_ENTRY_GRID = "entrydb";
    private static final String DB_ENTRY_ID = "entryid";
    private static final String DB_ENTRY_CONTENT = "entry_content";
    private static final String DB_KNOWLEDGE_ID = "knowledgeid";
    private static final String DB_KNOWLEDGE_BILLNO = "knowledge_billno";
    private static final String DB_KNOWLEDGE_TITLE = "knowledge_title";
    private static final String DB_KNOWLEDGE_STATUS = "knowledge_status";
    private static final String DB_KNOWLEDGE_UPSTATUS = "knowledge_upstatus";
    private static final String VECTOR_ENTRY_GRID = "entryvector";
    private static final String VECTOR_CHUNK_ID = "chunkid";
    private static final String VECTOR_KNOWLEDGE_ID = "chunkknowledgeid";
    private static final String ENABLE_DIFFERENCE = "enabledifference";
    private static final String ENABLE_DIRTY_DATA = "enabledirtydata";
    private Set<Long> toBeAddedIds = new HashSet<Long>();
    private Set<Long> toBeRemovedIds = new HashSet<Long>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.setupRepoListener();
        this.setupButtonListeners();
    }

    private void setupRepoListener() {
        BasedataEdit repo = (BasedataEdit)this.getControl("repos");
        repo.addBeforeF7SelectListener(evt -> {
            evt.getFormShowParameter().setCustomParam("modeltype", (Object)MODEL_TYPE_KM);
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(new QFilter("bizappid.number", "!=", (Object)"tpl"));
            evt.setCustomQFilters(qFilters);
        });
    }

    private void setupButtonListeners() {
        this.addClickListeners(new String[]{"check", "clear", "btnefresh", "btnnewchat"});
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        if ("check".equals(btn.getKey())) {
            this.doCheck();
        } else if ("clear".equals(btn.getKey())) {
            this.doClear();
        }
    }

    private void doCheck() {
        this.toBeAddedIds.clear();
        this.toBeRemovedIds.clear();
        String entityName = this.getSelectedEntityName();
        if (entityName == null) {
            return;
        }
        List<DynamicObject> dbData = this.loadDatabaseData(entityName);
        this.fillDBGrid(dbData);
        Map<String, List<?>> vectorData = this.loadVectorData(entityName);
        this.fillVectorGrid(vectorData);
        this.compareAndShowResult();
    }

    private void doClear() {
        String toBeRemovedIdStr = this.getPageCache().get("toBeRemovedIds");
        if (StringUtils.isBlank((CharSequence)toBeRemovedIdStr)) {
            this.getView().showTipNotification("Please click 'Check' first to detect dirty vectors");
            return;
        }
        List toBeRemovedIds = JSON.parseArray((String)toBeRemovedIdStr, Long.class);
        if (CollectionUtils.isEmpty((Collection)toBeRemovedIds)) {
            this.getView().showTipNotification("No dirty vectors found");
            return;
        }
        String entityName = this.getSelectedEntityName();
        if (entityName == null) {
            return;
        }
        SplitConfig splitConfig = KMConfigService.create().getSplitConfig(entityName);
        VectorService vectorService = VectorService.create((EmbeddingModel)splitConfig.getEmbeddingModel());
        vectorService.delete(entityName, toBeRemovedIds);
        this.getPageCache().put("toBeRemovedIds", JSON.toJSONString(new ArrayList(1)));
        this.doCheck();
    }

    private String getSelectedEntityName() {
        Object repos = this.getModel().getValue("repos");
        return repos instanceof DynamicObject ? ((DynamicObject)repos).getPkValue().toString() : null;
    }

    private List<DynamicObject> loadDatabaseData(String entityName) {
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)entityName, (String)"name,segmententity.id,segmententity.segment_tag,id,segmententity.seq,status,uploadstatus", null);
        return Arrays.asList(objects);
    }

    private Map<String, List<?>> loadVectorData(String entityName) {
        SplitConfig splitConfig = KMConfigService.create().getSplitConfig(entityName);
        VectorStoreService vectorStore = VectorStoreFactory.create((EmbeddingModel)splitConfig.getEmbeddingModel());
        HashMap result = new HashMap();
        int pageSize = 100;
        int offset = 0;
        while (true) {
            Map pageData = vectorStore.query(entityName, null, (long)offset, (long)pageSize);
            pageData.forEach((key, value) -> {
                List list = result.computeIfAbsent((String)key, k -> new ArrayList());
                list.addAll(value);
            });
            List idList = (List)pageData.get("id");
            if (idList == null || idList.size() < pageSize) break;
            offset += pageSize;
        }
        return result;
    }

    private void fillDBGrid(List<DynamicObject> dynamicObjects) {
        this.getModel().deleteEntryData(DB_ENTRY_GRID);
        if (dynamicObjects.isEmpty()) {
            return;
        }
        int totalRows = this.countTotalRows(dynamicObjects);
        this.getModel().batchCreateNewEntryRow(DB_ENTRY_GRID, totalRows);
        int currentRow = 0;
        for (DynamicObject obj : dynamicObjects) {
            DynamicObjectCollection segments = (DynamicObjectCollection)obj.get("segmententity");
            currentRow = this.fillDBEntryRows(currentRow, obj, segments);
        }
    }

    private int countTotalRows(List<DynamicObject> dynamicObjects) {
        return dynamicObjects.stream().mapToInt(obj -> ((DynamicObjectCollection)obj.get("segmententity")).size()).sum();
    }

    private int fillDBEntryRows(int startRow, DynamicObject knowledge, DynamicObjectCollection segments) {
        int currentRow = startRow;
        for (DynamicObject segment : segments) {
            this.getModel().setValue(DB_ENTRY_ID, segment.getPkValue(), currentRow);
            this.getModel().setValue(DB_ENTRY_CONTENT, (Object)segment.getString("segment_tag"), currentRow);
            this.getModel().setValue(DB_KNOWLEDGE_ID, knowledge.getPkValue(), currentRow);
            this.getModel().setValue(DB_KNOWLEDGE_BILLNO, (Object)knowledge.getString("number"), currentRow);
            this.getModel().setValue(DB_KNOWLEDGE_TITLE, (Object)knowledge.getString("name"), currentRow);
            this.getModel().setValue(DB_KNOWLEDGE_STATUS, (Object)knowledge.getString("status"), currentRow);
            this.getModel().setValue(DB_KNOWLEDGE_UPSTATUS, (Object)knowledge.getString("uploadstatus"), currentRow);
            ++currentRow;
        }
        return currentRow;
    }

    private void fillVectorGrid(Map<String, List<?>> vectorData) {
        this.getModel().deleteEntryData(VECTOR_ENTRY_GRID);
        List<?> ids = vectorData.get("id");
        List<?> knowledgeIds = vectorData.get("knowledgeId");
        if (ids == null || ids.isEmpty()) {
            return;
        }
        this.getModel().batchCreateNewEntryRow(VECTOR_ENTRY_GRID, ids.size());
        for (int i = 0; i < ids.size(); ++i) {
            this.getModel().setValue(VECTOR_CHUNK_ID, ids.get(i), i);
            this.getModel().setValue(VECTOR_KNOWLEDGE_ID, knowledgeIds.get(i), i);
        }
    }

    private void compareAndShowResult() {
        DynamicObjectCollection dbEntries = (DynamicObjectCollection)this.getModel().getDataEntity(true).get(DB_ENTRY_GRID);
        DynamicObjectCollection vectorEntries = (DynamicObjectCollection)this.getModel().getDataEntity(true).get(VECTOR_ENTRY_GRID);
        Map<Long, Integer> dbIds = this.buildIdRowMapping(dbEntries, DB_ENTRY_ID);
        Map<Long, Integer> vectorIds = this.buildIdRowMapping(vectorEntries, VECTOR_CHUNK_ID);
        this.calcDifferences(dbIds, vectorIds);
        this.highlightDifferences(this.toBeAddedIds, this.toBeRemovedIds, dbIds, vectorIds);
        boolean showOnlyDifference = (Boolean)this.getModel().getValue(ENABLE_DIFFERENCE);
        if (showOnlyDifference) {
            this.updateDifferenceView(dbEntries, vectorEntries, dbIds, vectorIds);
        }
    }

    private Map<Long, Integer> buildIdRowMapping(DynamicObjectCollection entries, String idField) {
        HashMap<Long, Integer> idMapping = new HashMap<Long, Integer>(entries.size());
        for (int i = 0; i < entries.size(); ++i) {
            idMapping.put(((DynamicObject)entries.get(i)).getLong(idField), i);
        }
        return idMapping;
    }

    private void calcDifferences(Map<Long, Integer> dbIds, Map<Long, Integer> vectorIds) {
        this.toBeAddedIds = new HashSet<Long>(dbIds.keySet());
        this.toBeAddedIds.removeAll(vectorIds.keySet());
        this.toBeRemovedIds = new HashSet<Long>(vectorIds.keySet());
        this.toBeRemovedIds.removeAll(dbIds.keySet());
        this.getPageCache().put("toBeRemovedIds", JSON.toJSONString(this.toBeRemovedIds));
    }

    private void highlightDifferences(Set<Long> toBeAdded, Set<Long> toBeRemoved, Map<Long, Integer> dbIds, Map<Long, Integer> vectorIds) {
        EntryGrid entrydbGrid = (EntryGrid)this.getControl(DB_ENTRY_GRID);
        EntryGrid entryvectorGrid = (EntryGrid)this.getControl(VECTOR_ENTRY_GRID);
        int[] toBeAddedRows = toBeAdded.stream().map(dbIds::get).mapToInt(Integer::intValue).toArray();
        entrydbGrid.setRowBackcolor(COLOR_LIGHT_GREEN, toBeAddedRows);
        int[] toBeRemovedRows = toBeRemoved.stream().map(vectorIds::get).mapToInt(Integer::intValue).toArray();
        entryvectorGrid.setRowBackcolor(COLOR_RED, toBeRemovedRows);
    }

    private void updateDifferenceView(DynamicObjectCollection entrydb, DynamicObjectCollection entryvector, Map<Long, Integer> dbIds, Map<Long, Integer> vectorIds) {
        boolean showDirtyData = (Boolean)this.getModel().getValue(ENABLE_DIRTY_DATA);
        ArrayList<DynamicObject> toBeAddedObjects = new ArrayList<DynamicObject>(this.toBeAddedIds.size());
        for (Long id : this.toBeAddedIds) {
            toBeAddedObjects.add((DynamicObject)entrydb.get(dbIds.get(id).intValue()));
        }
        this.getModel().deleteEntryData(DB_ENTRY_GRID);
        if (!showDirtyData && !this.toBeAddedIds.isEmpty()) {
            this.updateDbGridWithDifferences(toBeAddedObjects);
        }
        ArrayList<DynamicObject> toBeRemovedObjects = new ArrayList<DynamicObject>(this.toBeRemovedIds.size());
        for (Long id : this.toBeRemovedIds) {
            toBeRemovedObjects.add((DynamicObject)entryvector.get(vectorIds.get(id).intValue()));
        }
        this.getModel().deleteEntryData(VECTOR_ENTRY_GRID);
        if (!this.toBeRemovedIds.isEmpty()) {
            this.updateVectorGridWithDifferences(toBeRemovedObjects);
        }
    }

    private void updateDbGridWithDifferences(List<DynamicObject> objects) {
        this.getModel().batchCreateNewEntryRow(DB_ENTRY_GRID, objects.size());
        EntryGrid entrydbGrid = (EntryGrid)this.getControl(DB_ENTRY_GRID);
        int[] rows = new int[objects.size()];
        for (int i = 0; i < objects.size(); ++i) {
            DynamicObject obj = objects.get(i);
            this.getModel().setValue(DB_ENTRY_ID, obj.get(DB_ENTRY_ID), i);
            this.getModel().setValue(DB_ENTRY_CONTENT, obj.get(DB_ENTRY_CONTENT), i);
            this.getModel().setValue(DB_KNOWLEDGE_ID, obj.get(DB_KNOWLEDGE_ID), i);
            this.getModel().setValue(DB_KNOWLEDGE_BILLNO, obj.get(DB_KNOWLEDGE_BILLNO), i);
            this.getModel().setValue(DB_KNOWLEDGE_TITLE, obj.get(DB_KNOWLEDGE_TITLE), i);
            this.getModel().setValue(DB_KNOWLEDGE_STATUS, obj.get(DB_KNOWLEDGE_STATUS), i);
            this.getModel().setValue(DB_KNOWLEDGE_UPSTATUS, obj.get(DB_KNOWLEDGE_STATUS), i);
            rows[i] = i;
        }
        if (rows.length > 0) {
            entrydbGrid.setRowBackcolor(COLOR_LIGHT_GREEN, rows);
        }
    }

    private void updateVectorGridWithDifferences(List<DynamicObject> objects) {
        this.getModel().batchCreateNewEntryRow(VECTOR_ENTRY_GRID, objects.size());
        EntryGrid entryvectorGrid = (EntryGrid)this.getControl(VECTOR_ENTRY_GRID);
        int[] rows = new int[objects.size()];
        for (int i = 0; i < objects.size(); ++i) {
            DynamicObject obj = objects.get(i);
            this.getModel().setValue(VECTOR_CHUNK_ID, obj.get(VECTOR_CHUNK_ID), i);
            this.getModel().setValue(VECTOR_KNOWLEDGE_ID, obj.get(VECTOR_KNOWLEDGE_ID), i);
            rows[i] = i;
        }
        if (rows.length > 0) {
            entryvectorGrid.setRowBackcolor(COLOR_RED, rows);
        }
    }
}

