/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.adapter.embedding.kdai.service;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.gptas.common.GptasErrorCode;
import kd.bos.gptas.common.embedding.exception.EmbeddingException;
import kd.bos.gptas.common.embedding.model.EmbeddingVector;
import kd.bos.gptas.common.embedding.service.EmbeddingService;
import kd.bos.gptas.servicehelper.AIServiceProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.collections4.CollectionUtils;

public abstract class KDAIEmbeddingService
implements EmbeddingService {
    private static final Log log = LogFactory.getLog(KDAIEmbeddingService.class);

    public EmbeddingVector embed(String text) throws EmbeddingException {
        List<EmbeddingVector> vectors = this.embeds(Collections.singletonList(text));
        return vectors.isEmpty() ? null : vectors.get(0);
    }

    public List<EmbeddingVector> batchEmbed(List<String> texts) throws EmbeddingException {
        return this.supportBatch() ? this.embeds(texts) : this.foreachEmbed(texts);
    }

    private List<EmbeddingVector> foreachEmbed(List<String> texts) {
        ArrayList<EmbeddingVector> embeddingVectors = new ArrayList<EmbeddingVector>(texts.size());
        for (String text : texts) {
            List<EmbeddingVector> embeddingVector = this.embeds(Collections.singletonList(text));
            if (!CollectionUtils.isNotEmpty(embeddingVector)) continue;
            embeddingVectors.add(embeddingVector.get(0));
        }
        return embeddingVectors;
    }

    private List<EmbeddingVector> embeds(List<String> texts) {
        try {
            HashMap<String, List<String>> params = new HashMap<String, List<String>>();
            params.put("input", texts);
            HashMap<String, String> context = new HashMap<String, String>();
            context.put("stream", "false");
            String userName = this.getCurrentUserName();
            log.debug("User {} calling embedding service {} with params: {}", new Object[]{userName, this.getModelType(), JSON.toJSON(params)});
            long startTime = System.currentTimeMillis();
            Map<String, String> result = AIServiceProxy.invokeAICCService(context, this.getModelType(), SerializationUtils.toJsonString(params));
            long duration = System.currentTimeMillis() - startTime;
            log.debug("Embedding completed for user {} using {} in {}ms", new Object[]{userName, this.getModelType(), duration});
            this.validateResponse(result);
            List<EmbeddingVector> embeddingVectors = this.parseResponse(result.get("result"));
            return embeddingVectors;
        }
        catch (EmbeddingException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Embedding failed", (Throwable)e);
            throw new EmbeddingException(GptasErrorCode.EMBEDDING_ERROR, "Embedding failed: " + e.getMessage(), (Throwable)e);
        }
    }

    protected abstract List<EmbeddingVector> parseResponse(String var1) throws EmbeddingException;

    private void validateResponse(Map<String, String> result) throws EmbeddingException {
        String errorCode = result.get("errorCode");
        if (!"0".equals(errorCode)) {
            String errMessage = result.get("message");
            throw new EmbeddingException(GptasErrorCode.EMBEDDING_SERVICE_ERROR, String.format("Embedding service error (code: %s): %s", errorCode, errMessage));
        }
    }

    private String getCurrentUserName() {
        return RequestContext.get().getUserName();
    }
}

