/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.adapter.embedding.kdai.service.baidu;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.List;
import kd.bos.gptas.adapter.embedding.kdai.service.KDAIEmbeddingService;
import kd.bos.gptas.common.GptasErrorCode;
import kd.bos.gptas.common.embedding.exception.EmbeddingException;
import kd.bos.gptas.common.embedding.model.EmbeddingVector;

public class BaiduTao8KEmbeddingService
extends KDAIEmbeddingService {
    public static final int DIMENSION = 1024;
    public static final String MODEL_TYPE = "BAIDU_EMBEDDING_TAO_8K";

    public BaiduTao8KEmbeddingService(int dimension) {
    }

    @Override
    protected List<EmbeddingVector> parseResponse(String response) throws EmbeddingException {
        JSONObject contentJson = JSON.parseObject((String)response);
        if (!contentJson.containsKey((Object)"usage")) {
            throw new EmbeddingException(GptasErrorCode.EMBEDDING_MODEL_ERROR, "Invalid Baidu embedding response: " + response);
        }
        JSONArray jsonArray = contentJson.getJSONArray("data");
        ArrayList<EmbeddingVector> vectors = new ArrayList<EmbeddingVector>(jsonArray.size());
        for (int i = 0; i < jsonArray.size(); ++i) {
            String embeddingString = jsonArray.getJSONObject(i).getString("embedding");
            List vectorData = (List)JSON.parseObject((String)embeddingString, (TypeReference)new TypeReference<List<Float>>(){}, (Feature[])new Feature[0]);
            EmbeddingVector vector = new EmbeddingVector();
            vector.setVector(vectorData);
            vector.setModel(MODEL_TYPE);
            vector.setDimension(1024);
            vectors.add(vector);
        }
        return vectors;
    }

    public String getModelType() {
        return MODEL_TYPE;
    }

    public int dimension() {
        return 1024;
    }

    public boolean supportBatch() {
        return false;
    }
}

