/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.adapter.llm.kdai.callback;

import com.alibaba.fastjson.JSON;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.gptas.adapter.llm.kdai.callback.KDAILLMCallback;
import kd.bos.gptas.adapter.llm.kdai.model.KDAILLMAPIMsg;
import kd.bos.gptas.adapter.llm.kdai.model.KDAILLMData;
import kd.bos.gptas.common.llm.cache.LLMDataCache;
import kd.bos.gptas.common.llm.stream.LineReader;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.StringUtils;

public class KDAILLMCallbackProxy
implements KDAILLMCallback,
LineReader,
AutoCloseable {
    private static Log logger = LogFactory.getLog(KDAILLMCallbackProxy.class);
    private static final int STREAM_WAIT_TIME = 300;
    private static final long TASK_MAX_TIME = 180000L;
    private String taskId;

    public KDAILLMCallbackProxy() {
    }

    public KDAILLMCallbackProxy(String taskId) {
        this.taskId = taskId;
    }

    @Override
    public void callBack(Map<String, Object> response) {
        ProductHandler.handleLLMResponse(response);
    }

    public String read() {
        KDAILLMAPIMsg llmapiMsg = ConsumeHandler.fetchLLMResponse(this.taskId);
        if (llmapiMsg == null || !llmapiMsg.isStatus() || StringUtils.isNotBlank((CharSequence)llmapiMsg.getErrMsg())) {
            if (llmapiMsg != null) {
                logger.info("read error, errcode: {}, errmsg: {}", (Object)llmapiMsg.getErrCode(), (Object)llmapiMsg.getErrMsg());
            }
            return null;
        }
        return llmapiMsg.getData().getLlmValue();
    }

    @Override
    public void close() {
        LLMDataCache qaCache = LLMDataCache.getByTaskId((String)this.taskId);
        if (qaCache != null) {
            qaCache.release();
        }
    }

    private static String getTaskId(Map<String, Object> response) {
        Map dataMap;
        Object taskId;
        Object data = response.get("data");
        if (data != null && (taskId = (dataMap = (Map)data).get("taskId")) != null) {
            return taskId.toString();
        }
        return "";
    }

    private static boolean isEnd(KDAILLMAPIMsg response) {
        KDAILLMData data = response.getData();
        if (data != null) {
            return data.isEnd();
        }
        return false;
    }

    static class ConsumeHandler {
        ConsumeHandler() {
        }

        static KDAILLMAPIMsg fetchLLMResponse(String taskId) {
            LLMDataCache qaCache = LLMDataCache.getByTaskId((String)taskId);
            if (qaCache == null) {
                logger.error("agent error, can't find qacache\u3002{}", (Object)taskId);
                return null;
            }
            long ts = System.currentTimeMillis();
            KDAILLMAPIMsg apiMsg = ConsumeHandler.polling(qaCache, ts);
            logger.debug("task: {}, apiMsg: {}", (Object)taskId, (Object)(apiMsg == null ? "Empty" : apiMsg.toString()));
            return apiMsg;
        }

        static KDAILLMAPIMsg polling(LLMDataCache llmDataCache, long startTime) {
            do {
                if (llmDataCache.isStop()) {
                    return null;
                }
                String llmData = llmDataCache.popLLMData();
                if (StringUtils.isBlank((CharSequence)llmData)) {
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException e) {
                        logger.warn(e.getMessage());
                    }
                    continue;
                }
                KDAILLMAPIMsg mapData = (KDAILLMAPIMsg)JSON.parseObject((String)llmData, KDAILLMAPIMsg.class);
                if (!mapData.isStatus()) {
                    llmDataCache.release();
                    return mapData;
                }
                if (KDAILLMCallbackProxy.isEnd(mapData)) {
                    llmDataCache.release();
                }
                return mapData;
            } while (System.currentTimeMillis() - startTime <= 180000L);
            llmDataCache.release();
            logger.warn("LLM response polling timed out for task: {}. Max time of {} ms exceeded.", (Object)llmDataCache.getTaskId(), (Object)180000L);
            return null;
        }
    }

    static class ProductHandler {
        private static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
        private static final String LOG_PREFIX = "LLM_RESPONSE";

        ProductHandler() {
        }

        static void handleLLMResponse(Map<String, Object> response) {
            logger.debug("{}|{}|Handling_LLM_response: {}", new Object[]{LOG_PREFIX, LocalDateTime.now().format(TIMESTAMP_FORMATTER), SerializationUtils.toJsonString(response)});
            String taskId = KDAILLMCallbackProxy.getTaskId(response);
            if (StringUtils.isBlank((CharSequence)taskId)) {
                logger.error("Failed to get taskId from response: {}", (Object)SerializationUtils.toJsonString(response));
                return;
            }
            LLMDataCache qaCache = LLMDataCache.getByTaskId((String)taskId);
            if (qaCache == null) {
                logger.error("Cannot find LLMDataCache for taskId: {}", (Object)taskId);
                return;
            }
            String llmValue = SerializationUtils.toJsonString(response);
            qaCache.pushLLMData(llmValue);
        }
    }
}

