/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.adapter.llm.kdai.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import kd.bos.gptas.openapi.OpenApiException;

public class KDAIOpenAPIResponse {
    private static final Gson GSON = new Gson();
    private Data data;
    private String requestId;
    private String errCode;
    private boolean status;

    public static KDAIOpenAPIResponse convert(JsonObject jsonObject) {
        String errCode = jsonObject.get("errCode").getAsString();
        boolean status = jsonObject.get("status").getAsBoolean();
        if (!errCode.equals("0") || !status) {
            JsonElement msg = jsonObject.get("errMsg") == null ? jsonObject.get("message") : jsonObject.get("errMsg");
            throw new OpenApiException((msg == null ? "" : msg.getAsString()) + "(error_code=" + errCode + ")");
        }
        return (KDAIOpenAPIResponse)GSON.fromJson((JsonElement)jsonObject, KDAIOpenAPIResponse.class);
    }

    public Data getData() {
        return this.data;
    }

    public void setData(Data data) {
        this.data = data;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getErrCode() {
        return this.errCode;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    public boolean isStatus() {
        return this.status;
    }

    public void setStatus(boolean status) {
        this.status = status;
    }

    public String toString() {
        return "Response{data=" + this.data + ", requestId='" + this.requestId + '\'' + ", errCode='" + this.errCode + '\'' + ", status=" + this.status + '}';
    }

    public static class Data {
        private String llmValue;
        private String referenceInfos;

        public String getLlmValue() {
            return this.llmValue;
        }

        public void setLlmValue(String llmValue) {
            this.llmValue = llmValue;
        }

        public String getReferenceInfos() {
            return this.referenceInfos;
        }

        public void setReferenceInfos(String referenceInfos) {
            this.referenceInfos = referenceInfos;
        }

        public String toString() {
            return "Data{llmValue='" + this.llmValue + '\'' + ", referenceInfos='" + this.referenceInfos + '\'' + '}';
        }
    }
}

