/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.adapter.llm.kdai.service;

import com.alibaba.fastjson.JSON;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import kd.bos.gptas.adapter.llm.kdai.callback.KDAILLMCallback;
import kd.bos.gptas.adapter.llm.kdai.callback.KDAILLMCallbackProxy;
import kd.bos.gptas.adapter.llm.kdai.model.KDAILLMAsnycResponse;
import kd.bos.gptas.adapter.llm.kdai.model.KDAIOpenAPIResponse;
import kd.bos.gptas.api.LLMService;
import kd.bos.gptas.api.llm.MarkedMessageStream;
import kd.bos.gptas.api.llm.Marker;
import kd.bos.gptas.api.llm.MessageStream;
import kd.bos.gptas.common.llm.cache.LLMDataCache;
import kd.bos.gptas.common.llm.marker.MarkerAwareMessageStream;
import kd.bos.gptas.common.llm.stream.BufferedMessageStream;
import kd.bos.gptas.common.llm.stream.IterMessageStream;
import kd.bos.gptas.common.llm.stream.LineReader;
import kd.bos.gptas.config.ConfigurableItem;
import kd.bos.gptas.openapi.OpenApiClient;
import kd.bos.gptas.servicehelper.AIServiceProxy;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class KDAILLMService
implements LLMService {
    @ConfigurableItem
    public static final String GPT_LOCAL_ENABLE = "gpt.local.enable";
    public static final String LOCAL_PROMPTNUMBER = "gptas-default";
    private static Log logger = LogFactory.getLog(KDAILLMService.class);
    private static OpenApiClient openApiClient = OpenApiClient.builder().configFile("openapi-baseline.properties").build();
    private static final String AI_PARAM_CLOUDID = "ai";
    private static final String AI_PARAM_APPID = "gai";
    private static final String AI_PARAM_SERVICENAME = "GaiPromptService";
    private static final String AI_PARAM_METHODNAME = "asyncCall";

    public MessageStream llm(String input, Map<String, Object> customParams) {
        return this.getMessageOfDispatchService(input, customParams);
    }

    public MarkedMessageStream markerAware(MessageStream messageStream, List<Marker> markers) {
        return new MarkerAwareMessageStream(messageStream, markers);
    }

    public String syncLLM(String input, Map<String, Object> customParams) {
        Object promptNumber;
        Object object = promptNumber = customParams == null ? null : customParams.get("promptNumber");
        if (promptNumber == null) {
            promptNumber = LOCAL_PROMPTNUMBER;
        }
        return AIServiceProxy.invokePromptService(String.valueOf(promptNumber), input);
    }

    private MessageStream getMessageOfDispatchService(String input, Map<String, Object> customParams) {
        Object promptNumber;
        Object object = promptNumber = customParams == null ? null : customParams.get("promptNumber");
        if (promptNumber == null) {
            promptNumber = LOCAL_PROMPTNUMBER;
        }
        Map<String, Object> invokeResult = AIServiceProxy.invokePromptServiceAsync(this.buildCallBackInfo(), true, String.valueOf(promptNumber), input, new HashMap<String, String>(1));
        KDAILLMAsnycResponse llmAsyncResponse = KDAILLMAsnycResponse.convert(Objects.requireNonNull(invokeResult));
        LLMDataCache llmDataCache = new LLMDataCache(ID.genStringId()).persist();
        llmDataCache.setTaskId(llmAsyncResponse.getTaskId()).persist();
        Function<String, String> resultConsumer = msg -> msg;
        KDAILLMCallbackProxy lineReader = new KDAILLMCallbackProxy(llmAsyncResponse.getTaskId());
        return new IterMessageStream((LineReader)lineReader, (AutoCloseable)lineReader, resultConsumer);
    }

    private Map<String, String> buildCallBackInfo() {
        HashMap<String, String> callBackInfo = new HashMap<String, String>();
        callBackInfo.put("cloudId", "bos");
        callBackInfo.put("appId", "bos");
        callBackInfo.put("serviceName", KDAILLMCallback.class.getSimpleName());
        callBackInfo.put("methodName", "callBack");
        return callBackInfo;
    }

    private MessageStream getMessageOfOpenApi(String input, Map<String, Object> customParams) {
        Object promptNumber = customParams == null ? null : customParams.get("promptNumber");
        JsonObject jsonObject = openApiClient.requestPost("/kapi/v2/gai/prompt/syncCall", this.buildOpenApiRequest(input, promptNumber == null ? null : promptNumber.toString()));
        KDAIOpenAPIResponse aiResponse = KDAIOpenAPIResponse.convert(jsonObject);
        return new BufferedMessageStream(aiResponse.getData().getLlmValue());
    }

    private String buildOpenApiRequest(String input, String promptNumber) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("stream", Boolean.FALSE);
        ret.put("promptNumber", promptNumber == null ? LOCAL_PROMPTNUMBER : promptNumber);
        ret.put("varParams", new HashMap(1));
        ret.put("input", input);
        return JSON.toJSONString(ret);
    }
}

