/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.adapter.rerank.kdai.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.gptas.adapter.rerank.kdai.service.KDAIRerankService;
import kd.bos.gptas.api.rerank.RerankResult;
import kd.bos.gptas.common.GptasErrorCode;
import kd.bos.gptas.common.GptasException;

public class DoubaoRerankService
extends KDAIRerankService {
    private int topK;

    public DoubaoRerankService(String rerankNumber) {
        super(rerankNumber);
    }

    @Override
    protected Map<String, Object> parseRequest(String question, int topK, List<String> documents) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        ArrayList list = new ArrayList(16);
        this.topK = topK;
        for (String document : documents) {
            HashMap<String, String> data = new HashMap<String, String>(16);
            data.put("query", question);
            data.put("content", document);
            list.add(data);
        }
        map.put("datas", list);
        return map;
    }

    @Override
    protected List<RerankResult> parseResponse(String response) {
        JSONObject contentJson = JSON.parseObject((String)response);
        if (!contentJson.containsKey((Object)"request_id")) {
            throw new GptasException(GptasErrorCode.UNKNOWN_ERROR, "Invalid doubao rerank response: " + response);
        }
        Object o = contentJson.get((Object)"data");
        JSONArray jsonArray = contentJson.getJSONObject("data").getJSONArray("scores");
        if (jsonArray == null || jsonArray.size() == 0) {
            return new ArrayList<RerankResult>(1);
        }
        if (this.topK == 0) {
            this.topK = jsonArray.size();
        }
        ArrayList<RerankResult> rerankResults = new ArrayList<RerankResult>(jsonArray.size());
        for (int i = 0; i < jsonArray.size() && i < this.topK; ++i) {
            Float relevanceScore = jsonArray.getFloat(i);
            RerankResult rerankResult = new RerankResult();
            rerankResult.setRelevanceScore(relevanceScore.floatValue());
            rerankResult.setOriginIndex(i);
            rerankResult.setRank(i + 1);
            rerankResults.add(rerankResult);
        }
        return rerankResults;
    }
}

