/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.adapter.vectordb.milvus;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.gptas.adapter.vectordb.milvus.config.MilvusConfig;
import kd.bos.gptas.adapter.vectordb.milvus.service.MilvusVectorStoreProxy;

class MilvusVectorStoreManager {
    private static final Map<String, MilvusVectorStoreProxy> storeMap = new ConcurrentHashMap<String, MilvusVectorStoreProxy>();

    MilvusVectorStoreManager() {
    }

    public static MilvusVectorStoreProxy getStore(int dimension, String embeddingName) {
        RequestContext requestContext = RequestContext.get();
        String key = requestContext.getAccountId() + "_" + dimension + "_" + embeddingName;
        return storeMap.computeIfAbsent(key, k -> {
            MilvusConfig.Builder configBuilder = MilvusConfig.fromSystemProperties(requestContext.getTenantId());
            configBuilder.dimension(dimension).embeddingName(embeddingName).build();
            return new MilvusVectorStoreProxy(configBuilder.build());
        });
    }
}

