/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.adapter.vectordb.milvus.client;

import io.milvus.client.MilvusServiceClient;
import io.milvus.param.ConnectParam;
import io.milvus.param.R;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import kd.bos.gptas.adapter.vectordb.milvus.config.MilvusConfig;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

class MilvusClientHolder {
    private static final Log log = LogFactory.getLog(MilvusClientHolder.class);
    private static final AtomicReference<MilvusServiceClient> serviceClientRef = new AtomicReference();
    private static final AtomicLong lastCheckHealthTime = new AtomicLong(0L);
    private static final long HEALTH_CHECK_THRESHOLD = TimeUnit.SECONDS.toMillis(30L);

    MilvusClientHolder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static MilvusServiceClient getServiceClient(MilvusConfig config) {
        Class<MilvusClientHolder> clazz;
        long currentTime = System.currentTimeMillis();
        MilvusServiceClient currentClient = serviceClientRef.get();
        if (currentClient == null) {
            clazz = MilvusClientHolder.class;
            // MONITORENTER : kd.bos.gptas.adapter.vectordb.milvus.client.MilvusClientHolder.class
            currentClient = serviceClientRef.get();
            if (currentClient == null) {
                currentClient = MilvusClientHolder.createServiceClient(config);
                serviceClientRef.set(currentClient);
                lastCheckHealthTime.set(currentTime);
                // MONITOREXIT : clazz
                return currentClient;
            }
            // MONITOREXIT : clazz
        }
        if (currentTime - lastCheckHealthTime.get() <= HEALTH_CHECK_THRESHOLD) return currentClient;
        clazz = MilvusClientHolder.class;
        // MONITORENTER : kd.bos.gptas.adapter.vectordb.milvus.client.MilvusClientHolder.class
        if (currentTime - lastCheckHealthTime.get() > HEALTH_CHECK_THRESHOLD) {
            lastCheckHealthTime.set(currentTime);
            if (!MilvusClientHolder.checkHealth()) {
                log.warn("Milvus client health check failed, attempting to reconnect...");
                try {
                    currentClient.close();
                }
                catch (Exception e) {
                    log.error("Error closing old Milvus client", (Throwable)e);
                }
                currentClient = MilvusClientHolder.createServiceClient(config);
                serviceClientRef.set(currentClient);
                log.info("Milvus client reconnected successfully");
            }
        }
        // MONITOREXIT : clazz
        return currentClient;
    }

    private static MilvusServiceClient createServiceClient(MilvusConfig config) {
        ConnectParam connectParam = ConnectParam.newBuilder().withHost(config.getHost()).withPort(config.getPort()).withAuthorization(config.getUsername(), config.getPassword()).withConnectTimeout(config.getConnectTimeoutMillis(), TimeUnit.MILLISECONDS).build();
        MilvusServiceClient client = new MilvusServiceClient(connectParam);
        client.withTimeout(config.getOperationTimeoutMillis(), TimeUnit.MILLISECONDS);
        return client;
    }

    private static boolean checkHealth() {
        MilvusServiceClient client = serviceClientRef.get();
        if (client == null) {
            return false;
        }
        R responseR = client.checkHealth();
        if (responseR != null && responseR.getStatus().intValue() != R.Status.Success.getCode()) {
            log.error("Milvus client status error: {}", (Object)responseR);
            return false;
        }
        return true;
    }
}

