/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.adapter.vectordb.milvus.client;

import io.milvus.client.MilvusServiceClient;
import io.milvus.grpc.DataType;
import io.milvus.grpc.DescribeCollectionResponse;
import io.milvus.grpc.FieldSchema;
import io.milvus.grpc.MutationResult;
import io.milvus.grpc.QueryResults;
import io.milvus.grpc.SearchResults;
import io.milvus.param.IndexType;
import io.milvus.param.MetricType;
import io.milvus.param.R;
import io.milvus.param.collection.CreateCollectionParam;
import io.milvus.param.collection.DescribeCollectionParam;
import io.milvus.param.collection.DropCollectionParam;
import io.milvus.param.collection.FieldType;
import io.milvus.param.collection.HasCollectionParam;
import io.milvus.param.collection.LoadCollectionParam;
import io.milvus.param.dml.DeleteParam;
import io.milvus.param.dml.InsertParam;
import io.milvus.param.dml.QueryParam;
import io.milvus.param.dml.SearchParam;
import io.milvus.param.index.CreateIndexParam;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.gptas.adapter.vectordb.milvus.client.MilvusClientHolder;
import kd.bos.gptas.adapter.vectordb.milvus.config.MilvusConfig;
import kd.bos.gptas.common.GptasErrorCode;
import kd.bos.gptas.common.vectordb.exception.VectorException;
import kd.bos.gptas.utils.SystemPropertyUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class MilvusCollectionManager
implements Closeable {
    private static final Log log = LogFactory.getLog(MilvusCollectionManager.class);
    private final MilvusConfig config;

    public MilvusCollectionManager(MilvusConfig config) {
        this.config = config;
    }

    public void initialize(String collectionName) {
        this.createCollectionIfNotExists(collectionName);
        this.loadCollection(collectionName);
    }

    private MilvusServiceClient getHealthClient() {
        return MilvusClientHolder.getServiceClient(this.config);
    }

    private void createCollectionIfNotExists(String collectionName) {
        R result = this.getHealthClient().hasCollection(HasCollectionParam.newBuilder().withCollectionName(collectionName).build());
        if (Boolean.FALSE.equals(result.getData())) {
            List<FieldType> fields = this.createFieldTypes();
            CreateCollectionParam createParam = CreateCollectionParam.newBuilder().withCollectionName(collectionName).withDescription("Vector collection for GPTAS").withShardsNum(2).withFieldTypes(fields).build();
            R createResult = this.getHealthClient().createCollection(createParam);
            log.info("Collection created: {}", (Object)createResult);
            this.createIndex(collectionName);
        }
    }

    private List<FieldType> createFieldTypes() {
        ArrayList<FieldType> fieldTypes = new ArrayList<FieldType>(3);
        fieldTypes.add(FieldType.newBuilder().withName("id").withDataType(DataType.Int64).withPrimaryKey(true).withAutoID(false).build());
        fieldTypes.add(FieldType.newBuilder().withName("vector").withDataType(DataType.FloatVector).withDimension(Integer.valueOf(this.config.getDimension())).build());
        fieldTypes.add(FieldType.newBuilder().withName("repoId").withDataType(DataType.VarChar).withMaxLength(Integer.valueOf(50)).build());
        fieldTypes.add(FieldType.newBuilder().withName("knowledgeId").withDataType(DataType.Int64).build());
        fieldTypes.add(FieldType.newBuilder().withName("groupId").withDataType(DataType.Int64).build());
        return fieldTypes;
    }

    private void createIndex(String collectionName) {
        CreateIndexParam indexParam = CreateIndexParam.newBuilder().withCollectionName(collectionName).withFieldName("vector").withIndexType(IndexType.IVF_FLAT).withMetricType(MetricType.L2).withExtraParam(String.format("{\"nlist\":%d}", this.config.getDimension())).withSyncMode(Boolean.FALSE).build();
        R indexResult = this.getHealthClient().createIndex(indexParam);
        log.info("Index created: {}", (Object)indexResult);
    }

    private void loadCollection(String collectionName) {
        R loadResult = this.getHealthClient().loadCollection(LoadCollectionParam.newBuilder().withCollectionName(collectionName).build());
        log.debug("Collection loaded: {}", (Object)loadResult);
    }

    private boolean hasField(String collectionName, String fieldName) {
        DescribeCollectionParam describeParam = DescribeCollectionParam.newBuilder().withCollectionName(collectionName).build();
        R responseR = this.getHealthClient().describeCollection(describeParam);
        if (responseR.getStatus() != 0) {
            log.error("\u83b7\u53d6\u96c6\u5408\u4fe1\u606f\u5931\u8d25: {}", (Object)responseR.getMessage());
            return false;
        }
        List fieldsList = ((DescribeCollectionResponse)responseR.getData()).getSchema().getFieldsList();
        for (FieldSchema field : fieldsList) {
            if (!field.getName().equals(fieldName)) continue;
            return true;
        }
        return false;
    }

    public boolean isNewVersionCollection(String collectionName) {
        return this.hasField(collectionName, "groupId");
    }

    public SearchResults search(String collectionName, List<Float> vector, List<String> chunkTypes, List<Long> knowledgeIds, List<Long> chunkIds, List<Long> groupIds, int topK) {
        return this.search0(collectionName, vector, chunkTypes, knowledgeIds, chunkIds, groupIds, topK);
    }

    private SearchResults search0(String collectionName, List<Float> vector, List<String> chunkTypes, List<Long> knowledgeIds, List<Long> chunkIds, List<Long> groupIds, int topK) {
        StringBuilder expr = new StringBuilder();
        String exprChunkTypesStr = this.buildChunkTypesExpression(chunkTypes);
        String exprKnowIdStr = this.buildKnowledgeIdExpression(knowledgeIds);
        String exprChunkIdStr = this.buildChunkIdExpression(chunkIds);
        String exprgroupIdStr = this.buildGroupIdExpression(groupIds);
        if (StringUtils.isNotBlank((CharSequence)exprChunkTypesStr)) {
            expr.append("(").append(exprChunkTypesStr).append(")");
        }
        if (StringUtils.isNotBlank((CharSequence)exprKnowIdStr)) {
            if (expr.length() != 0) {
                expr.append(" and ");
            }
            expr.append("(").append(exprKnowIdStr).append(")");
        }
        if (StringUtils.isNotBlank((CharSequence)exprChunkIdStr)) {
            if (expr.length() != 0) {
                expr.append(" and ");
            }
            expr.append("(").append(exprChunkIdStr).append(")");
        }
        if (StringUtils.isNotBlank((CharSequence)exprgroupIdStr)) {
            if (expr.length() != 0) {
                expr.append(" and ");
            }
            expr.append("(").append(exprgroupIdStr).append(")");
        }
        ArrayList<String> outFields = new ArrayList<String>();
        outFields.add("repoId");
        outFields.add("knowledgeId");
        if (this.isNewVersionCollection(collectionName)) {
            outFields.add("groupId");
        }
        SearchParam searchParam = SearchParam.newBuilder().withCollectionName(collectionName).withMetricType(MetricType.L2).withOutFields(outFields).withTopK(Integer.valueOf(topK)).withVectors(Collections.singletonList(vector)).withVectorFieldName("vector").withExpr(expr.toString()).withParams(this.getNprobeParam(this.config.getDimension())).build();
        R response = this.getHealthClient().search(searchParam);
        if (response.getStatus() != 0) {
            throw new RuntimeException(response.getMessage());
        }
        return (SearchResults)response.getData();
    }

    public QueryResults query(QueryParam queryParam) {
        R response = this.getHealthClient().query(queryParam);
        if (response.getStatus().intValue() != R.Status.Success.getCode()) {
            throw new VectorException(GptasErrorCode.VECTOR_SEARCH_ERROR, "Store operation query failed: " + response.getMessage());
        }
        return (QueryResults)response.getData();
    }

    public MutationResult insert(InsertParam insertParam) {
        R response = this.getHealthClient().insert(insertParam);
        if (response.getStatus().intValue() != R.Status.Success.getCode()) {
            throw new VectorException(GptasErrorCode.VECTOR_STORE_WRITE_ERROR, "Store operation failed: " + response.getMessage());
        }
        return (MutationResult)response.getData();
    }

    public MutationResult delete(DeleteParam deleteParam) {
        R response = this.getHealthClient().delete(deleteParam);
        if (response.getStatus().intValue() != R.Status.Success.getCode()) {
            throw new VectorException(GptasErrorCode.VECTOR_STORE_WRITE_ERROR, "Store operation failed: " + response.getMessage());
        }
        return (MutationResult)response.getData();
    }

    private String getNprobeParam(int dimension) {
        String tenantId = RequestContext.get().getTenantId();
        String nprobeRatio = SystemPropertyUtils.getProptyByTenant((String)"milvus.search.nprobe.ratio.val", (String)tenantId);
        Double ratio = StringUtils.isEmpty((CharSequence)nprobeRatio) ? Double.valueOf(0.1) : Double.valueOf(nprobeRatio);
        int nprobe = (int)((double)dimension * ratio);
        log.debug("milvus search params nlist:{}, ratio:{}, nprobe:{}", new Object[]{dimension, ratio, nprobe});
        return String.format("{\"nprobe\":%s, \"offset\":0}", nprobe > 1 ? nprobe : 1);
    }

    private String buildChunkTypesExpression(List<String> chunkTypes) {
        if (chunkTypes == null || chunkTypes.isEmpty()) {
            return "";
        }
        String quotedIds = new HashSet<String>(chunkTypes).stream().map(id -> "\"" + id + "\"").collect(Collectors.joining(","));
        return "repoId in [" + quotedIds + "]";
    }

    private String buildKnowledgeIdExpression(List<Long> knowledgeIds) {
        if (knowledgeIds == null || knowledgeIds.isEmpty()) {
            return "";
        }
        String quotedIds = new HashSet<Long>(knowledgeIds).stream().map(id -> "" + id + "").collect(Collectors.joining(","));
        return "knowledgeId in [" + quotedIds + "]";
    }

    private String buildChunkIdExpression(List<Long> chunkIds) {
        if (chunkIds == null || chunkIds.isEmpty()) {
            return "";
        }
        String quotedIds = new HashSet<Long>(chunkIds).stream().map(id -> "" + id + "").collect(Collectors.joining(","));
        return "id in [" + quotedIds + "]";
    }

    private String buildGroupIdExpression(List<Long> groupIds) {
        if (groupIds == null || groupIds.isEmpty()) {
            return "";
        }
        String quotedIds = new HashSet<Long>(groupIds).stream().map(id -> "" + id + "").collect(Collectors.joining(","));
        return "groupId in [" + quotedIds + "]";
    }

    @Override
    public void close() {
        if (this.getHealthClient() != null) {
            this.getHealthClient().close();
        }
    }

    public void dropCollection(DropCollectionParam dropCollectionParam) {
        R rpcStatusR = this.getHealthClient().dropCollection(dropCollectionParam);
        if (rpcStatusR.getStatus().intValue() != R.Status.Success.getCode()) {
            throw new VectorException(GptasErrorCode.VECTOR_STORE_DELETE_ERROR, "drop collection failed: " + rpcStatusR.getMessage());
        }
    }

    public boolean existsCollection(String collectionName) {
        R result = this.getHealthClient().hasCollection(HasCollectionParam.newBuilder().withCollectionName(collectionName).build());
        return (Boolean)result.getData();
    }
}

