/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.adapter.vectordb.milvus.service;

import io.milvus.grpc.FieldData;
import io.milvus.grpc.SearchResults;
import io.milvus.param.dml.InsertParam;
import io.milvus.response.SearchResultsWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.gptas.api.vector.Chunk;
import kd.bos.gptas.api.vector.SimilarityType;
import kd.bos.gptas.api.vector.VectorResult;
import kd.bos.gptas.common.vectordb.model.VectorChunk;

public class MilvusConverter {
    private String formId;

    public MilvusConverter(String formId) {
        this.formId = formId;
    }

    public List<VectorResult> toVectorResults(SearchResults searchResults) {
        int i;
        if (searchResults == null) {
            return Collections.emptyList();
        }
        List ids = searchResults.getResults().getIds().getIntId().getDataList();
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        SearchResultsWrapper searchResultsWrapper = new SearchResultsWrapper(searchResults.getResults());
        List knowledgeIds = searchResultsWrapper.getFieldWrapper("knowledgeId").getFieldData();
        List fieldsDataList = searchResults.getResults().getFieldsDataList();
        List groupIds = null;
        for (FieldData fieldData : fieldsDataList) {
            if (!fieldData.getFieldName().equals("groupId")) continue;
            groupIds = fieldData.getScalars().getLongData().getDataList();
            break;
        }
        ArrayList<VectorResult> results = new ArrayList<VectorResult>(ids.size());
        for (i = 0; i < ids.size(); ++i) {
            VectorResult result = new VectorResult();
            Chunk chunk = new Chunk();
            chunk.setId((Long)ids.get(i));
            result.setChunk(chunk);
            result.setScore(searchResults.getResults().getScores(i));
            chunk.setKnowledgeId((Long)knowledgeIds.get(i));
            if (groupIds != null) {
                chunk.setGroupId((Long)groupIds.get(i));
            }
            chunk.setEntityId(this.formId);
            result.setSimilarityType(SimilarityType.L2.name());
            results.add(result);
        }
        results.sort((a, b) -> Float.compare(a.getScore(), b.getScore()));
        for (i = 0; i < results.size(); ++i) {
            ((VectorResult)results.get(i)).setRank(i + 1);
        }
        return results;
    }

    public List<InsertParam.Field> toMilvusFields(List<VectorChunk> vectorChunks, boolean newVersionCollection) {
        ArrayList<Long> ids = new ArrayList<Long>(vectorChunks.size());
        ArrayList<String> chunkTypes = new ArrayList<String>(vectorChunks.size());
        ArrayList<List> vectors = new ArrayList<List>(vectorChunks.size());
        ArrayList<Long> knowledgeIds = new ArrayList<Long>(vectorChunks.size());
        ArrayList<Long> groupIds = new ArrayList<Long>(vectorChunks.size());
        for (VectorChunk vectorChunk : vectorChunks) {
            ids.add(vectorChunk.getChunk().getId());
            chunkTypes.add(vectorChunk.getChunk().getChunkType() == null ? "" : vectorChunk.getChunk().getChunkType());
            vectors.add(vectorChunk.getVector());
            knowledgeIds.add(vectorChunk.getChunk().getKnowledgeId());
            groupIds.add(vectorChunk.getChunk().getGroupId());
        }
        ArrayList<InsertParam.Field> fields = new ArrayList<InsertParam.Field>(3);
        fields.add(new InsertParam.Field("id", ids));
        fields.add(new InsertParam.Field("repoId", chunkTypes));
        fields.add(new InsertParam.Field("vector", vectors));
        fields.add(new InsertParam.Field("knowledgeId", knowledgeIds));
        if (newVersionCollection) {
            fields.add(new InsertParam.Field("groupId", groupIds));
        }
        return fields;
    }
}

