/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.adapter.vectordb.vdb.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.ai.vdb.Filter;
import kd.ai.vdb.QueryParameters;
import kd.ai.vdb.VDBClient;
import kd.ai.vdb.VDBClientConfig;
import kd.ai.vdb.objects.CollectionData;
import kd.ai.vdb.objects.CollectionMeta;
import kd.ai.vdb.objects.FieldMeta;
import kd.ai.vdb.objects.ServerFeatures;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class VDBClientWrapper {
    private static final Log log = LogFactory.getLog(VDBClientWrapper.class);
    private VDBClient vdbClient;
    private int dimension;
    private String embeddingName;
    private static LocalMemoryCache mapFeatures;

    public VDBClientWrapper(VDBClient vdbClient, int dimension, String embeddingName) {
        this.vdbClient = vdbClient;
        this.dimension = dimension;
        this.embeddingName = embeddingName;
        CacheConfigInfo cacheConfigInfo = new CacheConfigInfo();
        cacheConfigInfo.setMaxItemSize(30000);
        cacheConfigInfo.setTimeout(300);
        String type = CacheKeyUtil.getAcctId() + ".vbdclient.features";
        mapFeatures = CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(Instance.getClusterName(), type, cacheConfigInfo);
    }

    public void init(VDBClientConfig config) {
        this.vdbClient.init(config);
    }

    public void insert(CollectionData collectionData, boolean checkVector) {
        if (!this.vdbClient.existsCollection(collectionData.getMeta().getName())) {
            throw new IllegalArgumentException("collection not exists,can't insert data.");
        }
        if (checkVector) {
            this.validateVectorDimension(collectionData.getData());
        }
        this.vdbClient.insert(collectionData);
    }

    public void delete(String collectionName, Object[] ids) {
        if (this.existsCollection(collectionName)) {
            this.vdbClient.delete(collectionName, ids);
        }
    }

    public CollectionData search(String collectionName, String destVectorFieldName, double[] destVector, int topk, String[] selectFields) {
        this.validateSearchVector(destVector);
        return this.vdbClient.search(collectionName, destVectorFieldName, destVector, topk, selectFields);
    }

    public CollectionData search(String collectionName, String destVectorFieldName, double[] destVector, int topk, String[] selectFields, Filter filter) {
        this.validateSearchVector(destVector);
        return this.vdbClient.search(collectionName, destVectorFieldName, destVector, topk, selectFields, filter);
    }

    public CollectionData query(String collectionName, int top, String[] selectFields) {
        return this.vdbClient.query(collectionName, top, selectFields);
    }

    public CollectionData query(String collectionName, int limit, int offset, String[] selectFields) {
        return this.vdbClient.query(collectionName, limit, offset, selectFields);
    }

    public CollectionData query(QueryParameters parameters) {
        return this.vdbClient.query(parameters);
    }

    public void createCollection(CollectionMeta collectionMeta) {
        boolean existsCollection = this.vdbClient.existsCollection(collectionMeta.getName());
        if (!existsCollection) {
            CollectionMeta existingCollectionMeta;
            this.vdbClient.createCollection(collectionMeta);
            int count = 0;
            while ((existingCollectionMeta = this.vdbClient.queryMeta(collectionMeta.getName())) == null) {
                if (++count > 20) {
                    throw new RuntimeException("collection create failed.");
                }
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            CollectionMeta existingCollectionMeta = this.vdbClient.queryMeta(collectionMeta.getName());
            List<FieldMeta> list = this.findNewFields(collectionMeta, existingCollectionMeta);
            if (!list.isEmpty()) {
                this.vdbClient.appendFields(collectionMeta.getName(), list.toArray(new FieldMeta[0]));
            }
        }
    }

    private List<FieldMeta> findNewFields(CollectionMeta collectionMeta, CollectionMeta existingCollectionMeta) {
        if (collectionMeta == null || existingCollectionMeta == null) {
            return new ArrayList<FieldMeta>();
        }
        FieldMeta[] fields = collectionMeta.getFields();
        if (fields == null) {
            return new ArrayList<FieldMeta>();
        }
        FieldMeta[] existingFields = existingCollectionMeta.getFields();
        if (existingFields == null) {
            return new ArrayList<FieldMeta>();
        }
        HashSet existNames = new HashSet(Arrays.asList(existingFields).stream().map(FieldMeta::getName).collect(Collectors.toList()));
        ArrayList<FieldMeta> list = new ArrayList<FieldMeta>(Math.max(0, fields.length - existNames.size()));
        Arrays.stream(fields).filter(field -> !existNames.contains(field.getName())).forEach(list::add);
        return list;
    }

    public void dropCollection(String collectionName) {
        this.vdbClient.dropCollection(collectionName);
    }

    public boolean existsCollection(String collectionName) {
        return this.vdbClient.existsCollection(collectionName);
    }

    public long count(String collectionName) {
        return this.vdbClient.count(collectionName);
    }

    public void close() throws Exception {
        if (this.vdbClient != null) {
            this.vdbClient.close();
        }
        mapFeatures.remove(new String[0]);
    }

    public int getDimension() {
        return this.dimension;
    }

    public void setDimension(int dimension) {
        this.dimension = dimension;
    }

    public String getEmbeddingName() {
        return this.embeddingName;
    }

    private void validateVectorDimension(Object[][] data) {
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("Collection data cannot be empty");
        }
        Object[][] objectArray = data;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object[] row;
            for (Object field : row = objectArray[i]) {
                double[] vector;
                if (!(field instanceof double[]) || (vector = (double[])field).length == this.dimension) continue;
                throw new IllegalArgumentException(String.format("Vector dimension mismatch. Expected: %d, Found: %d", this.dimension, vector.length));
            }
        }
    }

    private void validateSearchVector(double[] vector) {
        if (vector == null) {
            throw new IllegalArgumentException("Search vector cannot be null");
        }
        if (vector.length != this.dimension) {
            throw new IllegalArgumentException(String.format("Search vector dimension mismatch. Expected: %d, Found: %d", this.dimension, vector.length));
        }
    }

    public void deleteAll(String collectionName) {
        this.vdbClient.deleteAll(collectionName);
    }

    public void delete(String collectionName, Filter filter) {
        if (this.existsCollection(collectionName)) {
            this.vdbClient.delete(collectionName, filter);
        }
    }

    private void initFeatures() {
        Set s = (Set)mapFeatures.get(CacheKeyUtil.getAcctId());
        if (s == null) {
            mapFeatures.put(CacheKeyUtil.getAcctId(), (Object)this.vdbClient.getFeatures());
        } else if (!s.contains(ServerFeatures.KEYWORD_SEARCH)) {
            mapFeatures.put(CacheKeyUtil.getAcctId(), (Object)this.vdbClient.getFeatures());
        }
    }

    public boolean supportVector() {
        try {
            this.initFeatures();
            return ((Set)mapFeatures.get(CacheKeyUtil.getAcctId())).contains(ServerFeatures.VECTOR_SEARCH);
        }
        catch (Exception ex) {
            log.warn(ex.getMessage());
            mapFeatures.clear();
            return false;
        }
    }

    public boolean supportFullText() {
        try {
            this.initFeatures();
            return ((Set)mapFeatures.get(CacheKeyUtil.getAcctId())).contains(ServerFeatures.KEYWORD_SEARCH);
        }
        catch (Exception ex) {
            log.warn(ex.getMessage());
            mapFeatures.clear();
            return false;
        }
    }
}

