/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.adapter.vectordb.vdb.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.gptas.adapter.vectordb.vdb.client.VDBClientWrapper;
import kd.bos.gptas.adapter.vectordb.vdb.service.VDBCommonCollectionService;
import kd.bos.gptas.adapter.vectordb.vdb.service.VDBService;
import kd.bos.gptas.api.km.split.SplitConfig;
import kd.bos.gptas.api.vector.VectorResult;
import kd.bos.gptas.common.VectorStorePlugin;
import kd.bos.gptas.common.vectordb.exception.VectorException;
import kd.bos.gptas.common.vectordb.model.VectorChunk;
import kd.bos.gptas.common.vectordb.model.VectorQuery;
import kd.bos.gptas.common.vectordb.service.KnowledgeVectorStoreService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.Pair;

public class VDBServiceProxy
extends KnowledgeVectorStoreService {
    private static final Log log = LogFactory.getLog(VDBServiceProxy.class);
    private final Map<String, VDBService> vdbServiceByFormId = new ConcurrentHashMap<String, VDBService>();
    private final VDBClientWrapper vdbClient;
    private List<VectorStorePlugin> vectorStorePluginList = new ArrayList<VectorStorePlugin>(16);

    public VDBServiceProxy(VDBClientWrapper vdbClient) {
        this.vdbClient = vdbClient;
    }

    public void setVectorStorePlugin(List<VectorStorePlugin> vectorStorePluginList) {
        this.vectorStorePluginList = vectorStorePluginList;
    }

    protected boolean enableVector(String entityId) {
        boolean enable = false;
        for (VectorStorePlugin vectorStorePlugin : this.vectorStorePluginList) {
            SplitConfig splitConfig = vectorStorePlugin.getSplitConfig(entityId);
            enable = splitConfig.isEnableVector();
        }
        return enable;
    }

    protected boolean enableFullText(String entityId) {
        boolean enable = false;
        for (VectorStorePlugin vectorStorePlugin : this.vectorStorePluginList) {
            SplitConfig splitConfig = vectorStorePlugin.getSplitConfig(entityId);
            enable = splitConfig.isEnableFullText();
        }
        return enable;
    }

    public VDBService initialize(String entityId) throws VectorException {
        log.info("Initializing new VDBService for formId: {}", (Object)Objects.toString(entityId, "NULL"));
        try {
            VDBService vdbService = this.vdbClient.existsCollection(this.generateCollectionName(entityId)) ? new VDBService(this.vdbClient, entityId) : new VDBCommonCollectionService(this.vdbClient, entityId);
            vdbService.initialize();
            log.info("Successfully initialized VDBService for formId: {} . VDBService:{}", (Object)entityId, (Object)((Object)((Object)vdbService)).getClass().getName());
            return vdbService;
        }
        catch (Exception e) {
            log.error("Failed to initialize VDBService for formId: " + entityId, (Throwable)e);
            throw e;
        }
    }

    private String generateCollectionName(String entityId) {
        String accountId = RequestContext.get().getAccountId();
        return String.format("KM_%s_%s_%s", accountId, entityId, this.vdbClient.getEmbeddingName());
    }

    private VDBService getVDBService(String entityId) {
        VDBService vdbService = this.vdbServiceByFormId.get(entityId);
        if (vdbService == null) {
            vdbService = this.initialize(entityId);
            this.vdbServiceByFormId.put(entityId, vdbService);
        }
        vdbService.setVectorStorePlugin(this.vectorStorePluginList);
        return vdbService;
    }

    public List<VectorResult> doSearch(VectorQuery vectorQuery) throws VectorException {
        List entityIds = vectorQuery.getRepositoryIds();
        log.debug("Performing vector search across {} forms, topK: {}", (Object)entityIds.size(), (Object)vectorQuery.getTopK());
        int topK = vectorQuery.getTopK() * ((this.enableVector((String)entityIds.get(0)) ? 1 : 0) + (this.enableFullText((String)entityIds.get(0)) ? 1 : 0));
        List<VectorResult> result = entityIds.stream().flatMap(entityId -> {
            VDBService vdbService = this.getVDBService((String)entityId);
            List<VectorResult> list = vdbService.doSearch(vectorQuery);
            return list.stream();
        }).sorted(Comparator.comparingDouble(VectorResult::getScore)).limit(topK).collect(Collectors.toList());
        log.info("Search completed, found {} results across {} forms", (Object)result.size(), (Object)entityIds.size());
        return result;
    }

    public boolean doStore(VectorChunk vectorChunk) throws VectorException {
        String entityId = vectorChunk.getChunk().getEntityId();
        log.debug("Storing single vector chunk for entityId: {}, chunkId: {}", (Object)entityId, (Object)vectorChunk.getChunk().getId());
        VDBService vdbService = this.getVDBService(entityId);
        boolean result = vdbService.store(vectorChunk);
        log.info("Vector chunk storage completed for entityId: {}, chunkId: {}, success: {}", new Object[]{entityId, vectorChunk.getChunk().getId(), result});
        return result;
    }

    public Pair<List<VectorChunk>, List<VectorChunk>> doBatchStore(List<VectorChunk> vectorChunks) throws VectorException {
        log.debug("Starting batch store operation for {} chunks", (Object)vectorChunks.size());
        ArrayList successVectorChunks = new ArrayList();
        ArrayList failedVectorChunks = new ArrayList();
        LinkedHashMap<String, List> vectorChunksGroup = new LinkedHashMap<String, List>();
        for (VectorChunk vectorChunk : vectorChunks) {
            String formId = vectorChunk.getChunk().getEntityId();
            vectorChunksGroup.computeIfAbsent(formId, s -> new ArrayList()).add(vectorChunk);
        }
        log.debug("Grouped chunks into {} forms for batch storage", (Object)vectorChunksGroup.size());
        for (Map.Entry entry : vectorChunksGroup.entrySet()) {
            try {
                log.debug("Processing batch for formId: {}, chunks: {}", entry.getKey(), (Object)((List)entry.getValue()).size());
                VDBService vdbService = this.getVDBService((String)entry.getKey());
                Pair pair = vdbService.batchStore((List)entry.getValue());
                successVectorChunks.addAll((Collection)pair.getKey());
                failedVectorChunks.addAll((Collection)pair.getValue());
            }
            catch (VectorException e) {
                log.error("Batch storage failed for formId: " + (String)entry.getKey(), (Throwable)e);
                failedVectorChunks.addAll((Collection)entry.getValue());
            }
        }
        log.info("Batch store completed. Success: {}, Failed: {}", (Object)successVectorChunks.size(), (Object)failedVectorChunks.size());
        return new Pair(successVectorChunks, failedVectorChunks);
    }

    public void delete(String entityId, List<Long> chunkIds) throws VectorException {
        log.debug("Deleting {} chunks from entityId: {}", (Object)chunkIds.size(), (Object)entityId);
        VDBService vdbService = this.getVDBService(entityId);
        vdbService.delete(entityId, chunkIds);
    }

    public Map<String, List<?>> query(String entityId, List<Long> knowledgeIds, long start, long limit) {
        VDBService vdbService = this.getVDBService(entityId);
        return vdbService.query(entityId, knowledgeIds, start, limit);
    }

    public void close() {
        for (VDBService vdbService : this.vdbServiceByFormId.values()) {
            vdbService.close();
        }
    }

    public void deleteAll(String entityId) {
        VDBService vdbService = this.getVDBService(entityId);
        vdbService.deleteAll(entityId);
    }

    public boolean supportFullText() {
        return this.vdbClient.supportFullText();
    }

    public boolean supportVector() {
        return this.vdbClient.supportVector();
    }
}

