/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.servicehelper;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.gptas.adapter.llm.kdai.model.KDAIOpenAPIResponse;
import kd.bos.gptas.openapi.OpenApiClient;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class AIServiceProxy {
    private static final Log logger = LogFactory.getLog(AIServiceProxy.class);
    private static final OpenApiClient openApiClient = OpenApiClient.builder().configFile("openapi.properties").build();

    public static String invokePromptService(Object promptNumber, String input) {
        boolean status;
        Map ret = (Map)AIServiceProxyEnum.PromptService_Sync.invoke(promptNumber, input, new HashMap());
        boolean bl = status = ret.get("status") != null && (Boolean)ret.get("status") != false;
        if (status) {
            Map dataMap = (Map)ret.get("data");
            return (String)dataMap.get("llmValue");
        }
        throw new RuntimeException((String)ret.get("errMsg"));
    }

    public static String invokePromptService(Object promptNumber, String input, String chatSessionId) {
        Map ret;
        boolean status;
        HashMap<String, String> map = new HashMap<String, String>(16);
        if (!StringUtils.isEmpty((CharSequence)chatSessionId)) {
            map.put("chatSessionId", chatSessionId);
        }
        boolean bl = status = (ret = (Map)AIServiceProxyEnum.PromptService_Sync.invoke(promptNumber, input, map)).get("status") != null && (Boolean)ret.get("status") != false;
        if (status) {
            Map dataMap = (Map)ret.get("data");
            return (String)dataMap.get("llmValue");
        }
        throw new RuntimeException((String)ret.get("errMsg"));
    }

    public static Map<String, Object> invokePromptServiceAsync(Map<String, String> callBackInfo, boolean isStream, String promptNumber, String input, Map<String, String> varParams) {
        return (Map)AIServiceProxyEnum.PromptService_Async.invoke(callBackInfo, isStream, promptNumber, input, new HashMap());
    }

    public static Map<String, String> invokeAICCService(Map<String, String> context, String serviceNumber, String paramStr) {
        return (Map)AIServiceProxyEnum.AICCService_Sync.invoke(context, serviceNumber, paramStr);
    }

    public static Object invokeAICCServiceMethod(String serviceNumber, String methodName, Object ... params) {
        boolean isLocalMode = Boolean.parseBoolean(System.getProperty("gpt.local.enable", "false"));
        if (isLocalMode) {
            HashMap<String, Object> apiParams = new HashMap<String, Object>(16);
            apiParams.put("appId", "aicc");
            apiParams.put("serviceName", serviceNumber);
            apiParams.put("methodName", methodName);
            apiParams.put("params", params);
            JsonObject jsonObject = openApiClient.requestPost("kapi/v2/logm/tcsd/gpt_ai_proxy", SerializationUtils.toJsonString(apiParams));
            if (jsonObject != null) {
                JsonElement data = jsonObject.get("data");
                if (data.isJsonArray()) {
                    JsonArray arrayData = jsonObject.getAsJsonArray("data");
                    return SerializationUtils.fromJsonString((String)arrayData.toString(), List.class);
                }
                JsonObject jsonData = jsonObject.getAsJsonObject("data");
                return SerializationUtils.fromJsonString((String)jsonData.toString(), Map.class);
            }
        }
        return DispatchServiceHelper.invokeBizService((String)"ai", (String)"aicc", (String)serviceNumber, (String)methodName, (Object[])params);
    }

    private static enum AIServiceProxyEnum {
        PromptService_Sync("gai", "GaiPromptService", "syncCall"){

            @Override
            protected Object invokeService(Object ... params) {
                Object number = params[0];
                QFilter[] qFilters = new QFilter[]{new QFilter("number", "=", number)};
                Map prompt = BusinessDataReader.loadFromCache((String)"gai_prompt", (QFilter[])qFilters);
                Optional first = prompt.values().stream().findFirst();
                if (!first.isPresent()) {
                    throw new RuntimeException("prompt not exists. number:=" + number);
                }
                params[0] = ((DynamicObject)first.get()).get("id");
                return super.invokeService(params);
            }

            @Override
            protected Object invokeLocal(Object ... params) {
                Object number = params[0];
                String input = (String)params[1];
                Map blank_params = new HashMap(16);
                if (params.length >= 3) {
                    blank_params = (Map)params[2];
                }
                HashMap<String, Object> apiParams = new HashMap<String, Object>(16);
                apiParams.put("stream", Boolean.FALSE);
                apiParams.put("promptNumber", number);
                apiParams.put("input", input);
                apiParams.put("varParams", blank_params);
                JsonObject result = openApiClient.requestPost("/kapi/v2/gai/prompt/syncCall", SerializationUtils.toJsonString(apiParams));
                String errCode = result.get("errCode").getAsString();
                boolean status = result.get("status").getAsBoolean();
                HashMap<String, Object> resp = new HashMap<String, Object>(4);
                if (!errCode.equals("0") || !status) {
                    resp.put("errCode", errCode);
                    JsonElement msg = result.get("errMsg") == null ? result.get("message") : result.get("errMsg");
                    resp.put("errMsg", msg.getAsString());
                    resp.put("status", Boolean.FALSE);
                } else {
                    resp.put("errCode", "0");
                    resp.put("errMsg", "");
                    resp.put("status", Boolean.TRUE);
                    HashMap<String, String> data = new HashMap<String, String>(16);
                    data.put("llmValue", result.getAsJsonObject("data").get("llmValue").getAsString());
                    resp.put("data", data);
                }
                return resp;
            }
        }
        ,
        PromptService_Async("gai", "GaiPromptService", "asyncCall"){

            @Override
            protected Object invokeService(Object ... params) {
                Object number = params[2];
                QFilter[] qFilters = new QFilter[]{new QFilter("number", "=", number)};
                Map prompt = BusinessDataReader.loadFromCache((String)"gai_prompt", (QFilter[])qFilters);
                Optional first = prompt.values().stream().findFirst();
                if (!first.isPresent()) {
                    throw new RuntimeException("prompt not exists. number:=" + number);
                }
                params[2] = ((DynamicObject)first.get()).get("id");
                return super.invokeService(params);
            }

            @Override
            protected Object invokeLocal(Object ... params) {
                Map callBackInfo = (Map)params[0];
                String taskId = ID.genStringId();
                String cloudId = (String)callBackInfo.get("cloudId");
                String appId = (String)callBackInfo.get("appId");
                String method = (String)callBackInfo.get("methodName");
                String serviceName = (String)callBackInfo.get("serviceName");
                HashMap response = new HashMap(16);
                ThreadPools.executeOnce((String)"GaiPromptServiceFake.asyncCall", () -> {
                    String promptNumber = params[2] == null ? "gptas-default" : (String)params[2];
                    HashMap<String, Object> apiParams = new HashMap<String, Object>(16);
                    apiParams.put("stream", Boolean.FALSE);
                    apiParams.put("promptNumber", promptNumber);
                    apiParams.put("input", params[3]);
                    apiParams.put("varParams", params.length > 4 ? params[4] : new HashMap());
                    JsonObject jsonObject = openApiClient.requestPost("/kapi/v2/gai/prompt/syncCall", SerializationUtils.toJsonString(apiParams));
                    KDAIOpenAPIResponse aiResponse = KDAIOpenAPIResponse.convert(jsonObject);
                    String llmValue = aiResponse.getData().getLlmValue();
                    logger.info("local api async, result: {}", (Object)llmValue);
                    int step = llmValue.length() / 20 + 1;
                    for (int i = 0; i < llmValue.length(); i += step) {
                        HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
                        dataMap.put("taskId", taskId);
                        dataMap.put("errMsg", "");
                        int to = i + step;
                        if (to > llmValue.length()) {
                            to = llmValue.length();
                        }
                        dataMap.put("llmValue", llmValue.substring(i, to));
                        dataMap.put("isEnd", to == llmValue.length());
                        dataMap.put("status", true);
                        response.put("data", dataMap);
                        response.put("status", true);
                        if (cloudId.equals("bos")) {
                            DispatchServiceHelper.invokeBOSService((String)appId, (String)serviceName, (String)method, (Object[])new Object[]{response});
                        } else {
                            DispatchServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)method, (Object[])new Object[]{response});
                        }
                        try {
                            Thread.sleep(100L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
                HashMap<String, Object> resp = new HashMap<String, Object>(4);
                resp.put("errCode", "0");
                resp.put("errMsg", "");
                resp.put("status", Boolean.TRUE);
                HashMap<String, String> data = new HashMap<String, String>(16);
                data.put("task_id", taskId);
                resp.put("data", data);
                return resp;
            }
        }
        ,
        AICCService_Sync("aicc", "AiccService", "syncService"){

            @Override
            protected Object invokeLocal(Object ... params) {
                String index_method = (String)params[1];
                String paramsStr = (String)params[2];
                HashMap<String, String> apiParams = new HashMap<String, String>(16);
                apiParams.put("indexmethod", index_method);
                apiParams.put("text", paramsStr);
                JsonObject jsonObject = openApiClient.requestPost("/kapi/v2/logm/logm_gai_ext/gptas_synccall", SerializationUtils.toJsonString(apiParams));
                HashMap<String, String> map = new HashMap<String, String>(16);
                JsonObject data = jsonObject.getAsJsonObject("data").getAsJsonObject("result");
                for (String key : data.keySet()) {
                    map.put(key, data.get(key).getAsString());
                }
                return map;
            }
        };

        private final String appId;
        private final String methodName;
        private final String serviceName;

        private AIServiceProxyEnum(String appId, String serviceName, String methodName) {
            this.serviceName = serviceName;
            this.appId = appId;
            this.methodName = methodName;
        }

        private boolean isLocalMode() {
            return Boolean.parseBoolean(System.getProperty("gpt.local.enable", "false"));
        }

        protected abstract Object invokeLocal(Object ... var1);

        protected Object invokeService(Object ... params) {
            return DispatchServiceHelper.invokeBizService((String)"ai", (String)this.appId, (String)this.serviceName, (String)this.methodName, (Object[])params);
        }

        public Object invoke(Object ... params) {
            if (this.isLocalMode()) {
                return this.invokeLocal(params);
            }
            return this.invokeService(params);
        }
    }
}

