/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.qa.assistant;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.gpt.api.DevAssistantService;
import kd.bos.gptas.api.LLMService;
import kd.bos.gptas.api.VectorService;
import kd.bos.gptas.api.llm.MessageStream;
import kd.bos.gptas.api.vector.EmbeddingModel;
import kd.bos.gptas.api.vector.VectorResult;
import kd.bos.gptas.qa.model.QAPrompt;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;

public class DevAssistantServiceImpl
implements DevAssistantService {
    private static Log logger = LogFactory.getLog(DevAssistantServiceImpl.class);
    private static final String KNOWLEDGE_ENTITYID = "cosmicintelliqa";

    public Object process(String assistantNumber, String userInput) {
        AssistantEnum assistantEnum = AssistantEnum.getEnumByNumberOrThrow(assistantNumber);
        if (assistantEnum.enableKnowledge) {
            return this.llmWithKnl(assistantEnum.getPromptTemplatePath(), userInput);
        }
        return this.llm(assistantEnum.getPromptTemplatePath(), userInput);
    }

    private MessageStream llm(String promptTemplate, String question) {
        String prompt = QAPrompt.getPromptTemplateFromFile("prompt/" + promptTemplate).replace("{{question}}", question);
        return LLMService.create().llm(prompt, null);
    }

    private MessageStream llmWithKnl(String promptTemplate, String question) {
        VectorService vectorService = VectorService.create((EmbeddingModel)this.getEmbeddingModel());
        List vectorResults = vectorService.search(Collections.singletonList(KNOWLEDGE_ENTITYID), question, 5);
        ArrayList list = new ArrayList(16);
        for (VectorResult vectorResult : vectorResults) {
            HashMap<String, String> map = new HashMap<String, String>(16);
            map.put("doc_id", vectorResult.getChunk().getEntityId() + "_" + vectorResult.getChunk().getId());
            map.put("content", vectorResult.getChunk().getContent());
            list.add(map);
        }
        String chunks = SerializationUtils.toJsonString(list) + "\n";
        String prompt = QAPrompt.getPromptTemplateFromFile("prompt/" + promptTemplate).replace("{{question}}", question).replace("{{chunks}}", chunks);
        return LLMService.create().llm(prompt, null);
    }

    private EmbeddingModel getEmbeddingModel() {
        QFilter qFilter = new QFilter("kmformid.number", "=", (Object)KNOWLEDGE_ENTITYID);
        QFilter[] qFilterList = new QFilter[]{qFilter};
        Map corpusLibs = BusinessDataReader.loadFromCache((String)"bos_knl_kmconfig", (QFilter[])qFilterList);
        if (corpusLibs.isEmpty()) {
            return null;
        }
        DynamicObject row = (DynamicObject)corpusLibs.values().iterator().next();
        return Enum.valueOf(EmbeddingModel.class, row.getString("indexmethod"));
    }

    private static enum AssistantEnum {
        Dev_QA("Dev QA", "DevQA.md", true),
        Code_Explain("Code Explain", "kingscript/CodeExplain.md", false),
        Code_Gen("Code Gen", "kingscript/CodeGen-FirstPrompt.md", true),
        Code_Optimize("Code Optimize", "kingscript/CodeOptimize.md", false),
        Comment_Gen("Comment Gen", "kingscript/CommentGen.md", false),
        Code_Explain_Java("Code Explain For Java", "java/CodeExplain.md", false),
        Code_Gen_Java("Code Gen For Java", "java/CodeGen-FirstPrompt.md", true),
        Code_Optimize_Java("Code Optimize For Java", "java/CodeOptimize.md", false),
        Comment_Gen_Java("Comment Gen For Java", "java/CommentGen.md", false),
        TestCode_Gen_For_Java("TestCode Gen For Java", "java/CommentGen.md", false);

        private String number;
        private String promptTemplatePath;
        private boolean enableKnowledge;

        private AssistantEnum(String number, String promptTemplatePath, boolean enableKnowledge) {
            this.number = number;
            this.promptTemplatePath = promptTemplatePath;
            this.enableKnowledge = enableKnowledge;
        }

        public static AssistantEnum getEnumByNumber(String number) {
            if (number == null || number.trim().isEmpty()) {
                return null;
            }
            for (AssistantEnum value : AssistantEnum.values()) {
                if (!value.getNumber().equals(number)) continue;
                return value;
            }
            return null;
        }

        public static AssistantEnum getEnumByNumberOrThrow(String number) {
            AssistantEnum assistantEnum = AssistantEnum.getEnumByNumber(number);
            if (assistantEnum == null) {
                throw new IllegalArgumentException("No enum constant with number: " + number);
            }
            return assistantEnum;
        }

        public String getNumber() {
            return this.number;
        }

        public String getPromptTemplatePath() {
            return this.promptTemplatePath;
        }
    }
}

