/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.qa.batchrun;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.bill.BillShowParameter;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.BeforeAttachmentUploadEvent;
import kd.bos.form.control.events.BeforeAttachmentUploadListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeBindDataEvent;
import kd.bos.form.events.BeforeBindDataListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.gptas.qa.batchrun.BatchRunnerUtil;
import kd.bos.gptas.qa.batchrun.RunnerTask;
import kd.bos.gptas.qa.batchrun.runner.RunnerData;
import kd.bos.id.ID;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.column.ListOperationColumnDesc;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class KMBatchTestFormPlugin
extends AbstractFormPlugin
implements UploadListener,
BeforeAttachmentUploadListener,
BeforeBindDataListener {
    private static final String BOS_GTPAS_QA = "bos-gptas-qa";
    public static final String TASKCLOSED = "taskclosed";
    public static final String TASKINFO = "taskinfo";
    private static final String LANGUAGE_MODEL = "languagemodel";
    private static final String RUN_STATUS = "runstatus";
    private static final String PROMPT_TEMPLATE = "prompttemplate";
    private static final String PROCESS = "process";
    private static final String JOBID = "jobid";
    private static final String AIKM_EVALUATIONBILL = "aikm_evaluationbill";
    private static final String AIKM_EVALUATIONBILL_DETAIL = "aikm_evalbilldetaillayout";
    private static final String AIKM_EVALUATIONBILL_ENTRYENTITY = "entryentity";
    private static final String BILLLIST_COLUMN_LLM_NAME = "llmname";
    private static List<ComboItem> comboItems;
    private static String[] arrStatus;

    public void initialize() {
        super.initialize();
        if (comboItems == null || comboItems.size() == 0) {
            comboItems = BatchRunnerUtil.createLlmComboItem();
        }
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addBeforeBindDataListener((BeforeBindDataListener)this);
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        comboItems.clear();
    }

    public void beforeAttachmentUpload(BeforeAttachmentUploadEvent beforeAttachmentUploadEvent) {
        this.getView().getPageCache().remove("dataurl");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        AttachmentPanel attachmentpanelap = (AttachmentPanel)this.getControl("attachmentpanelap");
        attachmentpanelap.addUploadListener((UploadListener)this);
        attachmentpanelap.addBeforeUploadListener((BeforeAttachmentUploadListener)this);
        BasedataEdit processEdit = (BasedataEdit)this.getControl(PROCESS);
        processEdit.addBeforeF7SelectListener(evt -> ((ListShowParameter)evt.getFormShowParameter()).setShowApproved(false));
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addHyperClickListener(efvt -> {
            if (efvt.getFieldName().equals("billno")) {
                ListSelectedRow currentSelectedRowInfo = billList.getCurrentSelectedRowInfo();
                Object id = currentSelectedRowInfo.getPrimaryKeyValue();
                BillShowParameter billShowParameter = new BillShowParameter();
                billShowParameter.setPkId(id);
                billShowParameter.setFormId(AIKM_EVALUATIONBILL_DETAIL);
                billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                String pageIdTag = AIKM_EVALUATIONBILL_DETAIL + id;
                String pageId = this.getPageCache().get(pageIdTag);
                if (StringUtils.isNotEmpty((CharSequence)pageId)) {
                    billShowParameter.setPageId(pageId);
                }
                this.getPageCache().put(pageIdTag, billShowParameter.getPageId());
                this.getView().showForm((FormShowParameter)billShowParameter);
            }
        });
    }

    public void beforeBindData(BeforeBindDataEvent beforeBindDataEvent) {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addPackageDataListener(e -> {
            Object source = e.getSource();
            DynamicObject rowData = e.getRowData();
            if (source instanceof ListOperationColumnDesc && rowData.getString(RUN_STATUS).equals("B")) {
                List operationColItems;
                Object id = rowData.getPkValue();
                MainEntityType type = EntityMetadataCache.getDataEntityType((String)AIKM_EVALUATIONBILL);
                DynamicObject dynamicObject = BusinessDataReader.loadSingle((Object)id, (DynamicObjectType)type);
                DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection(AIKM_EVALUATIONBILL_ENTRYENTITY);
                boolean showContinue = false;
                for (DynamicObject entity : entryentity) {
                    String answer = entity.getString("a_tag");
                    String reason = entity.getString("reason");
                    if (!StringUtils.isEmpty((CharSequence)answer) && !StringUtils.isEmpty((CharSequence)reason)) continue;
                    showContinue = true;
                    break;
                }
                if (!showContinue && (operationColItems = (List)e.getFormatValue()).size() >= 2) {
                    ((OperationColItem)operationColItems.get(1)).setVisible(false);
                }
            }
        });
        billList.addCreateListDataProviderListener(providerArgs -> providerArgs.setListDataProvider((IListDataProvider)new PropertyProvider()));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ComboEdit languageModel = (ComboEdit)this.getView().getControl(LANGUAGE_MODEL);
        languageModel.setComboItems(comboItems);
    }

    public void upload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        if (urls != null && urls.length > 0) {
            this.getView().getPageCache().put("dataurl", SerializationUtils.toJsonString((Object)urls[0]));
        }
    }

    public void remove(UploadEvent evt) {
        this.getView().getPageCache().remove("dataurl");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (operate.getOperateKey().equals("run")) {
            this.runTask();
        } else if (operate.getOperateKey().equals("deletelist")) {
            this.deleteList();
        } else if (operate.getOperateKey().equals("downloadtemplate")) {
            this.downloadTemplate();
        } else if (operate.getOperateKey().equals("editprompt")) {
            this.editPrompt();
        } else if (operate.getOperateKey().equals("continue")) {
            this.continueTask();
        }
    }

    private void editPrompt() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("aikm_evaluationeditprompt");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        String promptTemplate = this.getModel().getValue(PROMPT_TEMPLATE).toString();
        long skillId = 0L;
        DynamicObject skill = (DynamicObject)this.getModel().getValue(PROCESS);
        if (skill != null) {
            skillId = skill.getLong("id");
        }
        formShowParameter.setCustomParam("processId", (Object)skillId);
        formShowParameter.setCustomParam("promptTemplate", (Object)promptTemplate);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, PROMPT_TEMPLATE));
        this.getView().showForm(formShowParameter);
    }

    private void continueTask() {
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u8bc4\u6d4b\u8be5\u4efb\u52a1\uff1f", (String)"KMEvaluationDetailFormPlugin_11", (String)BOS_GTPAS_QA, (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Delete, new ConfirmCallBackListener("continueTask", (IFormPlugin)this));
    }

    private void downloadTemplate() {
        LinkedHashMap<String, String> fixHeader = new LinkedHashMap<String, String>(16);
        fixHeader.put("batchId", ResManager.loadKDString((String)"\u4f1a\u8bddID", (String)"KMEvaluationDetailFormPlugin_10", (String)BOS_GTPAS_QA, (Object[])new Object[0]));
        fixHeader.put("seq", ResManager.loadKDString((String)"\u95ee\u9898", (String)"KMEvaluationDetailFormPlugin_2", (String)BOS_GTPAS_QA, (Object[])new Object[0]));
        fixHeader.put("score", ResManager.loadKDString((String)"\u6807\u51c6\u7b54\u6848", (String)"KMEvaluationDetailFormPlugin_3", (String)BOS_GTPAS_QA, (Object[])new Object[0]));
        Object[] headers = Arrays.copyOf(fixHeader.values().toArray(new String[0]), fixHeader.size());
        Object[][] data = new Object[][]{};
        byte[] datas = BatchRunnerUtil.writeFile(headers, data);
        CacheFactory commonCacheFactory = CacheFactory.getCommonCacheFactory();
        TempFileCache tempFileCache = commonCacheFactory.getTempFileCache();
        String url = tempFileCache.saveAsFullUrl("template.xlsx", datas, 60);
        this.getView().openUrl(url);
    }

    private void deleteList() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRow currentSelectedRowInfo = billList.getCurrentSelectedRowInfo();
        if (currentSelectedRowInfo == null) {
            this.getView().showTipNotification("\u8bf7\u9009\u62e9\u884c\u3002");
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684\u6d4b\u8bc4\u4efb\u52a1\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u662f\u5426\u786e\u8ba4\u5220\u9664\uff1f", (String)"KMBatchTestFormPlugin_0", (String)BOS_GTPAS_QA, (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Delete, new ConfirmCallBackListener("deletelist", (IFormPlugin)this));
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        MessageBoxResult result;
        BillList billList = (BillList)this.getControl("billlistap");
        String callBackId = evt.getCallBackId();
        if (callBackId.equals("deletelist")) {
            MessageBoxResult result2 = evt.getResult();
            if (result2 == MessageBoxResult.Yes) {
                ListSelectedRow currentSelectedRowInfo = billList.getCurrentSelectedRowInfo();
                Object id = currentSelectedRowInfo.getPrimaryKeyValue();
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)AIKM_EVALUATIONBILL);
                DeleteServiceHelper.delete((IDataEntityType)dataEntityType, (Object[])new Object[]{id});
                billList.clearSelection();
                billList.refresh();
            }
        } else if (callBackId.equals("continueTask") && (result = evt.getResult()) == MessageBoxResult.Yes) {
            ListSelectedRow currentSelectedRowInfo = billList.getCurrentSelectedRowInfo();
            Object id = currentSelectedRowInfo.getPrimaryKeyValue();
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)AIKM_EVALUATIONBILL);
            DynamicObject dynamicObject = BusinessDataReader.loadSingle((Object)id, (DynamicObjectType)type);
            DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection(AIKM_EVALUATIONBILL_ENTRYENTITY);
            ArrayList<List<RunnerData>> listRunnerDatas = new ArrayList<List<RunnerData>>();
            HashMap<String, ArrayList<RunnerData>> map = new HashMap<String, ArrayList<RunnerData>>();
            for (int i = 0; i < entryentity.size(); ++i) {
                ArrayList<RunnerData> listBatch;
                DynamicObject entry = (DynamicObject)entryentity.get(i);
                String question = entry.getString("q");
                String answer = entry.getString("a_tag");
                String reason = entry.getString("reason");
                String batchId = entry.getString("batchid");
                int seq = entry.getInt("seq");
                String baseaTag = entry.getString("basea_tag");
                String chatSessionId = entry.getString("chatSessionId");
                String chatTraceId = entry.getString("chattraceid");
                RunnerData runnerData = new RunnerData();
                runnerData.setQ(question);
                runnerData.setExpectA(baseaTag);
                runnerData.setSeq(seq);
                runnerData.setBatchId(batchId);
                runnerData.setChatTraceId(chatTraceId);
                runnerData.setChatSessionId(chatSessionId);
                if (StringUtils.isNotEmpty((CharSequence)answer) && StringUtils.isNotEmpty((CharSequence)reason)) {
                    runnerData.setFinish(true);
                }
                if ((listBatch = (ArrayList<RunnerData>)map.get(batchId)) == null) {
                    listBatch = new ArrayList<RunnerData>();
                    map.put(batchId, listBatch);
                }
                listBatch.add(runnerData);
            }
            listRunnerDatas.addAll(map.values());
            String llmModelId = dynamicObject.getString(LANGUAGE_MODEL);
            String prompttemplate = dynamicObject.getString(PROMPT_TEMPLATE);
            long skillId = (Long)((DynamicObject)dynamicObject.get(PROCESS)).getPkValue();
            RunnerTask.startTask(this, TASKCLOSED, String.valueOf(id), skillId, listRunnerDatas, llmModelId, prompttemplate);
        }
    }

    private void runTask() {
        StringBuilder sbError;
        int questionMaxLength;
        String name;
        Map urlMap;
        String fileUrl;
        List<List<RunnerData>> listRunnerDatas;
        DynamicObject skill = (DynamicObject)this.getModel().getValue(PROCESS);
        if (skill == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4efb\u52a1\u6d41\u3002", (String)"KMBatchTestFormPlugin_1", (String)BOS_GTPAS_QA, (Object[])new Object[0]));
            return;
        }
        String url = this.getPageCache().get("dataurl");
        if (url == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8bc4\u6d4b\u96c6\u3002", (String)"KMBatchTestFormPlugin_2", (String)BOS_GTPAS_QA, (Object[])new Object[0]));
            return;
        }
        String llmModelId = "";
        Object objLanguageModel = this.getModel().getValue(LANGUAGE_MODEL);
        if (objLanguageModel != null) {
            llmModelId = objLanguageModel.toString();
        }
        if ((listRunnerDatas = this.loadRunnerDataFromFile(fileUrl = (String)(urlMap = (Map)SerializationUtils.fromJsonString((String)url, Map.class)).get("url"), name = (String)urlMap.get("name"), questionMaxLength = 500, sbError = new StringBuilder())).isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5408\u9002\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"KMBatchTestFormPlugin_3", (String)BOS_GTPAS_QA, (Object[])new Object[0]));
            return;
        }
        if (!StringUtils.isEmpty((CharSequence)sbError.toString())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)String.format("\u95ee\u9898\u7684\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7%d\uff0c\u8bf7\u68c0\u67e5\u8bc4\u6d4b\u96c6\u3002", questionMaxLength), (String)"KMBatchTestFormPlugin_4", (String)BOS_GTPAS_QA, (Object[])new Object[0]));
            return;
        }
        int count = 0;
        for (List<RunnerData> listRunnerData : listRunnerDatas) {
            count += listRunnerData.size();
        }
        DynamicObject data = BusinessDataServiceHelper.newDynamicObject((String)AIKM_EVALUATIONBILL);
        data.set("desc", this.getModel().getValue("desc"));
        data.set("process_id", (Object)skill.getLong("id"));
        data.set("billstatus", (Object)"A");
        data.set("billno", (Object)("task_" + ID.genLongId()));
        data.set("type", (Object)"A");
        data.set("count", (Object)count);
        data.set("starttime", (Object)new Date());
        data.set(RUN_STATUS, (Object)"A");
        data.set(LANGUAGE_MODEL, (Object)llmModelId);
        String prompttemplate = this.getModel().getValue(PROMPT_TEMPLATE).toString();
        data.set("prompttemplate_tag", (Object)prompttemplate);
        DynamicObjectCollection entryentity = data.getDynamicObjectCollection(AIKM_EVALUATIONBILL_ENTRYENTITY);
        int i = 1;
        for (List<RunnerData> runnerDatas : listRunnerDatas) {
            for (RunnerData runnerData : runnerDatas) {
                DynamicObject entryRow = entryentity.addNew();
                entryRow.set("seq", (Object)i);
                runnerData.setSeq(i);
                entryRow.set("batchid", (Object)BatchRunnerUtil.leftSubstr(runnerData.getBatchId(), 50));
                entryRow.set("q", (Object)runnerData.getQ());
                entryRow.set("basea", (Object)BatchRunnerUtil.leftSubstr(runnerData.getExpectA(), 2000));
                entryRow.set("basea_tag", (Object)runnerData.getExpectA());
                entryRow.set("follow", (Object)Boolean.TRUE);
                ++i;
            }
        }
        Object[] ids = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{data});
        Long id = ((DynamicObject)ids[0]).getLong("id");
        BillList billList = (BillList)this.getControl("billlistap");
        billList.refresh();
        RunnerTask.startTask(this, TASKCLOSED, String.valueOf(id), skill.getLong("id"), listRunnerDatas, llmModelId, prompttemplate);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<List<RunnerData>> loadRunnerDataFromFile(String url, String name, int questionMaxLength, StringBuilder sbError) {
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        try (InputStream inputStream = tempFileCache.getInputStream(url);){
            ArrayList<List<RunnerData>> arrayList;
            Object workBook = name.endsWith("xls") ? new HSSFWorkbook(inputStream) : new XSSFWorkbook(inputStream);
            Sheet sheet = null;
            for (int i = 0; i < workBook.getNumberOfSheets(); ++i) {
                if (workBook.isSheetHidden(i) || workBook.isSheetVeryHidden(i)) continue;
                sheet = workBook.getSheetAt(i);
                break;
            }
            if (sheet == null) {
                List<List<RunnerData>> i = Collections.emptyList();
                return i;
            }
            ArrayList<List<RunnerData>> list = new ArrayList<List<RunnerData>>();
            HashMap<String, ArrayList<RunnerData>> map = new HashMap<String, ArrayList<RunnerData>>();
            DataFormatter dataFormatter = new DataFormatter();
            for (Row row : sheet) {
                if (row.getRowNum() == 0) continue;
                RunnerData qa = new RunnerData();
                if (row.getLastCellNum() == 2) {
                    String q = dataFormatter.formatCellValue(row.getCell(0));
                    String a = dataFormatter.formatCellValue(row.getCell(1));
                    if (StringUtils.isBlank((CharSequence)q) || StringUtils.isBlank((CharSequence)a)) continue;
                    if (q.length() > questionMaxLength) {
                        sbError.append(q);
                        continue;
                    }
                    qa.setQ(q);
                    qa.setExpectA(a);
                    if (list.size() == 0) {
                        ArrayList qas = new ArrayList();
                        list.add(qas);
                    }
                    ((List)list.get(0)).add(qa);
                    continue;
                }
                if (row.getLastCellNum() != 3) continue;
                String batchId = dataFormatter.formatCellValue(row.getCell(0));
                if (StringUtils.isEmpty((CharSequence)batchId)) {
                    batchId = "";
                }
                String q = dataFormatter.formatCellValue(row.getCell(1));
                String a = dataFormatter.formatCellValue(row.getCell(2));
                if (StringUtils.isBlank((CharSequence)q) || StringUtils.isBlank((CharSequence)a)) continue;
                if (q.length() > questionMaxLength) {
                    sbError.append(q);
                    continue;
                }
                qa.setBatchId(batchId);
                qa.setQ(q);
                qa.setExpectA(a);
                ArrayList<RunnerData> listBatch = (ArrayList<RunnerData>)map.get(batchId);
                if (listBatch == null) {
                    listBatch = new ArrayList<RunnerData>();
                    map.put(batchId, listBatch);
                }
                listBatch.add(qa);
            }
            workBook.close();
            list.addAll(map.values());
            if (list.isEmpty()) {
                arrayList = Collections.emptyList();
                return arrayList;
            }
            this.getView().getPageCache().put("qalist", SerializationUtils.toJsonString(list));
            arrayList = list;
            return arrayList;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Object returnData;
        super.closedCallBack(evt);
        if (evt.getActionId().equals(TASKCLOSED)) {
            BillList billList = (BillList)this.getControl("billlistap");
            billList.refresh();
            Object returnData2 = evt.getReturnData();
            if (returnData2 instanceof Map) {
                Map returnDataMap = (Map)returnData2;
                if (!returnDataMap.containsKey(TASKINFO)) {
                    return;
                }
                String taskInfoStr = (String)returnDataMap.get(TASKINFO);
                TaskInfo taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class);
                if (!taskInfo.isTaskEnd()) {
                    return;
                }
                BatchRunnerUtil.showEvaluationResult(this.getView(), taskInfo);
            }
        } else if (evt.getActionId().equals(PROMPT_TEMPLATE) && (returnData = evt.getReturnData()) != null) {
            Map map = (Map)SerializationUtils.fromJsonString((String)((String)returnData), Map.class);
            String promptTemplate = map.get(PROMPT_TEMPLATE).toString();
            this.getModel().setValue(PROMPT_TEMPLATE, (Object)promptTemplate);
        }
    }

    static {
        arrStatus = new String[]{"ABORTED", "FAILED", "TIMEOUT"};
    }

    public static class PropertyProvider
    extends ListDataProvider {
        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection rows = super.getData(start, limit);
            rows.forEach(dynamicObject -> {
                String llmId = dynamicObject.getString(KMBatchTestFormPlugin.LANGUAGE_MODEL);
                String llmName = "";
                if (!StringUtils.isBlank((CharSequence)llmId)) {
                    for (ComboItem item : comboItems) {
                        if (!item.getValue().equals(llmId)) continue;
                        llmName = item.getCaption().toString();
                        break;
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)llmName)) {
                    dynamicObject.set(KMBatchTestFormPlugin.LANGUAGE_MODEL, (Object)llmName);
                }
                if (dynamicObject.getString(KMBatchTestFormPlugin.RUN_STATUS).equals("A")) {
                    String jobId = dynamicObject.getString(KMBatchTestFormPlugin.JOBID);
                    this.updateStatus(jobId, (DynamicObject)dynamicObject);
                }
            });
            return rows;
        }

        private void updateStatus(String jobId, DynamicObject dynamicObject) {
            QFilter qFilter = new QFilter("number", "=", (Object)jobId);
            try (DataSet rows = QueryServiceHelper.queryDataSet((String)"KMBatchTestFormPlugin", (String)"sch_task", (String)"number,status", (QFilter[])new QFilter[]{qFilter}, (String)"");){
                if (rows.hasNext()) {
                    kd.bos.algo.Row row = rows.next();
                    String status = row.getString("status");
                    if (Arrays.stream(arrStatus).anyMatch(s -> s.equals(status))) {
                        DynamicObject[] dynamicObjectArray;
                        DynamicObjectType dynamicObjectType = BusinessDataServiceHelper.newDynamicObject((String)KMBatchTestFormPlugin.AIKM_EVALUATIONBILL).getDynamicObjectType();
                        Object[] pkValueArray = new Object[]{dynamicObject.getPkValue()};
                        for (DynamicObject dynamicObjectForUpdate : dynamicObjectArray = BusinessDataServiceHelper.load((Object[])pkValueArray, (DynamicObjectType)dynamicObjectType)) {
                            dynamicObjectForUpdate.set(KMBatchTestFormPlugin.RUN_STATUS, (Object)"C");
                        }
                        SaveServiceHelper.save((DynamicObject[])dynamicObjectArray);
                    }
                }
            }
        }
    }
}

