/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.qa.batchrun;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.events.LoadDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.ClientActions;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.gptas.qa.batchrun.BatchRunnerUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class KMEvaluationDetailFormPlugin
extends AbstractFormPlugin {
    private static final String BOS_GTPAS_QA = "bos-gptas-qa";
    private static final String GAI_LOG_VIEW_FORM_ID = "gai_log_view";
    private static final String AIKM_EVALUATIONTRACE = "aikm_evaluationtrace";

    public void registerListener(EventObject e) {
        EntryGrid entryentity = (EntryGrid)this.getControl("entryentity");
        entryentity.addHyperClickListener(evt -> {
            if (evt.getFieldName().equals("q")) {
                Object id = this.getModel().getValue("entryentity.id");
                FormShowParameter billShowParameter = new FormShowParameter();
                billShowParameter.setCustomParam("entryid", id);
                billShowParameter.setFormId(AIKM_EVALUATIONTRACE);
                billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                billShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "traceclose"));
                this.getView().showForm(billShowParameter);
            } else if (evt.getFieldName().equals("chattraceid")) {
                Object traceId = this.getModel().getValue("chattraceid");
                if (StringUtils.isNotBlank((Object)traceId)) {
                    String chatSessionId = this.getModel().getValue("chatsessionid").toString();
                    FormShowParameter billShowParameter = new FormShowParameter();
                    billShowParameter.setCustomParam("chatSessionId", (Object)chatSessionId);
                    billShowParameter.setCustomParam("id", (Object)Long.parseLong(traceId.toString()));
                    billShowParameter.setCustomParam("origin", (Object)"trace");
                    billShowParameter.setFormId(GAI_LOG_VIEW_FORM_ID);
                    billShowParameter.setStatus(OperationStatus.VIEW);
                    String pageIdTag = chatSessionId + traceId.toString() + "trace";
                    String pageId = this.getPageCache().get(pageIdTag);
                    if (StringUtils.isNotEmpty((CharSequence)pageId)) {
                        billShowParameter.setPageId(pageId);
                    }
                    this.getPageCache().put(pageIdTag, billShowParameter.getPageId());
                    billShowParameter.setCaption(String.format("Trace\u8be6\u60c5-%s", traceId));
                    billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    this.getView().showForm(billShowParameter);
                }
            } else if (evt.getFieldName().equals("chatsessionid")) {
                Object chatSessionId = this.getModel().getValue("chatsessionid");
                Object traceId = this.getModel().getValue("chattraceid");
                if (StringUtils.isNotBlank((Object)chatSessionId) && StringUtils.isNotBlank((Object)traceId)) {
                    FormShowParameter billShowParameter = new FormShowParameter();
                    billShowParameter.setCustomParam("chatSessionId", chatSessionId);
                    billShowParameter.setCustomParam("origin", (Object)"session");
                    billShowParameter.setFormId(GAI_LOG_VIEW_FORM_ID);
                    billShowParameter.setStatus(OperationStatus.VIEW);
                    String pageIdTag = chatSessionId + traceId.toString() + "session";
                    String pageId = this.getPageCache().get(pageIdTag);
                    if (StringUtils.isNotEmpty((CharSequence)pageId)) {
                        billShowParameter.setPageId(pageId);
                    }
                    this.getPageCache().put(pageIdTag, billShowParameter.getPageId());
                    billShowParameter.setCaption(String.format("\u4f1a\u8bdd\u8be6\u60c5-%s", chatSessionId));
                    billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    this.getView().showForm(billShowParameter);
                } else {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4f1a\u8bdd\u8be6\u60c5\u672a\u627e\u5230", (String)"KMEvaluationDetailFormPlugin_14", (String)BOS_GTPAS_QA, (Object[])new Object[0]));
                }
            }
        });
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        HashMap<String, String> imageMap = new HashMap<String, String>();
        imageMap.put("imageKey", "/kingdee/gai/images/pc/agent/avatar/common_agent.png");
        this.getView().updateControlMetadata("imageap", imageMap);
    }

    public void loadData(LoadDataEventArgs e) {
        super.loadData(e);
        this.getModel().putContextVariable("MODEL_BOSENTRYSERVERFILTERSORT", (Object)true);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setFormTitle(new LocaleString(ResManager.loadKDString((String)"\u8bc4\u6d4b\u660e\u7ec6", (String)"KMEvaluationDetailFormPlugin_9", (String)BOS_GTPAS_QA, (Object[])new Object[0])));
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        ArrayList filters = new ArrayList();
        HashMap map = new HashMap();
        ArrayList<String> listTemp = new ArrayList<String>();
        listTemp.add("follow");
        map.put("FieldName", listTemp);
        listTemp = new ArrayList();
        listTemp.add("1");
        map.put("Value", listTemp);
        listTemp = new ArrayList();
        listTemp.add("17");
        map.put("Compare", listTemp);
        filters.add(map);
        entryGrid.getGridDataByFilter(filters);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("follow".equals(name)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            Boolean follow = (Boolean)this.getModel().getValue("follow", rowIndex);
            if (follow.booleanValue()) {
                this.setGridForeColor("OrangeRed", "entryentity", rowIndex);
            } else {
                this.setGridForeColor("", "entryentity", rowIndex);
            }
            int badCaseSum = 0;
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
            for (DynamicObject row : entryentity) {
                boolean isFollow = row.getBoolean("follow");
                if (!isFollow) continue;
                ++badCaseSum;
            }
            double v = (double)(entryentity.size() - badCaseSum) / (double)entryentity.size();
            this.getModel().setValue("rate", (Object)v);
            this.getView().updateView("rate");
        }
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("isshowmessage", "false");
        this.getView().invokeOperation("save", operateOption);
    }

    private void setGridForeColor(String foreColor, String key, int ... rowIndex) {
        ClientActions.createRowStyleBuilder().setRows(rowIndex).setForeColor(foreColor).buildStyle().build().invokeControlMethod((IClientViewProxy)this.getView().getService(IClientViewProxy.class), key);
    }

    public void itemClick(ItemClickEvent evt) {
        if ("btndownload".equals(evt.getItemKey())) {
            int rowCount;
            Map<String, List<GAILog>> gaiLogData = this.getGAILogData();
            int maxStep = 0;
            for (Map.Entry<String, List<GAILog>> kv : gaiLogData.entrySet()) {
                if (maxStep >= kv.getValue().size()) continue;
                maxStep = kv.getValue().size();
            }
            LinkedHashMap<String, String> fixHeader = new LinkedHashMap<String, String>(16);
            fixHeader.put("seq", ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"KMEvaluationDetailFormPlugin_0", (String)BOS_GTPAS_QA, (Object[])new Object[0]));
            fixHeader.put("score", ResManager.loadKDString((String)"\u8bc4\u5206", (String)"KMEvaluationDetailFormPlugin_0", (String)BOS_GTPAS_QA, (Object[])new Object[0]));
            fixHeader.put("duration", ResManager.loadKDString((String)"\u7528\u65f6", (String)"KMEvaluationDetailFormPlugin_1", (String)BOS_GTPAS_QA, (Object[])new Object[0]));
            fixHeader.put("q", ResManager.loadKDString((String)"\u95ee\u9898", (String)"KMEvaluationDetailFormPlugin_2", (String)BOS_GTPAS_QA, (Object[])new Object[0]));
            fixHeader.put("basea", ResManager.loadKDString((String)"\u6807\u51c6\u7b54\u6848", (String)"KMEvaluationDetailFormPlugin_3", (String)BOS_GTPAS_QA, (Object[])new Object[0]));
            fixHeader.put("a", ResManager.loadKDString((String)"\u667a\u80fd\u4f53\u56de\u7b54", (String)"KMEvaluationDetailFormPlugin_4", (String)BOS_GTPAS_QA, (Object[])new Object[0]));
            fixHeader.put("bugtype", ResManager.loadKDString((String)"\u95ee\u9898\u7c7b\u578b", (String)"KMEvaluationDetailFormPlugin_5", (String)BOS_GTPAS_QA, (Object[])new Object[0]));
            fixHeader.put("bugdesc", ResManager.loadKDString((String)"\u95ee\u9898\u63cf\u8ff0", (String)"KMEvaluationDetailFormPlugin_6", (String)BOS_GTPAS_QA, (Object[])new Object[0]));
            Object[] headers = Arrays.copyOf(fixHeader.values().toArray(new String[0]), fixHeader.size() + maxStep * 2 + 2);
            headers[fixHeader.size()] = "ChatSessionId";
            headers[fixHeader.size() + 1] = "ChatTraceId";
            EntryGrid entryentity = (EntryGrid)this.getView().getControl("entryentity");
            int[] selectRows = entryentity.getSelectRows();
            int n = rowCount = selectRows != null && selectRows.length > 0 ? selectRows.length : this.getModel().getEntryRowCount("entryentity");
            if (selectRows == null || selectRows.length == 0) {
                selectRows = IntStream.range(0, rowCount).toArray();
            }
            Object[][] data = new Object[rowCount][];
            boolean setHerder = false;
            for (int i = 0; i < data.length; ++i) {
                Object[] rows = new Object[headers.length];
                data[i] = rows;
                int row = selectRows[i];
                int column = 0;
                for (Map.Entry kv : fixHeader.entrySet()) {
                    if (((String)kv.getKey()).equals("seq")) {
                        rows[column] = row + 1;
                    } else {
                        rows[column] = this.getModel().getValue((String)kv.getKey(), row);
                        if (((String)kv.getKey()).equals("bugtype")) {
                            ComboProp durationProp = (ComboProp)this.getModel().getProperty("bugtype");
                            List comboItems = durationProp.getComboItems();
                            for (ValueMapItem comboItem : comboItems) {
                                if (!comboItem.getValue().equals(rows[column])) continue;
                                rows[column] = comboItem.getName();
                                break;
                            }
                        }
                    }
                    ++column;
                }
                String chatSessionId = (String)this.getModel().getValue("chatsessionid", row);
                String chatTraceId = (String)this.getModel().getValue("chattraceid", row);
                rows[fixHeader.size()] = chatSessionId;
                rows[fixHeader.size() + 1] = chatTraceId;
                List<GAILog> gaiLogList = gaiLogData.get(chatTraceId);
                if (gaiLogList == null || gaiLogList.isEmpty()) continue;
                column = fixHeader.size() + 2;
                for (GAILog gaiLog : gaiLogList) {
                    if (!setHerder) {
                        String nodeName = BatchRunnerUtil.getNodeName(gaiLog.getMeta());
                        if (StringUtils.isEmpty((CharSequence)nodeName) && gaiLog == gaiLogList.get(gaiLogList.size() - 1)) {
                            headers[column] = ResManager.loadKDString((String)"\u5927\u6a21\u578b\u8bc4\u5206-\u8f93\u5165", (String)"KMEvaluationDetailFormPlugin_12", (String)BOS_GTPAS_QA, (Object[])new Object[0]);
                            headers[column + 1] = ResManager.loadKDString((String)"\u5927\u6a21\u578b\u8bc4\u5206-\u8f93\u51fa", (String)"KMEvaluationDetailFormPlugin_13", (String)BOS_GTPAS_QA, (Object[])new Object[0]);
                        } else {
                            headers[column] = String.format(ResManager.loadKDString((String)"%s-\u8f93\u5165", (String)"KMEvaluationDetailFormPlugin_7", (String)BOS_GTPAS_QA, (Object[])new Object[0]), nodeName);
                            headers[column + 1] = String.format(ResManager.loadKDString((String)"%s-\u8f93\u51fa", (String)"KMEvaluationDetailFormPlugin_8", (String)BOS_GTPAS_QA, (Object[])new Object[0]), nodeName);
                        }
                    }
                    rows[column] = gaiLog.getStepInput();
                    rows[column + 1] = gaiLog.getStepOutput();
                    column += 2;
                }
                setHerder = true;
            }
            byte[] datas = BatchRunnerUtil.writeFile(headers, data);
            CacheFactory commonCacheFactory = CacheFactory.getCommonCacheFactory();
            TempFileCache tempFileCache = commonCacheFactory.getTempFileCache();
            String url = tempFileCache.saveAsFullUrl("batchrunner.xlsx", datas, 60);
            this.getView().openUrl(url);
        }
    }

    private Map<String, List<GAILog>> getGAILogData() {
        Object[] chatTraceId = new Object[this.getModel().getEntryRowCount("entryentity")];
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryRows = dataEntity.getDynamicObjectCollection("entryentity");
        int i = 0;
        for (DynamicObject row : entryRows) {
            chatTraceId[i++] = row.getLong("chattraceid");
        }
        HashSet<String> setStepType = new HashSet<String>();
        setStepType.add("vector-retriever");
        setStepType.add("trust-layer");
        setStepType.add("prompt");
        try (DataSet rows = QueryServiceHelper.queryDataSet((String)"KMEvaluationDetailFormPlugin", (String)"gai_log", (String)"chatsessionid,traceid, entryentity.metadata_tag ,entryentity.steptype,entryentity.stepinput_tag,entryentity.stepoutput_tag", (QFilter[])new QFilter[]{new QFilter("traceid", "in", (Object)chatTraceId), new QFilter("entryentity.steptype", "not in", setStepType)}, (String)"entryentity.id");){
            HashMap<String, List> gaiLogMap = new HashMap<String, List>(16);
            for (Row row : rows) {
                GAILog gaiLog = new GAILog();
                gaiLog.setChatSessionId(row.getString("chatsessionid"));
                gaiLog.setMeta(row.getString("entryentity.metadata_tag"));
                gaiLog.setSteptype(row.getString("entryentity.steptype"));
                gaiLog.setStepInput(row.getString("entryentity.stepinput_tag"));
                gaiLog.setStepOutput(row.getString("entryentity.stepoutput_tag"));
                gaiLog.setTraceId(row.getString("traceid"));
                List gaiLogList = gaiLogMap.computeIfAbsent(gaiLog.getTraceId(), k -> new ArrayList(16));
                gaiLogList.add(gaiLog);
            }
            HashMap<String, List> hashMap = gaiLogMap;
            return hashMap;
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Object returnData;
        if (evt.getActionId().equals("traceclose") && (returnData = evt.getReturnData()) != null) {
            Map map = (Map)SerializationUtils.fromJsonString((String)((String)returnData), Map.class);
            String bugtype = (String)map.get("bugtype");
            String bugdesc = (String)map.get("bugdesc");
            int currentRow = this.getModel().getEntryCurrentRowIndex("entryentity");
            this.getModel().setValue("bugtype", (Object)bugtype, currentRow);
            this.getModel().setValue("bugdesc", (Object)bugdesc, currentRow);
        }
    }

    static class GAILog {
        private String chatSessionId;
        private String traceId;
        private Long id;
        private String meta;
        private String steptype;
        private String stepInput;
        private String stepOutput;

        GAILog() {
        }

        public String getStepOutput() {
            return this.stepOutput;
        }

        public void setStepOutput(String stepOutput) {
            this.stepOutput = stepOutput;
        }

        public String getStepInput() {
            return this.stepInput;
        }

        public void setStepInput(String stepInput) {
            this.stepInput = stepInput;
        }

        public String getSteptype() {
            return this.steptype;
        }

        public void setSteptype(String steptype) {
            this.steptype = steptype;
        }

        public String getMeta() {
            return this.meta;
        }

        public void setMeta(String meta) {
            this.meta = meta;
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getChatSessionId() {
            return this.chatSessionId;
        }

        public void setChatSessionId(String chatSessionId) {
            this.chatSessionId = chatSessionId;
        }

        public String getTraceId() {
            return this.traceId;
        }

        public void setTraceId(String traceId) {
            this.traceId = traceId;
        }
    }
}

