/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.qa.batchrun;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.BillShowParameter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;

public class KMEvaluationFinishFormPlugin
extends AbstractFormPlugin {
    private static final String BTNOK = "btnok";
    private static final String RATE = "rate";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        BigDecimal rate = (BigDecimal)this.getModel().getValue(RATE);
        if (rate.compareTo(BigDecimal.ONE) >= 0) {
            this.updateButtonName();
        }
        this.updateColor(rate);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        HashMap<String, String> imageMap = new HashMap<String, String>();
        imageMap.put("imageKey", "/kingdee/gai/images/pc/agent/avatar/common_agent.png");
        this.getView().updateControlMetadata("imageap", imageMap);
    }

    private void updateButtonName() {
        HashMap props = new HashMap();
        HashMap<String, String> item = new HashMap<String, String>();
        item.put("zh_CN", "\u67e5\u770b\u8be6\u60c5");
        props.put("text", item);
        this.getView().updateControlMetadata(BTNOK, props);
    }

    private void updateColor(BigDecimal rate) {
        HashMap<String, String> item = new HashMap<String, String>();
        if (rate.compareTo(BigDecimal.ONE) >= 0) {
            item.put("fc", "#1BA854");
        } else if (rate.compareTo(BigDecimal.valueOf(0.6)) <= 0) {
            item.put("fc", "#FF5F1F");
        } else {
            item.put("fc", "#FF991C");
        }
        this.getView().updateControlMetadata(RATE, item);
        this.getView().updateView(RATE);
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTNOK});
    }

    public void click(EventObject evt) {
        Button source = (Button)evt.getSource();
        if (BTNOK.equals(source.getKey())) {
            Object id = ((BillShowParameter)this.getView().getFormShowParameter()).getPkId();
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setPkId(id);
            billShowParameter.setFormId("aikm_evalbilldetaillayout");
            billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            billShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "closethis"));
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if ("closethis".equals(closedCallBackEvent.getActionId())) {
            this.getView().close();
        }
    }
}

