/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.qa.batchrun;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.form.control.Markdown;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.gptas.qa.batchrun.BatchRunnerUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class KMEvaluationTraceFormPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String BOS_GTPAS_QA = "bos-gptas-qa";
    private static final Pattern NodeName_Pattern = Pattern.compile("\"nodeName\":\"([^\"]*)\"");
    private static final Pattern PromptType_Pattern = Pattern.compile("\"promptType\":(-?\\d+)?");
    public static final String FIRST = "first";
    public static final String BTNBUG = "btnbug";
    public static final String GOTOTRACE = "gototrace";
    public static final String ENTRYGUIDE = "entryguide";
    public static final String NODEROW = "noderow";
    public static final String ENTRYENTITY = "entryentity";
    public static final String BUGTYPE = "bugtype";
    public static final String BUGDESC = "bugdesc";
    public static final String TASKBUGTYPE = "taskbugtype";
    public static final String TASKBUGTYPEID = "taskbugtypeid";
    public static final String TASKBUGDESC = "taskbugdesc";
    public static final String TOOLBARAP = "toolbarap";
    public static final String BUGTYPERET = "bugtyperet";
    public static final String BUGTYEDESC = "bugtyedesc";
    public static final String BUGGUIDE = "bugguide";
    public static final String NODEOUTPUT = "nodeoutput";
    public static final String NEEDNOTICE = "neednotice";
    public static final String SHOWLINE = "flexline";
    public static final String ROWTITLE = "rowtitle";
    public static final String FLEXGUIDE = "flexguide";
    public static final String FLEXINPUT = "flexinput";
    public static final String FLEXOUTPUT = "flexoutput";
    public static final String CURRENTNODENAME = "currentnodename";
    private static final String LOOKUPTRACE = "lookuptrace";
    private static final String GAI_LOG_VIEW_FORM_ID = "gai_log_view";
    private static String chatSessionId = "";
    private static String chartTraceId = "";
    private GuideInfo[] guildInfo = new GuideInfo[]{new GuideInfo("generation", "G", ResManager.loadKDString((String)"\u95ee\u9898\u5206\u7c7b", (String)"KMEvaluationTraceFormPlugin_0", (String)"bos-gptas-qa", (Object[])new Object[0]), ResManager.loadKDString((String)"\u95ee\u9898\u63cf\u8ff0\uff1a\u7528\u6237\u95ee\u9898\u4e0e\u4e0b\u8ff0\u5206\u7c7b\u4e0d\u7b26", (String)"KMEvaluationTraceFormPlugin_1", (String)"bos-gptas-qa", (Object[])new Object[0]), ResManager.loadKDString((String)"1\u3001\u68c0\u67e5\u63d0\u793a\u8bcd\u5206\u7c7b\u63cf\u8ff0", (String)"KMEvaluationTraceFormPlugin_2", (String)"bos-gptas-qa", (Object[])new Object[0]), true, "1"), new GuideInfo("generation", "B", ResManager.loadKDString((String)"\u95ee\u9898\u6539\u5199", (String)"KMEvaluationTraceFormPlugin_3", (String)"bos-gptas-qa", (Object[])new Object[0]), ResManager.loadKDString((String)"\u95ee\u9898\u63cf\u8ff0\uff1a\u95ee\u9898\u6539\u5199\u540e\uff0c\u6539\u53d8\u4e86\u7528\u6237\u95ee\u9898\u539f\u610f", (String)"KMEvaluationTraceFormPlugin_4", (String)"bos-gptas-qa", (Object[])new Object[0]), ResManager.loadKDString((String)"1.\u68c0\u67e5\u63d0\u793a\u8bcd\u63cf\u8ff0\n2.\u68c0\u67e5\u662f\u5426\u5305\u542b\u5386\u53f2\u95ee\u9898\uff0c\u5386\u53f2\u95ee\u9898\u6539\u5199\u662f\u5426\u6b63\u786e", (String)"KMEvaluationTraceFormPlugin_5", (String)"bos-gptas-qa", (Object[])new Object[0]), true, "2"), new GuideInfo("repo", "C", ResManager.loadKDString((String)"\u77e5\u8bc6\u5e93\u547d\u4e2d", (String)"KMEvaluationTraceFormPlugin_6", (String)"bos-gptas-qa", (Object[])new Object[0]), ResManager.loadKDString((String)"\u95ee\u9898\u63cf\u8ff0\uff1a\u77e5\u8bc6\u5e93\u8fd4\u5185\u5bb9\u4e0e\u6b63\u786e\u7b54\u6848\u4e0d\u7b26", (String)"KMEvaluationTraceFormPlugin_7", (String)"bos-gptas-qa", (Object[])new Object[0]), ResManager.loadKDString((String)"1.\u77e5\u8bc6\u5e93\u67e5\u8be2\u95ee\u9898\u662f\u5426\u7ecf\u8fc7\u6539\u5199\uff0c\u6539\u5199\u95ee\u9898\u662f\u5426\u6b63\u786e\n2.\u77e5\u8bc6\u5e93\u5185\u662f\u5426\u5305\u542b\u95ee\u9898\u7b54\u6848\n3.\u77e5\u8bc6\u5e93\u8fd4\u56de\u5206\u5757\u662f\u5426\u547d\u4e2d\u95ee\u9898\u7b54\u6848\n4.\u95ee\u9898\u7b54\u6848\u88ab\u5207\u5206\u4e3a\u591a\u5757\uff0c\u68c0\u67e5\u5206\u5757\u987a\u5e8f", (String)"KMEvaluationTraceFormPlugin_8", (String)"bos-gptas-qa", (Object[])new Object[0]), false, ""), new GuideInfo("kmllm", "D", ResManager.loadKDString((String)"\u5927\u6a21\u578b\u603b\u7ed3", (String)"KMEvaluationTraceFormPlugin_9", (String)"bos-gptas-qa", (Object[])new Object[0]), ResManager.loadKDString((String)"\u95ee\u9898\u63cf\u8ff0\uff1a\u77e5\u8bc6\u5e93\u672a\u8fd4\u56de\u7b54\u6848\u539f\u6587", (String)"KMEvaluationTraceFormPlugin_10", (String)"bos-gptas-qa", (Object[])new Object[0]), ResManager.loadKDString((String)"1.\u603b\u7ed3\u63d0\u793a\u8bcd\u63cf\u8ff0\u662f\u5426\u6b63\u786e\n2.\u662f\u5426\u5305\u542b\u5386\u53f2\u56de\u7b54", (String)"KMEvaluationTraceFormPlugin_11", (String)"bos-gptas-qa", (Object[])new Object[0]), false, "")};
    private HashMap<String, String> mapBugType = new HashMap(7);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{GOTOTRACE});
        this.addClickListeners(new String[]{LOOKUPTRACE});
        this.addItemClickListeners(new String[]{TOOLBARAP});
    }

    public void initialize() {
        super.initialize();
        this.mapBugType.put("A", ResManager.loadKDString((String)"\u65e0\u95ee\u9898", (String)"KMEvaluationTraceFormPlugin_14", (String)BOS_GTPAS_QA, (Object[])new Object[0]));
        this.mapBugType.put("B", ResManager.loadKDString((String)"\u95ee\u9898\u6539\u5199\u9519\u8bef", (String)"KMEvaluationTraceFormPlugin_15", (String)BOS_GTPAS_QA, (Object[])new Object[0]));
        this.mapBugType.put("C", ResManager.loadKDString((String)"\u77e5\u8bc6\u5e93\u672a\u547d\u4e2d", (String)"KMEvaluationTraceFormPlugin_16", (String)BOS_GTPAS_QA, (Object[])new Object[0]));
        this.mapBugType.put("D", ResManager.loadKDString((String)"\u5927\u6a21\u578b\u603b\u7ed3\u9519\u8bef", (String)"KMEvaluationTraceFormPlugin_17", (String)BOS_GTPAS_QA, (Object[])new Object[0]));
        this.mapBugType.put("E", ResManager.loadKDString((String)"\u5176\u4ed6\u95ee\u9898(\u5f00\u53d1)", (String)"KMEvaluationTraceFormPlugin_18", (String)BOS_GTPAS_QA, (Object[])new Object[0]));
        this.mapBugType.put("F", ResManager.loadKDString((String)"\u5176\u4ed6\u95ee\u9898(\u5185\u5bb9)", (String)"KMEvaluationTraceFormPlugin_19", (String)BOS_GTPAS_QA, (Object[])new Object[0]));
        this.mapBugType.put("G", ResManager.loadKDString((String)"\u95ee\u9898\u5206\u7c7b\u9519\u8bef", (String)"KMEvaluationTraceFormPlugin_20", (String)BOS_GTPAS_QA, (Object[])new Object[0]));
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "btnbug": {
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("aikm_evaluationbugtype");
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                formShowParameter.setCustomParam(BUGTYPE, this.getModel().getValue(TASKBUGTYPEID));
                formShowParameter.setCustomParam(BUGDESC, this.getModel().getValue(TASKBUGDESC));
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BUGTYPE));
                this.getView().showForm(formShowParameter);
            }
        }
    }

    public void click(EventObject evt) {
        Button source = (Button)evt.getSource();
        if ((source.getKey().equals(LOOKUPTRACE) || source.getKey().equals(GOTOTRACE)) && !StringUtils.isBlank((CharSequence)chatSessionId) && !StringUtils.isBlank((CharSequence)chartTraceId)) {
            FormShowParameter billShowParameter = new FormShowParameter();
            billShowParameter.setCustomParam("chatSessionId", (Object)chatSessionId);
            billShowParameter.setCustomParam("id", (Object)Long.parseLong(chartTraceId));
            billShowParameter.setCustomParam("origin", (Object)"trace");
            billShowParameter.setFormId(GAI_LOG_VIEW_FORM_ID);
            billShowParameter.setStatus(OperationStatus.VIEW);
            billShowParameter.setCaption(String.format("Trace\u8be6\u60c5-%s", chatSessionId));
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(billShowParameter);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        int row = evt.getRow();
        String nodeType = (String)this.getModel().getValue("nodetype");
        String nodeName = (String)this.getModel().getValue("nodename");
        this.getModel().setValue(CURRENTNODENAME, (Object)nodeName);
        if (nodeType.equals(FIRST)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEXGUIDE});
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEXINPUT, FLEXOUTPUT});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEXGUIDE});
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEXINPUT, FLEXOUTPUT});
            String input = (String)this.getModel().getValue("stepinput", row);
            Markdown codeInput = (Markdown)this.getControl("currentinput");
            codeInput.setText(this.toPrettyJson(input));
            String output = (String)this.getModel().getValue("stepoutput", row);
            Markdown codeOutput = (Markdown)this.getControl("currentoutput");
            codeOutput.setText(this.toPrettyJson(output));
        }
    }

    private String toPrettyJson(String json) {
        if (json == null || json.isEmpty()) {
            return "```json\n\n```";
        }
        try {
            return "```json\n" + JSON.toJSONString((Object)JSON.parse((String)json), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat}) + "\n```";
        }
        catch (Exception ex) {
            return json;
        }
    }

    public void afterCreateNewData(EventObject e) {
        Object entryid = this.getView().getFormShowParameter().getCustomParam("entryid");
        if (entryid == null) {
            return;
        }
        try (DataSet rows = QueryServiceHelper.queryDataSet((String)"KMEvaluationTraceFormPlugin", (String)"aikm_evaluationbill", (String)"process.name,entryentity.score,entryentity.duration,entryentity.q,entryentity.a,entryentity.a_tag,entryentity.basea,entryentity.basea_tag,entryentity.chatsessionid,entryentity.chattraceid,entryentity.bugtype,entryentity.bugdesc", (QFilter[])new QFilter[]{new QFilter("entryentity.id", "=", entryid)}, (String)"");){
            if (rows.hasNext()) {
                String baseAnswer;
                Row row = rows.next();
                this.getModel().setValue("process", (Object)row.getString("process.name"));
                this.getModel().setValue("score", (Object)row.getString("entryentity.score"));
                this.getModel().setValue("durations", (Object)row.getString("entryentity.duration"));
                this.getModel().setValue("q", (Object)row.getString("entryentity.q"));
                String answer = row.getString("entryentity.a_tag");
                if (StringUtils.isEmpty((CharSequence)answer)) {
                    answer = row.getString("entryentity.a");
                }
                if (StringUtils.isEmpty((CharSequence)(baseAnswer = row.getString("entryentity.basea_tag")))) {
                    baseAnswer = row.getString("entryentity.basea");
                }
                this.getModel().setValue("a", (Object)answer);
                this.getModel().setValue("basea", (Object)baseAnswer);
                this.getModel().setValue("chatsessionid", (Object)row.getString("entryentity.chatsessionid"));
                String butTypeId = row.getString("entryentity.bugtype");
                String bugType = this.mapBugType.get(butTypeId);
                this.getModel().setValue(TASKBUGTYPE, (Object)bugType);
                this.getModel().setValue(TASKBUGTYPEID, (Object)butTypeId);
                this.getModel().setValue(TASKBUGDESC, (Object)row.getString("entryentity.bugdesc"));
                chatSessionId = row.getString("entryentity.chatsessionid");
                chartTraceId = row.getString("entryentity.chattraceid");
                this.showGAI_Log(chatSessionId);
            }
        }
        this.getModel().setValue(CURRENTNODENAME, (Object)ResManager.loadKDString((String)"\u6392\u67e5\u6307\u5f15", (String)"KMEvaluationTraceFormPlugin_12", (String)BOS_GTPAS_QA, (Object[])new Object[0]));
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        HashMap<String, String> imageMap = new HashMap<String, String>();
        imageMap.put("imageKey", "/kingdee/gai/images/pc/agent/avatar/common_agent.png");
        this.getView().updateControlMetadata("imageprocess", imageMap);
        imageMap = new HashMap();
        imageMap.put("imageKey", "/kingdee/gptas/images/pc/q.png");
        this.getView().updateControlMetadata("imageq", imageMap);
        imageMap = new HashMap();
        imageMap.put("imageKey", "/kingdee/gptas/images/pc/agent_a.png");
        this.getView().updateControlMetadata("imagea", imageMap);
        imageMap = new HashMap();
        imageMap.put("imageKey", "/kingdee/gptas/images/pc/base_a.png");
        this.getView().updateControlMetadata("imagebasea", imageMap);
    }

    public void afterBindData(EventObject e) {
        this.getView().setVisible(Boolean.TRUE, new String[]{FLEXGUIDE});
        this.getView().setVisible(Boolean.FALSE, new String[]{FLEXINPUT, FLEXOUTPUT});
    }

    private void showGAI_Log(String chatSessionId) {
        try (DataSet rows = QueryServiceHelper.queryDataSet((String)"KMEvaluationTraceFormPlugin", (String)"gai_log", (String)"entryentity.id, entryentity.metadata_tag,entryentity.steptype,entryentity.stepinput_tag,entryentity.stepoutput_tag", (QFilter[])new QFilter[]{new QFilter("chatsessionid", "=", (Object)chatSessionId)}, (String)"entryentity.id");){
            int currentRow;
            this.getModel().deleteEntryData(ENTRYGUIDE);
            this.getModel().deleteEntryData(ENTRYENTITY);
            this.getModel().createNewEntryRow(ENTRYENTITY);
            this.getModel().setValue("nodename", (Object)"\u6392\u67e5\u6307\u5f15", 0);
            this.getModel().setValue("nodetype", (Object)FIRST, 0);
            this.getModel().setValue("stepinput", (Object)"", 0);
            this.getModel().setValue("stepoutput", (Object)"", 0);
            int rowIndex = 1;
            for (Row row : rows) {
                String nodeName = BatchRunnerUtil.getNodeName(row.getString("entryentity.metadata_tag"));
                if (StringUtils.isBlank((CharSequence)nodeName)) continue;
                this.getModel().createNewEntryRow(ENTRYENTITY);
                this.getModel().setValue("nodename", (Object)nodeName, rowIndex);
                String nodeTypeName = this.getStepTypeName(row.getString("entryentity.steptype"));
                String stepoutput = row.getString("entryentity.stepoutput_tag");
                String promptType = BatchRunnerUtil.getPromptType(row.getString("entryentity.metadata_tag"));
                GuideInfo currentGuildInfo = StringUtils.isBlank((CharSequence)promptType) ? this.getGuildInfo(nodeTypeName) : this.getGuildInfo(nodeTypeName, promptType);
                if (currentGuildInfo != null && !currentGuildInfo.used) {
                    this.addGuildRow(currentGuildInfo, stepoutput, rowIndex);
                }
                this.getModel().setValue("nodetype", (Object)this.getStepTypeName(row.getString("entryentity.steptype")), rowIndex);
                this.getModel().setValue("stepinput", (Object)row.getString("entryentity.stepinput_tag"), rowIndex);
                this.getModel().setValue("stepoutput", (Object)stepoutput, rowIndex);
                ++rowIndex;
            }
            GuideInfo llmGuildInfo = this.getGuildInfo("kmllm");
            if (llmGuildInfo != null) {
                this.addGuildRow(llmGuildInfo, "", rowIndex);
            }
            if ((currentRow = this.getModel().getEntryRowCount(ENTRYGUIDE) - 1) >= 0) {
                CardEntry cardEntry = (CardEntry)this.getControl(ENTRYGUIDE);
                cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), currentRow, new String[]{SHOWLINE});
            }
        }
    }

    private void addGuildRow(GuideInfo guideInfo, String stepOutPut, int row) {
        this.getModel().createNewEntryRow(ENTRYGUIDE);
        int currentRow = this.getModel().getEntryRowCount(ENTRYGUIDE) - 1;
        this.getModel().setValue(BUGTYPE, (Object)guideInfo.getBugTypeDesc(), currentRow);
        this.getModel().setValue(BUGTYEDESC, (Object)guideInfo.getNodeDesc(), currentRow);
        this.getModel().setValue(BUGGUIDE, (Object)guideInfo.getGuide(), currentRow);
        this.getModel().setValue(NODEOUTPUT, (Object)stepOutPut, currentRow);
        this.getModel().setValue(NODEROW, (Object)row, currentRow);
        this.getModel().setValue(ROWTITLE, (Object)String.format(ResManager.loadKDString((String)"\u6392\u67e5\u70b9%s", (String)"KMEvaluationTraceFormPlugin_13", (String)BOS_GTPAS_QA, (Object[])new Object[0]), currentRow + 1), currentRow);
        String taskbugtypeId = (String)this.getModel().getValue(TASKBUGTYPEID);
        CardEntry cardEntry = (CardEntry)this.getControl(ENTRYGUIDE);
        if (taskbugtypeId.equals(guideInfo.getBugType())) {
            cardEntry.setChildVisible(Boolean.TRUE.booleanValue(), currentRow, new String[]{NEEDNOTICE});
        } else {
            cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), currentRow, new String[]{NEEDNOTICE});
        }
        if (!guideInfo.needOutput) {
            cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), currentRow, new String[]{NODEOUTPUT});
        }
        guideInfo.used = true;
    }

    private void updateBugType() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryRows = dataEntity.getDynamicObjectCollection(ENTRYGUIDE);
        String taskbugtype = (String)this.getModel().getValue(TASKBUGTYPE);
        CardEntry cardEntry = (CardEntry)this.getControl(ENTRYGUIDE);
        int rowIndex = 0;
        for (DynamicObject obj : entryRows) {
            if (taskbugtype.equals(obj.get(BUGTYPE).toString())) {
                cardEntry.setChildVisible(Boolean.TRUE.booleanValue(), rowIndex, new String[]{NEEDNOTICE});
            } else {
                cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), rowIndex, new String[]{NEEDNOTICE});
            }
            ++rowIndex;
        }
    }

    private GuideInfo getGuildInfo(String nodeType) {
        for (GuideInfo guideInfo : this.guildInfo) {
            if (!guideInfo.getNodeType().equals(nodeType)) continue;
            return guideInfo;
        }
        return null;
    }

    private GuideInfo getGuildInfo(String nodeType, String promptType) {
        for (GuideInfo guideInfo : this.guildInfo) {
            if (!guideInfo.getNodeType().equals(nodeType) || !guideInfo.getpromptType().equals(promptType)) continue;
            return guideInfo;
        }
        return null;
    }

    private String getStepTypeName(String stepType) {
        return stepType;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Object returnData;
        if (evt.getActionId().equals(BUGTYPE) && (returnData = evt.getReturnData()) != null) {
            Map map = (Map)SerializationUtils.fromJsonString((String)((String)returnData), Map.class);
            String bugTypeId = map.get(BUGTYPE).toString();
            String bugType = this.mapBugType.get(bugTypeId);
            this.getModel().setValue(TASKBUGTYPE, (Object)bugType);
            this.getModel().setValue(TASKBUGTYPEID, (Object)bugTypeId);
            this.getModel().setValue(TASKBUGDESC, map.get(BUGDESC));
            this.getPageCache().put(BUGTYPERET, (String)returnData);
            this.updateBugType();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String s = this.getPageCache().get(BUGTYPERET);
        if (s != null) {
            this.getView().returnDataToParent((Object)s);
        }
    }

    static class GuideInfo {
        private String nodeType;
        private String bugTypeDesc;
        private String bugType;
        private String nodeDesc;
        private String guide;
        private boolean needOutput;
        private String promptType;
        private boolean used = false;

        public GuideInfo(String nodeType, String bugType, String bugTypeDesc, String nodeDesc, String guide, boolean needOutput, String promptType) {
            this.nodeType = nodeType;
            this.nodeDesc = nodeDesc;
            this.guide = guide;
            this.bugTypeDesc = bugTypeDesc;
            this.bugType = bugType;
            this.needOutput = needOutput;
            this.promptType = promptType;
        }

        public String getNodeType() {
            return this.nodeType;
        }

        public String getpromptType() {
            return this.promptType;
        }

        public String getNodeDesc() {
            return this.nodeDesc;
        }

        public String getBugType() {
            return this.bugType;
        }

        public String getGuide() {
            return this.guide;
        }

        public String getBugTypeDesc() {
            return this.bugTypeDesc;
        }
    }
}

