/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.qa.batchrun.runner;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.gptas.qa.batchrun.BatchRunnerUtil;
import kd.bos.gptas.qa.batchrun.model.ActionVO;
import kd.bos.gptas.qa.batchrun.model.CallBackInfo;
import kd.bos.gptas.qa.batchrun.model.ChatParams;
import kd.bos.gptas.qa.batchrun.model.GaiChatVo;
import kd.bos.gptas.qa.batchrun.model.Message;
import kd.bos.gptas.qa.batchrun.model.NewSessionParams;
import kd.bos.gptas.qa.batchrun.model.Result;
import kd.bos.gptas.qa.batchrun.runner.RunnerData;
import kd.bos.gptas.qa.batchrun.runner.StackCache;
import kd.bos.gptas.qa.model.QAPrompt;
import kd.bos.gptas.servicehelper.AIServiceProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class AIKMRunner {
    private static final Log log = LogFactory.getLog(AIKMRunner.class);
    private static final ThreadPool threadPools = ThreadPools.newFixedThreadPool((String)"AIKMRunner", (int)5);
    private static final long GENERAL_ASSISTANT_ID = 10000L;
    private static final String BOS_GTPAS_QA = "bos-gptas-qa";
    private long assistantId = -1L;
    private long skillId = -1L;
    private String promptTemplate = "";
    private Supplier<Boolean> stopSupplier;

    public long getAssistantId() {
        return this.assistantId;
    }

    public void setAssistantId(long assistantId) {
        this.assistantId = assistantId;
    }

    public void setPromptTemplate(String promptTemplate) {
        this.promptTemplate = promptTemplate;
    }

    public String getPromptTemplate() {
        return this.promptTemplate;
    }

    public Supplier<Boolean> getStopSupplier() {
        return this.stopSupplier;
    }

    public void setStopSupplier(Supplier<Boolean> stopSupplier) {
        this.stopSupplier = stopSupplier;
    }

    public void batchStart(List<RunnerData> qList, Supplier<Boolean> stopSupplier, Consumer<RunnerData> answerConsumer) throws ExecutionException, InterruptedException {
        this.setStopSupplier(stopSupplier);
        ArrayList list = new ArrayList(qList.size());
        for (RunnerData s : qList) {
            Future result = threadPools.submit(() -> {
                if (stopSupplier != null && ((Boolean)stopSupplier.get()).booleanValue()) {
                    return s;
                }
                String chatSessionId = this.newChatSession();
                RunnerData runnerDataResult = this.start(chatSessionId, s);
                if (runnerDataResult != null) {
                    answerConsumer.accept(runnerDataResult);
                    if (stopSupplier != null) {
                        stopSupplier.get();
                    }
                }
                return runnerDataResult;
            });
            list.add(result);
        }
        this.waitStop(list, stopSupplier);
    }

    public void batchMultiStart(List<List<RunnerData>> qList, Supplier<Boolean> stopSupplier, Consumer<RunnerData> answerConsumer) throws ExecutionException, InterruptedException {
        ArrayList resultList = new ArrayList(16);
        for (List<RunnerData> s : qList) {
            Future result = threadPools.submit(() -> {
                if (stopSupplier != null && ((Boolean)stopSupplier.get()).booleanValue()) {
                    return s;
                }
                String chatSessionId = this.getChatSessionId(s);
                if (StringUtils.isEmpty((CharSequence)chatSessionId)) {
                    chatSessionId = this.newChatSession();
                }
                ArrayList<RunnerData> list = new ArrayList<RunnerData>(16);
                for (RunnerData runnerData : s) {
                    if (stopSupplier != null && ((Boolean)stopSupplier.get()).booleanValue()) {
                        return s;
                    }
                    RunnerData runnerDataResult = this.start(chatSessionId, runnerData);
                    if (runnerDataResult != null) {
                        answerConsumer.accept(runnerDataResult);
                        if (stopSupplier != null) {
                            stopSupplier.get();
                        }
                    }
                    list.add(runnerDataResult);
                }
                return list;
            });
            resultList.add(result);
        }
        this.waitStop(resultList, stopSupplier);
    }

    private String getChatSessionId(List<RunnerData> list) {
        String chatSessionId = "";
        for (RunnerData runnerData : list) {
            if (!StringUtils.isNotEmpty((CharSequence)runnerData.getChatSessionId())) continue;
            chatSessionId = runnerData.getChatSessionId();
            break;
        }
        return chatSessionId;
    }

    private <T> void waitStop(List<Future<T>> list, Supplier<Boolean> stopSupplier) throws ExecutionException, InterruptedException {
        for (Future<T> runnerDataFuture : list) {
            if (stopSupplier != null && stopSupplier.get().booleanValue()) break;
            runnerDataFuture.get();
        }
    }

    private <T> Boolean waitStop() throws ExecutionException, InterruptedException {
        Supplier<Boolean> stopSupplier = this.getStopSupplier();
        if (stopSupplier != null) {
            return stopSupplier.get();
        }
        return false;
    }

    public RunnerData start(String chatSessionId, RunnerData runnerData) throws ExecutionException, InterruptedException {
        if (runnerData.getFinish()) {
            return runnerData;
        }
        if (StringUtils.isBlank((CharSequence)chatSessionId)) {
            chatSessionId = this.newChatSession();
        }
        ChatParams chatParams = new ChatParams();
        chatParams.setCallbackInfo(this.buildCallBackInfo());
        chatParams.setSessionId(chatSessionId);
        Message message = new Message();
        message.setSkillType("PROCESS");
        message.setQuery(runnerData.getQ());
        message.setSkillId(String.valueOf(this.skillId));
        chatParams.setMessage(message);
        String ret = (String)DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiService", (String)"chat", (Object[])new Object[]{JSON.toJSONString((Object)chatParams)});
        Result result = (Result)SerializationUtils.fromJsonString((String)ret, Result.class);
        runnerData.setChatSessionId(chatSessionId);
        runnerData.setDurations(0L);
        long now = System.currentTimeMillis();
        if (result.getErrorCode().equals("0")) {
            String answer;
            if (result.getData() instanceof HashMap) {
                String chatTraceId = (String)((HashMap)result.getData()).get("traceProcessId");
                if (StringUtils.isNotEmpty((CharSequence)runnerData.getChatTraceId())) {
                    long oldChatTraceId = Long.parseLong(runnerData.getChatTraceId());
                    QFilter filter = new QFilter("chatsessionid", "=", (Object)chatSessionId).and(new QFilter("traceid", "=", (Object)oldChatTraceId));
                    int n = DeleteServiceHelper.delete((String)"gai_log", (QFilter[])new QFilter[]{filter});
                }
                runnerData.setChatTraceId(chatTraceId);
            }
            if (StringUtils.isNotEmpty((CharSequence)(answer = this.getAnswer(chatSessionId)))) {
                runnerData.setA(answer);
                String reason = this.getScore(runnerData.getQ(), runnerData.getA(), runnerData.getExpectA(), chatSessionId);
                double score = this.getScoreFromString(reason);
                runnerData.setReason(BatchRunnerUtil.leftSubstr(reason, 2000));
                runnerData.setScore(score);
            }
            runnerData.setDurations(System.currentTimeMillis() - now);
        }
        return runnerData;
    }

    private String getScore(String q, String a, String base_a, String chatSessionId) {
        String promptTemplate;
        StringBuilder s = new StringBuilder();
        String secureTemplate = QAPrompt.getPromptContentFromFile("prompt/SecurityPrompt.md");
        if (StringUtils.isNotBlank((CharSequence)secureTemplate)) {
            s.append(secureTemplate);
        }
        if (StringUtils.isBlank((CharSequence)(promptTemplate = this.getPromptTemplate()))) {
            promptTemplate = QAPrompt.getPromptContentFromFile("prompt/AnswerScore.md");
        }
        s.append(promptTemplate);
        String fieldTemplate = QAPrompt.getPromptContentFromFile("prompt/AnswerField.md");
        if (StringUtils.isNotBlank((CharSequence)fieldTemplate)) {
            s.append(fieldTemplate);
        }
        String prompt = s.toString().replace("{{q}}", q).replace("{{a}}", a).replace("{{base_a}}", base_a);
        String scoreResult = "";
        try {
            scoreResult = AIServiceProxy.invokePromptService((Object)"gptas-default", (String)prompt, (String)chatSessionId);
        }
        catch (Exception ex) {
            log.error(ResManager.loadKDString((String)"\u83b7\u53d6\u8bc4\u5206\u5931\u8d25", (String)"AIKMRunner_0", (String)BOS_GTPAS_QA, (Object[])new Object[0]), (Throwable)ex);
        }
        return scoreResult;
    }

    private Double getScoreFromString(String input) {
        Pattern pattern;
        Matcher matcher;
        if (StringUtils.isNotEmpty((CharSequence)input) && (matcher = (pattern = Pattern.compile("score:(\\d+(\\.\\d+)?)")).matcher(input)).find()) {
            double d = Double.parseDouble(matcher.group(1));
            if (d > 100.0) {
                d = 100.0;
            }
            return d;
        }
        return 0.0;
    }

    private String getPopContent(StackCache stackCache) {
        String pop = stackCache.popWithStop(() -> {
            try {
                return this.waitStop();
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        });
        return pop;
    }

    private String getAnswer(String chatSessionId) {
        StackCache stackCache = new StackCache(chatSessionId);
        StringBuilder answer = new StringBuilder();
        String pop = this.getPopContent(stackCache);
        while (!StringUtils.isEmpty((CharSequence)pop)) {
            GaiChatVo gaiChatVo = null;
            try {
                gaiChatVo = (GaiChatVo)SerializationUtils.fromJsonString((String)pop, GaiChatVo.class);
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
            if (gaiChatVo != null) {
                List<ActionVO> actionList = gaiChatVo.getActionList();
                for (ActionVO actionVO : actionList) {
                    String type;
                    switch (type = actionVO.getType().toLowerCase()) {
                        case "waitingdone": 
                        case "error": {
                            stackCache.clear();
                            return answer.toString();
                        }
                        case "chat": {
                            answer.append(actionVO.getData().get("message"));
                            break;
                        }
                        case "multimsg": {
                            List o = (List)actionVO.getData().get("msgList");
                            for (Map stringObjectMap : o) {
                                answer.append(stringObjectMap.get("value")).append("\n");
                            }
                            break;
                        }
                    }
                }
            }
            pop = this.getPopContent(stackCache);
        }
        return answer.toString();
    }

    private String newChatSession() {
        NewSessionParams newSessionParams = new NewSessionParams();
        newSessionParams.setCallBackInfo(this.buildCallBackInfo());
        newSessionParams.setAssistantId(this.assistantId == -1L ? 10000L : this.assistantId);
        String ret = (String)DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiService", (String)"newSession", (Object[])new Object[]{SerializationUtils.toJsonString((Object)newSessionParams)});
        Result result = (Result)SerializationUtils.fromJsonString((String)ret, Result.class);
        if ("0".equals(result.getErrorCode())) {
            Map data = (Map)result.getData();
            return (String)data.get("sessionId");
        }
        return "";
    }

    private CallBackInfo buildCallBackInfo() {
        CallBackInfo callBackInfo = new CallBackInfo();
        callBackInfo.setCloudId("ai");
        callBackInfo.setAppId("aikm");
        callBackInfo.setServiceName("GaiChatCallBackService");
        callBackInfo.setMethodName("callback");
        return callBackInfo;
    }

    public long getSkillId() {
        return this.skillId;
    }

    public void setSkillId(long skillId) {
        this.skillId = skillId;
    }
}

