/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.qa.chat;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.message.PushMessage;
import kd.bos.dataentity.message.PushMessageRange;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IFormView;
import kd.bos.gpt.api.DevAssistantService;
import kd.bos.gptas.common.llm.stream.IterMessageStream;
import kd.bos.gptas.qa.chat.ChatAiUtils;
import kd.bos.gptas.qa.chat.pojo.ChatMessage;
import kd.bos.gptas.qa.chat.pojo.ChatType;
import kd.bos.gptas.qa.model.QAAnswer;
import kd.bos.gptas.qa.service.QAService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.pushMessage.PushServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class ChatStreamThread
implements Runnable {
    private static final Log logger = LogFactory.getLog(ChatStreamThread.class);
    private static final String COSMICINTELLIQA = "cosmicintelliqa";
    private final DevAssistantService devAssistantService = (DevAssistantService)ServiceFactory.getService(DevAssistantService.class);
    private IFormView rootView;
    private IFormView view;
    private CustomControl control;
    private static final String DEFAULT_ASSISTANT = "-1";
    private QAService qaService = new QAService();
    private String question;
    private String number;
    private String requestId;
    private String userType;
    private int clientType;
    private String chatSessionId;
    private String uid;
    private String parentPageId;
    private String assistant;

    public String getParentPageId() {
        return this.parentPageId;
    }

    public void setParentPageId(String parentPageId) {
        this.parentPageId = parentPageId;
    }

    public ChatStreamThread() {
    }

    public ChatStreamThread(IFormView rootView, IFormView view, CustomControl control) {
        this.rootView = rootView;
        this.view = view;
        this.control = control;
    }

    public String getQuestion() {
        return this.question;
    }

    public void setQuestion(String question) {
        this.question = question;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getUserType() {
        return this.userType;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }

    public int getClientType() {
        return this.clientType;
    }

    public void setClientType(int clientType) {
        this.clientType = clientType;
    }

    public String getChatSessionId() {
        return this.chatSessionId;
    }

    public void setChatSessionId(String chatSessionId) {
        this.chatSessionId = chatSessionId;
    }

    public IFormView getRootView() {
        return this.rootView;
    }

    public void setRootView(IFormView rootView) {
        this.rootView = rootView;
    }

    public IFormView getView() {
        return this.view;
    }

    public void setView(IFormView view) {
        this.view = view;
    }

    public CustomControl getControl() {
        return this.control;
    }

    public void setControl(CustomControl control) {
        this.control = control;
    }

    @Override
    public void run() {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("time", System.currentTimeMillis());
        if (this.assistant.equals(DEFAULT_ASSISTANT)) {
            this.chatAnswer(dataMap);
        } else {
            this.devAssistantAnswer(dataMap);
        }
    }

    private void returnErrorMsg(String errorMsg, Map<String, Object> dataMap) {
        ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>(2);
        ChatMessage chatMessage = new ChatMessage(ChatType.error, errorMsg);
        messages.add(chatMessage);
        dataMap.put("messages", messages);
        dataMap.put("end", true);
        this.control.setData(dataMap);
        ChatStreamThread.sendFormActionByWS(this.rootView, this.view);
    }

    private void chatAnswer(Map<String, Object> dataMap) {
        String errorMsg = null;
        try {
            ArrayList<String> formIds = new ArrayList<String>();
            formIds.add(COSMICINTELLIQA);
            Iterator<QAAnswer> answer = this.qaService.qa(this.chatSessionId, this.question, formIds);
            while (answer.hasNext()) {
                if (!ChatAiUtils.isChatting(this.requestId)) {
                    dataMap.put("stop", true);
                    this.control.setData(dataMap);
                    ChatStreamThread.sendFormActionByWS(this.rootView, this.view);
                    break;
                }
                QAAnswer next = answer.next();
                List<ChatMessage> messages = this.getChatMessages(next);
                dataMap.put("messages", messages);
                dataMap.put("end", next.isEnd());
                this.control.setData(dataMap);
                ChatStreamThread.sendFormActionByWS(this.rootView, this.view);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            errorMsg = e.getMessage();
        }
        if (errorMsg != null) {
            this.returnErrorMsg(errorMsg, dataMap);
        }
        ChatAiUtils.stopChat(this.requestId);
    }

    private List<ChatMessage> getChatMessages(QAAnswer value) {
        ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>(4);
        ChatMessage chatMessage = new ChatMessage(this.requestId + "_robot", ChatType.markdown, value.getAnswer());
        if (value.isEnd() && value.getRefChunkList() != null) {
            chatMessage.setTitle(ResManager.loadKDString((String)"\u53c2\u8003\u94fe\u63a5", (String)"ChatStreamThread_0", (String)"bos-gptas-qa", (Object[])new Object[0]));
            chatMessage.setRefFiles(value.getRefFileList());
        }
        messages.add(chatMessage);
        return messages;
    }

    private void devAssistantAnswer(Map<String, Object> dataMap) {
        try {
            Object result = this.devAssistantService.process(this.assistant, this.question);
            if (result instanceof IterMessageStream) {
                QAAnswer qaAnswer;
                IterMessageStream messageStream = (IterMessageStream)result;
                while (messageStream.hasNext()) {
                    if (!ChatAiUtils.isChatting(this.requestId)) {
                        dataMap.put("stop", true);
                        this.control.setData(dataMap);
                        ChatStreamThread.sendFormActionByWS(this.rootView, this.view);
                        break;
                    }
                    qaAnswer = new QAAnswer();
                    qaAnswer.setAnswer(messageStream.next());
                    List<ChatMessage> chatMessages = this.getChatMessages(qaAnswer);
                    dataMap.put("messages", chatMessages);
                    dataMap.put("end", false);
                    this.control.setData(dataMap);
                    ChatStreamThread.sendFormActionByWS(this.rootView, this.view);
                }
                qaAnswer = new QAAnswer();
                qaAnswer.setAnswer("");
                dataMap.put("messages", this.getChatMessages(qaAnswer));
                dataMap.put("end", true);
            } else {
                String llmValue = result.toString();
                QAAnswer qaAnswer = new QAAnswer();
                qaAnswer.setAnswer(llmValue);
                List<ChatMessage> chatMessages = this.getChatMessages(qaAnswer);
                dataMap.put("messages", chatMessages);
                dataMap.put("end", true);
            }
        }
        catch (Exception e) {
            ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>(2);
            ChatMessage chatMessage = new ChatMessage(ChatType.error, e.getMessage());
            messages.add(chatMessage);
            dataMap.put("messages", messages);
            dataMap.put("end", true);
            logger.error((Throwable)e);
        }
        this.control.setData(dataMap);
        ChatStreamThread.sendFormActionByWS(this.rootView, this.view);
        ChatAiUtils.stopChat(this.requestId);
    }

    private static void sendFormActionByWS(IFormView rootView, IFormView formView) {
        rootView.sendFormAction(formView);
        PushMessage message = new PushMessage(PushMessageRange.RootPage, rootView.getPageId(), (Object)JSON.toJSONString((Object)rootView.getActionResult()));
        PushServiceHelper.push((PushMessage)message);
    }

    public ChatStreamThread buildQuestion(String question) {
        this.question = question;
        return this;
    }

    public ChatStreamThread buildNumber(String number) {
        this.number = number;
        return this;
    }

    public ChatStreamThread buildRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public ChatStreamThread buildUserType(String userType) {
        this.userType = userType;
        return this;
    }

    public ChatStreamThread buildClientType(int clientType) {
        this.clientType = clientType;
        return this;
    }

    public ChatStreamThread buildChatSessionId(String chatSessionId) {
        this.chatSessionId = chatSessionId;
        return this;
    }

    public ChatStreamThread buildAssistant(String assistant) {
        this.assistant = assistant;
        if (StringUtils.isBlank((CharSequence)assistant)) {
            this.assistant = DEFAULT_ASSISTANT;
        }
        return this;
    }

    public void buildUid(String uid) {
        this.uid = uid;
    }
}

