/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.qa.chat.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.gptas.api.km.event.UrlCreateEvent;
import kd.bos.gptas.api.qa.QAResultService;
import kd.bos.gptas.qa.chat.ChatAiUtils;
import kd.bos.gptas.qa.chat.ChatStreamThread;
import kd.bos.gptas.qa.chat.pojo.UserMetaData;
import kd.bos.gptas.qa.service.QAResultServiceImpl;
import kd.bos.gptas.qa.service.QAUrlService;
import kd.bos.gptas.utils.AssistantCorpusUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.threads.ThreadPools;
import kd.bos.url.UrlService;

public class ChatAiCustomPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(ChatAiCustomPlugin.class);
    private static final String USER_AGREE_CACHE_KEY = "ChatAiCustomPlugin_userAgree";
    private static final String BOS_DEVPORTAL_GPTAS = "bos-devportal-gptas";
    public static final String COSMIC_QA = "cosmic_qa";
    private CustomControl customControl;
    private final QAResultService qaResultService = new QAResultServiceImpl();

    public void initialize() {
        super.initialize();
        this.customControl = (CustomControl)this.getView().getControl("customcontrolap");
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        HashMap<String, Object> data = new HashMap<String, Object>(8);
        String openFrom = (String)this.getView().getFormShowParameter().getCustomParam("slideEnv");
        if ("APP_HOME".equals(openFrom)) {
            List maps = AssistantCorpusUtils.assistantForHomePage();
            maps.removeIf(o -> o.get("id").equals("100000"));
            data.put("agentList", maps);
            data.put("appHome", true);
        }
        if ("NEW_DEVDESIGNER".equals(openFrom)) {
            Object showIcon = this.getView().getFormShowParameter().getCustomParam("showIcon");
            data.put("showIcon", showIcon);
        }
        data.put("openFrom", openFrom);
        this.initChatSidebar(data);
        this.customControl.setData(data);
    }

    public void customEvent(CustomEventArgs e) {
        String eventName;
        super.customEvent(e);
        switch (eventName = e.getEventName()) {
            case "getChatAnswer": {
                this.getChatAnswer(e.getEventArgs());
                break;
            }
            case "showAgreeForm": {
                this.showAgreeForm();
                break;
            }
            case "refreshQuestion": {
                this.refreshQuestion();
                break;
            }
            case "answerStop": {
                this.answerStop(e.getEventArgs());
                break;
            }
            case "fbSubmit": {
                this.fbSubmit(e.getEventArgs());
                break;
            }
            case "getFileUrl": {
                this.getFileUrl(e.getEventArgs());
                break;
            }
        }
    }

    private void getFileUrl(String eventArgs) {
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        String url = new QAUrlService().getUrl(new UrlCreateEvent(jsonObject.getString("entityId"), jsonObject.getLong("id"), jsonObject.getLong("chunkId")));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("fileUrl", url);
        this.customControl.setData(hashMap);
    }

    private void fbSubmit(String eventArgs) {
        try {
            JSONObject jsonObject = JSON.parseObject((String)eventArgs);
            String billNo = jsonObject.getString("id");
            JSONArray linkIds = (JSONArray)jsonObject.get((Object)"linkIds");
            ArrayList<Long> knlIds = new ArrayList<Long>(linkIds.size());
            ArrayList<String> fbTypes = new ArrayList<String>(4);
            if (jsonObject.get((Object)"types") != null) {
                for (Object type : jsonObject.getJSONArray("types")) {
                    fbTypes.add((String)type);
                }
            }
            for (Object linkId : linkIds) {
                knlIds.add(Long.parseLong((String)linkId));
            }
            long assistantId = 100000L;
            HashMap<String, String> params = new HashMap<String, String>(16);
            params.put("question", jsonObject.getString("question"));
            params.put("answer", jsonObject.getString("answer"));
            params.put("api", "true");
            params.put("action", "QA_DISP_cosmic_qa");
            if (StringUtils.isNotBlank((CharSequence)billNo)) {
                params.put("billno", billNo);
            }
            if (!"-1".equals(jsonObject.getString("assistantId"))) {
                assistantId = Long.parseLong(jsonObject.getString("assistantId"));
            }
            this.qaResultService.saveQAResult(params, Long.valueOf(assistantId), jsonObject.getString("type"), Integer.valueOf(4), knlIds, fbTypes, jsonObject.getString("description"), "");
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    private void answerStop(String eventArgs) {
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        String requestId = (String)jsonObject.get((Object)"requestId");
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)requestId)) {
            ChatAiUtils.stopChat(requestId);
        }
    }

    private void refreshQuestion() {
        HashMap<String, List<String>> returnData = new HashMap<String, List<String>>(2);
        HashMap<String, HashMap<String, List<String>>> data = new HashMap<String, HashMap<String, List<String>>>(2);
        List<String> qList = ChatAiUtils.getCommonQuestions();
        returnData.put("questions", qList);
        data.put("questionData", returnData);
        this.customControl.setData(data);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getActionId().equals("showAgreement")) {
            boolean privacyCache = Boolean.parseBoolean(this.getPageCache().get(USER_AGREE_CACHE_KEY + RequestContext.get().getCurrUserId()));
            HashMap<String, Object> data = new HashMap<String, Object>();
            boolean userPrivacy = this.getAgreeFromRpc();
            if (privacyCache != userPrivacy) {
                this.setReturnDataToMap(userPrivacy, data);
                this.customControl.setData(data);
                this.getPageCache().put(USER_AGREE_CACHE_KEY + RequestContext.get().getCurrUserId(), String.valueOf(userPrivacy));
            }
        }
    }

    private void setReturnDataToMap(boolean agree, Map<String, Object> data) {
        data.put("userAgree", agree);
        if (!agree) {
            HashMap<String, String> returnText = new HashMap<String, String>(4);
            returnText.put("title", ResManager.loadKDString((String)"\u6b22\u8fce\u4f7f\u7528Cosmic\u52a9\u624b", (String)"ChatAiCustomPlugin_0", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0]));
            returnText.put("description", ResManager.loadKDString((String)"\u4e3a\u4e86\u7ed9\u60a8\u63d0\u4f9b\u66f4\u597d\u7684\u670d\u52a1\uff0c\u8bf7\u5148\u9605\u8bfb\u5e76\u540c\u610f\u9690\u79c1\u653f\u7b56", (String)"ChatAiCustomPlugin_1", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0]));
            returnText.put("btnText", ResManager.loadKDString((String)"\u9690\u79c1\u653f\u7b56\u8be6\u60c5", (String)"ChatAiCustomPlugin_2", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0]));
            data.put("privacyData", returnText);
            return;
        }
        HashMap<String, Object> returnData = new HashMap<String, Object>(4);
        HashMap<String, String> returnText = new HashMap<String, String>(4);
        returnText.put("title", "Cosmic");
        returnText.put("description", ResManager.loadKDString((String)"\u4f60\u7684AI\u7ba1\u7406\u52a9\u624b", (String)"ChatAiCustomPlugin_3", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0]));
        returnText.put("cardTitle", ResManager.loadKDString((String)"\u667a\u80fd\u95ee\u7b54\u52a9\u624b", (String)"ChatAiCustomPlugin_4", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0]));
        List<String> qList = ChatAiUtils.getCommonQuestions();
        returnData.put("questions", qList);
        returnData.put("questionTitle", returnText);
        data.put("questionData", returnData);
    }

    private boolean getUserPrivacy() {
        String agreeStr = this.getUserPrivacyByCache();
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)agreeStr)) {
            return Boolean.parseBoolean(agreeStr);
        }
        boolean agree = this.getAgreeFromRpc();
        this.getPageCache().put(USER_AGREE_CACHE_KEY + RequestContext.get().getCurrUserId(), String.valueOf(agree));
        return agree;
    }

    private boolean getAgreeFromRpc() {
        boolean agree = false;
        try {
            agree = (Boolean)DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiPrivacyService", (String)"isUserAgree", (Object[])new Object[0]);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return agree;
    }

    private String getUserPrivacyByCache() {
        return this.getPageCache().get(USER_AGREE_CACHE_KEY + RequestContext.get().getCurrUserId());
    }

    private void initChatSidebar(Map<String, Object> data) {
        boolean agree = this.getUserPrivacy();
        this.setReturnDataToMap(agree, data);
        UserMetaData userMetaData = ChatAiUtils.getUserMetaData(RequestContext.get().getCurrUserId());
        data.put("domainUrl", UrlService.getDomainContextUrl());
        boolean svcLoginAccountSession = Boolean.parseBoolean(SystemPropertyUtils.getProptyByTenant((String)"svc_login_account_session", (String)RequestContext.get().getTenantId()));
        if (svcLoginAccountSession) {
            data.put("kdcdc", RequestContext.get().getAccountId());
            data.put("isAccountSession", svcLoginAccountSession);
        }
        data.put("userMata", userMetaData);
        this.customControl.setData(data);
    }

    private void showAgreeForm() {
        boolean userPrivacy = this.getUserPrivacy();
        this.getView().getPageCache().put(USER_AGREE_CACHE_KEY + RequestContext.get().getCurrUserId(), String.valueOf(userPrivacy));
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("gai_privacy_agreement");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam("agreementType", (Object)"userAgreement");
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "showAgreement"));
        this.getView().showForm(fsp);
    }

    private void getChatAnswer(String eventArgs) {
        boolean agree = this.getUserPrivacy();
        if (agree) {
            JSONObject jsonObject = JSONObject.parseObject((String)eventArgs);
            this.getAsynAnswer(jsonObject.getString("msg"), jsonObject.getString("chatSessionId"), jsonObject.getString("requestId"), jsonObject.getString("assistant"));
        }
    }

    private void getAsynAnswer(String msg, String chatId, String requestId, String assistant) {
        String rootPageId = this.getView().getFormShowParameter().getRootPageId();
        IFormView rootView = SessionManager.getCurrent().getView(rootPageId);
        try {
            ChatAiUtils.beginChat(requestId);
            ChatStreamThread chatStreamThread = new ChatStreamThread(rootView, this.getView(), this.customControl);
            chatStreamThread.buildChatSessionId(chatId).buildNumber(COSMIC_QA).buildQuestion(msg).buildRequestId(requestId).buildClientType(4).buildAssistant(assistant).buildUid(String.valueOf(RequestContext.get().getCurrUserId()));
            chatStreamThread.setParentPageId(this.getView().getParentView().getPageId());
            ThreadPools.executeOnce((String)("chat-ai" + requestId), (Runnable)chatStreamThread);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

