/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.qa.formplugin;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.message.PushMessage;
import kd.bos.dataentity.message.PushMessageRange;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.Markdown;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.gptas.api.vector.EmbeddingModel;
import kd.bos.gptas.qa.model.QAAnswer;
import kd.bos.gptas.qa.model.QAChatHistory;
import kd.bos.gptas.qa.model.QAChatMessage;
import kd.bos.gptas.qa.model.QAChunk;
import kd.bos.gptas.qa.model.QARefFile;
import kd.bos.gptas.qa.service.ChunkProvider;
import kd.bos.gptas.qa.service.QAService;
import kd.bos.gptas.qa.service.QAServiceLog;
import kd.bos.gptas.servicehelper.AIServiceProxy;
import kd.bos.id.ID;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.pushMessage.PushServiceHelper;
import org.jetbrains.annotations.Nullable;

public class MultiChatFormPlugin
extends AbstractFormPlugin
implements ChunkProvider,
HyperLinkClickListener {
    private QAService qaService = new QAService();
    private boolean questionChanged = false;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit repo = (BasedataEdit)this.getControl("repos");
        repo.addBeforeF7SelectListener(evt -> {
            evt.getFormShowParameter().setCustomParam("modeltype", (Object)"KMModel");
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
            qFilters.add(new QFilter("bizappid.number", "!=", (Object)"tpl"));
            evt.setCustomQFilters(qFilters);
        });
        this.addClickListeners(new String[]{"btnanswer", "btnok", "btnefresh", "btnnewchat"});
        EntryGrid entrychunk = (EntryGrid)this.getControl("entrychunk");
        EntryGrid entryrefchunk = (EntryGrid)this.getControl("entryrefchunk");
        entrychunk.addHyperClickListener((HyperLinkClickListener)this);
        entryrefchunk.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (e.getProperty().getName().equals("question")) {
            this.questionChanged = true;
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.newChatSessionID();
        List<Map<String, Object>> rerankList = this.getRerankListFromAI();
        if (rerankList == null) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"enablererank", "reranklist"});
        } else {
            ComboEdit reranklist = (ComboEdit)this.getControl("reranklist");
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(rerankList.size());
            for (Map<String, Object> re : rerankList) {
                ComboItem comboItem = new ComboItem();
                comboItem.setValue((String)re.get("number"));
                comboItem.setId((String)re.get("number"));
                comboItem.setCaption(new LocaleString((String)re.get("name")));
                comboItems.add(comboItem);
            }
            reranklist.setComboItems(comboItems);
            this.getView().setEnable(Boolean.TRUE, new String[]{"enablererank", "reranklist"});
        }
    }

    private List<Map<String, Object>> getRerankListFromAI() {
        try {
            List rerankList = (List)AIServiceProxy.invokeAICCServiceMethod((String)"AiccService", (String)"getRerankList", (Object[])new Object[0]);
            return rerankList;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        switch (btn.getKey()) {
            case "btnanswer": {
                this.doAnswer();
                break;
            }
            case "btnok": {
                this.doSearch();
                break;
            }
            case "btnefresh": {
                this.doShowHistory();
                break;
            }
            case "btnnewchat": {
                this.newChatSessionID();
            }
        }
    }

    private void newChatSessionID() {
        String s = ID.genStringId();
        this.getModel().setValue("sessionid", (Object)s);
        this.getModel().setValue("question", (Object)"");
    }

    private void doAnswer() {
        String reranknumber;
        String chatSessionId = this.getValue("sessionid", "chatSessionId can't be empty.");
        if (chatSessionId == null) {
            return;
        }
        String question = this.getValue("question", "question can't be empty.");
        if (question == null) {
            return;
        }
        boolean enableRerank = (Boolean)this.getModel().getValue("enablererank");
        if (enableRerank && (reranknumber = this.getValue("reranklist", "rerank can't be empty.")) == null) {
            return;
        }
        this.qaService.setDebugLog(new QAServiceLog(){

            @Override
            public void info(String msg) {
                String n = (String)MultiChatFormPlugin.this.getModel().getValue("log");
                MultiChatFormPlugin.this.getModel().setValue("log", (Object)(n + msg + "\n"));
            }
        });
        this.qaService.setChunkProvider(this);
        List<String> formIds = this.getFormIds();
        if (formIds == null) {
            return;
        }
        this.qaService.setTopK((Integer)this.getModel().getValue("top"));
        this.qaService.setEnableRerank((Boolean)this.getModel().getValue("enablererank"));
        this.qaService.setRerankNumber((String)this.getModel().getValue("reranklist"));
        this.qaService.setEnableReSeq((Boolean)this.getModel().getValue("enablechunkseqrank"));
        if (this.questionChanged) {
            this.doSearch();
        }
        this.getModel().setValue("log", (Object)"");
        Iterator<QAAnswer> qa = this.qaService.qa(chatSessionId, question, formIds);
        boolean isStream = (Boolean)this.getView().getModel().getValue("enablestream");
        StringBuilder s = new StringBuilder();
        QAAnswer answer = null;
        while (qa.hasNext()) {
            answer = qa.next();
            s.append(answer.getAnswer());
            if (!isStream) continue;
            this.pushAnswer(s.toString());
        }
        if (!isStream) {
            Markdown markdownap = (Markdown)this.getView().getControl("markdownap");
            markdownap.setText(s.toString());
        }
        if (answer != null) {
            this.getModel().clearNoDataRow();
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection rows = dataEntity.getDynamicObjectCollection("entrychunk");
            EntryGrid entryGrid = (EntryGrid)this.getControl("entrychunk");
            List<QARefFile> refFileList = answer.getRefFileList();
            if (refFileList.isEmpty() && rows != null) {
                int[] index = new int[rows.size()];
                for (int i = 0; i < rows.size(); ++i) {
                    index[i] = i;
                }
                entryGrid.setRowBackcolor("", index);
            } else if (rows != null) {
                HashMap<String, String> idMap = new HashMap<String, String>(5);
                for (QARefFile refFile : refFileList) {
                    idMap.put(refFile.getId(), refFile.getEntityId());
                }
                int i = 0;
                for (DynamicObject row : rows) {
                    String knowledgeId = row.getString("fileid");
                    String entityId = row.getString("kmform");
                    boolean found = entityId.equals(idMap.get(knowledgeId));
                    entryGrid.setRowBackcolor(found ? "lightgreen" : "", new int[]{i++});
                }
            }
        }
        this.doShowHistory();
    }

    private void pushAnswer(String msg) {
        String pageId = this.getView().getPageId();
        SessionManager sessionManager = new SessionManager();
        IFormView formView = sessionManager.getView(pageId);
        Markdown markdownap = (Markdown)formView.getControl("markdownap");
        markdownap.setText(msg);
        IFormView rootView = sessionManager.getView(this.getView().getFormShowParameter().getRootPageId());
        MultiChatFormPlugin.sendFormActionByWS(rootView, formView);
    }

    private static void sendFormActionByWS(IFormView rootView, IFormView formView) {
        rootView.sendFormAction(formView);
        PushMessage message = new PushMessage(PushMessageRange.RootPage, rootView.getPageId(), (Object)JSON.toJSONString((Object)rootView.getActionResult()));
        PushServiceHelper.push((PushMessage)message);
    }

    @Nullable
    private String getValue(String key, String msg) {
        String value = (String)this.getModel().getValue(key);
        if (StringUtils.isBlank((CharSequence)value)) {
            this.getView().showTipNotification(msg);
            return null;
        }
        return value;
    }

    private List<String> getFormIds() {
        DynamicObjectCollection repos = (DynamicObjectCollection)this.getModel().getValue("repos");
        ArrayList<String> formIds = new ArrayList<String>(16);
        EmbeddingModel firstModel = null;
        for (DynamicObject repo : repos) {
            String formId = repo.getString("fbasedataid_id");
            formIds.add(formId);
            EmbeddingModel embeddingModel = this.getEmbeddingModel(formId);
            if (embeddingModel == null) {
                this.getView().showTipNotification(formId + "'s embedding model not found.");
                return null;
            }
            if (firstModel == null) {
                firstModel = embeddingModel;
                continue;
            }
            if (firstModel == embeddingModel) continue;
            this.getView().showTipNotification("can't select multi embedding model.");
            return null;
        }
        return formIds;
    }

    private EmbeddingModel getEmbeddingModel(String entityNumber) {
        QFilter qFilter = new QFilter("kmformid.number", "=", (Object)entityNumber);
        QFilter[] qFilterList = new QFilter[]{qFilter};
        Map corpusLibs = BusinessDataReader.loadFromCache((String)"bos_knl_kmconfig", (QFilter[])qFilterList);
        if (corpusLibs.isEmpty()) {
            return null;
        }
        DynamicObject row = (DynamicObject)corpusLibs.values().iterator().next();
        return Enum.valueOf(EmbeddingModel.class, row.getString("indexmethod"));
    }

    private void doShowHistory() {
        String chatSessionId = this.getValue("sessionid", "chatSessionId can't be empty\u3002");
        if (chatSessionId == null) {
            return;
        }
        QAChatHistory qaChatHistory = new QAChatHistory(chatSessionId);
        List<QAChatMessage> chatMessageList = qaChatHistory.getChatMessageList();
        this.getModel().deleteEntryData("entryhis");
        if (!chatMessageList.isEmpty()) {
            this.getModel().batchCreateNewEntryRow("entryhis", chatMessageList.size());
            for (int i = 0; i < chatMessageList.size(); ++i) {
                QAChatMessage qaChatMessage = chatMessageList.get(i);
                this.setTagValue("question_n", qaChatMessage.getQuestion(), i);
                this.setTagValue("answer_n", qaChatMessage.getAnswer(), i);
                this.setTagValue("prompt_n", qaChatMessage.getPrompt(), i);
            }
        }
        List<QAChunk> qaChunkList = qaChatHistory.getQaChunkList();
        this.getModel().deleteEntryData("entryrefchunk");
        if (!qaChunkList.isEmpty()) {
            this.getModel().batchCreateNewEntryRow("entryrefchunk", qaChunkList.size());
            for (int i = 0; i < qaChunkList.size(); ++i) {
                QAChunk qaChunk = qaChunkList.get(i);
                this.getModel().setValue("chunkid_ref", qaChunk.getId(), i);
                this.getModel().setValue("chunk_ref", (Object)qaChunk.getContent(), i);
                this.getModel().setItemValueByID("kmformid_ref", (Object)qaChunk.getFormId(), i);
                this.getModel().setValue("kmform_ref", (Object)qaChunk.getFormId(), i);
            }
        }
    }

    private void doSearch() {
        String question = this.getValue("question", "question can't be empty\u3002");
        if (question == null) {
            return;
        }
        List<String> formIds = this.getFormIds();
        if (formIds == null) {
            return;
        }
        boolean isChunkSeqRank = (Boolean)this.getModel().getValue("enablechunkseqrank");
        boolean isRerank = (Boolean)this.getModel().getValue("enablererank");
        boolean enableCommonSearch = (Boolean)this.getModel().getValue("enablecommonsearch");
        int top = (Integer)this.getModel().getValue("top");
        String rerankNumber = isRerank ? this.getValue("reranklist", "reranknumber must be selected\u3002") : "";
        List<QAChunk> chunkList = ChunkProvider.createDefault().getChunkList(formIds, question, top, isChunkSeqRank, isRerank, rerankNumber, enableCommonSearch);
        this.fillChunkGrid(chunkList);
    }

    private void setTagValue(String key, String value, int row) {
        this.getModel().setValue(key, (Object)value, row);
        this.getModel().setValue(key + "_tag", (Object)value, row);
    }

    private void fillChunkGrid(List<QAChunk> chunkList) {
        this.getModel().deleteEntryData("entrychunk");
        if (chunkList.isEmpty()) {
            return;
        }
        this.getModel().batchCreateNewEntryRow("entrychunk", chunkList.size());
        block0: for (int i = 0; i < chunkList.size(); ++i) {
            QAChunk qaChunk = chunkList.get(i);
            this.getModel().setItemValueByID("kmformid", (Object)qaChunk.getFormId(), i);
            this.getModel().setValue("score", (Object)Float.valueOf(qaChunk.getScores()), i);
            this.setTagValue("chunk", qaChunk.getContent(), i);
            this.getModel().setValue("chunkid1", qaChunk.getId(), i);
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)qaChunk.getFormId());
            Map map = BusinessDataReader.loadFromCache((Object[])new Object[]{qaChunk.getKnowledgeId()}, (DynamicObjectType)dataEntityType);
            if (!map.containsKey(qaChunk.getKnowledgeId())) continue;
            this.getModel().setValue("filename", (Object)((DynamicObject)map.get(qaChunk.getKnowledgeId())).getString("name"), i);
            DynamicObject data = (DynamicObject)map.get(qaChunk.getKnowledgeId());
            DynamicObjectCollection entryRows = data.getDynamicObjectCollection("segmententity");
            for (DynamicObject entryRow : entryRows) {
                if (!entryRow.get("id").equals(qaChunk.getId())) continue;
                this.getModel().setValue("chunkseq", entryRow.get("seq"), i);
                this.getModel().setValue("kmform", (Object)qaChunk.getFormId(), i);
                this.getModel().setValue("fileid", (Object)qaChunk.getKnowledgeId(), i);
                continue block0;
            }
        }
    }

    @Override
    public List<QAChunk> getChunkList(List<String> formIds, String question, int topK, boolean enableChunkSeqRank, boolean enableRerank, String rerankNumber, boolean enableCommonSearch) {
        int count = this.getModel().getEntryRowCount("entrychunk");
        if (count == 0) {
            return Collections.emptyList();
        }
        EntryGrid entrychunkGrid = (EntryGrid)this.getView().getControl("entrychunk");
        int[] selectRows = entrychunkGrid.getSelectRows();
        HashSet<Integer> set = new HashSet<Integer>(16);
        if (selectRows != null) {
            for (int selectRow : selectRows) {
                set.add(selectRow);
            }
        }
        ArrayList<QAChunk> list = new ArrayList<QAChunk>(16);
        for (int i = 0; i < count; ++i) {
            if (!set.contains(i) && set.size() != 0) continue;
            QAChunk qaChunk = new QAChunk();
            qaChunk.setId(this.getModel().getValue("chunkid1", i));
            qaChunk.setContent((String)this.getModel().getValue("chunk", i));
            DynamicObject kmformid = (DynamicObject)this.getModel().getValue("kmformid", i);
            qaChunk.setFormId(kmformid.getString("id"));
            list.add(qaChunk);
        }
        return list;
    }

    @Override
    public void onGetChunk(List<QAChunk> chunkList) {
        this.fillChunkGrid(chunkList);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int row = evt.getRowIndex();
        String fileName = evt.getFieldName();
        if ("kmformid".equals(fileName) || "kmformid_ref".equals(fileName)) {
            String entIDFile = "kmformid".equals(fileName) ? "kmform" : "kmform_ref";
            String formId = (String)this.getModel().getValue(entIDFile, row);
            ListShowParameter showListForm = ShowFormHelper.createShowListForm((String)formId, (boolean)false, (int)ShowType.NonModal.getValue(), (boolean)false);
            this.getView().showForm((FormShowParameter)showListForm);
        } else if ("filename".equals(fileName)) {
            String formId = (String)this.getModel().getValue("kmform", row);
            Object knowledgeId = this.getModel().getValue("fileid", row);
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.getOpenStyle().setShowType(ShowType.NonModal);
            billShowParameter.setFormId(formId);
            billShowParameter.setPkId(knowledgeId);
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }
}

