/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.qa.formplugin;

import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.gptas.utils.AssistantPreset;
import kd.bos.gptas.utils.IFrameUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class QAResultFormPlugin
extends AbstractBillPlugIn {
    private static final String USER_QUESTION = "userquestion";
    private static final String COS_ANSWER = "cosanswer";
    private static final String USER_NAME = "username";
    private static final String CHAT_TIME = "chattime";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject assistant = (DynamicObject)this.getModel().getValue("assistant");
        if (assistant != null) {
            this.getView().getPageCache().put("type", assistant.getString("number"));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if ("save".equals(operateKey) || "submit".equals(operateKey)) {
            this.loadQAHistory();
            this.loadDemoAssistantCard();
        }
    }

    public void afterLoadData(EventObject e) {
        this.loadDemoAssistantCard();
        this.loadQAHistory();
    }

    private void loadDemoAssistantCard() {
        Object assistant = this.getModel().getValue("assistant");
        if (null == assistant) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"assistantentry"});
            return;
        }
        String assistantName = ((DynamicObject)assistant).getString("name");
        int index = this.getModel().createNewEntryRow("assistantentry");
        Long assistantId = (Long)((DynamicObject)assistant).getPkValue();
        String assistantImg = ((DynamicObject)assistant).getString("icon");
        if (AssistantPreset.isPresetAssistant((Long)assistantId).booleanValue() && StringUtils.isBlank((CharSequence)assistantImg)) {
            String presetIconUrl = AssistantPreset.getIconUrl((Long)assistantId);
            this.getModel().setValue("assistanticon", (Object)IFrameUtil.buildImageUrl((String)presetIconUrl, (boolean)false), index);
        } else {
            this.getModel().setValue("assistanticon", (Object)assistantImg, index);
        }
        this.getModel().setValue("assistantname", (Object)assistantName, index);
        this.getModel().setDataChanged(false);
    }

    private void loadQAHistory() {
        QFilter filter = new QFilter("chatsessionid", "=", this.getModel().getValue("chatsessionid"));
        filter.and(new QFilter("createtime", "<=", this.getModel().getValue("createtime")));
        try {
            int i;
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bos_qaresult", (String)"createtime, answer, userinput, creator", (QFilter[])filter.toArray(), (String)"createtime desc", (int)10);
            this.getModel().deleteEntryData("historyentry");
            int n = i = "".equals(this.getModel().getValue("chatsessionid")) ? 0 : dynamicObjects.size() - 1;
            while (i >= 0) {
                DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(i);
                int row = this.getModel().createNewEntryRow("historyentry");
                this.getModel().setValue(USER_NAME, (Object)dynamicObject.getString("creator"), row);
                this.getModel().setValue(USER_QUESTION, (Object)dynamicObject.getString("userinput"), row);
                this.getModel().setValue(COS_ANSWER, (Object)dynamicObject.getString("answer"), row);
                this.getModel().setValue(CHAT_TIME, dynamicObject.get("createtime"), row);
                --i;
            }
            this.getModel().setDataChanged(false);
        }
        catch (Exception e) {
            return;
        }
    }
}

