/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.qa.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormMetadataCache;
import kd.bos.gptas.api.KMSearchService;
import kd.bos.gptas.api.RerankService;
import kd.bos.gptas.api.vector.EmbeddingModel;
import kd.bos.gptas.api.vector.KMSearchOption;
import kd.bos.gptas.api.vector.VectorResult;
import kd.bos.gptas.qa.model.QAChunk;
import kd.bos.gptas.qa.service.ChunkProvider;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;

class DefaultChunkProvider
implements ChunkProvider {
    DefaultChunkProvider() {
    }

    @Override
    public List<QAChunk> getChunkList(List<String> formIds, String question, int topK, boolean enableChunkSeqRank, boolean enableRerank, String rerankNumber, boolean enableCommonSearch) {
        if (formIds == null || formIds.isEmpty()) {
            return new ArrayList<QAChunk>(0);
        }
        String kmConfigFormId = this.enableRerankFormId(formIds);
        boolean isRerank = enableRerank;
        List<Object> vectorResultsAll = new ArrayList(topK * formIds.size());
        for (String formId : formIds) {
            long commonKMID;
            long l = commonKMID = enableCommonSearch ? this.getCommonKMID(formId) : 0L;
            if (commonKMID > 0L) {
                List vectorResult = (List)DispatchServiceHelper.invokeBizService((String)"ai", (String)"aikm", (String)"AIKMService", (String)"retrieval", (Object[])new Object[]{question, Collections.singletonList(commonKMID), "TEXT_QA", topK, null, false, ""});
                vectorResultsAll.addAll(vectorResult);
                continue;
            }
            String appId = FormMetadataCache.getFormConfig((String)formId).getAppId();
            KMSearchOption kmSearchOption = KMSearchOption.withPermissionOnly((String)appId);
            KMSearchService kmSearchService = KMSearchService.create((EmbeddingModel)this.getEmbeddingModel(formId));
            List vectorResult = kmSearchService.search(formId, null, question, isRerank ? 64 : topK, kmSearchOption);
            vectorResultsAll.addAll(vectorResult);
        }
        vectorResultsAll = vectorResultsAll.stream().sorted(Comparator.comparingDouble(VectorResult::getScore)).limit(isRerank ? (long)Math.min(64, vectorResultsAll.size()) : (long)topK).collect(Collectors.toList());
        if (isRerank) {
            RerankService rerankService = RerankService.create((String)rerankNumber);
            vectorResultsAll = rerankService.rerankSearchResults(question, vectorResultsAll, topK);
        }
        if (enableChunkSeqRank) {
            KMSearchService kmSearchService = KMSearchService.create((EmbeddingModel)this.getEmbeddingModel(formIds.get(0)));
            vectorResultsAll = kmSearchService.reorderBySequence(vectorResultsAll, topK);
        }
        List<Object> vectorResultList = vectorResultsAll.subList(0, Math.min(topK, vectorResultsAll.size()));
        ArrayList<QAChunk> qaChunkList = new ArrayList<QAChunk>(vectorResultList.size());
        for (VectorResult vectorResult : vectorResultList) {
            if (vectorResult.getChunk().getKnowledgeId() == null) continue;
            QAChunk qaChunk = new QAChunk();
            if (StringUtils.isNotBlank((CharSequence)vectorResult.getChunk().getExtendContent())) {
                qaChunk.setContent(vectorResult.getChunk().getExtendContent());
            } else {
                qaChunk.setContent(vectorResult.getChunk().getContent());
            }
            qaChunk.setId(vectorResult.getChunk().getId());
            qaChunk.setScores(vectorResult.getScore());
            qaChunk.setFormId(vectorResult.getChunk().getEntityId());
            qaChunk.setKnowledgeId(vectorResult.getChunk().getKnowledgeId());
            qaChunkList.add(qaChunk);
        }
        return qaChunkList;
    }

    private long getCommonKMID(String kmformNumber) {
        String id = MetadataDao.getIdByNumber((String)kmformNumber, (MetaCategory)MetaCategory.Form);
        Map datas = BusinessDataReader.loadFromCache((String)"aikm_knl_manager", (QFilter[])new QFilter[]{new QFilter("kmentityid", "=", (Object)id).or(new QFilter("kmqaentityid", "=", (Object)id))});
        if (datas.isEmpty()) {
            return -1L;
        }
        return ((DynamicObject)datas.values().iterator().next()).getLong("id");
    }

    private String enableRerankFormId(List<String> formIds) {
        for (String formId : formIds) {
            DynamicObject kmConfig = this.getKmConfig(formId);
            if (kmConfig == null || !kmConfig.getBoolean("enablererank") || !StringUtils.isNotEmpty((CharSequence)kmConfig.getString("reranknumber"))) continue;
            return formId;
        }
        return null;
    }

    private EmbeddingModel getEmbeddingModel(String entityNumber) {
        QFilter qFilter = new QFilter("kmformid.number", "=", (Object)entityNumber);
        QFilter[] qFilterList = new QFilter[]{qFilter};
        Map corpusLibs = BusinessDataReader.loadFromCache((String)"bos_knl_kmconfig", (QFilter[])qFilterList);
        DynamicObject row = (DynamicObject)corpusLibs.values().iterator().next();
        return Enum.valueOf(EmbeddingModel.class, row.getString("indexmethod"));
    }

    private DynamicObject getKmConfig(String entityNumber) {
        QFilter qFilter = new QFilter("kmformid.number", "=", (Object)entityNumber);
        QFilter[] qFilterList = new QFilter[]{qFilter};
        Map corpusLibs = BusinessDataReader.loadFromCache((String)"bos_knl_kmconfig", (QFilter[])qFilterList);
        if (corpusLibs.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u77e5\u8bc6\u5e93\u672a\u521d\u59cb\u5316\uff0c\u8bf7\u5728\u5217\u8868\u4e2d\u6267\u884c\u201c\u521d\u59cb\u5316\u6570\u636e\u5e93\u201d\u3002", (String)"KMConfigReader_0", (String)"bos-gptas-qa", (Object[])new Object[0]));
        }
        return (DynamicObject)corpusLibs.values().iterator().next();
    }
}

